#!perl
# vim:ts=4:sw=4:expandtab
#
# Please read the following documents before working on tests:
# • https://build.i3wm.org/docs/testsuite.html
#   (or docs/testsuite)
#
# • https://build.i3wm.org/docs/lib-i3test.html
#   (alternatively: perldoc ./testcases/lib/i3test.pm)
#
# • https://build.i3wm.org/docs/ipc.html
#   (or docs/ipc)
#
# • https://i3wm.org/downloads/modern_perl_a4.pdf
#   (unless you are already familiar with Perl)
#
# Regression: move a floating window to a different workspace crashes i3
#
use i3test;

my $tmp = fresh_workspace;
my $otmp = get_unused_workspace();

cmd 'open';
cmd 'mode toggle';
cmd "move workspace $otmp";

does_i3_live;

done_testing;
