/**
 * Copyright (c) 2012-2017, jcabi.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met: 1) Redistributions of source code must retain the above
 * copyright notice, this list of conditions and the following
 * disclaimer. 2) Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution. 3) Neither the name of the jcabi.com nor
 * the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.jcabi;

import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

/**
 * Test case for {@link Page}, which is actually testing how
 * {@link Cacheable} annotation works.
 * @author Yegor Bugayenko (yegor@tpc2.com)
 * @version $Id: a4373fefa64187a446f72cbc8c3f83b44c9ce2d2 $
 */
public final class PageTest {

    /**
     * Page can cache results.
     * @throws Exception If something goes wrong
     */
    @Test
    public void cachesResults() throws Exception {
        final Page page = new Page();
        page.downloadWithCache("with");
        page.downloadWithCache("with");
        page.downloadWithoutCache("without");
        page.downloadWithoutCache("without");
        MatcherAssert.assertThat(page.counted(), Matchers.equalTo(3));
    }

    /**
     * Page is equipped with three methods.
     * @throws Exception If something goes wrong
     */
    @Test
    public void equippedWithThreeMethods() throws Exception {
        final Page first = new Page();
        first.downloadWithoutCache("");
        final Page second = new Page();
        second.downloadWithoutCache("");
        MatcherAssert.assertThat(first, Matchers.equalTo(second));
        MatcherAssert.assertThat(
            first.hashCode(),
            Matchers.equalTo(second.hashCode())
        );
        MatcherAssert.assertThat(first, Matchers.hasToString("Page(cnt=1)"));
    }

}
