// ----------------------------------------------------------------------------
//
//  Copyright (C) 2010-2018 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __VUDETECT_H
#define __VUDETECT_H


class VUMdetect
{
public:

    VUMdetect (void) {}
    ~VUMdetect (void) {}

    int   init (int fsamp);
    void  reset (void);
    void  speed (bool slow) { _slow = slow; }
    void  process (int n, const float *inp);
    float value (void) { return 2.435f * _z2; }
    

private:

    bool  _slow;
    float _w;
    float _z1, _z2;
};


#endif


