// $Id: parsetreetosettings.h,v 1.18 2018/01/03 21:33:06 mkkuhner Exp $

/*
Copyright 2002-2005 Mary K. Kuhner, Peter Beerli, and Joseph Felsenstein

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

/* Authors: Peter Beerli, Mary Kuhner, Jon Yamato and Joseph Felsenstein */


#ifndef PARSETREETOSETTINGS_H
#define PARSETREETOSETTINGS_H

#include <string>
#include "defaults.h"       // for force_type
#include "parsetreewalker.h"
#include "vectorx.h"

class TiXmlElement;
class UIInterface;
class UIId;

/******************************************************************
 Walks the TinyXML parse tree generated by XmlParser (xml.h)
 and fills the UIVars variable store via UIInterface

 Based on a class by Jim Sloan, rewritten by Mary Kuhner, and
 then by Elizabeth Walkup
*********************************************************************/

class ParseTreeToSettings   : public ParseTreeWalker
{
  private:
    UIInterface&            uiInterface;

    // purposely not implemented, this class is meant to be a singleton
    ParseTreeToSettings();
    ParseTreeToSettings(const ParseTreeToSettings&);
    ParseTreeToSettings& operator=(const ParseTreeToSettings&);

  protected:

    // for stuffing data into UIInterface
    void DoOptionalElement(TiXmlElement* ancestor, std::string xmlTag, std::string uiIdentifier, UIId id = NO_ID());
    void DoRequiredElement(TiXmlElement* ancestor, std::string xmlTag, std::string uiIdentifier, UIId id = NO_ID());

    // main line data-model reading routines
    void        DoDataModels(TiXmlElement*);
    void        DoRegionDataModels(TiXmlElement*,long regionId);
    void        DoDLModel(TiXmlElement*, long regionId ,long locusId=0);
    void        DoBaseFrequencies(TiXmlElement*, UIId id);
    void        DoGTR(TiXmlElement*, UIId id);
    void        DoCategories(TiXmlElement*,UIId id);

    // main line chain parameter reading routines
    void        DoChainParams(TiXmlElement *);
    void        DoTemperatures(StringVec1d);
    void        DoSwapInterval(TiXmlElement *);

    // main line user parameter reading routines
    void        DoUserParams(TiXmlElement *);
    void        DoSeedParams(TiXmlElement *); // subset of UserParams

    // main line force parameter reading routines
    void        DoForces(TiXmlElement *);
    void        DoForceIfPresent(TiXmlElement *, force_type forcetype, const string& forcetag);
    void        DoForce(TiXmlElement *, force_type);
    void        DoStartValuesAndMethods(TiXmlElement *, UIId);
    void        DoTrueValues(TiXmlElement *, UIId);
    void        DoProfiles(TiXmlElement *, UIId);
    void        DoConstraints(TiXmlElement *, UIId);
    void        DoGroups(TiXmlElement *, UIId);
    void        DoGroup(TiXmlElement *, UIId, size_t index);
    void        DoPriors(TiXmlElement *, UIId);
    void        DoPrior(TiXmlElement *, UIId);

    void DoTraits(TiXmlElement * dataElement);
    void DoRegionTraits(TiXmlElement * traitsElement, long);
    void DoRegionTrait(TiXmlElement * traitElement, long);
    void DoLocations(TiXmlElement* locationsElement, long, long);
    void DoAnalysis(TiXmlElement* analysisElement, long, long);
    void DoPhenotypes(TiXmlElement* phenotypesElement, long, long);

  public:
    ParseTreeToSettings(XmlParser&, UIInterface &);
    virtual ~ParseTreeToSettings();
    void        ProcessFileSettings();    // processes remaining structures

};

#endif // PARSETREETOSETTINGS_H

//____________________________________________________________________________________
