/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcmaps_utils.h
    \brief  Internal header for the LCMAPS utilities.
    \author Martijn Steenbakkers for the EU DataGrid.

    This header contains the declarations of the LCMAPS utility functions:
    -# lcmaps_tokenize():
    \internal
*/

#ifndef _LCMAPS_UTILS_H
#define _LCMAPS_UTILS_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include "lcmaps_utils.h"

/******************************************************************************
 *                            Module definition
 *****************************************************************************/

/******************************************************************************
        OTHER STUFF
******************************************************************************/
/*! \name OTHER FUNCTIONS */
/*@{*/ /* Beginning of other functions */
/******************************************************************************
Function:   lcmaps_tokenize() (in modified form from globus_gatekeeper_utils.c)

Description:
    Breakup the command in to args, pointing the args array
    at the tokens. Replace white space at the end of each
    token with a null. A token maybe in quotes. 

Parameters:
    command: The command line to be parsed.
    args:    A pointer to an array of pointers to be filled it
    n:       Size of the array, on input, and set to size used on output. 
    sep:     string of separating characters

Returns:
    0 on success. 
    -1 on to malloc
    -2 on to many args
    -3 on quote not matched
******************************************************************************/
extern int lcmaps_tokenize(
        const char * command, 
        char ** args,
        int * n,
        const char * sep
);
/*@}*/ /* End of other functions */

#endif /* _LCMAPS_UTILS_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/src/pluginmanager/_lcmaps_utils.h,v $
    $Date: 2014-02-25 16:11:54 +0100 (Tue, 25 Feb 2014) $
    $Revision: 17511 $
    $Author: msalle $
******************************************************************************/
