/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.lisaac.ldt.builder.LisaacBuilder;
import org.lisaac.ldt.model.AbstractLisaacParser;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.Prototype;

class CompilerOutputParser
extends AbstractLisaacParser {
    public CompilerOutputParser(String contents) {
        super(contents);
    }

    public void run(LisaacModel model) throws CoreException {
        int startOffset = this.source.indexOf("--");
        while (startOffset != -1) {
            this.setPosition(startOffset + 2);
            if (!this.readCapIdentifier()) break;
            int severity = 0;
            if (this.lastString.compareTo("WARNING") == 0) {
                this.readWord("----------");
                severity = 1;
            } else if (this.lastString.compareTo("SYNTAX") == 0) {
                this.readWord("-----------");
                severity = 2;
            } else if (this.lastString.compareTo("SEMANTIC") == 0) {
                this.readWord("---------");
                severity = 2;
            }
            this.readLine();
            String msg = new String(this.lastString);
            msg = msg.replace('\r', ' ');
            this.readWord("Line");
            this.readInteger();
            int line = (int)this.lastInteger;
            this.readWord("column");
            this.readInteger();
            int column = (int)this.lastInteger;
            this.readWord("in");
            this.readCapIdentifier();
            String prototypeName = new String(this.lastString);
            Prototype prototype = model.getPrototype(prototypeName);
            if (prototype != null) {
                IFile file = prototype.getFile();
                IRegion region = prototype.getRegionAt(line, column);
                Position position = new Position(line, column, region.getOffset(), region.getLength());
                LisaacBuilder.addMarker(file, msg, position, severity);
            }
            startOffset = this.source.indexOf("--", this.position);
        }
    }

    private void readLine() {
        if (this.readSpace()) {
            this.string_tmp = "";
            while (this.lastCharacter() != '\u0000' && this.lastCharacter() != '\n') {
                this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                if (this.lastCharacter() == '\\') {
                    ++this.position;
                    this.readEscapeCharacter();
                    continue;
                }
                ++this.position;
            }
            ++this.position;
            this.lastString = this.string_tmp;
        }
    }
}

