/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;

public class GraphicsState
implements Cloneable {
    public static final Color DEFAULT_BACKGROUND = Color.BLACK;
    public static final Color DEFAULT_COLOR = Color.WHITE;
    public static final Shape DEFAULT_CLIP = null;
    public static final Composite DEFAULT_COMPOSITE = AlphaComposite.SrcOver;
    public static final Font DEFAULT_FONT = Font.decode(null);
    public static final Color DEFAULT_PAINT = DEFAULT_COLOR;
    public static final Stroke DEFAULT_STROKE = new BasicStroke();
    public static final AffineTransform DEFAULT_TRANSFORM = new AffineTransform();
    public static final Color DEFAULT_XOR_MODE = Color.BLACK;
    private RenderingHints hints = new RenderingHints(null);
    private Color background = DEFAULT_BACKGROUND;
    private Color color = DEFAULT_COLOR;
    private Shape clip = DEFAULT_CLIP;
    private Composite composite = DEFAULT_COMPOSITE;
    private Font font = DEFAULT_FONT;
    private Paint paint = DEFAULT_PAINT;
    private Stroke stroke = DEFAULT_STROKE;
    private AffineTransform transform = new AffineTransform(DEFAULT_TRANSFORM);
    private Color xorMode = DEFAULT_XOR_MODE;

    public Object clone() throws CloneNotSupportedException {
        GraphicsState graphicsState = (GraphicsState)super.clone();
        graphicsState.hints = (RenderingHints)this.hints.clone();
        graphicsState.clip = GraphicsUtils.clone(this.clip);
        graphicsState.transform = new AffineTransform(this.transform);
        return graphicsState;
    }

    private static Shape transformShape(Shape shape, AffineTransform affineTransform) {
        boolean bl;
        if (shape == null) {
            return null;
        }
        if (affineTransform == null || affineTransform.isIdentity()) {
            return GraphicsUtils.clone(shape);
        }
        boolean bl2 = shape instanceof Rectangle2D;
        int n = 48;
        boolean bl3 = bl = (affineTransform.getType() & n) == 0;
        if (bl2 && bl) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double[] dArray = new double[]{rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            rectangle2D = new Rectangle2D.Double();
            rectangle2D.setFrameFromDiagonal(dArray[0], dArray[1], dArray[2], dArray[3]);
            return rectangle2D;
        }
        return affineTransform.createTransformedShape(shape);
    }

    private static Shape untransformShape(Shape shape, AffineTransform affineTransform) {
        if (shape == null) {
            return null;
        }
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            return GraphicsState.transformShape(shape, affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public Shape transformShape(Shape shape) {
        return GraphicsState.transformShape(shape, this.transform);
    }

    public Shape untransformShape(Shape shape) {
        return GraphicsState.untransformShape(shape, this.transform);
    }

    public RenderingHints getHints() {
        return this.hints;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Shape getClip() {
        return this.untransformShape(this.clip);
    }

    public void setClip(Shape shape) {
        this.clip = this.transformShape(shape);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform.setTransform(affineTransform);
    }

    public Color getXorMode() {
        return this.xorMode;
    }

    public void setXorMode(Color color) {
        this.xorMode = color;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GraphicsState)) {
            return false;
        }
        GraphicsState graphicsState = (GraphicsState)object;
        return this.hints.equals(graphicsState.hints) && this.background.equals(graphicsState.background) && this.color.equals(graphicsState.color) && this.composite.equals(graphicsState.composite) && this.font.equals(graphicsState.font) && this.paint.equals(graphicsState.paint) && this.stroke.equals(graphicsState.stroke) && this.transform.equals(graphicsState.transform) && this.xorMode.equals(graphicsState.xorMode) && (this.clip != null && graphicsState.clip != null || this.clip == graphicsState.clip) && (this.clip == null || this.clip.equals(graphicsState.clip));
    }

    public boolean isDefault() {
        return this.hints.isEmpty() && this.background.equals(DEFAULT_BACKGROUND) && this.color.equals(DEFAULT_COLOR) && this.composite.equals(DEFAULT_COMPOSITE) && this.font.equals(DEFAULT_FONT) && this.paint.equals(DEFAULT_PAINT) && this.stroke.equals(DEFAULT_STROKE) && this.transform.equals(DEFAULT_TRANSFORM) && this.xorMode.equals(DEFAULT_XOR_MODE) && this.clip == DEFAULT_CLIP;
    }
}

