/**
 * \file pappsomspp/core/processing/cbor/mzcbor/mzcborreaderbase.h
 * \date 19/11/2025
 * \author Olivier Langella
 * \brief read mzcbor stream or file
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include "pappsomspp/core/processing/cbor/cborstreamreaderinterface.h"
#include "pappsomspp/core/processing/uimonitor/uimonitorinterface.h"
#include "cvparam.h"
namespace pappso
{
namespace cbor
{
namespace mzcbor
{
/**
 * @brief base class to initialize mzCBOR file parsing
 *
 * ensures stream read on regular file or any readable device
 */
class MzcborReaderBase : public CborStreamReaderInterface
{
  public:
  /**
   * Default constructor
   */
  MzcborReaderBase();

  /**
   * Destructor
   */
  virtual ~MzcborReaderBase();

  /**
   * @brief read mzCBOR file
   * @param cborp file pointer
   * @param monitor monitor read progress and messages
   */
  virtual void readCbor(QFile *cborp, pappso::UiMonitorInterface &monitor);


  /**
   * @brief read mzCBOR from any device (memory buffer or else)
   * @param cborp device pointer
   * @param monitor monitor read progress and messages
   */
  virtual void readCbor(QIODevice *cborp, pappso::UiMonitorInterface &monitor);

  virtual void close();

  bool isMzcbor() const;

  const QStringList &getMsrunIdList() const;


  protected:
  void readRoot(pappso::UiMonitorInterface &monitor);

  virtual void readMsrun();
  virtual void readReferenceableParamGroupList();

  /** @brief read the array containing cvParams to give accessions and values
   */
  std::map<QString, CvParam> getCvParamsMap();

  protected:
  bool m_stopParsing = false;

  private:
  bool m_isMzcbor = false;
  QStringList m_msrunIdList;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
