/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.TurbineException;

public class TurbineAssemblerBrokerService
extends TurbineBaseService
implements AssemblerBrokerService {
    private Hashtable factories = null;

    private Vector getFactoryGroup(String type) {
        if (!this.factories.containsKey(type)) {
            this.factories.put(type, new Vector());
        }
        return (Vector)this.factories.get(type);
    }

    private void registerFactories(String type) throws TurbineException {
        String key = "services.AssemblerBrokerService." + type;
        String[] names = TurbineResources.getStringArray(key);
        int i = 0;
        while (i < names.length) {
            try {
                Object o = Class.forName(names[i]).newInstance();
                this.registerFactory(type, (AssemblerFactory)o);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TurbineException("Failed registering " + type + " factories", t);
            }
            ++i;
        }
    }

    public void init() throws InitializationException {
        this.factories = new Hashtable();
        try {
            this.registerFactories("action");
            this.registerFactories("screen");
            this.registerFactories("navigation");
            this.registerFactories("layout");
            this.registerFactories("page");
            this.registerFactories("scheduledjob");
        }
        catch (TurbineException e) {
            throw new InitializationException("AssemblerBrokerService failed to initailize", e);
        }
        this.setInit(true);
    }

    public void registerFactory(String type, AssemblerFactory factory) {
        this.getFactoryGroup(type).add(factory);
    }

    public Assembler getAssembler(String type, String name) throws TurbineException {
        Vector facs = this.getFactoryGroup(type);
        int i = 0;
        while (i < facs.size()) {
            AssemblerFactory fac = (AssemblerFactory)facs.get(i);
            Assembler assembler = null;
            try {
                assembler = fac.getAssembler(name);
            }
            catch (Exception e) {
                throw new TurbineException("Failed to find the " + type + " named " + name, e);
            }
            if (assembler != null) {
                return assembler;
            }
            ++i;
        }
        return null;
    }
}

