// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                              avtBOVOptions.C                              //
// ************************************************************************* //

#include <avtBOVOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;

// ****************************************************************************
//  Function: GetBOVReadOptions
//
//  Purpose:
//      Creates the options for BOV readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: Alister Maguire -- generated by xml2avt
//  Creation:   Thu Sep  7 09:02:03 PDT 2017
//
// ****************************************************************************

DBOptionsAttributes *
GetBOVReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}


// ****************************************************************************
//  Function: GetBOVWriteOptions
//
//  Purpose:
//      Creates the options for BOV writers.
//
//  Programmer: Alister Maguire -- generated by xml2avt
//  Creation:   Thu Sep  7 09:02:03 PDT 2017
//
//  Modifications:
//
// ****************************************************************************

DBOptionsAttributes *
GetBOVWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    vector<string> compression;
    compression.push_back("None");
    compression.push_back("gzip");
    rv->SetEnum("Compression", 0);
    rv->SetEnumStrings("Compression", compression);
    return rv;
}
