/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class CLOPE
extends AbstractClusterer
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -567567567567588L;
    public ArrayList<CLOPECluster> clusters = new ArrayList();
    protected double m_RepulsionDefault;
    protected double m_Repulsion = this.m_RepulsionDefault = 2.6;
    protected int m_numberOfClusters = -1;
    protected int m_processed_InstanceID;
    protected int m_numberOfInstances;
    protected ArrayList<Integer> m_clusterAssignments = new ArrayList();
    protected boolean m_numberOfClustersDetermined = false;

    public int numberOfClusters() {
        this.determineNumberOfClusters();
        return this.m_numberOfClusters;
    }

    protected void determineNumberOfClusters() {
        this.m_numberOfClusters = this.clusters.size();
        this.m_numberOfClustersDetermined = true;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tRepulsion\n\t(default " + this.m_RepulsionDefault + ")", "R", 1, "-R <num>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setRepulsion(Double.parseDouble(tmpStr));
        } else {
            this.setRepulsion(this.m_RepulsionDefault);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add("" + this.getRepulsion());
        return result.toArray(new String[result.size()]);
    }

    public String repulsionTipText() {
        return "Repulsion to be used.";
    }

    public void setRepulsion(double value) {
        this.m_Repulsion = value;
    }

    public double getRepulsion() {
        return this.m_Repulsion;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        return result;
    }

    public void buildClusterer(Instances data) throws Exception {
        boolean moved;
        int clusterid;
        int i;
        this.clusters.clear();
        this.m_processed_InstanceID = 0;
        this.m_clusterAssignments.clear();
        this.m_numberOfInstances = data.numInstances();
        for (i = 0; i < data.numInstances(); ++i) {
            clusterid = this.AddInstanceToBestCluster(data.instance(i));
            this.m_clusterAssignments.add(clusterid);
        }
        do {
            moved = false;
            for (i = 0; i < data.numInstances(); ++i) {
                this.m_processed_InstanceID = i;
                clusterid = this.MoveInstanceToBestCluster(data.instance(i));
                if (clusterid == this.m_clusterAssignments.get(i)) continue;
                moved = true;
                this.m_clusterAssignments.set(i, clusterid);
            }
        } while (!moved);
        this.m_processed_InstanceID = 0;
    }

    public int AddInstanceToBestCluster(Instance inst) {
        int clustermax = -1;
        if (this.clusters.size() > 0) {
            int i;
            int tempS = 0;
            int tempW = 0;
            if (inst instanceof SparseInstance) {
                for (i = 0; i < inst.numValues(); ++i) {
                    ++tempS;
                    ++tempW;
                }
            } else {
                for (i = 0; i < inst.numAttributes(); ++i) {
                    if (inst.isMissing(i)) continue;
                    ++tempS;
                    ++tempW;
                }
            }
            double deltamax = (double)tempS / Math.pow(tempW, this.m_Repulsion);
            for (i = 0; i < this.clusters.size(); ++i) {
                CLOPECluster tempcluster = this.clusters.get(i);
                double delta = tempcluster.DeltaAdd(inst, this.m_Repulsion);
                if (!(delta > deltamax)) continue;
                deltamax = delta;
                clustermax = i;
            }
        } else {
            CLOPECluster newcluster = new CLOPECluster();
            this.clusters.add(newcluster);
            newcluster.AddInstance(inst);
            return this.clusters.size() - 1;
        }
        if (clustermax == -1) {
            CLOPECluster newcluster = new CLOPECluster();
            this.clusters.add(newcluster);
            newcluster.AddInstance(inst);
            return this.clusters.size() - 1;
        }
        this.clusters.get(clustermax).AddInstance(inst);
        return clustermax;
    }

    public int MoveInstanceToBestCluster(Instance inst) {
        int i;
        this.clusters.get(this.m_clusterAssignments.get(this.m_processed_InstanceID)).DeleteInstance(inst);
        this.m_clusterAssignments.set(this.m_processed_InstanceID, -1);
        int clustermax = -1;
        int tempS = 0;
        int tempW = 0;
        if (inst instanceof SparseInstance) {
            for (i = 0; i < inst.numValues(); ++i) {
                ++tempS;
                ++tempW;
            }
        } else {
            for (i = 0; i < inst.numAttributes(); ++i) {
                if (inst.isMissing(i)) continue;
                ++tempS;
                ++tempW;
            }
        }
        double deltamax = (double)tempS / Math.pow(tempW, this.m_Repulsion);
        for (i = 0; i < this.clusters.size(); ++i) {
            CLOPECluster tempcluster = this.clusters.get(i);
            double delta = tempcluster.DeltaAdd(inst, this.m_Repulsion);
            if (!(delta > deltamax)) continue;
            deltamax = delta;
            clustermax = i;
        }
        if (clustermax == -1) {
            CLOPECluster newcluster = new CLOPECluster();
            this.clusters.add(newcluster);
            newcluster.AddInstance(inst);
            return this.clusters.size() - 1;
        }
        this.clusters.get(clustermax).AddInstance(inst);
        return clustermax;
    }

    public int clusterInstance(Instance instance) throws Exception {
        if (this.m_processed_InstanceID >= this.m_numberOfInstances) {
            this.m_processed_InstanceID = 0;
        }
        int i = this.m_clusterAssignments.get(this.m_processed_InstanceID);
        ++this.m_processed_InstanceID;
        return i;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CLOPE clustering results\n========================================================================================\n\n");
        stringBuffer.append("Clustered instances: " + this.m_clusterAssignments.size() + "\n");
        return stringBuffer.toString() + "\n";
    }

    public String globalInfo() {
        return this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Yiling Yang and Xudong Guan and Jinyuan You");
        result.setValue(TechnicalInformation.Field.TITLE, "CLOPE: a fast and effective clustering algorithm for transactional data");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the eighth ACM SIGKDD international conference on Knowledge discovery and data mining");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.PAGES, "682-687");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM  New York, NY, USA");
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5538 $");
    }

    public static void main(String[] argv) {
        CLOPE.runClusterer(new CLOPE(), argv);
    }

    private class CLOPECluster
    implements Serializable {
        public int N = 0;
        public int W = 0;
        public int S = 0;
        public HashMap occ = new HashMap();

        private CLOPECluster() {
        }

        public void AddItem(String Item) {
            if (!this.occ.containsKey(Item)) {
                this.occ.put(Item, 1);
            } else {
                int count = (Integer)this.occ.get(Item);
                this.occ.remove(Item);
                this.occ.put(Item, ++count);
            }
            ++this.S;
        }

        public void AddItem(Integer Item) {
            if (!this.occ.containsKey(Item)) {
                this.occ.put(Item, 1);
            } else {
                int count = (Integer)this.occ.get(Item);
                this.occ.remove(Item);
                this.occ.put(Item, ++count);
            }
            ++this.S;
        }

        public void DeleteItem(String Item) {
            int count = (Integer)this.occ.get(Item);
            if (count == 1) {
                this.occ.remove(Item);
            } else {
                this.occ.remove(Item);
                this.occ.put(Item, --count);
            }
            --this.S;
        }

        public void DeleteItem(Integer Item) {
            int count = (Integer)this.occ.get(Item);
            if (count == 1) {
                this.occ.remove(Item);
            } else {
                this.occ.remove(Item);
                this.occ.put(Item, --count);
            }
            --this.S;
        }

        public double DeltaAdd(Instance inst, double r) {
            double deltaprofit;
            int S_new = 0;
            int W_new = this.occ.size();
            if (inst instanceof SparseInstance) {
                for (int i = 0; i < inst.numValues(); ++i) {
                    ++S_new;
                    if ((Integer)this.occ.get(inst.index(i)) != null) continue;
                    ++W_new;
                }
            } else {
                for (int i = 0; i < inst.numAttributes(); ++i) {
                    if (inst.isMissing(i)) continue;
                    ++S_new;
                    if ((Integer)this.occ.get(i + inst.toString(i)) != null) continue;
                    ++W_new;
                }
            }
            S_new += this.S;
            if (this.N == 0) {
                deltaprofit = (double)S_new / Math.pow(W_new, r);
            } else {
                double profit = (double)(this.S * this.N) / Math.pow(this.W, r);
                double profit_new = (double)(S_new * (this.N + 1)) / Math.pow(W_new, r);
                deltaprofit = profit_new - profit;
            }
            return deltaprofit;
        }

        public void AddInstance(Instance inst) {
            if (inst instanceof SparseInstance) {
                for (int i = 0; i < inst.numValues(); ++i) {
                    this.AddItem(inst.index(i));
                }
            } else {
                for (int i = 0; i < inst.numAttributes(); ++i) {
                    if (inst.isMissing(i)) continue;
                    this.AddItem(i + inst.toString(i));
                }
            }
            this.W = this.occ.size();
            ++this.N;
        }

        public void DeleteInstance(Instance inst) {
            if (inst instanceof SparseInstance) {
                for (int i = 0; i < inst.numValues(); ++i) {
                    this.DeleteItem(inst.index(i));
                }
            } else {
                for (int i = 0; i <= inst.numAttributes() - 1; ++i) {
                    if (inst.isMissing(i)) continue;
                    this.DeleteItem(i + inst.toString(i));
                }
            }
            this.W = this.occ.size();
            --this.N;
        }
    }
}

