# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.purestorageblock import PureStorageBlockMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPureStorageBlockMgmtReservationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PureStorageBlockMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_get(self, resource_group):
        response = self.client.reservations.get(
            resource_group_name=resource_group.name,
            reservation_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_begin_create(self, resource_group):
        response = self.client.reservations.begin_create(
            resource_group_name=resource_group.name,
            reservation_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "marketplace": {
                        "offerDetails": {
                            "offerId": "str",
                            "planId": "str",
                            "publisherId": "str",
                            "planName": "str",
                            "termId": "str",
                            "termUnit": "str",
                        },
                        "subscriptionId": "str",
                        "subscriptionStatus": "str",
                    },
                    "user": {
                        "emailAddress": "str",
                        "firstName": "str",
                        "lastName": "str",
                        "companyDetails": {
                            "companyName": "str",
                            "address": {
                                "addressLine1": "str",
                                "city": "str",
                                "country": "str",
                                "postalCode": "str",
                                "state": "str",
                                "addressLine2": "str",
                            },
                        },
                        "phoneNumber": "str",
                        "upn": "str",
                    },
                    "provisioningState": "str",
                    "reservationInternalId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_begin_update(self, resource_group):
        response = self.client.reservations.begin_update(
            resource_group_name=resource_group.name,
            reservation_name="str",
            properties={
                "properties": {
                    "user": {
                        "emailAddress": "str",
                        "firstName": "str",
                        "lastName": "str",
                        "companyDetails": {
                            "companyName": "str",
                            "address": {
                                "addressLine1": "str",
                                "city": "str",
                                "country": "str",
                                "postalCode": "str",
                                "state": "str",
                                "addressLine2": "str",
                            },
                        },
                        "phoneNumber": "str",
                        "upn": "str",
                    }
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_begin_delete(self, resource_group):
        response = self.client.reservations.begin_delete(
            resource_group_name=resource_group.name,
            reservation_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_list_by_resource_group(self, resource_group):
        response = self.client.reservations.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_list_by_subscription(self, resource_group):
        response = self.client.reservations.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_get_resource_limits(self, resource_group):
        response = self.client.reservations.get_resource_limits(
            resource_group_name=resource_group.name,
            reservation_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_get_billing_status(self, resource_group):
        response = self.client.reservations.get_billing_status(
            resource_group_name=resource_group.name,
            reservation_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reservations_get_billing_report(self, resource_group):
        response = self.client.reservations.get_billing_report(
            resource_group_name=resource_group.name,
            reservation_name="str",
        )

        # please add some check logic here by yourself
        # ...
