from __future__ import annotations

import pathlib
from uuid import UUID

class Item:
    @property
    def title(self) -> str: ...
    @property
    def path(self) -> str: ...
    @property
    def content(self) -> memoryview: ...
    @property
    def mimetype(self) -> str: ...
    @property
    def _index(self) -> int: ...
    @property
    def size(self) -> int: ...
    def __repr__(self) -> str: ...

class Entry:
    @property
    def title(self) -> str: ...
    @property
    def path(self) -> str: ...
    @property
    def _index(self) -> int: ...
    @property
    def is_redirect(self) -> bool: ...
    def get_redirect_entry(self) -> Entry: ...
    def get_item(self) -> Item: ...
    def __repr__(self) -> str: ...

class Archive:
    def __init__(self, filename: pathlib.Path) -> None: ...
    @property
    def filename(self) -> pathlib.Path: ...
    @property
    def filesize(self) -> int: ...
    def has_entry_by_path(self, path: str) -> bool: ...
    def get_entry_by_path(self, path: str) -> Entry: ...
    def has_entry_by_title(self, title: str) -> bool: ...
    def get_entry_by_title(self, title: str) -> Entry: ...
    @property
    def metadata_keys(self) -> list[str]: ...
    def get_metadata_item(self, name: str) -> Item: ...
    def get_metadata(self, name: str) -> bytes: ...
    def _get_entry_by_id(self, entry_id: int) -> Entry: ...
    @property
    def has_main_entry(self) -> bool: ...
    @property
    def main_entry(self) -> Entry: ...
    @property
    def uuid(self) -> UUID: ...
    @property
    def has_new_namespace_scheme(self) -> bool: ...
    @property
    def is_multipart(self) -> bool: ...
    @property
    def has_fulltext_index(self) -> bool: ...
    @property
    def has_title_index(self) -> bool: ...
    @property
    def has_checksum(self) -> str: ...
    @property
    def checksum(self) -> str: ...
    def check(self) -> bool: ...
    @property
    def entry_count(self) -> int: ...
    @property
    def all_entry_count(self) -> int: ...
    @property
    def article_count(self) -> int: ...
    @property
    def media_count(self) -> int: ...
    def get_illustration_sizes(self) -> set[int]: ...
    def has_illustration(self, size: int | None = None) -> bool: ...
    def get_illustration_item(self, size: int | None = None) -> Item: ...
    def __repr__(self) -> str: ...
