# SPDX-License-Identifier: MIT
# Copyright (c) 2022, Mathias Laurin

from __future__ import annotations

from typing import NoReturn, Optional, Sequence, TypeVar

T_co = TypeVar("T_co", covariant=True)

class _Entropy:
    def __init__(self) -> None: ...
    def __getstate__(self) -> NoReturn: ...
    def gather(self) -> None: ...
    def retrieve(self, __length: int) -> bytes: ...
    def update(self, __data: bytes) -> None: ...

class Random:
    _entropy: _Entropy
    def __init__(self) -> None: ...
    def __getstate__(self) -> NoReturn: ...
    def _reseed(self, __data: Optional[bytes] = None) -> None: ...
    def urandom(self, __length: int) -> None: ...
    def randbelow(self, upper_bound: int) -> int: ...
    def random(self) -> float: ...
    def getrandbits(self, __k: int) -> int: ...
    def choice(self, __seq: Sequence[T_co]) -> T_co: ...

def default_rng() -> Random: ...
