# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ArchivedCallList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the ArchivedCallList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.voice.v1.archived_call.ArchivedCallList
        :rtype: twilio.rest.voice.v1.archived_call.ArchivedCallList
        """
        super(ArchivedCallList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, date, sid):
        """
        Constructs a ArchivedCallContext

        :param date: The date of the Call in UTC.
        :param sid: The unique string that identifies this resource

        :returns: twilio.rest.voice.v1.archived_call.ArchivedCallContext
        :rtype: twilio.rest.voice.v1.archived_call.ArchivedCallContext
        """
        return ArchivedCallContext(self._version, date=date, sid=sid, )

    def __call__(self, date, sid):
        """
        Constructs a ArchivedCallContext

        :param date: The date of the Call in UTC.
        :param sid: The unique string that identifies this resource

        :returns: twilio.rest.voice.v1.archived_call.ArchivedCallContext
        :rtype: twilio.rest.voice.v1.archived_call.ArchivedCallContext
        """
        return ArchivedCallContext(self._version, date=date, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.ArchivedCallList>'


class ArchivedCallPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the ArchivedCallPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.voice.v1.archived_call.ArchivedCallPage
        :rtype: twilio.rest.voice.v1.archived_call.ArchivedCallPage
        """
        super(ArchivedCallPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ArchivedCallInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.archived_call.ArchivedCallInstance
        :rtype: twilio.rest.voice.v1.archived_call.ArchivedCallInstance
        """
        return ArchivedCallInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.ArchivedCallPage>'


class ArchivedCallContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, date, sid):
        """
        Initialize the ArchivedCallContext

        :param Version version: Version that contains the resource
        :param date: The date of the Call in UTC.
        :param sid: The unique string that identifies this resource

        :returns: twilio.rest.voice.v1.archived_call.ArchivedCallContext
        :rtype: twilio.rest.voice.v1.archived_call.ArchivedCallContext
        """
        super(ArchivedCallContext, self).__init__(version)

        # Path Solution
        self._solution = {'date': date, 'sid': sid, }
        self._uri = '/Archives/{date}/Calls/{sid}'.format(**self._solution)

    def delete(self):
        """
        Deletes the ArchivedCallInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.ArchivedCallContext {}>'.format(context)


class ArchivedCallInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, date=None, sid=None):
        """
        Initialize the ArchivedCallInstance

        :returns: twilio.rest.voice.v1.archived_call.ArchivedCallInstance
        :rtype: twilio.rest.voice.v1.archived_call.ArchivedCallInstance
        """
        super(ArchivedCallInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'date': deserialize.iso8601_date(payload.get('date')),
            'sid': payload.get('sid'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'date': date or self._properties['date'], 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ArchivedCallContext for this ArchivedCallInstance
        :rtype: twilio.rest.voice.v1.archived_call.ArchivedCallContext
        """
        if self._context is None:
            self._context = ArchivedCallContext(
                self._version,
                date=self._solution['date'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def date(self):
        """
        :returns: date
        :rtype: date
        """
        return self._properties['date']

    @property
    def sid(self):
        """
        :returns: sid
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def delete(self):
        """
        Deletes the ArchivedCallInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.ArchivedCallInstance {}>'.format(context)
