\name{db.subset}
\alias{db.subset}
\title{Subset a descriptor database and return a sub-database for the selected compounds}
\description{
'db.subset' will take a descriptor database generated by 'cmp.parse' and an
array of indecies, and return a new database for compounds
corresponding to these indecies. The returned value is a descriptor database as returned by the \code{\link{cmp.parse}} function.
}
\usage{
db.subset(db, cmps)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{db}{The database generated by 'cmp.parse'}
  \item{cmps}{An array of indecies that correspond to a set of selected
	  compounds from the database}
}
\details{
	'db.subset' creates a sub-database from 'db' by only including
	infomration that is relevant to compounds indexed by 'cmps'.
}
\value{
	Return a descriptor database for the selected compounds. The format of the database is compatible with the one returned by \code{\link{cmp.parse}}.
}

\seealso{\code{\link{cmp.parse}}, \code{\link{sdf.subset}}}
\examples{
## Note: this functionality has become obsolete since the introduction of the 
## 'apset' S4 class.

## Load sample SD file
# data(sdfsample); sdfset <- sdfsample

## Generate atom pair descriptor database for searching
# apset <- sdf2ap(sdfset) 

## Loads same atom pair sample data set provided by library
data(apset) 
db <- apset
olddb <- apset2descdb(db)

## Create a sub-database for the 1st and 2nd compound in that SDF
db_sub <- db.subset(olddb, c(1, 2))

}
\keyword{utilities}
