## ----style, echo=FALSE--------------------------------------------------------
knitr::opts_chunk$set(error=FALSE, warning=FALSE, message=FALSE)

## -----------------------------------------------------------------------------
library(scRNAseq)
fluidigm <- ReprocessedFluidigmData()
fluidigm

## -----------------------------------------------------------------------------
out <- listDatasets()

## ---- echo=FALSE--------------------------------------------------------------
out <- as.data.frame(out)
out$Taxonomy <- c(`10090`="Mouse", `9606`="Human", `8355`="Xenopus")[as.character(out$Taxonomy)]
out$Call <- sprintf("`%s`", out$Call)
knitr::kable(out)

## -----------------------------------------------------------------------------
sce <- ZeiselBrainData(ensembl=TRUE)
head(rownames(sce))

## -----------------------------------------------------------------------------
sce <- ZeiselBrainData(ensembl=TRUE, location=TRUE)
head(rowRanges(sce))

