% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_for_ard.R
\name{.nesting_rename_ard_columns}
\alias{.nesting_rename_ard_columns}
\title{Rename ARD Columns}
\usage{
.nesting_rename_ard_columns(x, variable = NULL, by = NULL, strata = NULL)
}
\arguments{
\item{x}{(\code{data.frame})\cr
a data frame}

\item{variable}{(\code{character})\cr
name of \code{variable} column in \code{x}. Default is \code{NULL}.}

\item{by}{(\code{character})\cr
character vector of names of \code{by} columns in \code{x}. Default is \code{NULL}.}

\item{strata}{(\code{character})\cr
character vector of names of \code{strata} columns in \code{x}. Default is \code{NULL}.}
}
\value{
a tibble
}
\description{
If \code{variable} is provided, adds the standard \code{variable} column to \code{x}. If \code{by}/\code{strata} are
provided, adds the standard \code{group##} column(s) to \code{x} and renames the provided columns to
\code{group##_level} in \code{x}, where \verb{##} is determined by the column's position in \code{c(by, strata)}.
}
\examples{
ard <- nest_for_ard(
  data =
    ADAE |>
      dplyr::left_join(ADSL[c("USUBJID", "ARM")], by = "USUBJID") |>
      dplyr::filter(AOCCSFL \%in\% "Y"),
  by = "ARM",
  strata = "AESOC",
  rename_columns = FALSE
)

cards:::.nesting_rename_ard_columns(ard, by = "ARM", strata = "AESOC")
}
\keyword{internal}
