% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subdendrograms.R
\name{get_subdendrograms}
\alias{get_subdendrograms}
\title{Extract a list of \emph{k} subdendrograms from a given dendrogram
object}
\usage{
get_subdendrograms(dend, k, ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{k}{the number of subdendrograms that should be extracted}

\item{...}{parameters that should be passed to the cutree
\code{\link{cutree.dendrogram}}}
}
\value{
A list of \emph{k} subdendrograms, based on the cutree
\code{\link{cutree.dendrogram}} clustering
clusters.
}
\description{
Extracts a list of subdendrogram structures based on the cutree \code{\link{cutree.dendrogram}} function
from a given dendrogram object. It can be useful in case of more exact visual
investigation of clustering results.
}
\examples{

# needed packages:
# install.packages(gplots)
# install.packages(viridis)
# install.packages(devtools)
# devtools::install_github('talgalili/dendextend') #' dendextend from github

# define dendrogram object to play with:
dend <- iris[, -5] \%>\%
  dist() \%>\%
  hclust() \%>\%
  as.dendrogram() \%>\%
  set("labels_to_character") \%>\%
  color_branches(k = 5)
dend_list <- get_subdendrograms(dend, 5)

# Plotting the result
par(mfrow = c(2, 3))
plot(dend, main = "Original dendrogram")
sapply(dend_list, plot)

# plot a heatmap of only one of the sub dendrograms
par(mfrow = c(1, 1))
library(gplots)
sub_dend <- dend_list[[1]] #' get the sub dendrogram
# make sure of the size of the dend
nleaves(sub_dend)
length(order.dendrogram(sub_dend))
# get the subset of the data
subset_iris <- as.matrix(iris[order.dendrogram(sub_dend), -5])
# update the dendrogram's internal order so to not cause an error in heatmap.2
order.dendrogram(sub_dend) <- as.integer(rank(order.dendrogram(sub_dend)))
heatmap.2(subset_iris, Rowv = sub_dend, trace = "none", col = viridis::viridis(100))
}
