% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology.R
\name{count_isomorphisms}
\alias{count_isomorphisms}
\alias{graph.count.isomorphisms.vf2}
\title{Count the number of isomorphic mappings between two graphs}
\usage{
count_isomorphisms(graph1, graph2, method = "vf2", ...)
}
\arguments{
\item{graph1}{The first graph.}

\item{graph2}{The second graph.}

\item{method}{Currently only \sQuote{vf2} is supported, see
\code{\link{isomorphic}} for details about it and extra arguments.}

\item{...}{Passed to the individual methods.}
}
\value{
Number of isomirphic mappings between the two graphs.
}
\description{
Count the number of isomorphic mappings between two graphs
}
\examples{
# colored graph isomorphism
g1 <- make_ring(10)
g2 <- make_ring(10)
isomorphic(g1, g2)

V(g1)$color <- rep(1:2, length = vcount(g1))
V(g2)$color <- rep(2:1, length = vcount(g2))
# consider colors by default
count_isomorphisms(g1, g2)
# ignore colors
count_isomorphisms(g1, g2, vertex.color1 = NULL,
    vertex.color2 = NULL)
}
\references{
LP Cordella,  P Foggia, C Sansone, and M Vento: An improved algorithm
 for matching large graphs, \emph{Proc. of the 3rd IAPR TC-15 Workshop
 on Graphbased Representations in Pattern Recognition}, 149--159, 2001.
}
\seealso{
Other graph isomorphism: 
\code{\link{count_subgraph_isomorphisms}()},
\code{\link{graph_from_isomorphism_class}()},
\code{\link{isomorphic}()},
\code{\link{isomorphism_class}()},
\code{\link{isomorphisms}()},
\code{\link{subgraph_isomorphic}()},
\code{\link{subgraph_isomorphisms}()}
}
\concept{graph isomorphism}
