% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_json.R
\name{read_json}
\alias{read_json}
\alias{parse_json}
\alias{write_json}
\title{Read/write JSON}
\usage{
read_json(path, simplifyVector = FALSE, ...)

parse_json(json, simplifyVector = FALSE, ...)

write_json(x, path, ...)
}
\arguments{
\item{path}{file on disk}

\item{simplifyVector}{simplifies nested lists into vectors and data frames. See \link{fromJSON}.}

\item{...}{additional conversion arguments, see also \link{toJSON} or \link{fromJSON}}

\item{json}{string with literal json or connection object to read from}

\item{x}{an object to be serialized to JSON}
}
\description{
These functions are similar to \link{toJSON} and \link{fromJSON} except they
explicitly distinguish between path and literal input, and do not simplify
by default.
}
\examples{
tmp <- tempfile()
write_json(iris, tmp)

# Nested lists
read_json(tmp)

# A data frame
read_json(tmp, simplifyVector = TRUE)
}
\seealso{
\code{\link{fromJSON}}, \code{\link{stream_in}}
}
