% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMetrics.R
\name{recall}
\alias{recall}
\alias{sensitivity}
\alias{tpr}
\title{Recall, Sensitivity, tpr}
\usage{
recall(actual, predicted, cutoff = 0.5)
}
\arguments{
\item{actual}{A vector of the labels}

\item{predicted}{A vector of predicted values}

\item{cutoff}{A cutoff for the predicted values}
}
\description{
True Positives / (True Positives + False Negatives)
}
\examples{
data(testDF)
glmModel <- glm(y ~ ., data = testDF, family="binomial")
Preds <- predict(glmModel, type = 'response')

recall(testDF$y, Preds, cutoff = 0)
sensitivity(testDF$y, Preds, cutoff = 0)
tpr(testDF$y, Preds, cutoff = 0)

}
