% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc_coord.R
\name{nc_coord_var}
\alias{nc_coord_var}
\alias{nc_coord_var.character}
\alias{nc_coord_var.NetCDF}
\title{Get Coordinate Variables for Given Variable}
\usage{
nc_coord_var(x, variable = NULL, ...)

\method{nc_coord_var}{character}(x, variable = NULL, ...)

\method{nc_coord_var}{NetCDF}(x, variable = NULL, ...)
}
\arguments{
\item{x}{NetCDF source}

\item{variable}{variable name of interest.
If not included, all variables will be returned.}

\item{...}{ignored}
}
\value{
tibble with "variable", "X", "Y", "Z", "T", and "bounds" columns that reference
variables by name.
}
\description{
In NetCDF, variables are defined along dimensions and are said to have "coordinate
variables" that define the (typically spatio-temporal) positions of the data's cells.
}
\details{
This function attempts to identify the X, Y, Z, and T coordinate variables for each
data variable in the provided NetCDF source. The NetCDF-CF attribute conventions are
used to make this determination.

All variables that can be related to a spatio-temporal axis, including coordinate
variables are returned. For coordinate variables, a "bounds" column is included in
the response indicating which variable contains bounds information.

See \url{http://cfconventions.org/cf-conventions/v1.6.0/cf-conventions.html#coordinate-system}
for more.
}
\examples{
f <- system.file("extdata", "S2008001.L3m_DAY_CHL_chlor_a_9km.nc", package = "ncmeta")
nc_coord_var(f, "chlor_a")

f <- system.file("extdata", "guam.nc", package = "ncmeta")
nc_coord_var(f)
}
