% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_classes.R
\docType{data}
\name{pd_class_definitions}
\alias{pd_class_definitions}
\alias{pd_is_class_definition}
\alias{pd_is_in_class_definition}
\alias{pd_add_class_definition}
\alias{pd_add_class}
\title{Test for Class Definitions}
\format{An object of class \code{environment} of length 12.}
\usage{
pd_class_definitions

pd_is_class_definition(id, pd, .check = TRUE)

pd_is_in_class_definition(id, pd, .check = TRUE)

pd_add_class_definition(
  name,
  test.is,
  test.in,
  .exists = TRUE,
  .overwrite = FALSE
)

pd_add_class(name, .exists = TRUE, .overwrite = FALSE)
}
\arguments{
\item{id}{id(s) to test.}

\item{pd}{parse data which contains id.}

\item{.check}{should the id, and pd be checked?}

\item{name}{name of the class defining function}

\item{test.is}{function accepting arguments \code{id} and \code{pd} which
tests if given \code{id} is associated with the defined
class defining functions.}

\item{test.in}{function accepting arguments \code{id} and \code{pd} which
tests if given \code{id} is contained in the defined
class defining functions.}

\item{.exists}{require the function to exists to add.}

\item{.overwrite}{if TRUE allows for overwriting existing test functions.}
}
\description{
These function manage adding class defining functions and
testing if an id is associated with a class definition or
if is contained in the class definition.
}
\details{
\subsection{\code{pd_class_definitions$has}}{
\subsection{Usage}{\preformatted{
        pd_class_definitions$has(name)
    }}
Check if a class defining function has
'is' and 'in' function defined for it.
}
\subsection{\code{pd_class_definitions$add} or \code{pd_add_class}}{
\subsection{Usage}{\preformatted{
pd_class_definitions$add(name, .exists=TRUE, .overwrite=FALSE)

pd_add_class(name, .exists=TRUE, .overwrite=FALSE)
}}
Add a def with default 'is' and 'in' functions defined.
}
\subsection{\code{pd_class_definitions$add_definition} or \code{pd_add_class_definition}}{
\subsection{Usage}{\preformatted{
pd_class_definitions$add_definition(name, test.is, test.in, .exists=TRUE, .overwrite=FALSE)

pd_add_class_definition(name, test.is, test.in, .exists=TRUE, .overwrite=FALSE)
}}
Add a class defining function with custom 'is' and 'in' functions defined.
}
\subsection{\code{pd_class_definitions$rm}}{
\subsection{Usage}{\preformatted{
pd_class_definitions$rm(name)
}}
Remove the testing functions for the class.
}
\subsection{\code{pd_class_definitions$names}}{
\subsection{Usage}{\preformatted{
pd_class_definitions$names()
}}
Return a vector of the classed for which tests are defined.
}
\subsection{\code{pd_class_definitions$test_is}}{
\subsection{Usage}{\preformatted{
pd_class_definitions$test_is(id, pd, check=TRUE)
}}
Test if \code{id} is associated with each of
defined class definitions.
}
\subsection{\code{pd_class_definitions$test_is_in}}{
\subsection{Usage}{\preformatted{
pd_class_definitions$test_is_in(id, pd, check=TRUE)
}}
Test if \code{id} is contained within each of
defined class definitions.
}
\subsection{\code{pd_class_definitions$which}}{
\subsection{Usage}{\preformatted{
pd_class_definitions$which(id, pd, check=TRUE)
}}
Return the name of the class, if any,
which \code{id} corresponds to.
}
\subsection{\code{pd_class_definitions$in_which}}{
\subsection{Usage}{\preformatted{
pd_class_definitions$in_which(id, pd, check=TRUE)
}}
Returns a vector of the classes, if any,
of the classes which \code{id} is contained in.
}
\subsection{\code{pd_is_class_definition}}{
Returns \code{TRUE} if the id corresponds to any of the
class defining calls.
}
}
\examples{
# load example file and get_parse data
ex.file <- system.file("examples", "example.R", package="parsetools")
exprs <- parse(ex.file, keep.source = TRUE)
pd <- get_parse_data(exprs)

# There are 3 expressions so there should be three roots.
sum(pd_is_root(pd$id, pd))
roots <- pd_all_root_ids(pd)

# Get the 'setClass' call.
class.id <- pd_get_assign_value_id(roots[2], pd)
# Check to make sure that it is a function that sets a class.
pd_is_class_definition(class.id, pd)
# and that it is the setClass call.
pd_text(pd_get_call_symbol_id(class.id, pd), pd)

}
\keyword{datasets}
