% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/withProgressShiny.R
\name{withProgressShiny}
\alias{withProgressShiny}
\title{Use Progressr in Shiny Apps: Plug-in Backward Compatibility Replacement for shiny::withProgress()}
\usage{
withProgressShiny(
  expr,
  ...,
  message = NULL,
  detail = NULL,
  inputs = list(message = NULL, detail = "message"),
  env = parent.frame(),
  quoted = FALSE,
  handlers = c(shiny = handler_shiny, progressr::handlers(default = NULL))
)
}
\arguments{
\item{expr, \ldots, env, quoted}{Arguments passed to \link[shiny:withProgress]{shiny::withProgress} as is.}

\item{message, detail}{(character string) The message and the detail message to be passed to \code{\link[shiny:withProgress]{shiny::withProgress()}}.}

\item{inputs}{(named list) Specifies from what sources the Shiny progress
elements 'message' and 'detail' should be updated.  Valid sources are
\code{"message"}, \code{"sticky_message"} and \code{"non_sticky_message"}, where
\code{"message"} is short for \code{c("non_sticky_message", "sticky_message")}. For
example, \code{inputs = list(message = "sticky_message", detail = "message")}
will update the Shiny 'message' component from sticky messages only,
whereas the 'detail' component is updated using any message.}

\item{handlers}{Zero or more progression handlers used to report on progress.}
}
\value{
The value of \link[shiny:withProgress]{shiny::withProgress}.
}
\description{
Use Progressr in Shiny Apps: Plug-in Backward Compatibility Replacement for shiny::withProgress()
}
\section{Requirements}{

This function requires the \pkg{shiny} package and will use the
\code{\link[=handler_shiny]{handler_shiny()}} \strong{progressr} handler internally to report on updates.
}

\examples{
library(shiny)
library(progressr)

app <- shinyApp(
  ui = fluidPage(
    plotOutput("plot")
  ),

  server = function(input, output) {
    output$plot <- renderPlot({
      X <- 1:15
      withProgressShiny(message = "Calculation in progress",
                        detail = "Starting ...",
                        value = 0, {
        p <- progressor(along = X)
        y <- lapply(X, FUN=function(x) {
          Sys.sleep(0.25)
          p(sprintf("x=\%d", x))
        })
      })
      
      plot(cars)

      ## Terminate the Shiny app
      Sys.sleep(1.0)
      stopApp(returnValue = invisible())
    })
  }
)

local({
  oopts <- options(device.ask.default = FALSE)
  on.exit(options(oopts))
  if (interactive()) print(app)
})
}
