% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-accessors.R, R/s2-transformers.R
\name{s2_project}
\alias{s2_project}
\alias{s2_project_normalized}
\alias{s2_interpolate}
\alias{s2_interpolate_normalized}
\title{Linear referencing}
\usage{
s2_project(x, y, radius = s2_earth_radius_meters())

s2_project_normalized(x, y)

s2_interpolate(x, distance, radius = s2_earth_radius_meters())

s2_interpolate_normalized(x, distance_normalized)
}
\arguments{
\item{x}{A simple polyline geography vector}

\item{y}{A simple point geography vector. The point will be
snapped to the nearest point on \code{x} for the purposes of
interpolation.}

\item{radius}{Radius of the earth. Defaults to the average radius of
the earth in meters as defined by \code{\link[=s2_earth_radius_meters]{s2_earth_radius_meters()}}.}

\item{distance}{A distance along \code{x} in \code{radius} units.}

\item{distance_normalized}{A \code{distance} normalized to \code{\link[=s2_length]{s2_length()}} of
\code{x}.}
}
\value{
\itemize{
\item \code{s2_interpolate()} returns the point on \code{x}, \code{distance} meters
along the line.
\item \code{s2_interpolate_normalized()} returns the point on \code{x} interpolated
to a fraction along the line.
\item \code{s2_project()} returns the \code{distance} that \code{point} occurs along \code{x}.
\item \code{s2_project_normalized()} returns the \code{distance_normalized} along \code{x}
where \code{point} occurs.
}
}
\description{
Linear referencing
}
\examples{
s2_project_normalized("LINESTRING (0 0, 0 90)", "POINT (0 22.5)")
s2_project("LINESTRING (0 0, 0 90)", "POINT (0 22.5)")
s2_interpolate_normalized("LINESTRING (0 0, 0 90)", 0.25)
s2_interpolate("LINESTRING (0 0, 0 90)", 2501890)

}
