#!/usr/bin/python3
""" This script is used to generate values for
    config/Fedora/configs/Fedora/users-groups.toml
"""

import datetime
import os
import re

users = set()
groups = set()
uidgid_regex = re.compile(r'^\s*(\S+)\s+(-|\d+)\s+(-|\d+|\(\d+\))\s')
for uidgid_file in ['/usr/share/doc/setup/uidgid']:
    if os.path.exists(uidgid_file):
        with open(uidgid_file) as fobj:
            try:
                for line in fobj.read().strip().splitlines():
                    if line.startswith('#'):
                        continue
                    res = uidgid_regex.search(line)
                    if res:
                        name = res.group(1)
                        if res.group(2) != '-':
                            users.add(name)
                        if res.group(3) != '-' and '(' not in res.group(3):
                            groups.add(name)
                    del res
                del line
            finally:
                fobj.close()
            del fobj

name = '/'.join(__file__.split('/')[-2:])
date = datetime.datetime.utcnow().strftime('%Y-%m-%d')
print(f'# generated by {name} on {date}\n')

print(f'StandardUsers = {sorted(users)}\n')

print(f'StandardGroups = {sorted(groups)}')
