# 2024-04-29 Triage Log

Several non-noise changes this week, with both improvements and regresions
coming as a result. Overall compiler performance is roughly neutral across the
week.

Triage done by **@simulacrum**.
Revision range: [a77f76e2..c65b2dc9](https://perf.rust-lang.org/?start=a77f76e26302e9a084fb321817675b1dfc1dcd63&end=c65b2dc935c27c0c8c3997c6e8d8894718a2cb1a&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.4%]    | 104   |
| Regressions ❌ <br /> (secondary)  | 2.4%  | [0.2%, 23.7%]   | 81    |
| Improvements ✅ <br /> (primary)   | -3.8% | [-26.1%, -0.3%] | 10    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-4.6%, -0.5%]  | 12    |
| All ❌✅ (primary)                 | 0.1%  | [-26.1%, 1.4%]  | 114   |


2 Regressions, 2 Improvements, 3 Mixed; 1 of them in rollups
51 artifact comparisons made in total

#### Regressions

Use fulfillment in method probe, not evaluation [#122317](https://github.com/rust-lang/rust/pull/122317) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ad07aa12c99698f810d730d7b5a49704c729651d&end=cd90d5c03532da6f7ca7dcfb861ffabdc36a9d00&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.2%, 1.3%]  | 38    |
| Regressions ❌ <br /> (secondary)  | 4.2% | [0.5%, 23.6%] | 39    |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.2%, 1.3%]  | 38    |

Some additional attempts to fix perf were done in a follow-up PR
(https://github.com/rust-lang/rust/pull/124303) but did not pan out to be
successful. It looks like this is a correctness fix, so we'll need to accept
the regressions for now.

Stabilize `Utf8Chunks` [#123909](https://github.com/rust-lang/rust/pull/123909) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1b3a32958bb54bde45e693217e8f7469459e5865&end=4d570eea025a19564429eb52b34ec34e14659f55&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.2%, 1.1%] | 11    |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.3%, 1.2%] | 19    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.2%, 1.1%] | 11    |

The regressions are in doc builds, but are not really expected from what is a
relatively small change. Further investigation feels warranted (see
https://github.com/rust-lang/rust/pull/123909#issuecomment-2082668500).

#### Improvements

Rollup of 5 pull requests [#124289](https://github.com/rust-lang/rust/pull/124289) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c67277301c896857d0534f2bb7431680796833fb&end=ad07aa12c99698f810d730d7b5a49704c729651d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 7     |

Unclear whether this is a genuine improvement. Performance seems to have
re-regressed in #123126 (see Mixed results below), so this may just be
bimodality of some kind.

Set writable and dead_on_unwind attributes for sret arguments [#121298](https://github.com/rust-lang/rust/pull/121298) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cb3752d20e0f5d24348062211102a08d46fbecff&end=284f94f9c0f77ad4ef85323a634cfda29c1a801d&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.5%, 0.5%]    | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -3.1% | [-26.0%, -0.3%] | 12    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-4.4%, -0.5%]  | 11    |
| All ❌✅ (primary)                 | -2.8% | [-26.0%, 0.5%]  | 13    |

#### Mixed

Enable `CrateNum` query feeding via `TyCtxt` [#123126](https://github.com/rust-lang/rust/pull/123126) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=40dcd796d094b911b8b7b55a0519fb8e3d21680f&end=244da22fabd9fa677bbd0ac601a88e5ca6917526&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.6%]   | 19    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 5     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.7%, -0.7%] | 2     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.6%]   | 19    |

This looks like it's mostly just a regression to incremental. The PR
description notes this is expected and sounds like there's follow-up work
planned (unclear whether it will help with performance though).

Stop using LLVM struct types for alloca [#122053](https://github.com/rust-lang/rust/pull/122053) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c1feb3eceef7d5f0126c309a87062cf413fe0a25&end=29a56a3b1c06a624c0c06728c0af756d09df6b1b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 1.1%]   | 17    |
| Improvements ✅ <br /> (primary)   | -1.9% | [-1.9%, -1.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | -0.0% | [-1.9%, 0.3%]  | 9     |

Instruction counts are predominantly affected by some shuffling inside LLVM,
but cycles are largely unaffected. See detailed analysis in
https://github.com/rust-lang/rust/pull/122053#issuecomment-2074850501.

Abort a process when FD ownership is violated [#124210](https://github.com/rust-lang/rust/pull/124210) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6c90ac8d8f4489472720fce03c338cd5d0977f33&end=cb4940645775f60d74aee2e018d6c516c5aa9ed7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-0.8%, -0.8%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 2     |
| All ❌✅ (primary)                 | 0.0%  | [-0.8%, 0.4%]  | 3     |

Based on the [self profile results](https://perf.rust-lang.org/detailed-query.html?commit=cb4940645775f60d74aee2e018d6c516c5aa9ed7&benchmark=cargo-0.60.0-opt&scenario=full&base_commit=6c90ac8d8f4489472720fce03c338cd5d0977f33&sort_idx=-12)
I suspect this is caused by us generating more code in the downstream crate(s)
as a result of the late-bound ub checks.
