# Release Notes v0.11.3 : Performance Stabilization

This release somewhat stabilizes the performance profile of analysis across platforms.
The stabilization results in up to 20% analysis performance regression;
however, this regression is compensated
by slightly improved BDD/ZBDD variable ordering heuristics,
which increases performance by around 20%.


## Major Changes

- CacheTable for BDD (10% memory and 20% speed improvement)
- Space-optimized container (2-3x memory efficient) for final analysis products
  (However, the maximum product order is limited to 32.)
- Generic XML data streaming (25% reporting speed improvement)
- XML streaming optimization for static string literals
  (10-15% reporting speed improvement)
- Simplified role-based (private and public) element lookup in models
  (at least 30% speed improvement for model element initialization)
- Continuous integration on Windows (#130)
- Continuous integration on Mac OS X (#129)


## Minor Changes

- Numerical operation expressions: ``neg``, ``add``, ``sub``, ``mul``, ``div``, ``pi``.


## Removed Features

- Fault tree graphical representation with Graphviz


## Bug Fixes

- Regression in detection of duplicate input files (#131)
- Regression in handling an undefined event with mixed roles and types in Model input (#141)
  (The bug was introduced in version 0.11.1)


## Since v0.11.2

139 commits resulted in 179 files changed, 6334 insertions(+), 4752 deletions(-)

- Core : 62 files changed, 3670 insertions(+), 3401 deletions(-)
- Scripts : 3 files changed, 29 insertions(+), 18 deletions(-)
- GUI : 5 files changed, 70 insertions(+), 44 deletions(-)
- Tests : 40 files changed, 864 insertions(+), 378 deletions(-)
- Documentation : 36 files changed, 1113 insertions(+), 280 deletions(-)
