/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_25 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4801, "epsg", 4801,
        "Bern 1898 (Bern)", 1, 1,
        "Bessel 1841", "Bern",
        "CH1903_Bern", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.");
    add_proj4text (p, 1,
        "346,0,0,0,0 +pm=bern +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bern 1898 (Bern)\",DATUM[\"CH1903_Bern\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6801\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Bern\",7.43958333333333,AUTHORITY[\"EPSG\",\"8907\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4801\"]]");
    p = add_epsg_def_ex (filter, first, last, 4802, "epsg", 4802,
        "Bogota 1975 (Bogota)", 1, 1,
        "International 1924", "Bogota",
        "Bogota_1975_Bogota", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 ");
    add_proj4text (p, 1,
        "+pm=bogota +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bogota 1975 (Bogota)\",DATUM[\"Bogota_1975_Bogo");
    add_srs_wkt (p, 1,
        "ta\",SPHEROID[\"International 1924\",6378388,297,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6802\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Bogota\",-74.0809166666667,AUTHORITY[\"EPSG\",\"89");
    add_srs_wkt (p, 4,
        "04\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitud");
    add_srs_wkt (p, 6,
        "e\",EAST],AUTHORITY[\"EPSG\",\"4802\"]]");
    p = add_epsg_def_ex (filter, first, last, 4803, "epsg", 4803,
        "Lisbon (Lisbon)", 1, 1,
        "International 1924", "Lisbon",
        "Lisbon_1937_Lisbon", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-304.046,-60.576,103.");
    add_proj4text (p, 1,
        "64,0,0,0,0 +pm=lisbon +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6803\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Lisbon\",-9.13190611111111,AUTHORITY[\"EPSG\",\"8902\"]]");
    add_srs_wkt (p, 4,
        ",UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4803\"]]");
    p = add_epsg_def_ex (filter, first, last, 4804, "epsg", 4804,
        "Makassar (Jakarta)", 1, 1,
        "Bessel 1841", "Jakarta",
        "Makassar_Jakarta", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.7");
    add_proj4text (p, 1,
        "6,0,0,0,0 +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Makassar (Jakarta)\",DATUM[\"Makassar_Jakarta\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6804\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Jakarta\",106.807719444444,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "908\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4804\"]]");
    p = add_epsg_def_ex (filter, first, last, 4805, "epsg", 4805,
        "MGI (Ferro)", 1, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,");
    add_proj4text (p, 1,
        "0 +pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MGI (Ferro)\",DATUM[\"Militar-Geographische_Ins");
    add_srs_wkt (p, 1,
        "titut_Ferro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1");
    add_srs_wkt (p, 2,
        "528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6805\"]],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8909\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4805\"]]");
    p = add_epsg_def_ex (filter, first, last, 4806, "epsg", 4806,
        "Monte Mario (Rome)", 1, 1,
        "International 1924", "Rome",
        "Monte_Mario_Rome", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.9");
    add_proj4text (p, 1,
        "71,-2.917,0.714,-11.68 +pm=rome +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Monte Mario (Rome)\",DATUM[\"Monte_Mario_Rome\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6806\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Rome\",12.4523333333333,AUTHORITY[\"EPSG\",\"8906\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4806\"]]");
    p = add_epsg_def_ex (filter, first, last, 4807, "epsg", 4807,
        "NTF (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,");
    add_proj4text (p, 1,
        "320,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Fr");
    add_srs_wkt (p, 1,
        "ancaise_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4807\"]]");
    p = add_epsg_def_ex (filter, first, last, 4808, "epsg", 4808,
        "Batavia (Jakarta)", 1, 1,
        "Bessel 1841", "Jakarta",
        "Batavia_Jakarta", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Batavia (Jakarta)\",DATUM[\"Batavia_Jakarta\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6813\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Jakarta\",106.807719444444,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "8\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4813\"]]");
    p = add_epsg_def_ex (filter, first, last, 4809, "epsg", 4809,
        "Belge 1950 (Brussels)", 1, 1,
        "International 1924", "Brussels",
        "Reseau_National_Belge_1950_Brussels", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +pm=brussels +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Belge 1950 (Brussels)\",DATUM[\"Reseau_National");
    add_srs_wkt (p, 1,
        "_Belge_1950_Brussels\",SPHEROID[\"International 1924\",6");
    add_srs_wkt (p, 2,
        "378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6809\"]],PRIMEM[\"Brussels\",4.367975,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8910\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4809\"]]");
    p = add_epsg_def_ex (filter, first, last, 4810, "epsg", 4810,
        "Tananarive (Paris)", 1, 1,
        "International 1924", "Paris",
        "Tananarive_1925_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0");
    add_proj4text (p, 1,
        " +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925_Pa");
    add_srs_wkt (p, 1,
        "ris\",SPHEROID[\"International 1924\",6378388,297,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6810\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "05\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4810\"]]");
    p = add_epsg_def_ex (filter, first, last, 4811, "epsg", 4811,
        "Voirol 1875 (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Voirol_1875_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,");
    add_proj4text (p, 1,
        "227,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1875 (Paris)\",DATUM[\"Voirol_1875_Paris");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129");
    add_srs_wkt (p, 2,
        "3627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6811\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4811\"]]");
    p = add_epsg_def_ex (filter, first, last, 4812, "epsg", 4812,
        "New Beijing / 3-degree Gauss-Kruger CM 132E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 132E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",132],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4812\"]]");
    p = add_epsg_def_ex (filter, first, last, 4813, "epsg", 4813,
        "Batavia (Jakarta)", 1, 1,
        "Bessel 1841", "Jakarta",
        "Batavia_Jakarta", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-377,681,-50,0,0,0,");
    add_proj4text (p, 1,
        "0 +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Batavia (Jakarta)\",DATUM[\"Batavia_Jakarta\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6813\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Jakarta\",106.807719444444,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "8\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4813\"]]");
    p = add_epsg_def_ex (filter, first, last, 4814, "epsg", 4814,
        "RT38 (Stockholm)", 1, 1,
        "Bessel 1841", "Stockholm",
        "Stockholm_1938_Stockholm", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=stockholm +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RT38 (Stockholm)\",DATUM[\"Stockholm_1938_Stock");
    add_srs_wkt (p, 1,
        "holm\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6814\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Stockholm\",18.0582777777778,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8911\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4814\"]]");
    p = add_epsg_def_ex (filter, first, last, 4815, "epsg", 4815,
        "Greek (Athens)", 1, 1,
        "Bessel 1841", "Athens",
        "Greek_Athens", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=athens +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Greek (Athens)\",DATUM[\"Greek_Athens\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6815\"]],PRIMEM[\"A");
    add_srs_wkt (p, 3,
        "thens\",23.7163375,AUTHORITY[\"EPSG\",\"8912\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4815\"]]");
    p = add_epsg_def_ex (filter, first, last, 4816, "epsg", 4816,
        "Carthage (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Carthage_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-263,6,43");
    add_proj4text (p, 1,
        "1,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Carthage (Paris)\",DATUM[\"Carthage_Paris\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293627,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6816\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4816\"]]");
    p = add_epsg_def_ex (filter, first, last, 4817, "epsg", 4817,
        "NGO 1948 (Oslo)", 1, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs");
    add_proj4text (p, 1,
        "84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NGO 1948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Bessel Modified\",6377492.018,299.1528128,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7005\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Oslo\",10.7229166666667,AUTHORITY[\"EPSG\",\"8913\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4817\"]]");
    p = add_epsg_def_ex (filter, first, last, 4818, "epsg", 4818,
        "S-JTSK (Ferro)", 1, 1,
        "Bessel 1841", "Ferro",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_Ferro", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=589,76,480,0,0,0,0 ");
    add_proj4text (p, 1,
        "+pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"S-JTSK (Ferro)\",DATUM[\"System_of_the_Unified_");
    add_srs_wkt (p, 1,
        "Trigonometrical_Cadastral_Network_Ferro\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6818\"]],PRIMEM[\"Ferro\",");
    add_srs_wkt (p, 4,
        "-17.6666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4818\"]]");
    p = add_epsg_def_ex (filter, first, last, 4819, "epsg", 4819,
        "Nord Sahara 1959", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-209.3622,-87.8162,");
    add_proj4text (p, 1,
        "404.6198,0.0046,3.4784,0.5805,-1.4547 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nord Sahara 1959\",DATUM[\"Nord_Sahara_1959\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6307\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4307\"]]");
    p = add_epsg_def_ex (filter, first, last, 4820, "epsg", 4820,
        "Segara (Jakarta)", 1, 1,
        "Bessel 1841", "Jakarta",
        "Gunung_Segara_Jakarta", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 1,
        " +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Segara (Jakarta)\",DATUM[\"Gunung_Segara_Jakart");
    add_srs_wkt (p, 1,
        "a\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6820\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Jakarta\",106.807719444444,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8908\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4820\"]]");
    p = add_epsg_def_ex (filter, first, last, 4821, "epsg", 4821,
        "Voirol 1879 (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Voirol_1879_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1879 (Paris)\",DATUM[\"Voirol_1879_Paris");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129");
    add_srs_wkt (p, 2,
        "3627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6821\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4821\"]]");
    p = add_epsg_def_ex (filter, first, last, 4822, "epsg", 4822,
        "New Beijing / 3-degree Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 135E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",135],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4822\"]]");
    p = add_epsg_def_ex (filter, first, last, 4823, "epsg", 4823,
        "Sao Tome", 1, 1,
        "International 1924", "Greenwich",
        "Sao_Tome", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sao Tome\",DATUM[\"Sao_Tome\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1044\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4823");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4824, "epsg", 4824,
        "Principe", 1, 1,
        "International 1924", "Greenwich",
        "Principe", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Principe\",DATUM[\"Principe\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1046\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4824");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4826, "epsg", 4826,
        "WGS 84 / Cape Verde National", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=15 +lat_2=16.66666666666667 +lat_0=15.8");
    add_proj4text (p, 1,
        "3333333333333 +lon_0=-24 +x_0=161587.83 +y_0=128511.202 ");
    add_proj4text (p, 2,
        "+datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Cape Verde National\",GEOGCS[\"WGS 84\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",15.8333333333333],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-24],PARAMETER[\"standard_parallel_1\",15],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",16.6666666666667],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",161587.83],PARAMETER[\"false_northing\",12");
    add_srs_wkt (p, 11,
        "8511.202],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"4826\"]]");
    p = add_epsg_def_ex (filter, first, last, 4839, "epsg", 4839,
        "ETRS89 / LCC Germany (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.66666666666666 +lat_2=53.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=51 +lon_0=10.5 +x_0=0 +y_0=0 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / LCC Germany (N-E)\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",51],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",10.5],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",48.6666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",53.6666666666667],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"4839\"]]");
    p = add_epsg_def_ex (filter, first, last, 4855, "epsg", 4855,
        "ETRS89 / NTM zone 5", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=5.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 5\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",5.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5105\"]]");
    p = add_epsg_def_ex (filter, first, last, 4856, "epsg", 4856,
        "ETRS89 / NTM zone 6", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 6\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",6.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5106\"]]");
    p = add_epsg_def_ex (filter, first, last, 4857, "epsg", 4857,
        "ETRS89 / NTM zone 7", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=7.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 7\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",7.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5107\"]]");
    p = add_epsg_def_ex (filter, first, last, 4858, "epsg", 4858,
        "ETRS89 / NTM zone 8", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=8.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 8\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",8.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5108\"]]");
    p = add_epsg_def_ex (filter, first, last, 4859, "epsg", 4859,
        "ETRS89 / NTM zone 9", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 9\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",9.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5109\"]]");
    p = add_epsg_def_ex (filter, first, last, 4860, "epsg", 4860,
        "ETRS89 / NTM zone 10", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 10\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",10.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5110\"]]");
    p = add_epsg_def_ex (filter, first, last, 4861, "epsg", 4861,
        "ETRS89 / NTM zone 11", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 11\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",11.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5111\"]]");
    p = add_epsg_def_ex (filter, first, last, 4862, "epsg", 4862,
        "ETRS89 / NTM zone 12", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 12\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",12.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5112\"]]");
    p = add_epsg_def_ex (filter, first, last, 4863, "epsg", 4863,
        "ETRS89 / NTM zone 13", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 13\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",13.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5113\"]]");
    p = add_epsg_def_ex (filter, first, last, 4864, "epsg", 4864,
        "ETRS89 / NTM zone 14", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 14\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",14.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5114\"]]");
    p = add_epsg_def_ex (filter, first, last, 4865, "epsg", 4865,
        "ETRS89 / NTM zone 15", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 15\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",15.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5115\"]]");
    p = add_epsg_def_ex (filter, first, last, 4866, "epsg", 4866,
        "ETRS89 / NTM zone 16", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 16\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",16.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5116\"]]");
    p = add_epsg_def_ex (filter, first, last, 4867, "epsg", 4867,
        "ETRS89 / NTM zone 17", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 17\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",17.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5117\"]]");
    p = add_epsg_def_ex (filter, first, last, 4868, "epsg", 4868,
        "ETRS89 / NTM zone 18", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 18\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",18.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5118\"]]");
    p = add_epsg_def_ex (filter, first, last, 4869, "epsg", 4869,
        "ETRS89 / NTM zone 19", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 19\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",19.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5119\"]]");
    p = add_epsg_def_ex (filter, first, last, 4870, "epsg", 4870,
        "ETRS89 / NTM zone 20", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 20\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",20.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5120\"]]");
    p = add_epsg_def_ex (filter, first, last, 4871, "epsg", 4871,
        "ETRS89 / NTM zone 21", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 21\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",21.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5121\"]]");
    p = add_epsg_def_ex (filter, first, last, 4872, "epsg", 4872,
        "ETRS89 / NTM zone 22", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 22\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",22.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5122\"]]");
    p = add_epsg_def_ex (filter, first, last, 4873, "epsg", 4873,
        "ETRS89 / NTM zone 23", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 23\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",23.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5123\"]]");
    p = add_epsg_def_ex (filter, first, last, 4874, "epsg", 4874,
        "ETRS89 / NTM zone 24", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 24\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",24.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5124\"]]");
    p = add_epsg_def_ex (filter, first, last, 4875, "epsg", 4875,
        "ETRS89 / NTM zone 25", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 25\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",25.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5125\"]]");
    p = add_epsg_def_ex (filter, first, last, 4876, "epsg", 4876,
        "ETRS89 / NTM zone 26", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=26.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 26\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",26.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5126\"]]");
    p = add_epsg_def_ex (filter, first, last, 4877, "epsg", 4877,
        "ETRS89 / NTM zone 27", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 27\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",27.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5127\"]]");
    p = add_epsg_def_ex (filter, first, last, 4878, "epsg", 4878,
        "ETRS89 / NTM zone 28", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 28\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",28.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5128\"]]");
    p = add_epsg_def_ex (filter, first, last, 4879, "epsg", 4879,
        "ETRS89 / NTM zone 29", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 29\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",29.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5129\"]]");
    p = add_epsg_def_ex (filter, first, last, 4880, "epsg", 4880,
        "ETRS89 / NTM zone 30", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 30\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",30.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5130\"]]");
    p = add_epsg_def_ex (filter, first, last, 4883, "epsg", 4883,
        "Slovenia 1996", 1, 1,
        "GRS 1980", "Greenwich",
        "Slovenia_Geodetic_Datum_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Slovenia 1996\",DATUM[\"Slovenia Geodetic Datu");
    add_srs_wkt (p, 1,
        "m 1996\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Slo");
    add_srs_wkt (p, 9,
        "venia - onshore and offshore.\"],BBOX[45.42,13.38,46.88,");
    add_srs_wkt (p, 10,
        "16.61]],ID[\"EPSG\",4883]]");
    p = add_epsg_def_ex (filter, first, last, 4885, "epsg", 4885,
        "RSRGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Ross_Sea_Region_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RSRGD2000\",DATUM[\"Ross Sea Region Geodetic D");
    add_srs_wkt (p, 1,
        "atum 2000\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 2,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 3,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AX");
    add_srs_wkt (p, 4,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433]],AXIS[\"geodetic longitud");
    add_srs_wkt (p, 6,
        "e (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 7,
        "5199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LE");
    add_srs_wkt (p, 8,
        "NGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Antarctica - Ross Sea Region - nominally between 160°E ");
    add_srs_wkt (p, 10,
        "and 150°W but includes buffer on eastern hemisphere mar");
    add_srs_wkt (p, 11,
        "gin to include Transantarctic Mountains\"],BBOX[-90,144.");
    add_srs_wkt (p, 12,
        "99,-59.99,-144.99]],ID[\"EPSG\",4885]]");
    p = add_epsg_def_ex (filter, first, last, 4887, "epsg", 4887,
        "BDA2000", 1, 1,
        "WGS 84", "Greenwich",
        "Bermuda_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"BDA2000\",DATUM[\"Bermuda 2000\",ELLIPSOID[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],");
    add_srs_wkt (p, 2,
        "PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 3,
        "199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat");
    add_srs_wkt (p, 4,
        ")\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANG");
    add_srs_wkt (p, 6,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoida");
    add_srs_wkt (p, 7,
        "l height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAG");
    add_srs_wkt (p, 8,
        "E[SCOPE[\"Geodesy.\"],AREA[\"Bermuda - onshore and offsh");
    add_srs_wkt (p, 9,
        "ore.\"],BBOX[28.91,-68.83,35.73,-60.7]],ID[\"EPSG\",4887");
    add_srs_wkt (p, 10,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4889, "epsg", 4889,
        "HTRS96", 1, 1,
        "GRS 1980", "Greenwich",
        "Croatian_Terrestrial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"HTRS96\",DATUM[\"Croatian Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e System\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUN");
    add_srs_wkt (p, 3,
        "IT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXI");
    add_srs_wkt (p, 4,
        "S[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433]],AXIS[\"geodetic longitude ");
    add_srs_wkt (p, 6,
        "(Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 7,
        "99433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENG");
    add_srs_wkt (p, 8,
        "THUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Cr");
    add_srs_wkt (p, 9,
        "oatia - onshore and offshore.\"],BBOX[41.62,13,46.54,19.");
    add_srs_wkt (p, 10,
        "43]],ID[\"EPSG\",4889]]");
    p = add_epsg_def_ex (filter, first, last, 4891, "epsg", 4891,
        "WGS 66", 1, 1,
        "NWL 9D", "Greenwich",
        "World_Geodetic_System_1966", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=NWL9D +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 66\",DYNAMIC[FRAMEEPOCH[1966]],DATUM[\"Wor");
    add_srs_wkt (p, 1,
        "ld Geodetic System 1966\",ELLIPSOID[\"NWL 9D\",6378145,2");
    add_srs_wkt (p, 2,
        "98.25,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"World.\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4891]]");
    p = add_epsg_def_ex (filter, first, last, 4893, "epsg", 4893,
        "NAD83(NSRS2007)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(NSRS2007)\",DATUM[\"NAD83 (National Spat");
    add_srs_wkt (p, 1,
        "ial Reference System 2007)\",ELLIPSOID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gre");
    add_srs_wkt (p, 3,
        "enwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[");
    add_srs_wkt (p, 4,
        "ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,OR");
    add_srs_wkt (p, 5,
        "DER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 6,
        "geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 7,
        "ree\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)");
    add_srs_wkt (p, 8,
        "\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Ge");
    add_srs_wkt (p, 9,
        "odesy.\"],AREA[\"Puerto Rico - onshore and offshore. Uni");
    add_srs_wkt (p, 10,
        "ted States (USA) onshore and offshore - Alabama; Alaska;");
    add_srs_wkt (p, 11,
        " Arizona; Arkansas; California; Colorado; Connecticut; D");
    add_srs_wkt (p, 12,
        "elaware; Florida; Georgia; Idaho; Illinois; Indiana; Iow");
    add_srs_wkt (p, 13,
        "a; Kansas; Kentucky; Louisiana; Maine; Maryland; Massach");
    add_srs_wkt (p, 14,
        "usetts; Michigan; Minnesota; Mississippi; Missouri; Mont");
    add_srs_wkt (p, 15,
        "ana; Nebraska; Nevada; New Hampshire; New Jersey; New Me");
    add_srs_wkt (p, 16,
        "xico; New York; North Carolina; North Dakota; Ohio; Okla");
    add_srs_wkt (p, 17,
        "homa; Oregon; Pennsylvania; Rhode Island; South Carolina");
    add_srs_wkt (p, 18,
        "; South Dakota; Tennessee; Texas; Utah; Vermont; Virgini");
    add_srs_wkt (p, 19,
        "a; Washington; West Virginia; Wisconsin; Wyoming. US Vir");
    add_srs_wkt (p, 20,
        "gin Islands - onshore and offshore.\"],BBOX[14.92,167.65");
    add_srs_wkt (p, 21,
        ",74.71,-63.88]],ID[\"EPSG\",4893]]");
    p = add_epsg_def_ex (filter, first, last, 4895, "epsg", 4895,
        "JAD2001", 1, 1,
        "WGS 84", "Greenwich",
        "Jamaica_2001", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"JAD2001\",DATUM[\"Jamaica 2001\",ELLIPSOID[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],");
    add_srs_wkt (p, 2,
        "PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 3,
        "199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat");
    add_srs_wkt (p, 4,
        ")\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANG");
    add_srs_wkt (p, 6,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoida");
    add_srs_wkt (p, 7,
        "l height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAG");
    add_srs_wkt (p, 8,
        "E[SCOPE[\"Geodesy.\"],AREA[\"Jamaica - onshore and offsh");
    add_srs_wkt (p, 9,
        "ore. Includes Morant Cays and Pedro Cays.\"],BBOX[14.08,");
    add_srs_wkt (p, 10,
        "-80.6,19.36,-74.51]],ID[\"EPSG\",4895]]");
    p = add_epsg_def_ex (filter, first, last, 4898, "epsg", 4898,
        "DGN95", 1, 1,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"DGN95\",DATUM[\"Datum Geodesi Nasional 1995\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Indonesia - on");
    add_srs_wkt (p, 9,
        "shore and offshore.\"],BBOX[-13.95,92.01,7.79,141.46]],I");
    add_srs_wkt (p, 10,
        "D[\"EPSG\",4898]]");
    p = add_epsg_def_ex (filter, first, last, 4900, "epsg", 4900,
        "LGD2006", 1, 1,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-208.4058,-109.8777,-");
    add_proj4text (p, 1,
        "2.5764,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"LGD2006\",DATUM[\"Libyan Geodetic Datum 2006\"");
    add_srs_wkt (p, 1,
        ",ELLIPSOID[\"International 1924\",6378388,297,LENGTHUNIT");
    add_srs_wkt (p, 2,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 3,
        "e\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodet");
    add_srs_wkt (p, 4,
        "ic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",e");
    add_srs_wkt (p, 6,
        "ast,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],A");
    add_srs_wkt (p, 7,
        "XIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Libya - ons");
    add_srs_wkt (p, 9,
        "hore and offshore.\"],BBOX[19.5,9.31,35.23,26.21]],ID[\"");
    add_srs_wkt (p, 10,
        "EPSG\",4900]]");
    p = add_epsg_def_ex (filter, first, last, 4901, "epsg", 4901,
        "ATF (Paris)", 1, 1,
        "Plessis 1817", "Paris RGS",
        "Ancienne_Triangulation_Francaise_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376523 +b=6355862.933255573 +pm=2.3372");
    add_proj4text (p, 1,
        "08333333333 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ATF (Paris)\",DATUM[\"Ancienne_Triangulation_Fr");
    add_srs_wkt (p, 1,
        "ancaise_Paris\",SPHEROID[\"Plessis 1817\",6376523,308.64");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Paris RGS\",2.33720833333333,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8914\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4901\"]]");
    p = add_epsg_def_ex (filter, first, last, 4902, "epsg", 4902,
        "ATF (Paris)", 1, 1,
        "Plessis 1817", "Paris RGS",
        "Ancienne_Triangulation_Francaise_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376523 +b=6355862.933255573 +pm=paris ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ATF (Paris)\",DATUM[\"Ancienne_Triangulation_Fr");
    add_srs_wkt (p, 1,
        "ancaise_Paris\",SPHEROID[\"Plessis 1817\",6376523,308.64");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Paris RGS\",2.33720833333333,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8914\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4901\"]]");
    p = add_epsg_def_ex (filter, first, last, 4903, "epsg", 4903,
        "Madrid 1870 (Madrid)", 1, 1,
        "Struve 1860", "Madrid",
        "Madrid_1870_Madrid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378298.3 +b=6356657.142669561 +pm=madr");
    add_proj4text (p, 1,
        "id +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Madrid 1870 (Madrid)\",DATUM[\"Madrid_1870_Madr");
    add_srs_wkt (p, 1,
        "id\",SPHEROID[\"Struve 1860\",6378298.3,294.73,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7028\"]],AUTHORITY[\"EPSG\",\"6903\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Madrid\",-3.687375,AUTHORITY[\"EPSG\",\"8905\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4903\"]]");
    p = add_epsg_def_ex (filter, first, last, 4904, "epsg", 4904,
        "Lisbon 1890 (Lisbon)", 1, 1,
        "Bessel 1841", "Lisbon",
        "Lisbon_1890_Lisbon", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,56");
    add_proj4text (p, 1,
        "5.223,0,0,0,0 +pm=lisbon +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon 1890 (Lisbon)\",DATUM[\"Lisbon_1890_Lisb");
    add_srs_wkt (p, 1,
        "on\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6904\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Lisbon\",-9.13190611111111,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8902\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4904\"]]");
    p = add_epsg_def_ex (filter, first, last, 4907, "epsg", 4907,
        "RGNC91-93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91-93", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGNC91-93\",DATUM[\"Reseau Geodesique de Nouve");
    add_srs_wkt (p, 1,
        "lle Caledonie 91-93\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"");
    add_srs_wkt (p, 9,
        "],AREA[\"New Caledonia - onshore and offshore. Isle de P");
    add_srs_wkt (p, 10,
        "ins, Loyalty Islands, Huon Islands, Belep archipelago, C");
    add_srs_wkt (p, 11,
        "hesterfield Islands, and Walpole.\"],BBOX[-26.45,156.25,");
    add_srs_wkt (p, 12,
        "-14.83,174.28]],ID[\"EPSG\",4907]]");
    p = add_epsg_def_ex (filter, first, last, 4909, "epsg", 4909,
        "GR96", 1, 1,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"GR96\",DATUM[\"Greenland 1996\",ELLIPSOID[\"GR");
    add_srs_wkt (p, 1,
        "S 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 2,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 3,
        "5199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (La");
    add_srs_wkt (p, 4,
        "t)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],AN");
    add_srs_wkt (p, 6,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoid");
    add_srs_wkt (p, 7,
        "al height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USA");
    add_srs_wkt (p, 8,
        "GE[SCOPE[\"Geodesy.\"],AREA[\"Greenland - onshore and of");
    add_srs_wkt (p, 9,
        "fshore.\"],BBOX[56.38,-75,87.03,8.12]],ID[\"EPSG\",4909]");
    add_srs_wkt (p, 10,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4921, "epsg", 4921,
        "GDM2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"GDM2000\",DATUM[\"Geodetic Datum of Malaysia 2");
    add_srs_wkt (p, 1,
        "000\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Malays");
    add_srs_wkt (p, 9,
        "ia - onshore and offshore. Includes peninsular Malayasia");
    add_srs_wkt (p, 10,
        ", Sabah and Sarawak.\"],BBOX[0.85,98.02,7.81,119.61]],ID");
    add_srs_wkt (p, 11,
        "[\"EPSG\",4921]]");
    p = add_epsg_def_ex (filter, first, last, 4923, "epsg", 4923,
        "PZ-90", 1, 1,
        "PZ-90", "Greenwich",
        "Parametry_Zemli_1990", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136 +rf=298.257839303 +towgs84=0,0,");
    add_proj4text (p, 1,
        "1.5,0,0,0.076,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"PZ-90\",DYNAMIC[FRAMEEPOCH[1990]],DATUM[\"Para");
    add_srs_wkt (p, 1,
        "metry Zemli 1990\",ELLIPSOID[\"PZ-90\",6378136,298.25783");
    add_srs_wkt (p, 2,
        "9303,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,AN");
    add_srs_wkt (p, 3,
        "GLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3");
    add_srs_wkt (p, 4,
        "],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEU");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic long");
    add_srs_wkt (p, 6,
        "itude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 7,
        "32925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3");
    add_srs_wkt (p, 8,
        "],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy. Naviga");
    add_srs_wkt (p, 9,
        "tion and positioning using Glonass satellite system.\"],");
    add_srs_wkt (p, 10,
        "AREA[\"World.\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4923");
    add_srs_wkt (p, 11,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4925, "epsg", 4925,
        "Mauritania 1999", 1, 1,
        "GRS 1980", "Greenwich",
        "Mauritania_1999", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Mauritania 1999\",DATUM[\"Mauritania 1999\",EL");
    add_srs_wkt (p, 1,
        "LIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Mauritania - o");
    add_srs_wkt (p, 9,
        "nshore and offshore.\"],BBOX[14.72,-20.04,27.3,-4.8]],ID");
    add_srs_wkt (p, 10,
        "[\"EPSG\",4925]]");
    p = add_epsg_def_ex (filter, first, last, 4927, "epsg", 4927,
        "Korea 2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Korea 2000\",DATUM[\"Geocentric datum of Korea");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Republic of");
    add_srs_wkt (p, 9,
        " Korea (South Korea) - onshore and offshore.\"],BBOX[28.");
    add_srs_wkt (p, 10,
        "6,122.71,40.27,134.28]],ID[\"EPSG\",4927]]");
    p = add_epsg_def_ex (filter, first, last, 4929, "epsg", 4929,
        "POSGAR 94", 1, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"POSGAR 94\",DATUM[\"Posiciones Geodesicas Arge");
    add_srs_wkt (p, 1,
        "ntinas 1994\",ELLIPSOID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 3,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AX");
    add_srs_wkt (p, 4,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433]],AXIS[\"geodetic longitud");
    add_srs_wkt (p, 6,
        "e (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 7,
        "5199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LE");
    add_srs_wkt (p, 8,
        "NGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Argentina - onshore and offshore.\"],BBOX[-58.41,-73.59,");
    add_srs_wkt (p, 10,
        "-21.78,-52.63]],ID[\"EPSG\",4929]]");
    p = add_epsg_def_ex (filter, first, last, 4931, "epsg", 4931,
        "Australian Antarctic", 1, 1,
        "GRS 1980", "Greenwich",
        "Australian_Antarctic_Datum_1998", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Australian Antarctic\",DATUM[\"Australian Anta");
    add_srs_wkt (p, 1,
        "rctic Datum 1998\",ELLIPSOID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 3,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoida");
    add_srs_wkt (p, 4,
        "l,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANG");
    add_srs_wkt (p, 5,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic l");
    add_srs_wkt (p, 6,
        "ongitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01");
    add_srs_wkt (p, 7,
        "74532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDE");
    add_srs_wkt (p, 8,
        "R[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],");
    add_srs_wkt (p, 9,
        "AREA[\"Antarctica between 45°E and 136°E and between 1");
    add_srs_wkt (p, 10,
        "42°E and 160°E - Australian sector.\"],BBOX[-90,45,-60");
    add_srs_wkt (p, 11,
        ",160]],ID[\"EPSG\",4931]]");
    p = add_epsg_def_ex (filter, first, last, 4933, "epsg", 4933,
        "CHTRF95", 1, 1,
        "GRS 1980", "Greenwich",
        "Swiss_Terrestrial_Reference_Frame_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"CHTRF95\",DATUM[\"Swiss Terrestrial Reference ");
    add_srs_wkt (p, 1,
        "Frame 1995\",ELLIPSOID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLE");
    add_srs_wkt (p, 3,
        "UNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],A");
    add_srs_wkt (p, 4,
        "XIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433]],AXIS[\"geodetic longitu");
    add_srs_wkt (p, 6,
        "de (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 7,
        "25199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],L");
    add_srs_wkt (p, 8,
        "ENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Liechtenstein; Switzerland.\"],BBOX[45.82,5.96,47.81,10.");
    add_srs_wkt (p, 10,
        "49]],ID[\"EPSG\",4933]]");
    p = add_epsg_def_ex (filter, first, last, 4935, "epsg", 4935,
        "EST97", 1, 1,
        "GRS 1980", "Greenwich",
        "Estonia_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"EST97\",DATUM[\"Estonia 1997\",ELLIPSOID[\"GRS");
    add_srs_wkt (p, 1,
        " 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],");
    add_srs_wkt (p, 2,
        "PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 3,
        "199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat");
    add_srs_wkt (p, 4,
        ")\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANG");
    add_srs_wkt (p, 6,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoida");
    add_srs_wkt (p, 7,
        "l height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAG");
    add_srs_wkt (p, 8,
        "E[SCOPE[\"Geodesy.\"],AREA[\"Estonia - onshore and offsh");
    add_srs_wkt (p, 9,
        "ore.\"],BBOX[57.52,20.37,60,28.2]],ID[\"EPSG\",4935]]");
    p = add_epsg_def_ex (filter, first, last, 4937, "epsg", 4937,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRS89\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e System 1989\",ELLIPSOID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,AN");
    add_srs_wkt (p, 3,
        "GLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3");
    add_srs_wkt (p, 4,
        "],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEU");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic long");
    add_srs_wkt (p, 6,
        "itude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 7,
        "32925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3");
    add_srs_wkt (p, 8,
        "],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Spatial referen");
    add_srs_wkt (p, 9,
        "cing.\"],AREA[\"Europe - onshore and offshore: Albania; ");
    add_srs_wkt (p, 10,
        "Andorra; Austria; Belgium; Bosnia and Herzegovina; Bulga");
    add_srs_wkt (p, 11,
        "ria; Croatia; Cyprus; Czechia; Denmark; Estonia; Faroe I");
    add_srs_wkt (p, 12,
        "slands; Finland; France; Germany; Gibraltar; Greece; Hun");
    add_srs_wkt (p, 13,
        "gary; Ireland; Italy; Kosovo; Latvia; Liechtenstein; Lit");
    add_srs_wkt (p, 14,
        "huania; Luxembourg; Malta; Moldova; Monaco; Montenegro; ");
    add_srs_wkt (p, 15,
        "Netherlands; North Macedonia; Norway including Svalbard ");
    add_srs_wkt (p, 16,
        "and Jan Mayen; Poland; Portugal; Romania; San Marino; Se");
    add_srs_wkt (p, 17,
        "rbia; Slovakia; Slovenia; Spain; Sweden; Switzerland; Un");
    add_srs_wkt (p, 18,
        "ited Kingdom (UK) including Channel Islands and Isle of ");
    add_srs_wkt (p, 19,
        "Man; Vatican City State.\"],BBOX[32.88,-16.1,84.17,40.18");
    add_srs_wkt (p, 20,
        "]],ID[\"EPSG\",4937]]");
    p = add_epsg_def_ex (filter, first, last, 4939, "epsg", 4939,
        "GDA94", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"GDA94\",DATUM[\"Geocentric Datum of Australia ");
    add_srs_wkt (p, 1,
        "1994\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Austra");
    add_srs_wkt (p, 9,
        "lia including Lord Howe Island, Macquarie Islands, Ashmo");
    add_srs_wkt (p, 10,
        "re and Cartier Islands, Christmas Island, Cocos (Keeling");
    add_srs_wkt (p, 11,
        ") Islands, Norfolk Island. All onshore and offshore.\"],");
    add_srs_wkt (p, 12,
        "BBOX[-60.56,93.41,-8.47,173.35]],ID[\"EPSG\",4939]]");
    p = add_epsg_def_ex (filter, first, last, 4941, "epsg", 4941,
        "Hartebeesthoek94", 1, 1,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Hartebeesthoek94\",DATUM[\"Hartebeesthoek94\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Eswatini (Swaz");
    add_srs_wkt (p, 9,
        "iland); Lesotho; South Africa - onshore and offshore.\"]");
    add_srs_wkt (p, 10,
        ",BBOX[-50.32,13.33,-22.13,42.85]],ID[\"EPSG\",4941]]");
    p = add_epsg_def_ex (filter, first, last, 4943, "epsg", 4943,
        "IRENET95", 1, 1,
        "GRS 1980", "Greenwich",
        "IRENET95", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IRENET95\",DATUM[\"IRENET95\",ELLIPSOID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 2,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 3,
        "99433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)");
    add_srs_wkt (p, 4,
        "\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 6,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal");
    add_srs_wkt (p, 7,
        " height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE");
    add_srs_wkt (p, 8,
        "[SCOPE[\"Geodesy.\"],AREA[\"Ireland - onshore. United Ki");
    add_srs_wkt (p, 9,
        "ngdom (UK) - Northern Ireland (Ulster) - onshore.\"],BBO");
    add_srs_wkt (p, 10,
        "X[51.39,-10.56,55.43,-5.34]],ID[\"EPSG\",4943]]");
    p = add_epsg_def_ex (filter, first, last, 4945, "epsg", 4945,
        "ISN93", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ISN93\",DATUM[\"Islands Net 1993\",ELLIPSOID[\"");
    add_srs_wkt (p, 1,
        "GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 2,
        "]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 3,
        "925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (");
    add_srs_wkt (p, 4,
        "Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],");
    add_srs_wkt (p, 6,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipso");
    add_srs_wkt (p, 7,
        "idal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],U");
    add_srs_wkt (p, 8,
        "SAGE[SCOPE[\"Geodesy.\"],AREA[\"Iceland - onshore and of");
    add_srs_wkt (p, 9,
        "fshore.\"],BBOX[59.96,-30.87,69.59,-5.55]],ID[\"EPSG\",4");
    add_srs_wkt (p, 10,
        "945]]");
    p = add_epsg_def_ex (filter, first, last, 4947, "epsg", 4947,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"JGD2000\",DATUM[\"Japanese Geodetic Datum 2000");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Japan - ons");
    add_srs_wkt (p, 9,
        "hore and offshore.\"],BBOX[17.09,122.38,46.05,157.65]],I");
    add_srs_wkt (p, 10,
        "D[\"EPSG\",4947]]");
    p = add_epsg_def_ex (filter, first, last, 4949, "epsg", 4949,
        "LKS92", 1, 1,
        "GRS 1980", "Greenwich",
        "Latvia_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"LKS92\",DATUM[\"Latvia 1992\",ELLIPSOID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 2,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 3,
        "99433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)");
    add_srs_wkt (p, 4,
        "\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 6,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal");
    add_srs_wkt (p, 7,
        " height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE");
    add_srs_wkt (p, 8,
        "[SCOPE[\"Geodesy.\"],AREA[\"Latvia - onshore and offshor");
    add_srs_wkt (p, 9,
        "e.\"],BBOX[55.67,19.06,58.09,28.24]],ID[\"EPSG\",4949]]");
    p = add_epsg_def_ex (filter, first, last, 4951, "epsg", 4951,
        "LKS94", 1, 1,
        "GRS 1980", "Greenwich",
        "Lithuania_1994_ETRS89", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"LKS94\",DATUM[\"Lithuania 1994 (ETRS89)\",ELLI");
    add_srs_wkt (p, 1,
        "PSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"me");
    add_srs_wkt (p, 2,
        "tre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 3,
        ".0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic la");
    add_srs_wkt (p, 4,
        "titude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433]],AXIS[\"geodetic longitude (Lon)\",east,O");
    add_srs_wkt (p, 6,
        "RDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 7,
        "ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 8,
        ",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Lithuania - onshor");
    add_srs_wkt (p, 9,
        "e and offshore.\"],BBOX[53.89,19.02,56.45,26.82]],ID[\"E");
    add_srs_wkt (p, 10,
        "PSG\",4951]]");
    p = add_epsg_def_ex (filter, first, last, 4953, "epsg", 4953,
        "Moznet", 1, 1,
        "WGS 84", "Greenwich",
        "Moznet_ITRF94", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Moznet\",DATUM[\"Moznet (ITRF94)\",ELLIPSOID[\"");
    add_srs_wkt (p, 1,
        "WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 2,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 3,
        "5199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (La");
    add_srs_wkt (p, 4,
        "t)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],AN");
    add_srs_wkt (p, 6,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoid");
    add_srs_wkt (p, 7,
        "al height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USA");
    add_srs_wkt (p, 8,
        "GE[SCOPE[\"Geodesy.\"],AREA[\"Mozambique - onshore and o");
    add_srs_wkt (p, 9,
        "ffshore.\"],BBOX[-27.71,30.21,-10.09,43.03]],ID[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",4953]]");
    p = add_epsg_def_ex (filter, first, last, 4955, "epsg", 4955,
        "NAD83(CSRS)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)\",DATUM[\"NAD83 Canadian Spatial R");
    add_srs_wkt (p, 1,
        "eference System\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],A");
    add_srs_wkt (p, 9,
        "REA[\"Canada - onshore and offshore - Alberta; British C");
    add_srs_wkt (p, 10,
        "olumbia; Manitoba; New Brunswick; Newfoundland and Labra");
    add_srs_wkt (p, 11,
        "dor; Northwest Territories; Nova Scotia; Nunavut; Ontari");
    add_srs_wkt (p, 12,
        "o; Prince Edward Island; Quebec; Saskatchewan; Yukon.\"]");
    add_srs_wkt (p, 13,
        ",BBOX[40.04,-141.01,86.46,-47.74]],ID[\"EPSG\",4955]]");
    p = add_epsg_def_ex (filter, first, last, 4957, "epsg", 4957,
        "NAD83(HARN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(HARN)\",DATUM[\"NAD83 (High Accuracy Ref");
    add_srs_wkt (p, 1,
        "erence Network)\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],A");
    add_srs_wkt (p, 9,
        "REA[\"American Samoa - onshore - Tutuila, Aunu'u, Ofu, O");
    add_srs_wkt (p, 10,
        "lesega, Ta'u and Rose islands. Guam - onshore. Northern ");
    add_srs_wkt (p, 11,
        "Mariana Islands - onshore. Puerto Rico - onshore. United");
    add_srs_wkt (p, 12,
        " States (USA) - onshore Alabama, Alaska, Arizona, Arkans");
    add_srs_wkt (p, 13,
        "as, California, Colorado, Connecticut, Delaware, Florida");
    add_srs_wkt (p, 14,
        ", Georgia, Hawaii, Idaho, Illinois, Indiana, Iowa, Kansa");
    add_srs_wkt (p, 15,
        "s, Kentucky, Louisiana, Maine, Maryland, Massachusetts, ");
    add_srs_wkt (p, 16,
        "Michigan, Minnesota, Mississippi, Missouri, Montana, Neb");
    add_srs_wkt (p, 17,
        "raska, Nevada, New Hampshire, New Jersey, New Mexico, Ne");
    add_srs_wkt (p, 18,
        "w York, North Carolina, North Dakota, Ohio, Oklahoma, Or");
    add_srs_wkt (p, 19,
        "egon, Pennsylvania, Rhode Island, South Carolina, South ");
    add_srs_wkt (p, 20,
        "Dakota, Tennessee, Texas, Utah, Vermont, Virginia, Washi");
    add_srs_wkt (p, 21,
        "ngton, West Virginia, Wisconsin and Wyoming; offshore Gu");
    add_srs_wkt (p, 22,
        "lf of Mexico continental shelf (GoM OCS). US Virgin Isla");
    add_srs_wkt (p, 23,
        "nds - onshore.\"],BBOX[-14.59,144.58,71.4,-64.51]],ID[\"");
    add_srs_wkt (p, 24,
        "EPSG\",4957]]");
    p = add_epsg_def_ex (filter, first, last, 4959, "epsg", 4959,
        "NZGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NZGD2000\",DATUM[\"New Zealand Geodetic Datum ");
    add_srs_wkt (p, 1,
        "2000\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"New Ze");
    add_srs_wkt (p, 9,
        "aland - onshore and offshore. Includes Antipodes Islands");
    add_srs_wkt (p, 10,
        ", Auckland Islands, Bounty Islands, Chatham Islands, Cam");
    add_srs_wkt (p, 11,
        "bell Island, Kermadec Islands, Raoul Island and Snares I");
    add_srs_wkt (p, 12,
        "slands.\"],BBOX[-55.95,160.6,-25.88,-171.2]],ID[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",4959]]");
    p = add_epsg_def_ex (filter, first, last, 4961, "epsg", 4961,
        "POSGAR 98", 1, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"POSGAR 98\",DATUM[\"Posiciones Geodesicas Arge");
    add_srs_wkt (p, 1,
        "ntinas 1998\",ELLIPSOID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGL");
    add_srs_wkt (p, 3,
        "EUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],");
    add_srs_wkt (p, 4,
        "AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433]],AXIS[\"geodetic longit");
    add_srs_wkt (p, 6,
        "ude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 7,
        "925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],");
    add_srs_wkt (p, 8,
        "LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[");
    add_srs_wkt (p, 9,
        "\"Argentina - onshore and offshore.\"],BBOX[-58.41,-73.5");
    add_srs_wkt (p, 10,
        "9,-21.78,-52.63]],ID[\"EPSG\",4961]]");
    p = add_epsg_def_ex (filter, first, last, 4963, "epsg", 4963,
        "REGVEN", 1, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Venezolana", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"REGVEN\",DATUM[\"Red Geodesica Venezolana\",EL");
    add_srs_wkt (p, 1,
        "LIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Venezuela - on");
    add_srs_wkt (p, 9,
        "shore and offshore.\"],BBOX[0.64,-73.38,16.75,-58.95]],I");
    add_srs_wkt (p, 10,
        "D[\"EPSG\",4963]]");
    p = add_epsg_def_ex (filter, first, last, 4965, "epsg", 4965,
        "RGF93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGF93\",DATUM[\"Reseau Geodesique Francais 199");
    add_srs_wkt (p, 1,
        "3\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"Geodesy; air, land and sea n");
    add_srs_wkt (p, 9,
        "avigation and safety of life purposes.\"],AREA[\"France ");
    add_srs_wkt (p, 10,
        "- onshore and offshore, mainland and Corsica.\"],BBOX[41");
    add_srs_wkt (p, 11,
        ".15,-9.86,51.56,10.38]],ID[\"EPSG\",4965]]");
    p = add_epsg_def_ex (filter, first, last, 4967, "epsg", 4967,
        "RGFG95", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGFG95\",DATUM[\"Reseau Geodesique Francais Gu");
    add_srs_wkt (p, 1,
        "yane 1995\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 2,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 3,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AX");
    add_srs_wkt (p, 4,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433]],AXIS[\"geodetic longitud");
    add_srs_wkt (p, 6,
        "e (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 7,
        "5199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LE");
    add_srs_wkt (p, 8,
        "NGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy; air, land ");
    add_srs_wkt (p, 9,
        "and sea navigation and safety of life purposes.\"],AREA[");
    add_srs_wkt (p, 10,
        "\"French Guiana - onshore and offshore.\"],BBOX[2.11,-54");
    add_srs_wkt (p, 11,
        ".61,8.88,-49.45]],ID[\"EPSG\",4967]]");
    p = add_epsg_def_ex (filter, first, last, 4969, "epsg", 4969,
        "RGNC91-93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91-93", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGNC91-93\",DATUM[\"Reseau Geodesique de Nouve");
    add_srs_wkt (p, 1,
        "lle Caledonie 91-93\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"");
    add_srs_wkt (p, 9,
        "],AREA[\"New Caledonia - onshore and offshore. Isle de P");
    add_srs_wkt (p, 10,
        "ins, Loyalty Islands, Huon Islands, Belep archipelago, C");
    add_srs_wkt (p, 11,
        "hesterfield Islands, and Walpole.\"],BBOX[-26.45,156.25,");
    add_srs_wkt (p, 12,
        "-14.83,174.28]],ID[\"EPSG\",4907]]");
    p = add_epsg_def_ex (filter, first, last, 4971, "epsg", 4971,
        "RGR92", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGR92\",DATUM[\"Reseau Geodesique de la Reunio");
    add_srs_wkt (p, 1,
        "n 1992\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy; air, land and");
    add_srs_wkt (p, 9,
        " sea navigation and safety of life purposes.\"],AREA[\"R");
    add_srs_wkt (p, 10,
        "eunion - onshore and offshore.\"],BBOX[-24.72,51.83,-18.");
    add_srs_wkt (p, 11,
        "28,58.24]],ID[\"EPSG\",4971]]");
    p = add_epsg_def_ex (filter, first, last, 4973, "epsg", 4973,
        "RRAF 1991", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RRAF 1991\",DATUM[\"Reseau de Reference des An");
    add_srs_wkt (p, 1,
        "tilles Francaises 1991\",ELLIPSOID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 3,
        "ch\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[elli");
    add_srs_wkt (p, 4,
        "psoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[");
    add_srs_wkt (p, 5,
        "1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geod");
    add_srs_wkt (p, 6,
        "etic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 7,
        ",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up");
    add_srs_wkt (p, 8,
        ",ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy");
    add_srs_wkt (p, 9,
        ".\"],AREA[\"French Antilles onshore and offshore - Guade");
    add_srs_wkt (p, 10,
        "loupe (including Grande Terre, Basse Terre, Marie Galant");
    add_srs_wkt (p, 11,
        "e, Les Saintes, Iles de la Petite Terre, La Desirade, St");
    add_srs_wkt (p, 12,
        " Barthélemy, and northern St Martin) and Martinique.\"]");
    add_srs_wkt (p, 13,
        ",BBOX[14.08,-63.66,18.54,-57.52]],ID[\"EPSG\",4557]]");
    p = add_epsg_def_ex (filter, first, last, 4975, "epsg", 4975,
        "SIRGAS 1995", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS 1995\",DATUM[\"Sistema de Referencia Ge");
    add_srs_wkt (p, 1,
        "ocentrico para America del Sur 1995\",ELLIPSOID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 4,
        "433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\"");
    add_srs_wkt (p, 5,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 6,
        "],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 7,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal h");
    add_srs_wkt (p, 8,
        "eight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[S");
    add_srs_wkt (p, 9,
        "COPE[\"Geodesy.\"],AREA[\"South America - onshore and of");
    add_srs_wkt (p, 10,
        "fshore. Ecuador (mainland and Galapagos) - onshore and o");
    add_srs_wkt (p, 11,
        "ffshore.\"],BBOX[-59.87,-113.21,16.75,-26]],ID[\"EPSG\",");
    add_srs_wkt (p, 12,
        "4975]]");
    p = add_epsg_def_ex (filter, first, last, 4977, "epsg", 4977,
        "SWEREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SWEREF99\",DATUM[\"SWEREF99\",ELLIPSOID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 2,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 3,
        "99433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)");
    add_srs_wkt (p, 4,
        "\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 6,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal");
    add_srs_wkt (p, 7,
        " height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE");
    add_srs_wkt (p, 8,
        "[SCOPE[\"Geodesy.\"],AREA[\"Sweden - onshore and offshor");
    add_srs_wkt (p, 9,
        "e.\"],BBOX[54.96,10.03,69.07,24.17]],ID[\"EPSG\",4977]]");
    p = add_epsg_def_ex (filter, first, last, 4979, "epsg", 4979,
        "WGS 84", 1, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"Geodesy. Navigation and positioni");
    add_srs_wkt (p, 9,
        "ng using GPS satellite system.\"],AREA[\"World: Afghanis");
    add_srs_wkt (p, 10,
        "tan, Albania, Algeria, American Samoa, Andorra, Angola, ");
    add_srs_wkt (p, 11,
        "Anguilla, Antarctica, Antigua and Barbuda, Argentina, Ar");
    add_srs_wkt (p, 12,
        "menia, Aruba, Australia, Austria, Azerbaijan, Bahamas, B");
    add_srs_wkt (p, 13,
        "ahrain, Bangladesh, Barbados, Belgium, Belgium, Belize, ");
    add_srs_wkt (p, 14,
        "Benin, Bermuda, Bhutan, Bolivia, Bonaire, Saint Eustasiu");
    add_srs_wkt (p, 15,
        "s and Saba, Bosnia and Herzegovina, Botswana, Bouvet Isl");
    add_srs_wkt (p, 16,
        "and, Brazil, British Indian Ocean Territory, British Vir");
    add_srs_wkt (p, 17,
        "gin Islands, Brunei Darussalam, Bulgaria, Burkina Faso, ");
    add_srs_wkt (p, 18,
        "Burundi, Cambodia, Cameroon, Canada, Cape Verde, Cayman ");
    add_srs_wkt (p, 19,
        "Islands, Central African Republic, Chad, Chile, China, C");
    add_srs_wkt (p, 20,
        "hristmas Island, Cocos (Keeling) Islands, Comoros, Congo");
    add_srs_wkt (p, 21,
        ", Cook Islands, Costa Rica, Côte d'Ivoire (Ivory Coast)");
    add_srs_wkt (p, 22,
        ", Croatia, Cuba, Curacao, Cyprus, Czechia, Denmark, Djib");
    add_srs_wkt (p, 23,
        "outi, Dominica, Dominican Republic, East Timor, Ecuador,");
    add_srs_wkt (p, 24,
        " Egypt, El Salvador, Equatorial Guinea, Eritrea, Estonia");
    add_srs_wkt (p, 25,
        ", Eswatini (Swaziland), Ethiopia, Falkland Islands (Malv");
    add_srs_wkt (p, 26,
        "inas), Faroe Islands, Fiji, Finland, France, French Guia");
    add_srs_wkt (p, 27,
        "na, French Polynesia, French Southern Territories, Gabon");
    add_srs_wkt (p, 28,
        ", Gambia, Georgia, Germany, Ghana, Gibraltar, Greece, Gr");
    add_srs_wkt (p, 29,
        "eenland, Grenada, Guadeloupe, Guam, Guatemala, Guinea, G");
    add_srs_wkt (p, 30,
        "uinea-Bissau, Guyana, Haiti, Heard Island and McDonald I");
    add_srs_wkt (p, 31,
        "slands, Holy See (Vatican City State), Honduras, China -");
    add_srs_wkt (p, 32,
        " Hong Kong, Hungary, Iceland, India, Indonesia, Islamic ");
    add_srs_wkt (p, 33,
        "Republic of Iran, Iraq, Ireland, Israel, Italy, Jamaica,");
    add_srs_wkt (p, 34,
        " Japan, Jordan, Kazakhstan, Kenya, Kiribati, Democratic ");
    add_srs_wkt (p, 35,
        "People's Republic of Korea (North Korea), Republic of Ko");
    add_srs_wkt (p, 36,
        "rea (South Korea), Kosovo, Kuwait, Kyrgyzstan, Lao Peopl");
    add_srs_wkt (p, 37,
        "e's Democratic Republic (Laos), Latvia, Lebanon, Lesotho");
    add_srs_wkt (p, 38,
        ", Liberia, Libyan Arab Jamahiriya, Liechtenstein, Lithua");
    add_srs_wkt (p, 39,
        "nia, Luxembourg, China - Macao, Madagascar, Malawi, Mala");
    add_srs_wkt (p, 40,
        "ysia, Maldives, Mali, Malta, Marshall Islands, Martiniqu");
    add_srs_wkt (p, 41,
        "e, Mauritania, Mauritius, Mayotte, Mexico, Federated Sta");
    add_srs_wkt (p, 42,
        "tes of Micronesia, Monaco, Mongolia, Montenegro, Montser");
    add_srs_wkt (p, 43,
        "rat, Morocco, Mozambique, Myanmar (Burma), Namibia, Naur");
    add_srs_wkt (p, 44,
        "u, Nepal, Netherlands, New Caledonia, New Zealand, Nicar");
    add_srs_wkt (p, 45,
        "agua, Niger, Nigeria, Niue, Norfolk Island, North Macedo");
    add_srs_wkt (p, 46,
        "nia, Northern Mariana Islands, Norway, Oman, Pakistan, P");
    add_srs_wkt (p, 47,
        "alau, Panama, Papua New Guinea (PNG), Paraguay, Peru, Ph");
    add_srs_wkt (p, 48,
        "ilippines, Pitcairn, Poland, Portugal, Puerto Rico, Qata");
    add_srs_wkt (p, 49,
        "r, Reunion, Romania, Russian Federation, Rwanda, Saint K");
    add_srs_wkt (p, 50,
        "itts and Nevis, Saint Helena, Ascension and Tristan da C");
    add_srs_wkt (p, 51,
        "unha, Saint Lucia, Saint Pierre and Miquelon, Saint Vinc");
    add_srs_wkt (p, 52,
        "ent and the Grenadines, Samoa, San Marino, Sao Tome and ");
    add_srs_wkt (p, 53,
        "Principe, Saudi Arabia, Senegal, Serbia, Seychelles, Sie");
    add_srs_wkt (p, 54,
        "rra Leone, Singapore, Slovakia (Slovak Republic), Sloven");
    add_srs_wkt (p, 55,
        "ia, Sint Maarten, Solomon Islands, Somalia, South Africa");
    add_srs_wkt (p, 56,
        ", South Georgia and the South Sandwich Islands, South Su");
    add_srs_wkt (p, 57,
        "dan, Spain, Sri Lanka, Sudan, Suriname, Svalbard and Jan");
    add_srs_wkt (p, 58,
        " Mayen, Sweden, Switzerland, Syrian Arab Republic, Taiwa");
    add_srs_wkt (p, 59,
        "n, Tajikistan, United Republic of Tanzania, Thailand, Th");
    add_srs_wkt (p, 60,
        "e Democratic Republic of the Congo (Zaire), Togo, Tokela");
    add_srs_wkt (p, 61,
        "u, Tonga, Trinidad and Tobago, Tunisia, Turkey, Turkmeni");
    add_srs_wkt (p, 62,
        "stan, Turks and Caicos Islands, Tuvalu, Uganda, Ukraine,");
    add_srs_wkt (p, 63,
        " United Arab Emirates (UAE), United Kingdom (UK), United");
    add_srs_wkt (p, 64,
        " States (USA), United States Minor Outlying Islands, Uru");
    add_srs_wkt (p, 65,
        "guay, Uzbekistan, Vanuatu, Venezuela, Vietnam, US Virgin");
    add_srs_wkt (p, 66,
        " Islands, Wallis and Futuna, Western Sahara, Yemen, Zamb");
    add_srs_wkt (p, 67,
        "ia, Zimbabwe.\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4979");
    add_srs_wkt (p, 68,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4981, "epsg", 4981,
        "Yemen NGN96", 1, 1,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Yemen NGN96\",DATUM[\"Yemen National Geodetic ");
    add_srs_wkt (p, 1,
        "Network 1996\",ELLIPSOID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLE");
    add_srs_wkt (p, 3,
        "UNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],A");
    add_srs_wkt (p, 4,
        "XIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433]],AXIS[\"geodetic longitu");
    add_srs_wkt (p, 6,
        "de (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 7,
        "25199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],L");
    add_srs_wkt (p, 8,
        "ENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Yemen - onshore and offshore.\"],BBOX[8.95,41.08,19,57.9");
    add_srs_wkt (p, 10,
        "6]],ID[\"EPSG\",4981]]");
    p = add_epsg_def_ex (filter, first, last, 4983, "epsg", 4983,
        "IGM95", 1, 1,
        "GRS 1980", "Greenwich",
        "Istituto_Geografico_Militaire_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGM95\",DATUM[\"Istituto Geografico Militaire ");
    add_srs_wkt (p, 1,
        "1995\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Italy ");
    add_srs_wkt (p, 9,
        "- onshore and offshore; San Marino, Vatican City State.\"");
    add_srs_wkt (p, 10,
        "],BBOX[34.76,5.93,47.1,18.99]],ID[\"EPSG\",4983]]");
    p = add_epsg_def_ex (filter, first, last, 4985, "epsg", 4985,
        "WGS 72", 1, 1,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 72\",DYNAMIC[FRAMEEPOCH[1972]],DATUM[\"Wor");
    add_srs_wkt (p, 1,
        "ld Geodetic System 1972\",ELLIPSOID[\"WGS 72\",6378135,2");
    add_srs_wkt (p, 2,
        "98.26,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"World.\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4985]]");
    p = add_epsg_def_ex (filter, first, last, 4987, "epsg", 4987,
        "WGS 72BE", 1, 1,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0");
    add_proj4text (p, 1,
        ".38 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 72BE\",DYNAMIC[FRAMEEPOCH[1972]],DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS 72 Transit Broadcast Ephemeris\",ELLIPSOID[\"WGS 72\"");
    add_srs_wkt (p, 2,
        ",6378135,298.26,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[el");
    add_srs_wkt (p, 4,
        "lipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDE");
    add_srs_wkt (p, 5,
        "R[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ge");
    add_srs_wkt (p, 6,
        "odetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 7,
        "e\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\"");
    add_srs_wkt (p, 8,
        ",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geod");
    add_srs_wkt (p, 9,
        "esy.\"],AREA[\"World.\"],BBOX[-90,-180,90,180]],ID[\"EPS");
    add_srs_wkt (p, 10,
        "G\",4987]]");
}

#endif /* full EPSG initialization enabled/disabled */

