// Copyright (C) 2019 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by gen-grammar.go --template=../schema/schema.go.tmpl --out=../schema/schema.go
// Do not modify this file directly.

package schema

// Opcode holds information about a specific SPIR-V opcode.
type Opcode struct {
	Opname   string
	Class    string
	Opcode   int
	Operands []Operand
}

// Operand contains information about a logical operand for an instruction.
type Operand struct {
	Kind       *OperandKind
	Name       string
	Quantifier Quantifier
}

// OperandKind contains information about a specific operand kind.
type OperandKind struct {
	Category   OperandCategory
	Kind       string
	Enumerants []Enumerant
	Bases      []*OperandKind
}

// Enumerant contains information about an enumerant in an enum.
type Enumerant struct {
	Enumerant    string
	Value        interface{}
	Capabilities []string
	Parameters   []Parameter
	Version      string
}

// Parameter contains information about a logical parameter for an enumerant.
type Parameter struct {
	Kind *OperandKind
	Name string
}

// Quantifier indicates the number of times the quantified term may appear.
type Quantifier string

const (
	// Once indicates the quantified term may appear exactly once.
	Once Quantifier = ""

	// ZeroOrOnce indicates the quantified term may appear zero or one
	// time; an optional term.
	ZeroOrOnce Quantifier = "?"

	// ZeroOrMany indicates the quantified term may appear any number of
	// times.
	ZeroOrMany Quantifier = "*"
)

// OperandCategory is an enumerator that groups operand kinds.
type OperandCategory string

const (
	// OperandCategoryBitEnum describes an operand kind where its value is a
	// mask, which is formed by combining the bits specified as enumerants in an
	// enum.
	OperandCategoryBitEnum = "BitEnum"

	// OperandCategoryValueEnum describes an operand kind where its value is an
	// enumerant from an enum.
	OperandCategoryValueEnum = "ValueEnum"

	// OperandCategoryID describes and operand kind where its value is an <id>
	// definition or reference.
	OperandCategoryID = "Id"

	// OperandCategoryLiteral describes and operand kind where its value is an
	// literal number or string.
	OperandCategoryLiteral = "Literal"

	// OperandCategoryComposite describes and operand kind where its value is
	// composed from operand values from the above categories.
	OperandCategoryComposite = "Composite"
)

// OpcodeMap is a map of opcode name to Opcode type.
type OpcodeMap map[string]*Opcode

var (
	// Opcodes is a map of opcode name to Opcode description.
	Opcodes = OpcodeMap {
		"OpNop": OpNop,
		"OpUndef": OpUndef,
		"OpSourceContinued": OpSourceContinued,
		"OpSource": OpSource,
		"OpSourceExtension": OpSourceExtension,
		"OpName": OpName,
		"OpMemberName": OpMemberName,
		"OpString": OpString,
		"OpLine": OpLine,
		"OpExtension": OpExtension,
		"OpExtInstImport": OpExtInstImport,
		"OpExtInst": OpExtInst,
		"OpMemoryModel": OpMemoryModel,
		"OpEntryPoint": OpEntryPoint,
		"OpExecutionMode": OpExecutionMode,
		"OpCapability": OpCapability,
		"OpTypeVoid": OpTypeVoid,
		"OpTypeBool": OpTypeBool,
		"OpTypeInt": OpTypeInt,
		"OpTypeFloat": OpTypeFloat,
		"OpTypeVector": OpTypeVector,
		"OpTypeMatrix": OpTypeMatrix,
		"OpTypeImage": OpTypeImage,
		"OpTypeSampler": OpTypeSampler,
		"OpTypeSampledImage": OpTypeSampledImage,
		"OpTypeArray": OpTypeArray,
		"OpTypeRuntimeArray": OpTypeRuntimeArray,
		"OpTypeStruct": OpTypeStruct,
		"OpTypeOpaque": OpTypeOpaque,
		"OpTypePointer": OpTypePointer,
		"OpTypeFunction": OpTypeFunction,
		"OpTypeEvent": OpTypeEvent,
		"OpTypeDeviceEvent": OpTypeDeviceEvent,
		"OpTypeReserveId": OpTypeReserveId,
		"OpTypeQueue": OpTypeQueue,
		"OpTypePipe": OpTypePipe,
		"OpTypeForwardPointer": OpTypeForwardPointer,
		"OpConstantTrue": OpConstantTrue,
		"OpConstantFalse": OpConstantFalse,
		"OpConstant": OpConstant,
		"OpConstantComposite": OpConstantComposite,
		"OpConstantSampler": OpConstantSampler,
		"OpConstantNull": OpConstantNull,
		"OpSpecConstantTrue": OpSpecConstantTrue,
		"OpSpecConstantFalse": OpSpecConstantFalse,
		"OpSpecConstant": OpSpecConstant,
		"OpSpecConstantComposite": OpSpecConstantComposite,
		"OpSpecConstantOp": OpSpecConstantOp,
		"OpFunction": OpFunction,
		"OpFunctionParameter": OpFunctionParameter,
		"OpFunctionEnd": OpFunctionEnd,
		"OpFunctionCall": OpFunctionCall,
		"OpVariable": OpVariable,
		"OpImageTexelPointer": OpImageTexelPointer,
		"OpLoad": OpLoad,
		"OpStore": OpStore,
		"OpCopyMemory": OpCopyMemory,
		"OpCopyMemorySized": OpCopyMemorySized,
		"OpAccessChain": OpAccessChain,
		"OpInBoundsAccessChain": OpInBoundsAccessChain,
		"OpPtrAccessChain": OpPtrAccessChain,
		"OpArrayLength": OpArrayLength,
		"OpGenericPtrMemSemantics": OpGenericPtrMemSemantics,
		"OpInBoundsPtrAccessChain": OpInBoundsPtrAccessChain,
		"OpDecorate": OpDecorate,
		"OpMemberDecorate": OpMemberDecorate,
		"OpDecorationGroup": OpDecorationGroup,
		"OpGroupDecorate": OpGroupDecorate,
		"OpGroupMemberDecorate": OpGroupMemberDecorate,
		"OpVectorExtractDynamic": OpVectorExtractDynamic,
		"OpVectorInsertDynamic": OpVectorInsertDynamic,
		"OpVectorShuffle": OpVectorShuffle,
		"OpCompositeConstruct": OpCompositeConstruct,
		"OpCompositeExtract": OpCompositeExtract,
		"OpCompositeInsert": OpCompositeInsert,
		"OpCopyObject": OpCopyObject,
		"OpTranspose": OpTranspose,
		"OpSampledImage": OpSampledImage,
		"OpImageSampleImplicitLod": OpImageSampleImplicitLod,
		"OpImageSampleExplicitLod": OpImageSampleExplicitLod,
		"OpImageSampleDrefImplicitLod": OpImageSampleDrefImplicitLod,
		"OpImageSampleDrefExplicitLod": OpImageSampleDrefExplicitLod,
		"OpImageSampleProjImplicitLod": OpImageSampleProjImplicitLod,
		"OpImageSampleProjExplicitLod": OpImageSampleProjExplicitLod,
		"OpImageSampleProjDrefImplicitLod": OpImageSampleProjDrefImplicitLod,
		"OpImageSampleProjDrefExplicitLod": OpImageSampleProjDrefExplicitLod,
		"OpImageFetch": OpImageFetch,
		"OpImageGather": OpImageGather,
		"OpImageDrefGather": OpImageDrefGather,
		"OpImageRead": OpImageRead,
		"OpImageWrite": OpImageWrite,
		"OpImage": OpImage,
		"OpImageQueryFormat": OpImageQueryFormat,
		"OpImageQueryOrder": OpImageQueryOrder,
		"OpImageQuerySizeLod": OpImageQuerySizeLod,
		"OpImageQuerySize": OpImageQuerySize,
		"OpImageQueryLod": OpImageQueryLod,
		"OpImageQueryLevels": OpImageQueryLevels,
		"OpImageQuerySamples": OpImageQuerySamples,
		"OpConvertFToU": OpConvertFToU,
		"OpConvertFToS": OpConvertFToS,
		"OpConvertSToF": OpConvertSToF,
		"OpConvertUToF": OpConvertUToF,
		"OpUConvert": OpUConvert,
		"OpSConvert": OpSConvert,
		"OpFConvert": OpFConvert,
		"OpQuantizeToF16": OpQuantizeToF16,
		"OpConvertPtrToU": OpConvertPtrToU,
		"OpSatConvertSToU": OpSatConvertSToU,
		"OpSatConvertUToS": OpSatConvertUToS,
		"OpConvertUToPtr": OpConvertUToPtr,
		"OpPtrCastToGeneric": OpPtrCastToGeneric,
		"OpGenericCastToPtr": OpGenericCastToPtr,
		"OpGenericCastToPtrExplicit": OpGenericCastToPtrExplicit,
		"OpBitcast": OpBitcast,
		"OpSNegate": OpSNegate,
		"OpFNegate": OpFNegate,
		"OpIAdd": OpIAdd,
		"OpFAdd": OpFAdd,
		"OpISub": OpISub,
		"OpFSub": OpFSub,
		"OpIMul": OpIMul,
		"OpFMul": OpFMul,
		"OpUDiv": OpUDiv,
		"OpSDiv": OpSDiv,
		"OpFDiv": OpFDiv,
		"OpUMod": OpUMod,
		"OpSRem": OpSRem,
		"OpSMod": OpSMod,
		"OpFRem": OpFRem,
		"OpFMod": OpFMod,
		"OpVectorTimesScalar": OpVectorTimesScalar,
		"OpMatrixTimesScalar": OpMatrixTimesScalar,
		"OpVectorTimesMatrix": OpVectorTimesMatrix,
		"OpMatrixTimesVector": OpMatrixTimesVector,
		"OpMatrixTimesMatrix": OpMatrixTimesMatrix,
		"OpOuterProduct": OpOuterProduct,
		"OpDot": OpDot,
		"OpIAddCarry": OpIAddCarry,
		"OpISubBorrow": OpISubBorrow,
		"OpUMulExtended": OpUMulExtended,
		"OpSMulExtended": OpSMulExtended,
		"OpAny": OpAny,
		"OpAll": OpAll,
		"OpIsNan": OpIsNan,
		"OpIsInf": OpIsInf,
		"OpIsFinite": OpIsFinite,
		"OpIsNormal": OpIsNormal,
		"OpSignBitSet": OpSignBitSet,
		"OpLessOrGreater": OpLessOrGreater,
		"OpOrdered": OpOrdered,
		"OpUnordered": OpUnordered,
		"OpLogicalEqual": OpLogicalEqual,
		"OpLogicalNotEqual": OpLogicalNotEqual,
		"OpLogicalOr": OpLogicalOr,
		"OpLogicalAnd": OpLogicalAnd,
		"OpLogicalNot": OpLogicalNot,
		"OpSelect": OpSelect,
		"OpIEqual": OpIEqual,
		"OpINotEqual": OpINotEqual,
		"OpUGreaterThan": OpUGreaterThan,
		"OpSGreaterThan": OpSGreaterThan,
		"OpUGreaterThanEqual": OpUGreaterThanEqual,
		"OpSGreaterThanEqual": OpSGreaterThanEqual,
		"OpULessThan": OpULessThan,
		"OpSLessThan": OpSLessThan,
		"OpULessThanEqual": OpULessThanEqual,
		"OpSLessThanEqual": OpSLessThanEqual,
		"OpFOrdEqual": OpFOrdEqual,
		"OpFUnordEqual": OpFUnordEqual,
		"OpFOrdNotEqual": OpFOrdNotEqual,
		"OpFUnordNotEqual": OpFUnordNotEqual,
		"OpFOrdLessThan": OpFOrdLessThan,
		"OpFUnordLessThan": OpFUnordLessThan,
		"OpFOrdGreaterThan": OpFOrdGreaterThan,
		"OpFUnordGreaterThan": OpFUnordGreaterThan,
		"OpFOrdLessThanEqual": OpFOrdLessThanEqual,
		"OpFUnordLessThanEqual": OpFUnordLessThanEqual,
		"OpFOrdGreaterThanEqual": OpFOrdGreaterThanEqual,
		"OpFUnordGreaterThanEqual": OpFUnordGreaterThanEqual,
		"OpShiftRightLogical": OpShiftRightLogical,
		"OpShiftRightArithmetic": OpShiftRightArithmetic,
		"OpShiftLeftLogical": OpShiftLeftLogical,
		"OpBitwiseOr": OpBitwiseOr,
		"OpBitwiseXor": OpBitwiseXor,
		"OpBitwiseAnd": OpBitwiseAnd,
		"OpNot": OpNot,
		"OpBitFieldInsert": OpBitFieldInsert,
		"OpBitFieldSExtract": OpBitFieldSExtract,
		"OpBitFieldUExtract": OpBitFieldUExtract,
		"OpBitReverse": OpBitReverse,
		"OpBitCount": OpBitCount,
		"OpDPdx": OpDPdx,
		"OpDPdy": OpDPdy,
		"OpFwidth": OpFwidth,
		"OpDPdxFine": OpDPdxFine,
		"OpDPdyFine": OpDPdyFine,
		"OpFwidthFine": OpFwidthFine,
		"OpDPdxCoarse": OpDPdxCoarse,
		"OpDPdyCoarse": OpDPdyCoarse,
		"OpFwidthCoarse": OpFwidthCoarse,
		"OpEmitVertex": OpEmitVertex,
		"OpEndPrimitive": OpEndPrimitive,
		"OpEmitStreamVertex": OpEmitStreamVertex,
		"OpEndStreamPrimitive": OpEndStreamPrimitive,
		"OpControlBarrier": OpControlBarrier,
		"OpMemoryBarrier": OpMemoryBarrier,
		"OpAtomicLoad": OpAtomicLoad,
		"OpAtomicStore": OpAtomicStore,
		"OpAtomicExchange": OpAtomicExchange,
		"OpAtomicCompareExchange": OpAtomicCompareExchange,
		"OpAtomicCompareExchangeWeak": OpAtomicCompareExchangeWeak,
		"OpAtomicIIncrement": OpAtomicIIncrement,
		"OpAtomicIDecrement": OpAtomicIDecrement,
		"OpAtomicIAdd": OpAtomicIAdd,
		"OpAtomicISub": OpAtomicISub,
		"OpAtomicSMin": OpAtomicSMin,
		"OpAtomicUMin": OpAtomicUMin,
		"OpAtomicSMax": OpAtomicSMax,
		"OpAtomicUMax": OpAtomicUMax,
		"OpAtomicAnd": OpAtomicAnd,
		"OpAtomicOr": OpAtomicOr,
		"OpAtomicXor": OpAtomicXor,
		"OpPhi": OpPhi,
		"OpLoopMerge": OpLoopMerge,
		"OpSelectionMerge": OpSelectionMerge,
		"OpLabel": OpLabel,
		"OpBranch": OpBranch,
		"OpBranchConditional": OpBranchConditional,
		"OpSwitch": OpSwitch,
		"OpKill": OpKill,
		"OpReturn": OpReturn,
		"OpReturnValue": OpReturnValue,
		"OpUnreachable": OpUnreachable,
		"OpLifetimeStart": OpLifetimeStart,
		"OpLifetimeStop": OpLifetimeStop,
		"OpGroupAsyncCopy": OpGroupAsyncCopy,
		"OpGroupWaitEvents": OpGroupWaitEvents,
		"OpGroupAll": OpGroupAll,
		"OpGroupAny": OpGroupAny,
		"OpGroupBroadcast": OpGroupBroadcast,
		"OpGroupIAdd": OpGroupIAdd,
		"OpGroupFAdd": OpGroupFAdd,
		"OpGroupFMin": OpGroupFMin,
		"OpGroupUMin": OpGroupUMin,
		"OpGroupSMin": OpGroupSMin,
		"OpGroupFMax": OpGroupFMax,
		"OpGroupUMax": OpGroupUMax,
		"OpGroupSMax": OpGroupSMax,
		"OpReadPipe": OpReadPipe,
		"OpWritePipe": OpWritePipe,
		"OpReservedReadPipe": OpReservedReadPipe,
		"OpReservedWritePipe": OpReservedWritePipe,
		"OpReserveReadPipePackets": OpReserveReadPipePackets,
		"OpReserveWritePipePackets": OpReserveWritePipePackets,
		"OpCommitReadPipe": OpCommitReadPipe,
		"OpCommitWritePipe": OpCommitWritePipe,
		"OpIsValidReserveId": OpIsValidReserveId,
		"OpGetNumPipePackets": OpGetNumPipePackets,
		"OpGetMaxPipePackets": OpGetMaxPipePackets,
		"OpGroupReserveReadPipePackets": OpGroupReserveReadPipePackets,
		"OpGroupReserveWritePipePackets": OpGroupReserveWritePipePackets,
		"OpGroupCommitReadPipe": OpGroupCommitReadPipe,
		"OpGroupCommitWritePipe": OpGroupCommitWritePipe,
		"OpEnqueueMarker": OpEnqueueMarker,
		"OpEnqueueKernel": OpEnqueueKernel,
		"OpGetKernelNDrangeSubGroupCount": OpGetKernelNDrangeSubGroupCount,
		"OpGetKernelNDrangeMaxSubGroupSize": OpGetKernelNDrangeMaxSubGroupSize,
		"OpGetKernelWorkGroupSize": OpGetKernelWorkGroupSize,
		"OpGetKernelPreferredWorkGroupSizeMultiple": OpGetKernelPreferredWorkGroupSizeMultiple,
		"OpRetainEvent": OpRetainEvent,
		"OpReleaseEvent": OpReleaseEvent,
		"OpCreateUserEvent": OpCreateUserEvent,
		"OpIsValidEvent": OpIsValidEvent,
		"OpSetUserEventStatus": OpSetUserEventStatus,
		"OpCaptureEventProfilingInfo": OpCaptureEventProfilingInfo,
		"OpGetDefaultQueue": OpGetDefaultQueue,
		"OpBuildNDRange": OpBuildNDRange,
		"OpImageSparseSampleImplicitLod": OpImageSparseSampleImplicitLod,
		"OpImageSparseSampleExplicitLod": OpImageSparseSampleExplicitLod,
		"OpImageSparseSampleDrefImplicitLod": OpImageSparseSampleDrefImplicitLod,
		"OpImageSparseSampleDrefExplicitLod": OpImageSparseSampleDrefExplicitLod,
		"OpImageSparseSampleProjImplicitLod": OpImageSparseSampleProjImplicitLod,
		"OpImageSparseSampleProjExplicitLod": OpImageSparseSampleProjExplicitLod,
		"OpImageSparseSampleProjDrefImplicitLod": OpImageSparseSampleProjDrefImplicitLod,
		"OpImageSparseSampleProjDrefExplicitLod": OpImageSparseSampleProjDrefExplicitLod,
		"OpImageSparseFetch": OpImageSparseFetch,
		"OpImageSparseGather": OpImageSparseGather,
		"OpImageSparseDrefGather": OpImageSparseDrefGather,
		"OpImageSparseTexelsResident": OpImageSparseTexelsResident,
		"OpNoLine": OpNoLine,
		"OpAtomicFlagTestAndSet": OpAtomicFlagTestAndSet,
		"OpAtomicFlagClear": OpAtomicFlagClear,
		"OpImageSparseRead": OpImageSparseRead,
		"OpSizeOf": OpSizeOf,
		"OpTypePipeStorage": OpTypePipeStorage,
		"OpConstantPipeStorage": OpConstantPipeStorage,
		"OpCreatePipeFromPipeStorage": OpCreatePipeFromPipeStorage,
		"OpGetKernelLocalSizeForSubgroupCount": OpGetKernelLocalSizeForSubgroupCount,
		"OpGetKernelMaxNumSubgroups": OpGetKernelMaxNumSubgroups,
		"OpTypeNamedBarrier": OpTypeNamedBarrier,
		"OpNamedBarrierInitialize": OpNamedBarrierInitialize,
		"OpMemoryNamedBarrier": OpMemoryNamedBarrier,
		"OpModuleProcessed": OpModuleProcessed,
		"OpExecutionModeId": OpExecutionModeId,
		"OpDecorateId": OpDecorateId,
		"OpGroupNonUniformElect": OpGroupNonUniformElect,
		"OpGroupNonUniformAll": OpGroupNonUniformAll,
		"OpGroupNonUniformAny": OpGroupNonUniformAny,
		"OpGroupNonUniformAllEqual": OpGroupNonUniformAllEqual,
		"OpGroupNonUniformBroadcast": OpGroupNonUniformBroadcast,
		"OpGroupNonUniformBroadcastFirst": OpGroupNonUniformBroadcastFirst,
		"OpGroupNonUniformBallot": OpGroupNonUniformBallot,
		"OpGroupNonUniformInverseBallot": OpGroupNonUniformInverseBallot,
		"OpGroupNonUniformBallotBitExtract": OpGroupNonUniformBallotBitExtract,
		"OpGroupNonUniformBallotBitCount": OpGroupNonUniformBallotBitCount,
		"OpGroupNonUniformBallotFindLSB": OpGroupNonUniformBallotFindLSB,
		"OpGroupNonUniformBallotFindMSB": OpGroupNonUniformBallotFindMSB,
		"OpGroupNonUniformShuffle": OpGroupNonUniformShuffle,
		"OpGroupNonUniformShuffleXor": OpGroupNonUniformShuffleXor,
		"OpGroupNonUniformShuffleUp": OpGroupNonUniformShuffleUp,
		"OpGroupNonUniformShuffleDown": OpGroupNonUniformShuffleDown,
		"OpGroupNonUniformIAdd": OpGroupNonUniformIAdd,
		"OpGroupNonUniformFAdd": OpGroupNonUniformFAdd,
		"OpGroupNonUniformIMul": OpGroupNonUniformIMul,
		"OpGroupNonUniformFMul": OpGroupNonUniformFMul,
		"OpGroupNonUniformSMin": OpGroupNonUniformSMin,
		"OpGroupNonUniformUMin": OpGroupNonUniformUMin,
		"OpGroupNonUniformFMin": OpGroupNonUniformFMin,
		"OpGroupNonUniformSMax": OpGroupNonUniformSMax,
		"OpGroupNonUniformUMax": OpGroupNonUniformUMax,
		"OpGroupNonUniformFMax": OpGroupNonUniformFMax,
		"OpGroupNonUniformBitwiseAnd": OpGroupNonUniformBitwiseAnd,
		"OpGroupNonUniformBitwiseOr": OpGroupNonUniformBitwiseOr,
		"OpGroupNonUniformBitwiseXor": OpGroupNonUniformBitwiseXor,
		"OpGroupNonUniformLogicalAnd": OpGroupNonUniformLogicalAnd,
		"OpGroupNonUniformLogicalOr": OpGroupNonUniformLogicalOr,
		"OpGroupNonUniformLogicalXor": OpGroupNonUniformLogicalXor,
		"OpGroupNonUniformQuadBroadcast": OpGroupNonUniformQuadBroadcast,
		"OpGroupNonUniformQuadSwap": OpGroupNonUniformQuadSwap,
		"OpCopyLogical": OpCopyLogical,
		"OpPtrEqual": OpPtrEqual,
		"OpPtrNotEqual": OpPtrNotEqual,
		"OpPtrDiff": OpPtrDiff,
		"OpSubgroupBallotKHR": OpSubgroupBallotKHR,
		"OpSubgroupFirstInvocationKHR": OpSubgroupFirstInvocationKHR,
		"OpSubgroupAllKHR": OpSubgroupAllKHR,
		"OpSubgroupAnyKHR": OpSubgroupAnyKHR,
		"OpSubgroupAllEqualKHR": OpSubgroupAllEqualKHR,
		"OpSubgroupReadInvocationKHR": OpSubgroupReadInvocationKHR,
		"OpGroupIAddNonUniformAMD": OpGroupIAddNonUniformAMD,
		"OpGroupFAddNonUniformAMD": OpGroupFAddNonUniformAMD,
		"OpGroupFMinNonUniformAMD": OpGroupFMinNonUniformAMD,
		"OpGroupUMinNonUniformAMD": OpGroupUMinNonUniformAMD,
		"OpGroupSMinNonUniformAMD": OpGroupSMinNonUniformAMD,
		"OpGroupFMaxNonUniformAMD": OpGroupFMaxNonUniformAMD,
		"OpGroupUMaxNonUniformAMD": OpGroupUMaxNonUniformAMD,
		"OpGroupSMaxNonUniformAMD": OpGroupSMaxNonUniformAMD,
		"OpFragmentMaskFetchAMD": OpFragmentMaskFetchAMD,
		"OpFragmentFetchAMD": OpFragmentFetchAMD,
		"OpReadClockKHR": OpReadClockKHR,
		"OpImageSampleFootprintNV": OpImageSampleFootprintNV,
		"OpGroupNonUniformPartitionNV": OpGroupNonUniformPartitionNV,
		"OpWritePackedPrimitiveIndices4x8NV": OpWritePackedPrimitiveIndices4x8NV,
		"OpReportIntersectionNV": OpReportIntersectionNV,
		"OpReportIntersectionKHR": OpReportIntersectionKHR,
		"OpIgnoreIntersectionNV": OpIgnoreIntersectionNV,
		"OpIgnoreIntersectionKHR": OpIgnoreIntersectionKHR,
		"OpTerminateRayNV": OpTerminateRayNV,
		"OpTerminateRayKHR": OpTerminateRayKHR,
		"OpTraceNV": OpTraceNV,
		"OpTraceRayKHR": OpTraceRayKHR,
		"OpTypeAccelerationStructureNV": OpTypeAccelerationStructureNV,
		"OpTypeAccelerationStructureKHR": OpTypeAccelerationStructureKHR,
		"OpTypeRayQueryKHR": OpTypeRayQueryKHR,
		"OpRayQueryInitializeKHR": OpRayQueryInitializeKHR,
		"OpRayQueryTerminateKHR": OpRayQueryTerminateKHR,
		"OpRayQueryGenerateIntersectionKHR": OpRayQueryGenerateIntersectionKHR,
		"OpRayQueryConfirmIntersectionKHR": OpRayQueryConfirmIntersectionKHR,
		"OpRayQueryProceedKHR": OpRayQueryProceedKHR,
		"OpRayQueryGetIntersectionTypeKHR": OpRayQueryGetIntersectionTypeKHR,
		"OpRayQueryGetRayTMinKHR": OpRayQueryGetRayTMinKHR,
		"OpRayQueryGetRayFlagsKHR": OpRayQueryGetRayFlagsKHR,
		"OpRayQueryGetIntersectionTKHR": OpRayQueryGetIntersectionTKHR,
		"OpRayQueryGetIntersectionInstanceCustomIndexKHR": OpRayQueryGetIntersectionInstanceCustomIndexKHR,
		"OpRayQueryGetIntersectionInstanceIdKHR": OpRayQueryGetIntersectionInstanceIdKHR,
		"OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR": OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR,
		"OpRayQueryGetIntersectionGeometryIndexKHR": OpRayQueryGetIntersectionGeometryIndexKHR,
		"OpRayQueryGetIntersectionPrimitiveIndexKHR": OpRayQueryGetIntersectionPrimitiveIndexKHR,
		"OpRayQueryGetIntersectionBarycentricsKHR": OpRayQueryGetIntersectionBarycentricsKHR,
		"OpRayQueryGetIntersectionFrontFaceKHR": OpRayQueryGetIntersectionFrontFaceKHR,
		"OpRayQueryGetIntersectionCandidateAABBOpaqueKHR": OpRayQueryGetIntersectionCandidateAABBOpaqueKHR,
		"OpRayQueryGetIntersectionObjectRayDirectionKHR": OpRayQueryGetIntersectionObjectRayDirectionKHR,
		"OpRayQueryGetIntersectionObjectRayOriginKHR": OpRayQueryGetIntersectionObjectRayOriginKHR,
		"OpRayQueryGetWorldRayDirectionKHR": OpRayQueryGetWorldRayDirectionKHR,
		"OpRayQueryGetWorldRayOriginKHR": OpRayQueryGetWorldRayOriginKHR,
		"OpRayQueryGetIntersectionObjectToWorldKHR": OpRayQueryGetIntersectionObjectToWorldKHR,
		"OpRayQueryGetIntersectionWorldToObjectKHR": OpRayQueryGetIntersectionWorldToObjectKHR,
		"OpExecuteCallableNV": OpExecuteCallableNV,
		"OpExecuteCallableKHR": OpExecuteCallableKHR,
		"OpTypeCooperativeMatrixNV": OpTypeCooperativeMatrixNV,
		"OpCooperativeMatrixLoadNV": OpCooperativeMatrixLoadNV,
		"OpCooperativeMatrixStoreNV": OpCooperativeMatrixStoreNV,
		"OpCooperativeMatrixMulAddNV": OpCooperativeMatrixMulAddNV,
		"OpCooperativeMatrixLengthNV": OpCooperativeMatrixLengthNV,
		"OpBeginInvocationInterlockEXT": OpBeginInvocationInterlockEXT,
		"OpEndInvocationInterlockEXT": OpEndInvocationInterlockEXT,
		"OpDemoteToHelperInvocationEXT": OpDemoteToHelperInvocationEXT,
		"OpIsHelperInvocationEXT": OpIsHelperInvocationEXT,
		"OpSubgroupShuffleINTEL": OpSubgroupShuffleINTEL,
		"OpSubgroupShuffleDownINTEL": OpSubgroupShuffleDownINTEL,
		"OpSubgroupShuffleUpINTEL": OpSubgroupShuffleUpINTEL,
		"OpSubgroupShuffleXorINTEL": OpSubgroupShuffleXorINTEL,
		"OpSubgroupBlockReadINTEL": OpSubgroupBlockReadINTEL,
		"OpSubgroupBlockWriteINTEL": OpSubgroupBlockWriteINTEL,
		"OpSubgroupImageBlockReadINTEL": OpSubgroupImageBlockReadINTEL,
		"OpSubgroupImageBlockWriteINTEL": OpSubgroupImageBlockWriteINTEL,
		"OpSubgroupImageMediaBlockReadINTEL": OpSubgroupImageMediaBlockReadINTEL,
		"OpSubgroupImageMediaBlockWriteINTEL": OpSubgroupImageMediaBlockWriteINTEL,
		"OpUCountLeadingZerosINTEL": OpUCountLeadingZerosINTEL,
		"OpUCountTrailingZerosINTEL": OpUCountTrailingZerosINTEL,
		"OpAbsISubINTEL": OpAbsISubINTEL,
		"OpAbsUSubINTEL": OpAbsUSubINTEL,
		"OpIAddSatINTEL": OpIAddSatINTEL,
		"OpUAddSatINTEL": OpUAddSatINTEL,
		"OpIAverageINTEL": OpIAverageINTEL,
		"OpUAverageINTEL": OpUAverageINTEL,
		"OpIAverageRoundedINTEL": OpIAverageRoundedINTEL,
		"OpUAverageRoundedINTEL": OpUAverageRoundedINTEL,
		"OpISubSatINTEL": OpISubSatINTEL,
		"OpUSubSatINTEL": OpUSubSatINTEL,
		"OpIMul32x16INTEL": OpIMul32x16INTEL,
		"OpUMul32x16INTEL": OpUMul32x16INTEL,
		"OpDecorateString": OpDecorateString,
		"OpDecorateStringGOOGLE": OpDecorateStringGOOGLE,
		"OpMemberDecorateString": OpMemberDecorateString,
		"OpMemberDecorateStringGOOGLE": OpMemberDecorateStringGOOGLE,
		"OpVmeImageINTEL": OpVmeImageINTEL,
		"OpTypeVmeImageINTEL": OpTypeVmeImageINTEL,
		"OpTypeAvcImePayloadINTEL": OpTypeAvcImePayloadINTEL,
		"OpTypeAvcRefPayloadINTEL": OpTypeAvcRefPayloadINTEL,
		"OpTypeAvcSicPayloadINTEL": OpTypeAvcSicPayloadINTEL,
		"OpTypeAvcMcePayloadINTEL": OpTypeAvcMcePayloadINTEL,
		"OpTypeAvcMceResultINTEL": OpTypeAvcMceResultINTEL,
		"OpTypeAvcImeResultINTEL": OpTypeAvcImeResultINTEL,
		"OpTypeAvcImeResultSingleReferenceStreamoutINTEL": OpTypeAvcImeResultSingleReferenceStreamoutINTEL,
		"OpTypeAvcImeResultDualReferenceStreamoutINTEL": OpTypeAvcImeResultDualReferenceStreamoutINTEL,
		"OpTypeAvcImeSingleReferenceStreaminINTEL": OpTypeAvcImeSingleReferenceStreaminINTEL,
		"OpTypeAvcImeDualReferenceStreaminINTEL": OpTypeAvcImeDualReferenceStreaminINTEL,
		"OpTypeAvcRefResultINTEL": OpTypeAvcRefResultINTEL,
		"OpTypeAvcSicResultINTEL": OpTypeAvcSicResultINTEL,
		"OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL": OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL,
		"OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL": OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL": OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL,
		"OpSubgroupAvcMceSetInterShapePenaltyINTEL": OpSubgroupAvcMceSetInterShapePenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL": OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL,
		"OpSubgroupAvcMceSetInterDirectionPenaltyINTEL": OpSubgroupAvcMceSetInterDirectionPenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL": OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL": OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL,
		"OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL": OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL,
		"OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL": OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL,
		"OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL": OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL,
		"OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL": OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL,
		"OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL": OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL": OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL,
		"OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL": OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL,
		"OpSubgroupAvcMceSetAcOnlyHaarINTEL": OpSubgroupAvcMceSetAcOnlyHaarINTEL,
		"OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL": OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL,
		"OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL": OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL,
		"OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL": OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL,
		"OpSubgroupAvcMceConvertToImePayloadINTEL": OpSubgroupAvcMceConvertToImePayloadINTEL,
		"OpSubgroupAvcMceConvertToImeResultINTEL": OpSubgroupAvcMceConvertToImeResultINTEL,
		"OpSubgroupAvcMceConvertToRefPayloadINTEL": OpSubgroupAvcMceConvertToRefPayloadINTEL,
		"OpSubgroupAvcMceConvertToRefResultINTEL": OpSubgroupAvcMceConvertToRefResultINTEL,
		"OpSubgroupAvcMceConvertToSicPayloadINTEL": OpSubgroupAvcMceConvertToSicPayloadINTEL,
		"OpSubgroupAvcMceConvertToSicResultINTEL": OpSubgroupAvcMceConvertToSicResultINTEL,
		"OpSubgroupAvcMceGetMotionVectorsINTEL": OpSubgroupAvcMceGetMotionVectorsINTEL,
		"OpSubgroupAvcMceGetInterDistortionsINTEL": OpSubgroupAvcMceGetInterDistortionsINTEL,
		"OpSubgroupAvcMceGetBestInterDistortionsINTEL": OpSubgroupAvcMceGetBestInterDistortionsINTEL,
		"OpSubgroupAvcMceGetInterMajorShapeINTEL": OpSubgroupAvcMceGetInterMajorShapeINTEL,
		"OpSubgroupAvcMceGetInterMinorShapeINTEL": OpSubgroupAvcMceGetInterMinorShapeINTEL,
		"OpSubgroupAvcMceGetInterDirectionsINTEL": OpSubgroupAvcMceGetInterDirectionsINTEL,
		"OpSubgroupAvcMceGetInterMotionVectorCountINTEL": OpSubgroupAvcMceGetInterMotionVectorCountINTEL,
		"OpSubgroupAvcMceGetInterReferenceIdsINTEL": OpSubgroupAvcMceGetInterReferenceIdsINTEL,
		"OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL": OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL,
		"OpSubgroupAvcImeInitializeINTEL": OpSubgroupAvcImeInitializeINTEL,
		"OpSubgroupAvcImeSetSingleReferenceINTEL": OpSubgroupAvcImeSetSingleReferenceINTEL,
		"OpSubgroupAvcImeSetDualReferenceINTEL": OpSubgroupAvcImeSetDualReferenceINTEL,
		"OpSubgroupAvcImeRefWindowSizeINTEL": OpSubgroupAvcImeRefWindowSizeINTEL,
		"OpSubgroupAvcImeAdjustRefOffsetINTEL": OpSubgroupAvcImeAdjustRefOffsetINTEL,
		"OpSubgroupAvcImeConvertToMcePayloadINTEL": OpSubgroupAvcImeConvertToMcePayloadINTEL,
		"OpSubgroupAvcImeSetMaxMotionVectorCountINTEL": OpSubgroupAvcImeSetMaxMotionVectorCountINTEL,
		"OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL": OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL,
		"OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL": OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL,
		"OpSubgroupAvcImeSetWeightedSadINTEL": OpSubgroupAvcImeSetWeightedSadINTEL,
		"OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL": OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL,
		"OpSubgroupAvcImeEvaluateWithDualReferenceINTEL": OpSubgroupAvcImeEvaluateWithDualReferenceINTEL,
		"OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL": OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL,
		"OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL": OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL,
		"OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL": OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL,
		"OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL": OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL,
		"OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL": OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL,
		"OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL": OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL,
		"OpSubgroupAvcImeConvertToMceResultINTEL": OpSubgroupAvcImeConvertToMceResultINTEL,
		"OpSubgroupAvcImeGetSingleReferenceStreaminINTEL": OpSubgroupAvcImeGetSingleReferenceStreaminINTEL,
		"OpSubgroupAvcImeGetDualReferenceStreaminINTEL": OpSubgroupAvcImeGetDualReferenceStreaminINTEL,
		"OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL": OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL,
		"OpSubgroupAvcImeStripDualReferenceStreamoutINTEL": OpSubgroupAvcImeStripDualReferenceStreamoutINTEL,
		"OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL": OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL,
		"OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL": OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL,
		"OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL": OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL,
		"OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL": OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL,
		"OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL": OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL,
		"OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL": OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL,
		"OpSubgroupAvcImeGetBorderReachedINTEL": OpSubgroupAvcImeGetBorderReachedINTEL,
		"OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL": OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL,
		"OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL": OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL,
		"OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL": OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL,
		"OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL": OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL,
		"OpSubgroupAvcFmeInitializeINTEL": OpSubgroupAvcFmeInitializeINTEL,
		"OpSubgroupAvcBmeInitializeINTEL": OpSubgroupAvcBmeInitializeINTEL,
		"OpSubgroupAvcRefConvertToMcePayloadINTEL": OpSubgroupAvcRefConvertToMcePayloadINTEL,
		"OpSubgroupAvcRefSetBidirectionalMixDisableINTEL": OpSubgroupAvcRefSetBidirectionalMixDisableINTEL,
		"OpSubgroupAvcRefSetBilinearFilterEnableINTEL": OpSubgroupAvcRefSetBilinearFilterEnableINTEL,
		"OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL": OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL,
		"OpSubgroupAvcRefEvaluateWithDualReferenceINTEL": OpSubgroupAvcRefEvaluateWithDualReferenceINTEL,
		"OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL": OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL,
		"OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL": OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL,
		"OpSubgroupAvcRefConvertToMceResultINTEL": OpSubgroupAvcRefConvertToMceResultINTEL,
		"OpSubgroupAvcSicInitializeINTEL": OpSubgroupAvcSicInitializeINTEL,
		"OpSubgroupAvcSicConfigureSkcINTEL": OpSubgroupAvcSicConfigureSkcINTEL,
		"OpSubgroupAvcSicConfigureIpeLumaINTEL": OpSubgroupAvcSicConfigureIpeLumaINTEL,
		"OpSubgroupAvcSicConfigureIpeLumaChromaINTEL": OpSubgroupAvcSicConfigureIpeLumaChromaINTEL,
		"OpSubgroupAvcSicGetMotionVectorMaskINTEL": OpSubgroupAvcSicGetMotionVectorMaskINTEL,
		"OpSubgroupAvcSicConvertToMcePayloadINTEL": OpSubgroupAvcSicConvertToMcePayloadINTEL,
		"OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL": OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL,
		"OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL": OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL,
		"OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL": OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL,
		"OpSubgroupAvcSicSetBilinearFilterEnableINTEL": OpSubgroupAvcSicSetBilinearFilterEnableINTEL,
		"OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL": OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL,
		"OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL": OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL,
		"OpSubgroupAvcSicEvaluateIpeINTEL": OpSubgroupAvcSicEvaluateIpeINTEL,
		"OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL": OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL,
		"OpSubgroupAvcSicEvaluateWithDualReferenceINTEL": OpSubgroupAvcSicEvaluateWithDualReferenceINTEL,
		"OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL": OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL,
		"OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL": OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL,
		"OpSubgroupAvcSicConvertToMceResultINTEL": OpSubgroupAvcSicConvertToMceResultINTEL,
		"OpSubgroupAvcSicGetIpeLumaShapeINTEL": OpSubgroupAvcSicGetIpeLumaShapeINTEL,
		"OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL": OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL,
		"OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL": OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL,
		"OpSubgroupAvcSicGetPackedIpeLumaModesINTEL": OpSubgroupAvcSicGetPackedIpeLumaModesINTEL,
		"OpSubgroupAvcSicGetIpeChromaModeINTEL": OpSubgroupAvcSicGetIpeChromaModeINTEL,
		"OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL": OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL,
		"OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL": OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL,
		"OpSubgroupAvcSicGetInterRawSadsINTEL": OpSubgroupAvcSicGetInterRawSadsINTEL,
	}

	// ExtOpcodes is a map of extension name to Opcode description list.
	ExtOpcodes = map[string]OpcodeMap {
		"GLSL.std.450": {
			"Round": GLSLStd450_Round,
			"RoundEven": GLSLStd450_RoundEven,
			"Trunc": GLSLStd450_Trunc,
			"FAbs": GLSLStd450_FAbs,
			"SAbs": GLSLStd450_SAbs,
			"FSign": GLSLStd450_FSign,
			"SSign": GLSLStd450_SSign,
			"Floor": GLSLStd450_Floor,
			"Ceil": GLSLStd450_Ceil,
			"Fract": GLSLStd450_Fract,
			"Radians": GLSLStd450_Radians,
			"Degrees": GLSLStd450_Degrees,
			"Sin": GLSLStd450_Sin,
			"Cos": GLSLStd450_Cos,
			"Tan": GLSLStd450_Tan,
			"Asin": GLSLStd450_Asin,
			"Acos": GLSLStd450_Acos,
			"Atan": GLSLStd450_Atan,
			"Sinh": GLSLStd450_Sinh,
			"Cosh": GLSLStd450_Cosh,
			"Tanh": GLSLStd450_Tanh,
			"Asinh": GLSLStd450_Asinh,
			"Acosh": GLSLStd450_Acosh,
			"Atanh": GLSLStd450_Atanh,
			"Atan2": GLSLStd450_Atan2,
			"Pow": GLSLStd450_Pow,
			"Exp": GLSLStd450_Exp,
			"Log": GLSLStd450_Log,
			"Exp2": GLSLStd450_Exp2,
			"Log2": GLSLStd450_Log2,
			"Sqrt": GLSLStd450_Sqrt,
			"InverseSqrt": GLSLStd450_InverseSqrt,
			"Determinant": GLSLStd450_Determinant,
			"MatrixInverse": GLSLStd450_MatrixInverse,
			"Modf": GLSLStd450_Modf,
			"ModfStruct": GLSLStd450_ModfStruct,
			"FMin": GLSLStd450_FMin,
			"UMin": GLSLStd450_UMin,
			"SMin": GLSLStd450_SMin,
			"FMax": GLSLStd450_FMax,
			"UMax": GLSLStd450_UMax,
			"SMax": GLSLStd450_SMax,
			"FClamp": GLSLStd450_FClamp,
			"UClamp": GLSLStd450_UClamp,
			"SClamp": GLSLStd450_SClamp,
			"FMix": GLSLStd450_FMix,
			"IMix": GLSLStd450_IMix,
			"Step": GLSLStd450_Step,
			"SmoothStep": GLSLStd450_SmoothStep,
			"Fma": GLSLStd450_Fma,
			"Frexp": GLSLStd450_Frexp,
			"FrexpStruct": GLSLStd450_FrexpStruct,
			"Ldexp": GLSLStd450_Ldexp,
			"PackSnorm4x8": GLSLStd450_PackSnorm4x8,
			"PackUnorm4x8": GLSLStd450_PackUnorm4x8,
			"PackSnorm2x16": GLSLStd450_PackSnorm2x16,
			"PackUnorm2x16": GLSLStd450_PackUnorm2x16,
			"PackHalf2x16": GLSLStd450_PackHalf2x16,
			"PackDouble2x32": GLSLStd450_PackDouble2x32,
			"UnpackSnorm2x16": GLSLStd450_UnpackSnorm2x16,
			"UnpackUnorm2x16": GLSLStd450_UnpackUnorm2x16,
			"UnpackHalf2x16": GLSLStd450_UnpackHalf2x16,
			"UnpackSnorm4x8": GLSLStd450_UnpackSnorm4x8,
			"UnpackUnorm4x8": GLSLStd450_UnpackUnorm4x8,
			"UnpackDouble2x32": GLSLStd450_UnpackDouble2x32,
			"Length": GLSLStd450_Length,
			"Distance": GLSLStd450_Distance,
			"Cross": GLSLStd450_Cross,
			"Normalize": GLSLStd450_Normalize,
			"FaceForward": GLSLStd450_FaceForward,
			"Reflect": GLSLStd450_Reflect,
			"Refract": GLSLStd450_Refract,
			"FindILsb": GLSLStd450_FindILsb,
			"FindSMsb": GLSLStd450_FindSMsb,
			"FindUMsb": GLSLStd450_FindUMsb,
			"InterpolateAtCentroid": GLSLStd450_InterpolateAtCentroid,
			"InterpolateAtSample": GLSLStd450_InterpolateAtSample,
			"InterpolateAtOffset": GLSLStd450_InterpolateAtOffset,
			"NMin": GLSLStd450_NMin,
			"NMax": GLSLStd450_NMax,
			"NClamp": GLSLStd450_NClamp,
		},
		"OpenCL.std": {
			"acos": OpenCLStd_acos,
			"acosh": OpenCLStd_acosh,
			"acospi": OpenCLStd_acospi,
			"asin": OpenCLStd_asin,
			"asinh": OpenCLStd_asinh,
			"asinpi": OpenCLStd_asinpi,
			"atan": OpenCLStd_atan,
			"atan2": OpenCLStd_atan2,
			"atanh": OpenCLStd_atanh,
			"atanpi": OpenCLStd_atanpi,
			"atan2pi": OpenCLStd_atan2pi,
			"cbrt": OpenCLStd_cbrt,
			"ceil": OpenCLStd_ceil,
			"copysign": OpenCLStd_copysign,
			"cos": OpenCLStd_cos,
			"cosh": OpenCLStd_cosh,
			"cospi": OpenCLStd_cospi,
			"erfc": OpenCLStd_erfc,
			"erf": OpenCLStd_erf,
			"exp": OpenCLStd_exp,
			"exp2": OpenCLStd_exp2,
			"exp10": OpenCLStd_exp10,
			"expm1": OpenCLStd_expm1,
			"fabs": OpenCLStd_fabs,
			"fdim": OpenCLStd_fdim,
			"floor": OpenCLStd_floor,
			"fma": OpenCLStd_fma,
			"fmax": OpenCLStd_fmax,
			"fmin": OpenCLStd_fmin,
			"fmod": OpenCLStd_fmod,
			"fract": OpenCLStd_fract,
			"frexp": OpenCLStd_frexp,
			"hypot": OpenCLStd_hypot,
			"ilogb": OpenCLStd_ilogb,
			"ldexp": OpenCLStd_ldexp,
			"lgamma": OpenCLStd_lgamma,
			"lgamma_r": OpenCLStd_lgamma_r,
			"log": OpenCLStd_log,
			"log2": OpenCLStd_log2,
			"log10": OpenCLStd_log10,
			"log1p": OpenCLStd_log1p,
			"logb": OpenCLStd_logb,
			"mad": OpenCLStd_mad,
			"maxmag": OpenCLStd_maxmag,
			"minmag": OpenCLStd_minmag,
			"modf": OpenCLStd_modf,
			"nan": OpenCLStd_nan,
			"nextafter": OpenCLStd_nextafter,
			"pow": OpenCLStd_pow,
			"pown": OpenCLStd_pown,
			"powr": OpenCLStd_powr,
			"remainder": OpenCLStd_remainder,
			"remquo": OpenCLStd_remquo,
			"rint": OpenCLStd_rint,
			"rootn": OpenCLStd_rootn,
			"round": OpenCLStd_round,
			"rsqrt": OpenCLStd_rsqrt,
			"sin": OpenCLStd_sin,
			"sincos": OpenCLStd_sincos,
			"sinh": OpenCLStd_sinh,
			"sinpi": OpenCLStd_sinpi,
			"sqrt": OpenCLStd_sqrt,
			"tan": OpenCLStd_tan,
			"tanh": OpenCLStd_tanh,
			"tanpi": OpenCLStd_tanpi,
			"tgamma": OpenCLStd_tgamma,
			"trunc": OpenCLStd_trunc,
			"half_cos": OpenCLStd_half_cos,
			"half_divide": OpenCLStd_half_divide,
			"half_exp": OpenCLStd_half_exp,
			"half_exp2": OpenCLStd_half_exp2,
			"half_exp10": OpenCLStd_half_exp10,
			"half_log": OpenCLStd_half_log,
			"half_log2": OpenCLStd_half_log2,
			"half_log10": OpenCLStd_half_log10,
			"half_powr": OpenCLStd_half_powr,
			"half_recip": OpenCLStd_half_recip,
			"half_rsqrt": OpenCLStd_half_rsqrt,
			"half_sin": OpenCLStd_half_sin,
			"half_sqrt": OpenCLStd_half_sqrt,
			"half_tan": OpenCLStd_half_tan,
			"native_cos": OpenCLStd_native_cos,
			"native_divide": OpenCLStd_native_divide,
			"native_exp": OpenCLStd_native_exp,
			"native_exp2": OpenCLStd_native_exp2,
			"native_exp10": OpenCLStd_native_exp10,
			"native_log": OpenCLStd_native_log,
			"native_log2": OpenCLStd_native_log2,
			"native_log10": OpenCLStd_native_log10,
			"native_powr": OpenCLStd_native_powr,
			"native_recip": OpenCLStd_native_recip,
			"native_rsqrt": OpenCLStd_native_rsqrt,
			"native_sin": OpenCLStd_native_sin,
			"native_sqrt": OpenCLStd_native_sqrt,
			"native_tan": OpenCLStd_native_tan,
			"s_abs": OpenCLStd_s_abs,
			"s_abs_diff": OpenCLStd_s_abs_diff,
			"s_add_sat": OpenCLStd_s_add_sat,
			"u_add_sat": OpenCLStd_u_add_sat,
			"s_hadd": OpenCLStd_s_hadd,
			"u_hadd": OpenCLStd_u_hadd,
			"s_rhadd": OpenCLStd_s_rhadd,
			"u_rhadd": OpenCLStd_u_rhadd,
			"s_clamp": OpenCLStd_s_clamp,
			"u_clamp": OpenCLStd_u_clamp,
			"clz": OpenCLStd_clz,
			"ctz": OpenCLStd_ctz,
			"s_mad_hi": OpenCLStd_s_mad_hi,
			"u_mad_sat": OpenCLStd_u_mad_sat,
			"s_mad_sat": OpenCLStd_s_mad_sat,
			"s_max": OpenCLStd_s_max,
			"u_max": OpenCLStd_u_max,
			"s_min": OpenCLStd_s_min,
			"u_min": OpenCLStd_u_min,
			"s_mul_hi": OpenCLStd_s_mul_hi,
			"rotate": OpenCLStd_rotate,
			"s_sub_sat": OpenCLStd_s_sub_sat,
			"u_sub_sat": OpenCLStd_u_sub_sat,
			"u_upsample": OpenCLStd_u_upsample,
			"s_upsample": OpenCLStd_s_upsample,
			"popcount": OpenCLStd_popcount,
			"s_mad24": OpenCLStd_s_mad24,
			"u_mad24": OpenCLStd_u_mad24,
			"s_mul24": OpenCLStd_s_mul24,
			"u_mul24": OpenCLStd_u_mul24,
			"u_abs": OpenCLStd_u_abs,
			"u_abs_diff": OpenCLStd_u_abs_diff,
			"u_mul_hi": OpenCLStd_u_mul_hi,
			"u_mad_hi": OpenCLStd_u_mad_hi,
			"fclamp": OpenCLStd_fclamp,
			"degrees": OpenCLStd_degrees,
			"fmax_common": OpenCLStd_fmax_common,
			"fmin_common": OpenCLStd_fmin_common,
			"mix": OpenCLStd_mix,
			"radians": OpenCLStd_radians,
			"step": OpenCLStd_step,
			"smoothstep": OpenCLStd_smoothstep,
			"sign": OpenCLStd_sign,
			"cross": OpenCLStd_cross,
			"distance": OpenCLStd_distance,
			"length": OpenCLStd_length,
			"normalize": OpenCLStd_normalize,
			"fast_distance": OpenCLStd_fast_distance,
			"fast_length": OpenCLStd_fast_length,
			"fast_normalize": OpenCLStd_fast_normalize,
			"bitselect": OpenCLStd_bitselect,
			"select": OpenCLStd_select,
			"vloadn": OpenCLStd_vloadn,
			"vstoren": OpenCLStd_vstoren,
			"vload_half": OpenCLStd_vload_half,
			"vload_halfn": OpenCLStd_vload_halfn,
			"vstore_half": OpenCLStd_vstore_half,
			"vstore_half_r": OpenCLStd_vstore_half_r,
			"vstore_halfn": OpenCLStd_vstore_halfn,
			"vstore_halfn_r": OpenCLStd_vstore_halfn_r,
			"vloada_halfn": OpenCLStd_vloada_halfn,
			"vstorea_halfn": OpenCLStd_vstorea_halfn,
			"vstorea_halfn_r": OpenCLStd_vstorea_halfn_r,
			"shuffle": OpenCLStd_shuffle,
			"shuffle2": OpenCLStd_shuffle2,
			"printf": OpenCLStd_printf,
			"prefetch": OpenCLStd_prefetch,
		},
		"OpenCL.DebugInfo.100": {
			"DebugInfoNone": OpenCLDebugInfo100_DebugInfoNone,
			"DebugCompilationUnit": OpenCLDebugInfo100_DebugCompilationUnit,
			"DebugTypeBasic": OpenCLDebugInfo100_DebugTypeBasic,
			"DebugTypePointer": OpenCLDebugInfo100_DebugTypePointer,
			"DebugTypeQualifier": OpenCLDebugInfo100_DebugTypeQualifier,
			"DebugTypeArray": OpenCLDebugInfo100_DebugTypeArray,
			"DebugTypeVector": OpenCLDebugInfo100_DebugTypeVector,
			"DebugTypedef": OpenCLDebugInfo100_DebugTypedef,
			"DebugTypeFunction": OpenCLDebugInfo100_DebugTypeFunction,
			"DebugTypeEnum": OpenCLDebugInfo100_DebugTypeEnum,
			"DebugTypeComposite": OpenCLDebugInfo100_DebugTypeComposite,
			"DebugTypeMember": OpenCLDebugInfo100_DebugTypeMember,
			"DebugTypeInheritance": OpenCLDebugInfo100_DebugTypeInheritance,
			"DebugTypePtrToMember": OpenCLDebugInfo100_DebugTypePtrToMember,
			"DebugTypeTemplate": OpenCLDebugInfo100_DebugTypeTemplate,
			"DebugTypeTemplateParameter": OpenCLDebugInfo100_DebugTypeTemplateParameter,
			"DebugTypeTemplateTemplateParameter": OpenCLDebugInfo100_DebugTypeTemplateTemplateParameter,
			"DebugTypeTemplateParameterPack": OpenCLDebugInfo100_DebugTypeTemplateParameterPack,
			"DebugGlobalVariable": OpenCLDebugInfo100_DebugGlobalVariable,
			"DebugFunctionDeclaration": OpenCLDebugInfo100_DebugFunctionDeclaration,
			"DebugFunction": OpenCLDebugInfo100_DebugFunction,
			"DebugLexicalBlock": OpenCLDebugInfo100_DebugLexicalBlock,
			"DebugLexicalBlockDiscriminator": OpenCLDebugInfo100_DebugLexicalBlockDiscriminator,
			"DebugScope": OpenCLDebugInfo100_DebugScope,
			"DebugNoScope": OpenCLDebugInfo100_DebugNoScope,
			"DebugInlinedAt": OpenCLDebugInfo100_DebugInlinedAt,
			"DebugLocalVariable": OpenCLDebugInfo100_DebugLocalVariable,
			"DebugInlinedVariable": OpenCLDebugInfo100_DebugInlinedVariable,
			"DebugDeclare": OpenCLDebugInfo100_DebugDeclare,
			"DebugValue": OpenCLDebugInfo100_DebugValue,
			"DebugOperation": OpenCLDebugInfo100_DebugOperation,
			"DebugExpression": OpenCLDebugInfo100_DebugExpression,
			"DebugMacroDef": OpenCLDebugInfo100_DebugMacroDef,
			"DebugMacroUndef": OpenCLDebugInfo100_DebugMacroUndef,
			"DebugImportedEntity": OpenCLDebugInfo100_DebugImportedEntity,
			"DebugSource": OpenCLDebugInfo100_DebugSource,
		},
	}

	OpNop = &Opcode {
		Opname:   "OpNop",
		Class:    "Miscellaneous",
		Opcode:   0,
		Operands: []Operand {
		},
	}
	OpUndef = &Opcode {
		Opname:   "OpUndef",
		Class:    "Miscellaneous",
		Opcode:   1,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSourceContinued = &Opcode {
		Opname:   "OpSourceContinued",
		Class:    "Debug",
		Opcode:   2,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Continued Source'",
				Quantifier: "",
			}, 
		},
	}
	OpSource = &Opcode {
		Opname:   "OpSource",
		Class:    "Debug",
		Opcode:   3,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindSourceLanguage,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Version'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'File'",
				Quantifier: "?",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Source'",
				Quantifier: "?",
			}, 
		},
	}
	OpSourceExtension = &Opcode {
		Opname:   "OpSourceExtension",
		Class:    "Debug",
		Opcode:   4,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Extension'",
				Quantifier: "",
			}, 
		},
	}
	OpName = &Opcode {
		Opname:   "OpName",
		Class:    "Debug",
		Opcode:   5,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
		},
	}
	OpMemberName = &Opcode {
		Opname:   "OpMemberName",
		Class:    "Debug",
		Opcode:   6,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Member'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
		},
	}
	OpString = &Opcode {
		Opname:   "OpString",
		Class:    "Debug",
		Opcode:   7,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'String'",
				Quantifier: "",
			}, 
		},
	}
	OpLine = &Opcode {
		Opname:   "OpLine",
		Class:    "Debug",
		Opcode:   8,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'File'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
		},
	}
	OpExtension = &Opcode {
		Opname:   "OpExtension",
		Class:    "Extension",
		Opcode:   10,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
		},
	}
	OpExtInstImport = &Opcode {
		Opname:   "OpExtInstImport",
		Class:    "Extension",
		Opcode:   11,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
		},
	}
	OpExtInst = &Opcode {
		Opname:   "OpExtInst",
		Class:    "Extension",
		Opcode:   12,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Set'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralExtInstInteger,
				Name:       "'Instruction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1', + 'Operand 2', + ...",
				Quantifier: "*",
			}, 
		},
	}
	OpMemoryModel = &Opcode {
		Opname:   "OpMemoryModel",
		Class:    "Mode-Setting",
		Opcode:   14,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindAddressingModel,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryModel,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpEntryPoint = &Opcode {
		Opname:   "OpEntryPoint",
		Class:    "Mode-Setting",
		Opcode:   15,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindExecutionModel,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Entry Point'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Interface'",
				Quantifier: "*",
			}, 
		},
	}
	OpExecutionMode = &Opcode {
		Opname:   "OpExecutionMode",
		Class:    "Mode-Setting",
		Opcode:   16,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Entry Point'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindExecutionMode,
				Name:       "'Mode'",
				Quantifier: "",
			}, 
		},
	}
	OpCapability = &Opcode {
		Opname:   "OpCapability",
		Class:    "Mode-Setting",
		Opcode:   17,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindCapability,
				Name:       "'Capability'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeVoid = &Opcode {
		Opname:   "OpTypeVoid",
		Class:    "Type-Declaration",
		Opcode:   19,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeBool = &Opcode {
		Opname:   "OpTypeBool",
		Class:    "Type-Declaration",
		Opcode:   20,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeInt = &Opcode {
		Opname:   "OpTypeInt",
		Class:    "Type-Declaration",
		Opcode:   21,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Width'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Signedness'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeFloat = &Opcode {
		Opname:   "OpTypeFloat",
		Class:    "Type-Declaration",
		Opcode:   22,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Width'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeVector = &Opcode {
		Opname:   "OpTypeVector",
		Class:    "Type-Declaration",
		Opcode:   23,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Component Count'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeMatrix = &Opcode {
		Opname:   "OpTypeMatrix",
		Class:    "Type-Declaration",
		Opcode:   24,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Column Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column Count'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeImage = &Opcode {
		Opname:   "OpTypeImage",
		Class:    "Type-Declaration",
		Opcode:   25,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDim,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Depth'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Arrayed'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'MS'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Sampled'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageFormat,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindAccessQualifier,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpTypeSampler = &Opcode {
		Opname:   "OpTypeSampler",
		Class:    "Type-Declaration",
		Opcode:   26,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeSampledImage = &Opcode {
		Opname:   "OpTypeSampledImage",
		Class:    "Type-Declaration",
		Opcode:   27,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Type'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeArray = &Opcode {
		Opname:   "OpTypeArray",
		Class:    "Type-Declaration",
		Opcode:   28,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Element Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Length'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeRuntimeArray = &Opcode {
		Opname:   "OpTypeRuntimeArray",
		Class:    "Type-Declaration",
		Opcode:   29,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Element Type'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeStruct = &Opcode {
		Opname:   "OpTypeStruct",
		Class:    "Type-Declaration",
		Opcode:   30,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Member 0 type', + 'member 1 type', + ...",
				Quantifier: "*",
			}, 
		},
	}
	OpTypeOpaque = &Opcode {
		Opname:   "OpTypeOpaque",
		Class:    "Type-Declaration",
		Opcode:   31,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "The name of the opaque type.",
				Quantifier: "",
			}, 
		},
	}
	OpTypePointer = &Opcode {
		Opname:   "OpTypePointer",
		Class:    "Type-Declaration",
		Opcode:   32,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeFunction = &Opcode {
		Opname:   "OpTypeFunction",
		Class:    "Type-Declaration",
		Opcode:   33,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Return Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parameter 0 Type', + 'Parameter 1 Type', + ...",
				Quantifier: "*",
			}, 
		},
	}
	OpTypeEvent = &Opcode {
		Opname:   "OpTypeEvent",
		Class:    "Type-Declaration",
		Opcode:   34,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeDeviceEvent = &Opcode {
		Opname:   "OpTypeDeviceEvent",
		Class:    "Type-Declaration",
		Opcode:   35,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeReserveId = &Opcode {
		Opname:   "OpTypeReserveId",
		Class:    "Type-Declaration",
		Opcode:   36,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeQueue = &Opcode {
		Opname:   "OpTypeQueue",
		Class:    "Type-Declaration",
		Opcode:   37,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypePipe = &Opcode {
		Opname:   "OpTypePipe",
		Class:    "Type-Declaration",
		Opcode:   38,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindAccessQualifier,
				Name:       "'Qualifier'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeForwardPointer = &Opcode {
		Opname:   "OpTypeForwardPointer",
		Class:    "Type-Declaration",
		Opcode:   39,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstantTrue = &Opcode {
		Opname:   "OpConstantTrue",
		Class:    "Constant-Creation",
		Opcode:   41,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstantFalse = &Opcode {
		Opname:   "OpConstantFalse",
		Class:    "Constant-Creation",
		Opcode:   42,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstant = &Opcode {
		Opname:   "OpConstant",
		Class:    "Constant-Creation",
		Opcode:   43,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralContextDependentNumber,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConstantComposite = &Opcode {
		Opname:   "OpConstantComposite",
		Class:    "Constant-Creation",
		Opcode:   44,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Constituents'",
				Quantifier: "*",
			}, 
		},
	}
	OpConstantSampler = &Opcode {
		Opname:   "OpConstantSampler",
		Class:    "Constant-Creation",
		Opcode:   45,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindSamplerAddressingMode,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindSamplerFilterMode,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstantNull = &Opcode {
		Opname:   "OpConstantNull",
		Class:    "Constant-Creation",
		Opcode:   46,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSpecConstantTrue = &Opcode {
		Opname:   "OpSpecConstantTrue",
		Class:    "Constant-Creation",
		Opcode:   48,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSpecConstantFalse = &Opcode {
		Opname:   "OpSpecConstantFalse",
		Class:    "Constant-Creation",
		Opcode:   49,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSpecConstant = &Opcode {
		Opname:   "OpSpecConstant",
		Class:    "Constant-Creation",
		Opcode:   50,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralContextDependentNumber,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSpecConstantComposite = &Opcode {
		Opname:   "OpSpecConstantComposite",
		Class:    "Constant-Creation",
		Opcode:   51,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Constituents'",
				Quantifier: "*",
			}, 
		},
	}
	OpSpecConstantOp = &Opcode {
		Opname:   "OpSpecConstantOp",
		Class:    "Constant-Creation",
		Opcode:   52,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralSpecConstantOpInteger,
				Name:       "'Opcode'",
				Quantifier: "",
			}, 
		},
	}
	OpFunction = &Opcode {
		Opname:   "OpFunction",
		Class:    "Function",
		Opcode:   54,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindFunctionControl,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Function Type'",
				Quantifier: "",
			}, 
		},
	}
	OpFunctionParameter = &Opcode {
		Opname:   "OpFunctionParameter",
		Class:    "Function",
		Opcode:   55,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpFunctionEnd = &Opcode {
		Opname:   "OpFunctionEnd",
		Class:    "Function",
		Opcode:   56,
		Operands: []Operand {
		},
	}
	OpFunctionCall = &Opcode {
		Opname:   "OpFunctionCall",
		Class:    "Function",
		Opcode:   57,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Function'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Argument 0', + 'Argument 1', + ...",
				Quantifier: "*",
			}, 
		},
	}
	OpVariable = &Opcode {
		Opname:   "OpVariable",
		Class:    "Memory",
		Opcode:   59,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Initializer'",
				Quantifier: "?",
			}, 
		},
	}
	OpImageTexelPointer = &Opcode {
		Opname:   "OpImageTexelPointer",
		Class:    "Memory",
		Opcode:   60,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sample'",
				Quantifier: "",
			}, 
		},
	}
	OpLoad = &Opcode {
		Opname:   "OpLoad",
		Class:    "Memory",
		Opcode:   61,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpStore = &Opcode {
		Opname:   "OpStore",
		Class:    "Memory",
		Opcode:   62,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpCopyMemory = &Opcode {
		Opname:   "OpCopyMemory",
		Class:    "Memory",
		Opcode:   63,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpCopyMemorySized = &Opcode {
		Opname:   "OpCopyMemorySized",
		Class:    "Memory",
		Opcode:   64,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpAccessChain = &Opcode {
		Opname:   "OpAccessChain",
		Class:    "Memory",
		Opcode:   65,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpInBoundsAccessChain = &Opcode {
		Opname:   "OpInBoundsAccessChain",
		Class:    "Memory",
		Opcode:   66,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpPtrAccessChain = &Opcode {
		Opname:   "OpPtrAccessChain",
		Class:    "Memory",
		Opcode:   67,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Element'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpArrayLength = &Opcode {
		Opname:   "OpArrayLength",
		Class:    "Memory",
		Opcode:   68,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Structure'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Array member'",
				Quantifier: "",
			}, 
		},
	}
	OpGenericPtrMemSemantics = &Opcode {
		Opname:   "OpGenericPtrMemSemantics",
		Class:    "Memory",
		Opcode:   69,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpInBoundsPtrAccessChain = &Opcode {
		Opname:   "OpInBoundsPtrAccessChain",
		Class:    "Memory",
		Opcode:   70,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Element'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpDecorate = &Opcode {
		Opname:   "OpDecorate",
		Class:    "Annotation",
		Opcode:   71,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpMemberDecorate = &Opcode {
		Opname:   "OpMemberDecorate",
		Class:    "Annotation",
		Opcode:   72,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Structure Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Member'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpDecorationGroup = &Opcode {
		Opname:   "OpDecorationGroup",
		Class:    "Annotation",
		Opcode:   73,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpGroupDecorate = &Opcode {
		Opname:   "OpGroupDecorate",
		Class:    "Annotation",
		Opcode:   74,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Decoration Group'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Targets'",
				Quantifier: "*",
			}, 
		},
	}
	OpGroupMemberDecorate = &Opcode {
		Opname:   "OpGroupMemberDecorate",
		Class:    "Annotation",
		Opcode:   75,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Decoration Group'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindPairIdRefLiteralInteger,
				Name:       "'Targets'",
				Quantifier: "*",
			}, 
		},
	}
	OpVectorExtractDynamic = &Opcode {
		Opname:   "OpVectorExtractDynamic",
		Class:    "Composite",
		Opcode:   77,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpVectorInsertDynamic = &Opcode {
		Opname:   "OpVectorInsertDynamic",
		Class:    "Composite",
		Opcode:   78,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpVectorShuffle = &Opcode {
		Opname:   "OpVectorShuffle",
		Class:    "Composite",
		Opcode:   79,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 2'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Components'",
				Quantifier: "*",
			}, 
		},
	}
	OpCompositeConstruct = &Opcode {
		Opname:   "OpCompositeConstruct",
		Class:    "Composite",
		Opcode:   80,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Constituents'",
				Quantifier: "*",
			}, 
		},
	}
	OpCompositeExtract = &Opcode {
		Opname:   "OpCompositeExtract",
		Class:    "Composite",
		Opcode:   81,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Composite'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpCompositeInsert = &Opcode {
		Opname:   "OpCompositeInsert",
		Class:    "Composite",
		Opcode:   82,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Composite'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpCopyObject = &Opcode {
		Opname:   "OpCopyObject",
		Class:    "Composite",
		Opcode:   83,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpTranspose = &Opcode {
		Opname:   "OpTranspose",
		Class:    "Composite",
		Opcode:   84,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Matrix'",
				Quantifier: "",
			}, 
		},
	}
	OpSampledImage = &Opcode {
		Opname:   "OpSampledImage",
		Class:    "Image",
		Opcode:   86,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampler'",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleImplicitLod = &Opcode {
		Opname:   "OpImageSampleImplicitLod",
		Class:    "Image",
		Opcode:   87,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSampleExplicitLod = &Opcode {
		Opname:   "OpImageSampleExplicitLod",
		Class:    "Image",
		Opcode:   88,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleDrefImplicitLod = &Opcode {
		Opname:   "OpImageSampleDrefImplicitLod",
		Class:    "Image",
		Opcode:   89,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSampleDrefExplicitLod = &Opcode {
		Opname:   "OpImageSampleDrefExplicitLod",
		Class:    "Image",
		Opcode:   90,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleProjImplicitLod = &Opcode {
		Opname:   "OpImageSampleProjImplicitLod",
		Class:    "Image",
		Opcode:   91,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSampleProjExplicitLod = &Opcode {
		Opname:   "OpImageSampleProjExplicitLod",
		Class:    "Image",
		Opcode:   92,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleProjDrefImplicitLod = &Opcode {
		Opname:   "OpImageSampleProjDrefImplicitLod",
		Class:    "Image",
		Opcode:   93,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSampleProjDrefExplicitLod = &Opcode {
		Opname:   "OpImageSampleProjDrefExplicitLod",
		Class:    "Image",
		Opcode:   94,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageFetch = &Opcode {
		Opname:   "OpImageFetch",
		Class:    "Image",
		Opcode:   95,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageGather = &Opcode {
		Opname:   "OpImageGather",
		Class:    "Image",
		Opcode:   96,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageDrefGather = &Opcode {
		Opname:   "OpImageDrefGather",
		Class:    "Image",
		Opcode:   97,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageRead = &Opcode {
		Opname:   "OpImageRead",
		Class:    "Image",
		Opcode:   98,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageWrite = &Opcode {
		Opname:   "OpImageWrite",
		Class:    "Image",
		Opcode:   99,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Texel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImage = &Opcode {
		Opname:   "OpImage",
		Class:    "Image",
		Opcode:   100,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQueryFormat = &Opcode {
		Opname:   "OpImageQueryFormat",
		Class:    "Image",
		Opcode:   101,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQueryOrder = &Opcode {
		Opname:   "OpImageQueryOrder",
		Class:    "Image",
		Opcode:   102,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQuerySizeLod = &Opcode {
		Opname:   "OpImageQuerySizeLod",
		Class:    "Image",
		Opcode:   103,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Level of Detail'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQuerySize = &Opcode {
		Opname:   "OpImageQuerySize",
		Class:    "Image",
		Opcode:   104,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQueryLod = &Opcode {
		Opname:   "OpImageQueryLod",
		Class:    "Image",
		Opcode:   105,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQueryLevels = &Opcode {
		Opname:   "OpImageQueryLevels",
		Class:    "Image",
		Opcode:   106,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpImageQuerySamples = &Opcode {
		Opname:   "OpImageQuerySamples",
		Class:    "Image",
		Opcode:   107,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertFToU = &Opcode {
		Opname:   "OpConvertFToU",
		Class:    "Conversion",
		Opcode:   109,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Float Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertFToS = &Opcode {
		Opname:   "OpConvertFToS",
		Class:    "Conversion",
		Opcode:   110,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Float Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertSToF = &Opcode {
		Opname:   "OpConvertSToF",
		Class:    "Conversion",
		Opcode:   111,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Signed Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertUToF = &Opcode {
		Opname:   "OpConvertUToF",
		Class:    "Conversion",
		Opcode:   112,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Unsigned Value'",
				Quantifier: "",
			}, 
		},
	}
	OpUConvert = &Opcode {
		Opname:   "OpUConvert",
		Class:    "Conversion",
		Opcode:   113,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Unsigned Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSConvert = &Opcode {
		Opname:   "OpSConvert",
		Class:    "Conversion",
		Opcode:   114,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Signed Value'",
				Quantifier: "",
			}, 
		},
	}
	OpFConvert = &Opcode {
		Opname:   "OpFConvert",
		Class:    "Conversion",
		Opcode:   115,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Float Value'",
				Quantifier: "",
			}, 
		},
	}
	OpQuantizeToF16 = &Opcode {
		Opname:   "OpQuantizeToF16",
		Class:    "Conversion",
		Opcode:   116,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertPtrToU = &Opcode {
		Opname:   "OpConvertPtrToU",
		Class:    "Conversion",
		Opcode:   117,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpSatConvertSToU = &Opcode {
		Opname:   "OpSatConvertSToU",
		Class:    "Conversion",
		Opcode:   118,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Signed Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSatConvertUToS = &Opcode {
		Opname:   "OpSatConvertUToS",
		Class:    "Conversion",
		Opcode:   119,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Unsigned Value'",
				Quantifier: "",
			}, 
		},
	}
	OpConvertUToPtr = &Opcode {
		Opname:   "OpConvertUToPtr",
		Class:    "Conversion",
		Opcode:   120,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Integer Value'",
				Quantifier: "",
			}, 
		},
	}
	OpPtrCastToGeneric = &Opcode {
		Opname:   "OpPtrCastToGeneric",
		Class:    "Conversion",
		Opcode:   121,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpGenericCastToPtr = &Opcode {
		Opname:   "OpGenericCastToPtr",
		Class:    "Conversion",
		Opcode:   122,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpGenericCastToPtrExplicit = &Opcode {
		Opname:   "OpGenericCastToPtrExplicit",
		Class:    "Conversion",
		Opcode:   123,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "'Storage'",
				Quantifier: "",
			}, 
		},
	}
	OpBitcast = &Opcode {
		Opname:   "OpBitcast",
		Class:    "Conversion",
		Opcode:   124,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpSNegate = &Opcode {
		Opname:   "OpSNegate",
		Class:    "Arithmetic",
		Opcode:   126,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpFNegate = &Opcode {
		Opname:   "OpFNegate",
		Class:    "Arithmetic",
		Opcode:   127,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpIAdd = &Opcode {
		Opname:   "OpIAdd",
		Class:    "Arithmetic",
		Opcode:   128,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFAdd = &Opcode {
		Opname:   "OpFAdd",
		Class:    "Arithmetic",
		Opcode:   129,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpISub = &Opcode {
		Opname:   "OpISub",
		Class:    "Arithmetic",
		Opcode:   130,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFSub = &Opcode {
		Opname:   "OpFSub",
		Class:    "Arithmetic",
		Opcode:   131,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIMul = &Opcode {
		Opname:   "OpIMul",
		Class:    "Arithmetic",
		Opcode:   132,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFMul = &Opcode {
		Opname:   "OpFMul",
		Class:    "Arithmetic",
		Opcode:   133,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUDiv = &Opcode {
		Opname:   "OpUDiv",
		Class:    "Arithmetic",
		Opcode:   134,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSDiv = &Opcode {
		Opname:   "OpSDiv",
		Class:    "Arithmetic",
		Opcode:   135,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFDiv = &Opcode {
		Opname:   "OpFDiv",
		Class:    "Arithmetic",
		Opcode:   136,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUMod = &Opcode {
		Opname:   "OpUMod",
		Class:    "Arithmetic",
		Opcode:   137,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSRem = &Opcode {
		Opname:   "OpSRem",
		Class:    "Arithmetic",
		Opcode:   138,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSMod = &Opcode {
		Opname:   "OpSMod",
		Class:    "Arithmetic",
		Opcode:   139,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFRem = &Opcode {
		Opname:   "OpFRem",
		Class:    "Arithmetic",
		Opcode:   140,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFMod = &Opcode {
		Opname:   "OpFMod",
		Class:    "Arithmetic",
		Opcode:   141,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpVectorTimesScalar = &Opcode {
		Opname:   "OpVectorTimesScalar",
		Class:    "Arithmetic",
		Opcode:   142,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Scalar'",
				Quantifier: "",
			}, 
		},
	}
	OpMatrixTimesScalar = &Opcode {
		Opname:   "OpMatrixTimesScalar",
		Class:    "Arithmetic",
		Opcode:   143,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Matrix'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Scalar'",
				Quantifier: "",
			}, 
		},
	}
	OpVectorTimesMatrix = &Opcode {
		Opname:   "OpVectorTimesMatrix",
		Class:    "Arithmetic",
		Opcode:   144,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Matrix'",
				Quantifier: "",
			}, 
		},
	}
	OpMatrixTimesVector = &Opcode {
		Opname:   "OpMatrixTimesVector",
		Class:    "Arithmetic",
		Opcode:   145,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Matrix'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
		},
	}
	OpMatrixTimesMatrix = &Opcode {
		Opname:   "OpMatrixTimesMatrix",
		Class:    "Arithmetic",
		Opcode:   146,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'LeftMatrix'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RightMatrix'",
				Quantifier: "",
			}, 
		},
	}
	OpOuterProduct = &Opcode {
		Opname:   "OpOuterProduct",
		Class:    "Arithmetic",
		Opcode:   147,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 2'",
				Quantifier: "",
			}, 
		},
	}
	OpDot = &Opcode {
		Opname:   "OpDot",
		Class:    "Arithmetic",
		Opcode:   148,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIAddCarry = &Opcode {
		Opname:   "OpIAddCarry",
		Class:    "Arithmetic",
		Opcode:   149,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpISubBorrow = &Opcode {
		Opname:   "OpISubBorrow",
		Class:    "Arithmetic",
		Opcode:   150,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUMulExtended = &Opcode {
		Opname:   "OpUMulExtended",
		Class:    "Arithmetic",
		Opcode:   151,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSMulExtended = &Opcode {
		Opname:   "OpSMulExtended",
		Class:    "Arithmetic",
		Opcode:   152,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpAny = &Opcode {
		Opname:   "OpAny",
		Class:    "Relational_and_Logical",
		Opcode:   154,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
		},
	}
	OpAll = &Opcode {
		Opname:   "OpAll",
		Class:    "Relational_and_Logical",
		Opcode:   155,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Vector'",
				Quantifier: "",
			}, 
		},
	}
	OpIsNan = &Opcode {
		Opname:   "OpIsNan",
		Class:    "Relational_and_Logical",
		Opcode:   156,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpIsInf = &Opcode {
		Opname:   "OpIsInf",
		Class:    "Relational_and_Logical",
		Opcode:   157,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpIsFinite = &Opcode {
		Opname:   "OpIsFinite",
		Class:    "Relational_and_Logical",
		Opcode:   158,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpIsNormal = &Opcode {
		Opname:   "OpIsNormal",
		Class:    "Relational_and_Logical",
		Opcode:   159,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpSignBitSet = &Opcode {
		Opname:   "OpSignBitSet",
		Class:    "Relational_and_Logical",
		Opcode:   160,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpLessOrGreater = &Opcode {
		Opname:   "OpLessOrGreater",
		Class:    "Relational_and_Logical",
		Opcode:   161,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpOrdered = &Opcode {
		Opname:   "OpOrdered",
		Class:    "Relational_and_Logical",
		Opcode:   162,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpUnordered = &Opcode {
		Opname:   "OpUnordered",
		Class:    "Relational_and_Logical",
		Opcode:   163,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalEqual = &Opcode {
		Opname:   "OpLogicalEqual",
		Class:    "Relational_and_Logical",
		Opcode:   164,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalNotEqual = &Opcode {
		Opname:   "OpLogicalNotEqual",
		Class:    "Relational_and_Logical",
		Opcode:   165,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalOr = &Opcode {
		Opname:   "OpLogicalOr",
		Class:    "Relational_and_Logical",
		Opcode:   166,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalAnd = &Opcode {
		Opname:   "OpLogicalAnd",
		Class:    "Relational_and_Logical",
		Opcode:   167,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpLogicalNot = &Opcode {
		Opname:   "OpLogicalNot",
		Class:    "Relational_and_Logical",
		Opcode:   168,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpSelect = &Opcode {
		Opname:   "OpSelect",
		Class:    "Relational_and_Logical",
		Opcode:   169,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Condition'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIEqual = &Opcode {
		Opname:   "OpIEqual",
		Class:    "Relational_and_Logical",
		Opcode:   170,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpINotEqual = &Opcode {
		Opname:   "OpINotEqual",
		Class:    "Relational_and_Logical",
		Opcode:   171,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUGreaterThan = &Opcode {
		Opname:   "OpUGreaterThan",
		Class:    "Relational_and_Logical",
		Opcode:   172,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSGreaterThan = &Opcode {
		Opname:   "OpSGreaterThan",
		Class:    "Relational_and_Logical",
		Opcode:   173,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUGreaterThanEqual = &Opcode {
		Opname:   "OpUGreaterThanEqual",
		Class:    "Relational_and_Logical",
		Opcode:   174,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSGreaterThanEqual = &Opcode {
		Opname:   "OpSGreaterThanEqual",
		Class:    "Relational_and_Logical",
		Opcode:   175,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpULessThan = &Opcode {
		Opname:   "OpULessThan",
		Class:    "Relational_and_Logical",
		Opcode:   176,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSLessThan = &Opcode {
		Opname:   "OpSLessThan",
		Class:    "Relational_and_Logical",
		Opcode:   177,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpULessThanEqual = &Opcode {
		Opname:   "OpULessThanEqual",
		Class:    "Relational_and_Logical",
		Opcode:   178,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSLessThanEqual = &Opcode {
		Opname:   "OpSLessThanEqual",
		Class:    "Relational_and_Logical",
		Opcode:   179,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdEqual = &Opcode {
		Opname:   "OpFOrdEqual",
		Class:    "Relational_and_Logical",
		Opcode:   180,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordEqual = &Opcode {
		Opname:   "OpFUnordEqual",
		Class:    "Relational_and_Logical",
		Opcode:   181,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdNotEqual = &Opcode {
		Opname:   "OpFOrdNotEqual",
		Class:    "Relational_and_Logical",
		Opcode:   182,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordNotEqual = &Opcode {
		Opname:   "OpFUnordNotEqual",
		Class:    "Relational_and_Logical",
		Opcode:   183,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdLessThan = &Opcode {
		Opname:   "OpFOrdLessThan",
		Class:    "Relational_and_Logical",
		Opcode:   184,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordLessThan = &Opcode {
		Opname:   "OpFUnordLessThan",
		Class:    "Relational_and_Logical",
		Opcode:   185,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdGreaterThan = &Opcode {
		Opname:   "OpFOrdGreaterThan",
		Class:    "Relational_and_Logical",
		Opcode:   186,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordGreaterThan = &Opcode {
		Opname:   "OpFUnordGreaterThan",
		Class:    "Relational_and_Logical",
		Opcode:   187,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdLessThanEqual = &Opcode {
		Opname:   "OpFOrdLessThanEqual",
		Class:    "Relational_and_Logical",
		Opcode:   188,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordLessThanEqual = &Opcode {
		Opname:   "OpFUnordLessThanEqual",
		Class:    "Relational_and_Logical",
		Opcode:   189,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFOrdGreaterThanEqual = &Opcode {
		Opname:   "OpFOrdGreaterThanEqual",
		Class:    "Relational_and_Logical",
		Opcode:   190,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpFUnordGreaterThanEqual = &Opcode {
		Opname:   "OpFUnordGreaterThanEqual",
		Class:    "Relational_and_Logical",
		Opcode:   191,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpShiftRightLogical = &Opcode {
		Opname:   "OpShiftRightLogical",
		Class:    "Bit",
		Opcode:   194,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Shift'",
				Quantifier: "",
			}, 
		},
	}
	OpShiftRightArithmetic = &Opcode {
		Opname:   "OpShiftRightArithmetic",
		Class:    "Bit",
		Opcode:   195,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Shift'",
				Quantifier: "",
			}, 
		},
	}
	OpShiftLeftLogical = &Opcode {
		Opname:   "OpShiftLeftLogical",
		Class:    "Bit",
		Opcode:   196,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Shift'",
				Quantifier: "",
			}, 
		},
	}
	OpBitwiseOr = &Opcode {
		Opname:   "OpBitwiseOr",
		Class:    "Bit",
		Opcode:   197,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpBitwiseXor = &Opcode {
		Opname:   "OpBitwiseXor",
		Class:    "Bit",
		Opcode:   198,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpBitwiseAnd = &Opcode {
		Opname:   "OpBitwiseAnd",
		Class:    "Bit",
		Opcode:   199,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpNot = &Opcode {
		Opname:   "OpNot",
		Class:    "Bit",
		Opcode:   200,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpBitFieldInsert = &Opcode {
		Opname:   "OpBitFieldInsert",
		Class:    "Bit",
		Opcode:   201,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Insert'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Count'",
				Quantifier: "",
			}, 
		},
	}
	OpBitFieldSExtract = &Opcode {
		Opname:   "OpBitFieldSExtract",
		Class:    "Bit",
		Opcode:   202,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Count'",
				Quantifier: "",
			}, 
		},
	}
	OpBitFieldUExtract = &Opcode {
		Opname:   "OpBitFieldUExtract",
		Class:    "Bit",
		Opcode:   203,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Count'",
				Quantifier: "",
			}, 
		},
	}
	OpBitReverse = &Opcode {
		Opname:   "OpBitReverse",
		Class:    "Bit",
		Opcode:   204,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
		},
	}
	OpBitCount = &Opcode {
		Opname:   "OpBitCount",
		Class:    "Bit",
		Opcode:   205,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdx = &Opcode {
		Opname:   "OpDPdx",
		Class:    "Derivative",
		Opcode:   207,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdy = &Opcode {
		Opname:   "OpDPdy",
		Class:    "Derivative",
		Opcode:   208,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpFwidth = &Opcode {
		Opname:   "OpFwidth",
		Class:    "Derivative",
		Opcode:   209,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdxFine = &Opcode {
		Opname:   "OpDPdxFine",
		Class:    "Derivative",
		Opcode:   210,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdyFine = &Opcode {
		Opname:   "OpDPdyFine",
		Class:    "Derivative",
		Opcode:   211,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpFwidthFine = &Opcode {
		Opname:   "OpFwidthFine",
		Class:    "Derivative",
		Opcode:   212,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdxCoarse = &Opcode {
		Opname:   "OpDPdxCoarse",
		Class:    "Derivative",
		Opcode:   213,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpDPdyCoarse = &Opcode {
		Opname:   "OpDPdyCoarse",
		Class:    "Derivative",
		Opcode:   214,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpFwidthCoarse = &Opcode {
		Opname:   "OpFwidthCoarse",
		Class:    "Derivative",
		Opcode:   215,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'P'",
				Quantifier: "",
			}, 
		},
	}
	OpEmitVertex = &Opcode {
		Opname:   "OpEmitVertex",
		Class:    "Primitive",
		Opcode:   218,
		Operands: []Operand {
		},
	}
	OpEndPrimitive = &Opcode {
		Opname:   "OpEndPrimitive",
		Class:    "Primitive",
		Opcode:   219,
		Operands: []Operand {
		},
	}
	OpEmitStreamVertex = &Opcode {
		Opname:   "OpEmitStreamVertex",
		Class:    "Primitive",
		Opcode:   220,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stream'",
				Quantifier: "",
			}, 
		},
	}
	OpEndStreamPrimitive = &Opcode {
		Opname:   "OpEndStreamPrimitive",
		Class:    "Primitive",
		Opcode:   221,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stream'",
				Quantifier: "",
			}, 
		},
	}
	OpControlBarrier = &Opcode {
		Opname:   "OpControlBarrier",
		Class:    "Barrier",
		Opcode:   224,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpMemoryBarrier = &Opcode {
		Opname:   "OpMemoryBarrier",
		Class:    "Barrier",
		Opcode:   225,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicLoad = &Opcode {
		Opname:   "OpAtomicLoad",
		Class:    "Atomic",
		Opcode:   227,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicStore = &Opcode {
		Opname:   "OpAtomicStore",
		Class:    "Atomic",
		Opcode:   228,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicExchange = &Opcode {
		Opname:   "OpAtomicExchange",
		Class:    "Atomic",
		Opcode:   229,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicCompareExchange = &Opcode {
		Opname:   "OpAtomicCompareExchange",
		Class:    "Atomic",
		Opcode:   230,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Equal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Unequal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Comparator'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicCompareExchangeWeak = &Opcode {
		Opname:   "OpAtomicCompareExchangeWeak",
		Class:    "Atomic",
		Opcode:   231,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Equal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Unequal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Comparator'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicIIncrement = &Opcode {
		Opname:   "OpAtomicIIncrement",
		Class:    "Atomic",
		Opcode:   232,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicIDecrement = &Opcode {
		Opname:   "OpAtomicIDecrement",
		Class:    "Atomic",
		Opcode:   233,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicIAdd = &Opcode {
		Opname:   "OpAtomicIAdd",
		Class:    "Atomic",
		Opcode:   234,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicISub = &Opcode {
		Opname:   "OpAtomicISub",
		Class:    "Atomic",
		Opcode:   235,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicSMin = &Opcode {
		Opname:   "OpAtomicSMin",
		Class:    "Atomic",
		Opcode:   236,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicUMin = &Opcode {
		Opname:   "OpAtomicUMin",
		Class:    "Atomic",
		Opcode:   237,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicSMax = &Opcode {
		Opname:   "OpAtomicSMax",
		Class:    "Atomic",
		Opcode:   238,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicUMax = &Opcode {
		Opname:   "OpAtomicUMax",
		Class:    "Atomic",
		Opcode:   239,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicAnd = &Opcode {
		Opname:   "OpAtomicAnd",
		Class:    "Atomic",
		Opcode:   240,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicOr = &Opcode {
		Opname:   "OpAtomicOr",
		Class:    "Atomic",
		Opcode:   241,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicXor = &Opcode {
		Opname:   "OpAtomicXor",
		Class:    "Atomic",
		Opcode:   242,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpPhi = &Opcode {
		Opname:   "OpPhi",
		Class:    "Control-Flow",
		Opcode:   245,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindPairIdRefIdRef,
				Name:       "'Variable, Parent, ...'",
				Quantifier: "*",
			}, 
		},
	}
	OpLoopMerge = &Opcode {
		Opname:   "OpLoopMerge",
		Class:    "Control-Flow",
		Opcode:   246,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Merge Block'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Continue Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLoopControl,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSelectionMerge = &Opcode {
		Opname:   "OpSelectionMerge",
		Class:    "Control-Flow",
		Opcode:   247,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Merge Block'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindSelectionControl,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpLabel = &Opcode {
		Opname:   "OpLabel",
		Class:    "Control-Flow",
		Opcode:   248,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpBranch = &Opcode {
		Opname:   "OpBranch",
		Class:    "Control-Flow",
		Opcode:   249,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target Label'",
				Quantifier: "",
			}, 
		},
	}
	OpBranchConditional = &Opcode {
		Opname:   "OpBranchConditional",
		Class:    "Control-Flow",
		Opcode:   250,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Condition'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'True Label'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'False Label'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Branch weights'",
				Quantifier: "*",
			}, 
		},
	}
	OpSwitch = &Opcode {
		Opname:   "OpSwitch",
		Class:    "Control-Flow",
		Opcode:   251,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Selector'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Default'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindPairLiteralIntegerIdRef,
				Name:       "'Target'",
				Quantifier: "*",
			}, 
		},
	}
	OpKill = &Opcode {
		Opname:   "OpKill",
		Class:    "Control-Flow",
		Opcode:   252,
		Operands: []Operand {
		},
	}
	OpReturn = &Opcode {
		Opname:   "OpReturn",
		Class:    "Control-Flow",
		Opcode:   253,
		Operands: []Operand {
		},
	}
	OpReturnValue = &Opcode {
		Opname:   "OpReturnValue",
		Class:    "Control-Flow",
		Opcode:   254,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpUnreachable = &Opcode {
		Opname:   "OpUnreachable",
		Class:    "Control-Flow",
		Opcode:   255,
		Operands: []Operand {
		},
	}
	OpLifetimeStart = &Opcode {
		Opname:   "OpLifetimeStart",
		Class:    "Control-Flow",
		Opcode:   256,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Size'",
				Quantifier: "",
			}, 
		},
	}
	OpLifetimeStop = &Opcode {
		Opname:   "OpLifetimeStop",
		Class:    "Control-Flow",
		Opcode:   257,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Size'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupAsyncCopy = &Opcode {
		Opname:   "OpGroupAsyncCopy",
		Class:    "Group",
		Opcode:   259,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Destination'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Elements'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupWaitEvents = &Opcode {
		Opname:   "OpGroupWaitEvents",
		Class:    "Group",
		Opcode:   260,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Events List'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupAll = &Opcode {
		Opname:   "OpGroupAll",
		Class:    "Group",
		Opcode:   261,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupAny = &Opcode {
		Opname:   "OpGroupAny",
		Class:    "Group",
		Opcode:   262,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupBroadcast = &Opcode {
		Opname:   "OpGroupBroadcast",
		Class:    "Group",
		Opcode:   263,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'LocalId'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupIAdd = &Opcode {
		Opname:   "OpGroupIAdd",
		Class:    "Group",
		Opcode:   264,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFAdd = &Opcode {
		Opname:   "OpGroupFAdd",
		Class:    "Group",
		Opcode:   265,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFMin = &Opcode {
		Opname:   "OpGroupFMin",
		Class:    "Group",
		Opcode:   266,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupUMin = &Opcode {
		Opname:   "OpGroupUMin",
		Class:    "Group",
		Opcode:   267,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupSMin = &Opcode {
		Opname:   "OpGroupSMin",
		Class:    "Group",
		Opcode:   268,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFMax = &Opcode {
		Opname:   "OpGroupFMax",
		Class:    "Group",
		Opcode:   269,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupUMax = &Opcode {
		Opname:   "OpGroupUMax",
		Class:    "Group",
		Opcode:   270,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupSMax = &Opcode {
		Opname:   "OpGroupSMax",
		Class:    "Group",
		Opcode:   271,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpReadPipe = &Opcode {
		Opname:   "OpReadPipe",
		Class:    "Pipe",
		Opcode:   274,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpWritePipe = &Opcode {
		Opname:   "OpWritePipe",
		Class:    "Pipe",
		Opcode:   275,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpReservedReadPipe = &Opcode {
		Opname:   "OpReservedReadPipe",
		Class:    "Pipe",
		Opcode:   276,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpReservedWritePipe = &Opcode {
		Opname:   "OpReservedWritePipe",
		Class:    "Pipe",
		Opcode:   277,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpReserveReadPipePackets = &Opcode {
		Opname:   "OpReserveReadPipePackets",
		Class:    "Pipe",
		Opcode:   278,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Packets'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpReserveWritePipePackets = &Opcode {
		Opname:   "OpReserveWritePipePackets",
		Class:    "Pipe",
		Opcode:   279,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Packets'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpCommitReadPipe = &Opcode {
		Opname:   "OpCommitReadPipe",
		Class:    "Pipe",
		Opcode:   280,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpCommitWritePipe = &Opcode {
		Opname:   "OpCommitWritePipe",
		Class:    "Pipe",
		Opcode:   281,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpIsValidReserveId = &Opcode {
		Opname:   "OpIsValidReserveId",
		Class:    "Pipe",
		Opcode:   282,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
		},
	}
	OpGetNumPipePackets = &Opcode {
		Opname:   "OpGetNumPipePackets",
		Class:    "Pipe",
		Opcode:   283,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGetMaxPipePackets = &Opcode {
		Opname:   "OpGetMaxPipePackets",
		Class:    "Pipe",
		Opcode:   284,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupReserveReadPipePackets = &Opcode {
		Opname:   "OpGroupReserveReadPipePackets",
		Class:    "Pipe",
		Opcode:   285,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Packets'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupReserveWritePipePackets = &Opcode {
		Opname:   "OpGroupReserveWritePipePackets",
		Class:    "Pipe",
		Opcode:   286,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Packets'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupCommitReadPipe = &Opcode {
		Opname:   "OpGroupCommitReadPipe",
		Class:    "Pipe",
		Opcode:   287,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupCommitWritePipe = &Opcode {
		Opname:   "OpGroupCommitWritePipe",
		Class:    "Pipe",
		Opcode:   288,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reserve Id'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
		},
	}
	OpEnqueueMarker = &Opcode {
		Opname:   "OpEnqueueMarker",
		Class:    "Device-Side_Enqueue",
		Opcode:   291,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Queue'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Wait Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ret Event'",
				Quantifier: "",
			}, 
		},
	}
	OpEnqueueKernel = &Opcode {
		Opname:   "OpEnqueueKernel",
		Class:    "Device-Side_Enqueue",
		Opcode:   292,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Queue'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ND Range'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Num Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Wait Events'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ret Event'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Local Size'",
				Quantifier: "*",
			}, 
		},
	}
	OpGetKernelNDrangeSubGroupCount = &Opcode {
		Opname:   "OpGetKernelNDrangeSubGroupCount",
		Class:    "Device-Side_Enqueue",
		Opcode:   293,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ND Range'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelNDrangeMaxSubGroupSize = &Opcode {
		Opname:   "OpGetKernelNDrangeMaxSubGroupSize",
		Class:    "Device-Side_Enqueue",
		Opcode:   294,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ND Range'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelWorkGroupSize = &Opcode {
		Opname:   "OpGetKernelWorkGroupSize",
		Class:    "Device-Side_Enqueue",
		Opcode:   295,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelPreferredWorkGroupSizeMultiple = &Opcode {
		Opname:   "OpGetKernelPreferredWorkGroupSizeMultiple",
		Class:    "Device-Side_Enqueue",
		Opcode:   296,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpRetainEvent = &Opcode {
		Opname:   "OpRetainEvent",
		Class:    "Device-Side_Enqueue",
		Opcode:   297,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
		},
	}
	OpReleaseEvent = &Opcode {
		Opname:   "OpReleaseEvent",
		Class:    "Device-Side_Enqueue",
		Opcode:   298,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
		},
	}
	OpCreateUserEvent = &Opcode {
		Opname:   "OpCreateUserEvent",
		Class:    "Device-Side_Enqueue",
		Opcode:   299,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpIsValidEvent = &Opcode {
		Opname:   "OpIsValidEvent",
		Class:    "Device-Side_Enqueue",
		Opcode:   300,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
		},
	}
	OpSetUserEventStatus = &Opcode {
		Opname:   "OpSetUserEventStatus",
		Class:    "Device-Side_Enqueue",
		Opcode:   301,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Status'",
				Quantifier: "",
			}, 
		},
	}
	OpCaptureEventProfilingInfo = &Opcode {
		Opname:   "OpCaptureEventProfilingInfo",
		Class:    "Device-Side_Enqueue",
		Opcode:   302,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Event'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Profiling Info'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGetDefaultQueue = &Opcode {
		Opname:   "OpGetDefaultQueue",
		Class:    "Device-Side_Enqueue",
		Opcode:   303,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpBuildNDRange = &Opcode {
		Opname:   "OpBuildNDRange",
		Class:    "Device-Side_Enqueue",
		Opcode:   304,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'GlobalWorkSize'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'LocalWorkSize'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'GlobalWorkOffset'",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseSampleImplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleImplicitLod",
		Class:    "Image",
		Opcode:   305,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseSampleExplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleExplicitLod",
		Class:    "Image",
		Opcode:   306,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseSampleDrefImplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleDrefImplicitLod",
		Class:    "Image",
		Opcode:   307,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseSampleDrefExplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleDrefExplicitLod",
		Class:    "Image",
		Opcode:   308,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseSampleProjImplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleProjImplicitLod",
		Class:    "Image",
		Opcode:   309,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseSampleProjExplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleProjExplicitLod",
		Class:    "Image",
		Opcode:   310,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseSampleProjDrefImplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleProjDrefImplicitLod",
		Class:    "Image",
		Opcode:   311,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseSampleProjDrefExplicitLod = &Opcode {
		Opname:   "OpImageSparseSampleProjDrefExplicitLod",
		Class:    "Image",
		Opcode:   312,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseFetch = &Opcode {
		Opname:   "OpImageSparseFetch",
		Class:    "Image",
		Opcode:   313,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseGather = &Opcode {
		Opname:   "OpImageSparseGather",
		Class:    "Image",
		Opcode:   314,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseDrefGather = &Opcode {
		Opname:   "OpImageSparseDrefGather",
		Class:    "Image",
		Opcode:   315,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'D~ref~'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpImageSparseTexelsResident = &Opcode {
		Opname:   "OpImageSparseTexelsResident",
		Class:    "Image",
		Opcode:   316,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Resident Code'",
				Quantifier: "",
			}, 
		},
	}
	OpNoLine = &Opcode {
		Opname:   "OpNoLine",
		Class:    "Debug",
		Opcode:   317,
		Operands: []Operand {
		},
	}
	OpAtomicFlagTestAndSet = &Opcode {
		Opname:   "OpAtomicFlagTestAndSet",
		Class:    "Atomic",
		Opcode:   318,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpAtomicFlagClear = &Opcode {
		Opname:   "OpAtomicFlagClear",
		Class:    "Atomic",
		Opcode:   319,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpImageSparseRead = &Opcode {
		Opname:   "OpImageSparseRead",
		Class:    "Image",
		Opcode:   320,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpSizeOf = &Opcode {
		Opname:   "OpSizeOf",
		Class:    "Miscellaneous",
		Opcode:   321,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
		},
	}
	OpTypePipeStorage = &Opcode {
		Opname:   "OpTypePipeStorage",
		Class:    "Type-Declaration",
		Opcode:   322,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpConstantPipeStorage = &Opcode {
		Opname:   "OpConstantPipeStorage",
		Class:    "Pipe",
		Opcode:   323,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Packet Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Packet Alignment'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Capacity'",
				Quantifier: "",
			}, 
		},
	}
	OpCreatePipeFromPipeStorage = &Opcode {
		Opname:   "OpCreatePipeFromPipeStorage",
		Class:    "Pipe",
		Opcode:   324,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pipe Storage'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelLocalSizeForSubgroupCount = &Opcode {
		Opname:   "OpGetKernelLocalSizeForSubgroupCount",
		Class:    "Device-Side_Enqueue",
		Opcode:   325,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Subgroup Count'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpGetKernelMaxNumSubgroups = &Opcode {
		Opname:   "OpGetKernelMaxNumSubgroups",
		Class:    "Device-Side_Enqueue",
		Opcode:   326,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Invoke'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Param Align'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeNamedBarrier = &Opcode {
		Opname:   "OpTypeNamedBarrier",
		Class:    "Type-Declaration",
		Opcode:   327,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpNamedBarrierInitialize = &Opcode {
		Opname:   "OpNamedBarrierInitialize",
		Class:    "Barrier",
		Opcode:   328,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Subgroup Count'",
				Quantifier: "",
			}, 
		},
	}
	OpMemoryNamedBarrier = &Opcode {
		Opname:   "OpMemoryNamedBarrier",
		Class:    "Barrier",
		Opcode:   329,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Named Barrier'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Memory'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdMemorySemantics,
				Name:       "'Semantics'",
				Quantifier: "",
			}, 
		},
	}
	OpModuleProcessed = &Opcode {
		Opname:   "OpModuleProcessed",
		Class:    "Debug",
		Opcode:   330,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralString,
				Name:       "'Process'",
				Quantifier: "",
			}, 
		},
	}
	OpExecutionModeId = &Opcode {
		Opname:   "OpExecutionModeId",
		Class:    "Mode-Setting",
		Opcode:   331,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Entry Point'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindExecutionMode,
				Name:       "'Mode'",
				Quantifier: "",
			}, 
		},
	}
	OpDecorateId = &Opcode {
		Opname:   "OpDecorateId",
		Class:    "Annotation",
		Opcode:   332,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformElect = &Opcode {
		Opname:   "OpGroupNonUniformElect",
		Class:    "Non-Uniform",
		Opcode:   333,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformAll = &Opcode {
		Opname:   "OpGroupNonUniformAll",
		Class:    "Non-Uniform",
		Opcode:   334,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformAny = &Opcode {
		Opname:   "OpGroupNonUniformAny",
		Class:    "Non-Uniform",
		Opcode:   335,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformAllEqual = &Opcode {
		Opname:   "OpGroupNonUniformAllEqual",
		Class:    "Non-Uniform",
		Opcode:   336,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBroadcast = &Opcode {
		Opname:   "OpGroupNonUniformBroadcast",
		Class:    "Non-Uniform",
		Opcode:   337,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Id'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBroadcastFirst = &Opcode {
		Opname:   "OpGroupNonUniformBroadcastFirst",
		Class:    "Non-Uniform",
		Opcode:   338,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallot = &Opcode {
		Opname:   "OpGroupNonUniformBallot",
		Class:    "Non-Uniform",
		Opcode:   339,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformInverseBallot = &Opcode {
		Opname:   "OpGroupNonUniformInverseBallot",
		Class:    "Non-Uniform",
		Opcode:   340,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallotBitExtract = &Opcode {
		Opname:   "OpGroupNonUniformBallotBitExtract",
		Class:    "Non-Uniform",
		Opcode:   341,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallotBitCount = &Opcode {
		Opname:   "OpGroupNonUniformBallotBitCount",
		Class:    "Non-Uniform",
		Opcode:   342,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallotFindLSB = &Opcode {
		Opname:   "OpGroupNonUniformBallotFindLSB",
		Class:    "Non-Uniform",
		Opcode:   343,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformBallotFindMSB = &Opcode {
		Opname:   "OpGroupNonUniformBallotFindMSB",
		Class:    "Non-Uniform",
		Opcode:   344,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformShuffle = &Opcode {
		Opname:   "OpGroupNonUniformShuffle",
		Class:    "Non-Uniform",
		Opcode:   345,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Id'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformShuffleXor = &Opcode {
		Opname:   "OpGroupNonUniformShuffleXor",
		Class:    "Non-Uniform",
		Opcode:   346,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Mask'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformShuffleUp = &Opcode {
		Opname:   "OpGroupNonUniformShuffleUp",
		Class:    "Non-Uniform",
		Opcode:   347,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Delta'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformShuffleDown = &Opcode {
		Opname:   "OpGroupNonUniformShuffleDown",
		Class:    "Non-Uniform",
		Opcode:   348,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Delta'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformIAdd = &Opcode {
		Opname:   "OpGroupNonUniformIAdd",
		Class:    "Non-Uniform",
		Opcode:   349,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformFAdd = &Opcode {
		Opname:   "OpGroupNonUniformFAdd",
		Class:    "Non-Uniform",
		Opcode:   350,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformIMul = &Opcode {
		Opname:   "OpGroupNonUniformIMul",
		Class:    "Non-Uniform",
		Opcode:   351,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformFMul = &Opcode {
		Opname:   "OpGroupNonUniformFMul",
		Class:    "Non-Uniform",
		Opcode:   352,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformSMin = &Opcode {
		Opname:   "OpGroupNonUniformSMin",
		Class:    "Non-Uniform",
		Opcode:   353,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformUMin = &Opcode {
		Opname:   "OpGroupNonUniformUMin",
		Class:    "Non-Uniform",
		Opcode:   354,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformFMin = &Opcode {
		Opname:   "OpGroupNonUniformFMin",
		Class:    "Non-Uniform",
		Opcode:   355,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformSMax = &Opcode {
		Opname:   "OpGroupNonUniformSMax",
		Class:    "Non-Uniform",
		Opcode:   356,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformUMax = &Opcode {
		Opname:   "OpGroupNonUniformUMax",
		Class:    "Non-Uniform",
		Opcode:   357,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformFMax = &Opcode {
		Opname:   "OpGroupNonUniformFMax",
		Class:    "Non-Uniform",
		Opcode:   358,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformBitwiseAnd = &Opcode {
		Opname:   "OpGroupNonUniformBitwiseAnd",
		Class:    "Non-Uniform",
		Opcode:   359,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformBitwiseOr = &Opcode {
		Opname:   "OpGroupNonUniformBitwiseOr",
		Class:    "Non-Uniform",
		Opcode:   360,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformBitwiseXor = &Opcode {
		Opname:   "OpGroupNonUniformBitwiseXor",
		Class:    "Non-Uniform",
		Opcode:   361,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformLogicalAnd = &Opcode {
		Opname:   "OpGroupNonUniformLogicalAnd",
		Class:    "Non-Uniform",
		Opcode:   362,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformLogicalOr = &Opcode {
		Opname:   "OpGroupNonUniformLogicalOr",
		Class:    "Non-Uniform",
		Opcode:   363,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformLogicalXor = &Opcode {
		Opname:   "OpGroupNonUniformLogicalXor",
		Class:    "Non-Uniform",
		Opcode:   364,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ClusterSize'",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformQuadBroadcast = &Opcode {
		Opname:   "OpGroupNonUniformQuadBroadcast",
		Class:    "Non-Uniform",
		Opcode:   365,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupNonUniformQuadSwap = &Opcode {
		Opname:   "OpGroupNonUniformQuadSwap",
		Class:    "Non-Uniform",
		Opcode:   366,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpCopyLogical = &Opcode {
		Opname:   "OpCopyLogical",
		Class:    "Composite",
		Opcode:   400,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpPtrEqual = &Opcode {
		Opname:   "OpPtrEqual",
		Class:    "Memory",
		Opcode:   401,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpPtrNotEqual = &Opcode {
		Opname:   "OpPtrNotEqual",
		Class:    "Memory",
		Opcode:   402,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpPtrDiff = &Opcode {
		Opname:   "OpPtrDiff",
		Class:    "Memory",
		Opcode:   403,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupBallotKHR = &Opcode {
		Opname:   "OpSubgroupBallotKHR",
		Class:    "Group",
		Opcode:   4421,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupFirstInvocationKHR = &Opcode {
		Opname:   "OpSubgroupFirstInvocationKHR",
		Class:    "Group",
		Opcode:   4422,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAllKHR = &Opcode {
		Opname:   "OpSubgroupAllKHR",
		Class:    "Group",
		Opcode:   4428,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAnyKHR = &Opcode {
		Opname:   "OpSubgroupAnyKHR",
		Class:    "Group",
		Opcode:   4429,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAllEqualKHR = &Opcode {
		Opname:   "OpSubgroupAllEqualKHR",
		Class:    "Group",
		Opcode:   4430,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Predicate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupReadInvocationKHR = &Opcode {
		Opname:   "OpSubgroupReadInvocationKHR",
		Class:    "Group",
		Opcode:   4432,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupIAddNonUniformAMD = &Opcode {
		Opname:   "OpGroupIAddNonUniformAMD",
		Class:    "Group",
		Opcode:   5000,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFAddNonUniformAMD = &Opcode {
		Opname:   "OpGroupFAddNonUniformAMD",
		Class:    "Group",
		Opcode:   5001,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFMinNonUniformAMD = &Opcode {
		Opname:   "OpGroupFMinNonUniformAMD",
		Class:    "Group",
		Opcode:   5002,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupUMinNonUniformAMD = &Opcode {
		Opname:   "OpGroupUMinNonUniformAMD",
		Class:    "Group",
		Opcode:   5003,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupSMinNonUniformAMD = &Opcode {
		Opname:   "OpGroupSMinNonUniformAMD",
		Class:    "Group",
		Opcode:   5004,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupFMaxNonUniformAMD = &Opcode {
		Opname:   "OpGroupFMaxNonUniformAMD",
		Class:    "Group",
		Opcode:   5005,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupUMaxNonUniformAMD = &Opcode {
		Opname:   "OpGroupUMaxNonUniformAMD",
		Class:    "Group",
		Opcode:   5006,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpGroupSMaxNonUniformAMD = &Opcode {
		Opname:   "OpGroupSMaxNonUniformAMD",
		Class:    "Group",
		Opcode:   5007,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindGroupOperation,
				Name:       "'Operation'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'X'",
				Quantifier: "",
			}, 
		},
	}
	OpFragmentMaskFetchAMD = &Opcode {
		Opname:   "OpFragmentMaskFetchAMD",
		Class:    "Reserved",
		Opcode:   5011,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
		},
	}
	OpFragmentFetchAMD = &Opcode {
		Opname:   "OpFragmentFetchAMD",
		Class:    "Reserved",
		Opcode:   5012,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fragment Index'",
				Quantifier: "",
			}, 
		},
	}
	OpReadClockKHR = &Opcode {
		Opname:   "OpReadClockKHR",
		Class:    "Reserved",
		Opcode:   5056,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
		},
	}
	OpImageSampleFootprintNV = &Opcode {
		Opname:   "OpImageSampleFootprintNV",
		Class:    "Image",
		Opcode:   5283,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampled Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Granularity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coarse'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindImageOperands,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpGroupNonUniformPartitionNV = &Opcode {
		Opname:   "OpGroupNonUniformPartitionNV",
		Class:    "Non-Uniform",
		Opcode:   5296,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpWritePackedPrimitiveIndices4x8NV = &Opcode {
		Opname:   "OpWritePackedPrimitiveIndices4x8NV",
		Class:    "Reserved",
		Opcode:   5299,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Index Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Indices'",
				Quantifier: "",
			}, 
		},
	}
	OpReportIntersectionNV = &Opcode {
		Opname:   "OpReportIntersectionNV",
		Class:    "Reserved",
		Opcode:   5334,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Hit'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'HitKind'",
				Quantifier: "",
			}, 
		},
	}
	OpReportIntersectionKHR = &Opcode {
		Opname:   "OpReportIntersectionKHR",
		Class:    "Reserved",
		Opcode:   5334,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Hit'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'HitKind'",
				Quantifier: "",
			}, 
		},
	}
	OpIgnoreIntersectionNV = &Opcode {
		Opname:   "OpIgnoreIntersectionNV",
		Class:    "Reserved",
		Opcode:   5335,
		Operands: []Operand {
		},
	}
	OpIgnoreIntersectionKHR = &Opcode {
		Opname:   "OpIgnoreIntersectionKHR",
		Class:    "Reserved",
		Opcode:   5335,
		Operands: []Operand {
		},
	}
	OpTerminateRayNV = &Opcode {
		Opname:   "OpTerminateRayNV",
		Class:    "Reserved",
		Opcode:   5336,
		Operands: []Operand {
		},
	}
	OpTerminateRayKHR = &Opcode {
		Opname:   "OpTerminateRayKHR",
		Class:    "Reserved",
		Opcode:   5336,
		Operands: []Operand {
		},
	}
	OpTraceNV = &Opcode {
		Opname:   "OpTraceNV",
		Class:    "Reserved",
		Opcode:   5337,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Accel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Cull Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Miss Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Origin'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Tmin'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Direction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Tmax'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'PayloadId'",
				Quantifier: "",
			}, 
		},
	}
	OpTraceRayKHR = &Opcode {
		Opname:   "OpTraceRayKHR",
		Class:    "Reserved",
		Opcode:   5337,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Accel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Cull Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Miss Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Origin'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Tmin'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Direction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ray Tmax'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'PayloadId'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAccelerationStructureNV = &Opcode {
		Opname:   "OpTypeAccelerationStructureNV",
		Class:    "Reserved",
		Opcode:   5341,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAccelerationStructureKHR = &Opcode {
		Opname:   "OpTypeAccelerationStructureKHR",
		Class:    "Reserved",
		Opcode:   5341,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeRayQueryKHR = &Opcode {
		Opname:   "OpTypeRayQueryKHR",
		Class:    "Reserved",
		Opcode:   4472,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryInitializeKHR = &Opcode {
		Opname:   "OpRayQueryInitializeKHR",
		Class:    "Reserved",
		Opcode:   4473,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Accel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayFlags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'CullMask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayOrigin'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayTMin'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayDirection'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayTMax'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryTerminateKHR = &Opcode {
		Opname:   "OpRayQueryTerminateKHR",
		Class:    "Reserved",
		Opcode:   4474,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGenerateIntersectionKHR = &Opcode {
		Opname:   "OpRayQueryGenerateIntersectionKHR",
		Class:    "Reserved",
		Opcode:   4475,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'HitT'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryConfirmIntersectionKHR = &Opcode {
		Opname:   "OpRayQueryConfirmIntersectionKHR",
		Class:    "Reserved",
		Opcode:   4476,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryProceedKHR = &Opcode {
		Opname:   "OpRayQueryProceedKHR",
		Class:    "Reserved",
		Opcode:   4477,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionTypeKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionTypeKHR",
		Class:    "Reserved",
		Opcode:   4479,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetRayTMinKHR = &Opcode {
		Opname:   "OpRayQueryGetRayTMinKHR",
		Class:    "Reserved",
		Opcode:   6016,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetRayFlagsKHR = &Opcode {
		Opname:   "OpRayQueryGetRayFlagsKHR",
		Class:    "Reserved",
		Opcode:   6017,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionTKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionTKHR",
		Class:    "Reserved",
		Opcode:   6018,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionInstanceCustomIndexKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionInstanceCustomIndexKHR",
		Class:    "Reserved",
		Opcode:   6019,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionInstanceIdKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionInstanceIdKHR",
		Class:    "Reserved",
		Opcode:   6020,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR",
		Class:    "Reserved",
		Opcode:   6021,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionGeometryIndexKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionGeometryIndexKHR",
		Class:    "Reserved",
		Opcode:   6022,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionPrimitiveIndexKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionPrimitiveIndexKHR",
		Class:    "Reserved",
		Opcode:   6023,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionBarycentricsKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionBarycentricsKHR",
		Class:    "Reserved",
		Opcode:   6024,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionFrontFaceKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionFrontFaceKHR",
		Class:    "Reserved",
		Opcode:   6025,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionCandidateAABBOpaqueKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionCandidateAABBOpaqueKHR",
		Class:    "Reserved",
		Opcode:   6026,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionObjectRayDirectionKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionObjectRayDirectionKHR",
		Class:    "Reserved",
		Opcode:   6027,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionObjectRayOriginKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionObjectRayOriginKHR",
		Class:    "Reserved",
		Opcode:   6028,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetWorldRayDirectionKHR = &Opcode {
		Opname:   "OpRayQueryGetWorldRayDirectionKHR",
		Class:    "Reserved",
		Opcode:   6029,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetWorldRayOriginKHR = &Opcode {
		Opname:   "OpRayQueryGetWorldRayOriginKHR",
		Class:    "Reserved",
		Opcode:   6030,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionObjectToWorldKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionObjectToWorldKHR",
		Class:    "Reserved",
		Opcode:   6031,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpRayQueryGetIntersectionWorldToObjectKHR = &Opcode {
		Opname:   "OpRayQueryGetIntersectionWorldToObjectKHR",
		Class:    "Reserved",
		Opcode:   6032,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'RayQuery'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intersection'",
				Quantifier: "",
			}, 
		},
	}
	OpExecuteCallableNV = &Opcode {
		Opname:   "OpExecuteCallableNV",
		Class:    "Reserved",
		Opcode:   5344,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Callable DataId'",
				Quantifier: "",
			}, 
		},
	}
	OpExecuteCallableKHR = &Opcode {
		Opname:   "OpExecuteCallableKHR",
		Class:    "Reserved",
		Opcode:   5344,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SBT Index'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Callable DataId'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeCooperativeMatrixNV = &Opcode {
		Opname:   "OpTypeCooperativeMatrixNV",
		Class:    "Reserved",
		Opcode:   5358,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdScope,
				Name:       "'Execution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Rows'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Columns'",
				Quantifier: "",
			}, 
		},
	}
	OpCooperativeMatrixLoadNV = &Opcode {
		Opname:   "OpCooperativeMatrixLoadNV",
		Class:    "Reserved",
		Opcode:   5359,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Column Major'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpCooperativeMatrixStoreNV = &Opcode {
		Opname:   "OpCooperativeMatrixStoreNV",
		Class:    "Reserved",
		Opcode:   5360,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pointer'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Object'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Stride'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Column Major'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindMemoryAccess,
				Name:       "",
				Quantifier: "?",
			}, 
		},
	}
	OpCooperativeMatrixMulAddNV = &Opcode {
		Opname:   "OpCooperativeMatrixMulAddNV",
		Class:    "Reserved",
		Opcode:   5361,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'A'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'B'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'C'",
				Quantifier: "",
			}, 
		},
	}
	OpCooperativeMatrixLengthNV = &Opcode {
		Opname:   "OpCooperativeMatrixLengthNV",
		Class:    "Reserved",
		Opcode:   5362,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
		},
	}
	OpBeginInvocationInterlockEXT = &Opcode {
		Opname:   "OpBeginInvocationInterlockEXT",
		Class:    "Reserved",
		Opcode:   5364,
		Operands: []Operand {
		},
	}
	OpEndInvocationInterlockEXT = &Opcode {
		Opname:   "OpEndInvocationInterlockEXT",
		Class:    "Reserved",
		Opcode:   5365,
		Operands: []Operand {
		},
	}
	OpDemoteToHelperInvocationEXT = &Opcode {
		Opname:   "OpDemoteToHelperInvocationEXT",
		Class:    "Reserved",
		Opcode:   5380,
		Operands: []Operand {
		},
	}
	OpIsHelperInvocationEXT = &Opcode {
		Opname:   "OpIsHelperInvocationEXT",
		Class:    "Reserved",
		Opcode:   5381,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupShuffleINTEL = &Opcode {
		Opname:   "OpSubgroupShuffleINTEL",
		Class:    "Group",
		Opcode:   5571,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'InvocationId'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupShuffleDownINTEL = &Opcode {
		Opname:   "OpSubgroupShuffleDownINTEL",
		Class:    "Group",
		Opcode:   5572,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Current'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Next'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Delta'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupShuffleUpINTEL = &Opcode {
		Opname:   "OpSubgroupShuffleUpINTEL",
		Class:    "Group",
		Opcode:   5573,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Previous'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Current'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Delta'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupShuffleXorINTEL = &Opcode {
		Opname:   "OpSubgroupShuffleXorINTEL",
		Class:    "Group",
		Opcode:   5574,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupBlockReadINTEL = &Opcode {
		Opname:   "OpSubgroupBlockReadINTEL",
		Class:    "Group",
		Opcode:   5575,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ptr'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupBlockWriteINTEL = &Opcode {
		Opname:   "OpSubgroupBlockWriteINTEL",
		Class:    "Group",
		Opcode:   5576,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ptr'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupImageBlockReadINTEL = &Opcode {
		Opname:   "OpSubgroupImageBlockReadINTEL",
		Class:    "Group",
		Opcode:   5577,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupImageBlockWriteINTEL = &Opcode {
		Opname:   "OpSubgroupImageBlockWriteINTEL",
		Class:    "Group",
		Opcode:   5578,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupImageMediaBlockReadINTEL = &Opcode {
		Opname:   "OpSubgroupImageMediaBlockReadINTEL",
		Class:    "Group",
		Opcode:   5580,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Width'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Height'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupImageMediaBlockWriteINTEL = &Opcode {
		Opname:   "OpSubgroupImageMediaBlockWriteINTEL",
		Class:    "Group",
		Opcode:   5581,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Coordinate'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Width'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Height'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Data'",
				Quantifier: "",
			}, 
		},
	}
	OpUCountLeadingZerosINTEL = &Opcode {
		Opname:   "OpUCountLeadingZerosINTEL",
		Class:    "Reserved",
		Opcode:   5585,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpUCountTrailingZerosINTEL = &Opcode {
		Opname:   "OpUCountTrailingZerosINTEL",
		Class:    "Reserved",
		Opcode:   5586,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand'",
				Quantifier: "",
			}, 
		},
	}
	OpAbsISubINTEL = &Opcode {
		Opname:   "OpAbsISubINTEL",
		Class:    "Reserved",
		Opcode:   5587,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpAbsUSubINTEL = &Opcode {
		Opname:   "OpAbsUSubINTEL",
		Class:    "Reserved",
		Opcode:   5588,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIAddSatINTEL = &Opcode {
		Opname:   "OpIAddSatINTEL",
		Class:    "Reserved",
		Opcode:   5589,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUAddSatINTEL = &Opcode {
		Opname:   "OpUAddSatINTEL",
		Class:    "Reserved",
		Opcode:   5590,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIAverageINTEL = &Opcode {
		Opname:   "OpIAverageINTEL",
		Class:    "Reserved",
		Opcode:   5591,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUAverageINTEL = &Opcode {
		Opname:   "OpUAverageINTEL",
		Class:    "Reserved",
		Opcode:   5592,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIAverageRoundedINTEL = &Opcode {
		Opname:   "OpIAverageRoundedINTEL",
		Class:    "Reserved",
		Opcode:   5593,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUAverageRoundedINTEL = &Opcode {
		Opname:   "OpUAverageRoundedINTEL",
		Class:    "Reserved",
		Opcode:   5594,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpISubSatINTEL = &Opcode {
		Opname:   "OpISubSatINTEL",
		Class:    "Reserved",
		Opcode:   5595,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUSubSatINTEL = &Opcode {
		Opname:   "OpUSubSatINTEL",
		Class:    "Reserved",
		Opcode:   5596,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpIMul32x16INTEL = &Opcode {
		Opname:   "OpIMul32x16INTEL",
		Class:    "Reserved",
		Opcode:   5597,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpUMul32x16INTEL = &Opcode {
		Opname:   "OpUMul32x16INTEL",
		Class:    "Reserved",
		Opcode:   5598,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operand 2'",
				Quantifier: "",
			}, 
		},
	}
	OpDecorateString = &Opcode {
		Opname:   "OpDecorateString",
		Class:    "Annotation",
		Opcode:   5632,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpDecorateStringGOOGLE = &Opcode {
		Opname:   "OpDecorateStringGOOGLE",
		Class:    "Annotation",
		Opcode:   5632,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpMemberDecorateString = &Opcode {
		Opname:   "OpMemberDecorateString",
		Class:    "Annotation",
		Opcode:   5633,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Struct Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Member'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpMemberDecorateStringGOOGLE = &Opcode {
		Opname:   "OpMemberDecorateStringGOOGLE",
		Class:    "Annotation",
		Opcode:   5633,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Struct Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Member'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDecoration,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpVmeImageINTEL = &Opcode {
		Opname:   "OpVmeImageINTEL",
		Class:    "@exclude",
		Opcode:   5699,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sampler'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeVmeImageINTEL = &Opcode {
		Opname:   "OpTypeVmeImageINTEL",
		Class:    "@exclude",
		Opcode:   5700,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Type'",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImePayloadINTEL = &Opcode {
		Opname:   "OpTypeAvcImePayloadINTEL",
		Class:    "@exclude",
		Opcode:   5701,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcRefPayloadINTEL = &Opcode {
		Opname:   "OpTypeAvcRefPayloadINTEL",
		Class:    "@exclude",
		Opcode:   5702,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcSicPayloadINTEL = &Opcode {
		Opname:   "OpTypeAvcSicPayloadINTEL",
		Class:    "@exclude",
		Opcode:   5703,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcMcePayloadINTEL = &Opcode {
		Opname:   "OpTypeAvcMcePayloadINTEL",
		Class:    "@exclude",
		Opcode:   5704,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcMceResultINTEL = &Opcode {
		Opname:   "OpTypeAvcMceResultINTEL",
		Class:    "@exclude",
		Opcode:   5705,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeResultINTEL = &Opcode {
		Opname:   "OpTypeAvcImeResultINTEL",
		Class:    "@exclude",
		Opcode:   5706,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeResultSingleReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpTypeAvcImeResultSingleReferenceStreamoutINTEL",
		Class:    "@exclude",
		Opcode:   5707,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeResultDualReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpTypeAvcImeResultDualReferenceStreamoutINTEL",
		Class:    "@exclude",
		Opcode:   5708,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeSingleReferenceStreaminINTEL = &Opcode {
		Opname:   "OpTypeAvcImeSingleReferenceStreaminINTEL",
		Class:    "@exclude",
		Opcode:   5709,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcImeDualReferenceStreaminINTEL = &Opcode {
		Opname:   "OpTypeAvcImeDualReferenceStreaminINTEL",
		Class:    "@exclude",
		Opcode:   5710,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcRefResultINTEL = &Opcode {
		Opname:   "OpTypeAvcRefResultINTEL",
		Class:    "@exclude",
		Opcode:   5711,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpTypeAvcSicResultINTEL = &Opcode {
		Opname:   "OpTypeAvcSicResultINTEL",
		Class:    "@exclude",
		Opcode:   5712,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5713,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5714,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reference Base Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5715,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetInterShapePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetInterShapePenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5716,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Shape Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5717,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetInterDirectionPenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetInterDirectionPenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5718,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction Cost'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5719,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL",
		Class:    "@exclude",
		Opcode:   5720,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL",
		Class:    "@exclude",
		Opcode:   5721,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL",
		Class:    "@exclude",
		Opcode:   5722,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL",
		Class:    "@exclude",
		Opcode:   5723,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL",
		Class:    "@exclude",
		Opcode:   5724,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Cost Center Delta'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Cost Table'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Cost Precision'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5725,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Slice Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Qp'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5726,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5727,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetAcOnlyHaarINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetAcOnlyHaarINTEL",
		Class:    "@exclude",
		Opcode:   5728,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL",
		Class:    "@exclude",
		Opcode:   5729,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source Field Polarity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL",
		Class:    "@exclude",
		Opcode:   5730,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Reference Field Polarity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL",
		Class:    "@exclude",
		Opcode:   5731,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Forward Reference Field Polarity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Backward Reference Field Polarity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToImePayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToImePayloadINTEL",
		Class:    "@exclude",
		Opcode:   5732,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToImeResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToImeResultINTEL",
		Class:    "@exclude",
		Opcode:   5733,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToRefPayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToRefPayloadINTEL",
		Class:    "@exclude",
		Opcode:   5734,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToRefResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToRefResultINTEL",
		Class:    "@exclude",
		Opcode:   5735,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToSicPayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToSicPayloadINTEL",
		Class:    "@exclude",
		Opcode:   5736,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceConvertToSicResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceConvertToSicResultINTEL",
		Class:    "@exclude",
		Opcode:   5737,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetMotionVectorsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetMotionVectorsINTEL",
		Class:    "@exclude",
		Opcode:   5738,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterDistortionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterDistortionsINTEL",
		Class:    "@exclude",
		Opcode:   5739,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetBestInterDistortionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetBestInterDistortionsINTEL",
		Class:    "@exclude",
		Opcode:   5740,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterMajorShapeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterMajorShapeINTEL",
		Class:    "@exclude",
		Opcode:   5741,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterMinorShapeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterMinorShapeINTEL",
		Class:    "@exclude",
		Opcode:   5742,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterDirectionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterDirectionsINTEL",
		Class:    "@exclude",
		Opcode:   5743,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterMotionVectorCountINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterMotionVectorCountINTEL",
		Class:    "@exclude",
		Opcode:   5744,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterReferenceIdsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterReferenceIdsINTEL",
		Class:    "@exclude",
		Opcode:   5745,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL = &Opcode {
		Opname:   "OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL",
		Class:    "@exclude",
		Opcode:   5746,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Parameter Field Polarities'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeInitializeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeInitializeINTEL",
		Class:    "@exclude",
		Opcode:   5747,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Partition Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'SAD Adjustment'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetSingleReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetSingleReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5748,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Search Window Config'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetDualReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetDualReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5749,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'id> Search Window Config'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeRefWindowSizeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeRefWindowSizeINTEL",
		Class:    "@exclude",
		Opcode:   5750,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Search Window Config'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Dual Ref'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeAdjustRefOffsetINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeAdjustRefOffsetINTEL",
		Class:    "@exclude",
		Opcode:   5751,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Window Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Size'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeConvertToMcePayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeConvertToMcePayloadINTEL",
		Class:    "@exclude",
		Opcode:   5752,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetMaxMotionVectorCountINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetMaxMotionVectorCountINTEL",
		Class:    "@exclude",
		Opcode:   5753,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Max Motion Vector Count'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL",
		Class:    "@exclude",
		Opcode:   5754,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL",
		Class:    "@exclude",
		Opcode:   5755,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Threshold'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeSetWeightedSadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeSetWeightedSadINTEL",
		Class:    "@exclude",
		Opcode:   5756,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Sad Weights'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5757,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithDualReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithDualReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5758,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL",
		Class:    "@exclude",
		Opcode:   5759,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Streamin Components'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL",
		Class:    "@exclude",
		Opcode:   5760,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Streamin Components'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL",
		Class:    "@exclude",
		Opcode:   5761,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL",
		Class:    "@exclude",
		Opcode:   5762,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL",
		Class:    "@exclude",
		Opcode:   5763,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Streamin Components'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL",
		Class:    "@exclude",
		Opcode:   5764,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Streamin Components'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeConvertToMceResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeConvertToMceResultINTEL",
		Class:    "@exclude",
		Opcode:   5765,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetSingleReferenceStreaminINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetSingleReferenceStreaminINTEL",
		Class:    "@exclude",
		Opcode:   5766,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetDualReferenceStreaminINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetDualReferenceStreaminINTEL",
		Class:    "@exclude",
		Opcode:   5767,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL",
		Class:    "@exclude",
		Opcode:   5768,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeStripDualReferenceStreamoutINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeStripDualReferenceStreamoutINTEL",
		Class:    "@exclude",
		Opcode:   5769,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL",
		Class:    "@exclude",
		Opcode:   5770,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL",
		Class:    "@exclude",
		Opcode:   5771,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL",
		Class:    "@exclude",
		Opcode:   5772,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL",
		Class:    "@exclude",
		Opcode:   5773,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL",
		Class:    "@exclude",
		Opcode:   5774,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL",
		Class:    "@exclude",
		Opcode:   5775,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shape'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetBorderReachedINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetBorderReachedINTEL",
		Class:    "@exclude",
		Opcode:   5776,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Image Select'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL",
		Class:    "@exclude",
		Opcode:   5777,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL",
		Class:    "@exclude",
		Opcode:   5778,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL",
		Class:    "@exclude",
		Opcode:   5779,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL",
		Class:    "@exclude",
		Opcode:   5780,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcFmeInitializeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcFmeInitializeINTEL",
		Class:    "@exclude",
		Opcode:   5781,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Motion Vectors'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shapes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Minor Shapes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pixel Resolution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcBmeInitializeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcBmeInitializeINTEL",
		Class:    "@exclude",
		Opcode:   5782,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Motion Vectors'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Major Shapes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Minor Shapes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Pixel Resolution'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bidirectional Weight'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefConvertToMcePayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefConvertToMcePayloadINTEL",
		Class:    "@exclude",
		Opcode:   5783,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefSetBidirectionalMixDisableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefSetBidirectionalMixDisableINTEL",
		Class:    "@exclude",
		Opcode:   5784,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefSetBilinearFilterEnableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefSetBilinearFilterEnableINTEL",
		Class:    "@exclude",
		Opcode:   5785,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5786,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefEvaluateWithDualReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefEvaluateWithDualReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5787,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5788,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL",
		Class:    "@exclude",
		Opcode:   5789,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Field Polarities'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcRefConvertToMceResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcRefConvertToMceResultINTEL",
		Class:    "@exclude",
		Opcode:   5790,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicInitializeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicInitializeINTEL",
		Class:    "@exclude",
		Opcode:   5791,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Coord'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConfigureSkcINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConfigureSkcINTEL",
		Class:    "@exclude",
		Opcode:   5792,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Skip Block Partition Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Skip Motion Vector Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Motion Vectors'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bidirectional Weight'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConfigureIpeLumaINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConfigureIpeLumaINTEL",
		Class:    "@exclude",
		Opcode:   5793,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Intra Partition Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intra Neighbour Availabilty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Left Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Left Corner Luma Pixel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Right Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConfigureIpeLumaChromaINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConfigureIpeLumaChromaINTEL",
		Class:    "@exclude",
		Opcode:   5794,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Intra Partition Mask'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Intra Neighbour Availabilty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Left Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Left Corner Luma Pixel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Right Edge Luma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Left Edge Chroma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Left Corner Chroma Pixel'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Upper Edge Chroma Pixels'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Sad Adjustment'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetMotionVectorMaskINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetMotionVectorMaskINTEL",
		Class:    "@exclude",
		Opcode:   5795,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Skip Block Partition Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Direction'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConvertToMcePayloadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConvertToMcePayloadINTEL",
		Class:    "@exclude",
		Opcode:   5796,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL",
		Class:    "@exclude",
		Opcode:   5797,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Shape Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL",
		Class:    "@exclude",
		Opcode:   5798,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Mode Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Packed Neighbor Modes'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Luma Packed Non Dc Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL",
		Class:    "@exclude",
		Opcode:   5799,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Chroma Mode Base Penalty'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetBilinearFilterEnableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetBilinearFilterEnableINTEL",
		Class:    "@exclude",
		Opcode:   5800,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL",
		Class:    "@exclude",
		Opcode:   5801,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Sad Coefficients'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL",
		Class:    "@exclude",
		Opcode:   5802,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Block Based Skip Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateIpeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateIpeINTEL",
		Class:    "@exclude",
		Opcode:   5803,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5804,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateWithDualReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateWithDualReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5805,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Fwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Bwd Ref Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL",
		Class:    "@exclude",
		Opcode:   5806,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL",
		Class:    "@exclude",
		Opcode:   5807,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Src Image'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Ids'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Packed Reference Field Polarities'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicConvertToMceResultINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicConvertToMceResultINTEL",
		Class:    "@exclude",
		Opcode:   5808,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetIpeLumaShapeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetIpeLumaShapeINTEL",
		Class:    "@exclude",
		Opcode:   5809,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL",
		Class:    "@exclude",
		Opcode:   5810,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL",
		Class:    "@exclude",
		Opcode:   5811,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetPackedIpeLumaModesINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetPackedIpeLumaModesINTEL",
		Class:    "@exclude",
		Opcode:   5812,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetIpeChromaModeINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetIpeChromaModeINTEL",
		Class:    "@exclude",
		Opcode:   5813,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL",
		Class:    "@exclude",
		Opcode:   5814,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL",
		Class:    "@exclude",
		Opcode:   5815,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}
	OpSubgroupAvcSicGetInterRawSadsINTEL = &Opcode {
		Opname:   "OpSubgroupAvcSicGetInterRawSadsINTEL",
		Class:    "@exclude",
		Opcode:   5816,
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdResultType,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdResult,
				Name:       "",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Payload'",
				Quantifier: "",
			}, 
		},
	}

	GLSLStd450_Round = &Opcode {
		Opname:   "Round",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_RoundEven = &Opcode {
		Opname:   "RoundEven",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Trunc = &Opcode {
		Opname:   "Trunc",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FAbs = &Opcode {
		Opname:   "FAbs",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_SAbs = &Opcode {
		Opname:   "SAbs",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FSign = &Opcode {
		Opname:   "FSign",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_SSign = &Opcode {
		Opname:   "SSign",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Floor = &Opcode {
		Opname:   "Floor",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Ceil = &Opcode {
		Opname:   "Ceil",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Fract = &Opcode {
		Opname:   "Fract",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Radians = &Opcode {
		Opname:   "Radians",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'degrees'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Degrees = &Opcode {
		Opname:   "Degrees",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'radians'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Sin = &Opcode {
		Opname:   "Sin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Cos = &Opcode {
		Opname:   "Cos",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Tan = &Opcode {
		Opname:   "Tan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Asin = &Opcode {
		Opname:   "Asin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Acos = &Opcode {
		Opname:   "Acos",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Atan = &Opcode {
		Opname:   "Atan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y_over_x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Sinh = &Opcode {
		Opname:   "Sinh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Cosh = &Opcode {
		Opname:   "Cosh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Tanh = &Opcode {
		Opname:   "Tanh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Asinh = &Opcode {
		Opname:   "Asinh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Acosh = &Opcode {
		Opname:   "Acosh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Atanh = &Opcode {
		Opname:   "Atanh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Atan2 = &Opcode {
		Opname:   "Atan2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Pow = &Opcode {
		Opname:   "Pow",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Exp = &Opcode {
		Opname:   "Exp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Log = &Opcode {
		Opname:   "Log",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Exp2 = &Opcode {
		Opname:   "Exp2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Log2 = &Opcode {
		Opname:   "Log2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Sqrt = &Opcode {
		Opname:   "Sqrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_InverseSqrt = &Opcode {
		Opname:   "InverseSqrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Determinant = &Opcode {
		Opname:   "Determinant",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_MatrixInverse = &Opcode {
		Opname:   "MatrixInverse",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Modf = &Opcode {
		Opname:   "Modf",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'i'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_ModfStruct = &Opcode {
		Opname:   "ModfStruct",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FMin = &Opcode {
		Opname:   "FMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UMin = &Opcode {
		Opname:   "UMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_SMin = &Opcode {
		Opname:   "SMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FMax = &Opcode {
		Opname:   "FMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UMax = &Opcode {
		Opname:   "UMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_SMax = &Opcode {
		Opname:   "SMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FClamp = &Opcode {
		Opname:   "FClamp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'minVal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'maxVal'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UClamp = &Opcode {
		Opname:   "UClamp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'minVal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'maxVal'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_SClamp = &Opcode {
		Opname:   "SClamp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'minVal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'maxVal'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FMix = &Opcode {
		Opname:   "FMix",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_IMix = &Opcode {
		Opname:   "IMix",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Step = &Opcode {
		Opname:   "Step",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'edge'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_SmoothStep = &Opcode {
		Opname:   "SmoothStep",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'edge0'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'edge1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Fma = &Opcode {
		Opname:   "Fma",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'b'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'c'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Frexp = &Opcode {
		Opname:   "Frexp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'exp'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FrexpStruct = &Opcode {
		Opname:   "FrexpStruct",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Ldexp = &Opcode {
		Opname:   "Ldexp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'exp'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_PackSnorm4x8 = &Opcode {
		Opname:   "PackSnorm4x8",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_PackUnorm4x8 = &Opcode {
		Opname:   "PackUnorm4x8",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_PackSnorm2x16 = &Opcode {
		Opname:   "PackSnorm2x16",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_PackUnorm2x16 = &Opcode {
		Opname:   "PackUnorm2x16",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_PackHalf2x16 = &Opcode {
		Opname:   "PackHalf2x16",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_PackDouble2x32 = &Opcode {
		Opname:   "PackDouble2x32",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UnpackSnorm2x16 = &Opcode {
		Opname:   "UnpackSnorm2x16",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UnpackUnorm2x16 = &Opcode {
		Opname:   "UnpackUnorm2x16",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UnpackHalf2x16 = &Opcode {
		Opname:   "UnpackHalf2x16",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UnpackSnorm4x8 = &Opcode {
		Opname:   "UnpackSnorm4x8",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UnpackUnorm4x8 = &Opcode {
		Opname:   "UnpackUnorm4x8",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_UnpackDouble2x32 = &Opcode {
		Opname:   "UnpackDouble2x32",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Length = &Opcode {
		Opname:   "Length",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Distance = &Opcode {
		Opname:   "Distance",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p0'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p1'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Cross = &Opcode {
		Opname:   "Cross",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Normalize = &Opcode {
		Opname:   "Normalize",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FaceForward = &Opcode {
		Opname:   "FaceForward",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'N'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'I'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Nref'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Reflect = &Opcode {
		Opname:   "Reflect",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'I'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'N'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_Refract = &Opcode {
		Opname:   "Refract",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'I'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'N'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'eta'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FindILsb = &Opcode {
		Opname:   "FindILsb",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FindSMsb = &Opcode {
		Opname:   "FindSMsb",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_FindUMsb = &Opcode {
		Opname:   "FindUMsb",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_InterpolateAtCentroid = &Opcode {
		Opname:   "InterpolateAtCentroid",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'interpolant'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_InterpolateAtSample = &Opcode {
		Opname:   "InterpolateAtSample",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'interpolant'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'sample'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_InterpolateAtOffset = &Opcode {
		Opname:   "InterpolateAtOffset",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'interpolant'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_NMin = &Opcode {
		Opname:   "NMin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_NMax = &Opcode {
		Opname:   "NMax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	GLSLStd450_NClamp = &Opcode {
		Opname:   "NClamp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'minVal'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'maxVal'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_acos = &Opcode {
		Opname:   "acos",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_acosh = &Opcode {
		Opname:   "acosh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_acospi = &Opcode {
		Opname:   "acospi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_asin = &Opcode {
		Opname:   "asin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_asinh = &Opcode {
		Opname:   "asinh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_asinpi = &Opcode {
		Opname:   "asinpi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_atan = &Opcode {
		Opname:   "atan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_atan2 = &Opcode {
		Opname:   "atan2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_atanh = &Opcode {
		Opname:   "atanh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_atanpi = &Opcode {
		Opname:   "atanpi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_atan2pi = &Opcode {
		Opname:   "atan2pi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_cbrt = &Opcode {
		Opname:   "cbrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_ceil = &Opcode {
		Opname:   "ceil",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_copysign = &Opcode {
		Opname:   "copysign",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_cos = &Opcode {
		Opname:   "cos",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_cosh = &Opcode {
		Opname:   "cosh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_cospi = &Opcode {
		Opname:   "cospi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_erfc = &Opcode {
		Opname:   "erfc",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_erf = &Opcode {
		Opname:   "erf",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_exp = &Opcode {
		Opname:   "exp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_exp2 = &Opcode {
		Opname:   "exp2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_exp10 = &Opcode {
		Opname:   "exp10",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_expm1 = &Opcode {
		Opname:   "expm1",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fabs = &Opcode {
		Opname:   "fabs",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fdim = &Opcode {
		Opname:   "fdim",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_floor = &Opcode {
		Opname:   "floor",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fma = &Opcode {
		Opname:   "fma",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'b'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'c'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fmax = &Opcode {
		Opname:   "fmax",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fmin = &Opcode {
		Opname:   "fmin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fmod = &Opcode {
		Opname:   "fmod",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fract = &Opcode {
		Opname:   "fract",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ptr'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_frexp = &Opcode {
		Opname:   "frexp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'exp'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_hypot = &Opcode {
		Opname:   "hypot",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_ilogb = &Opcode {
		Opname:   "ilogb",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_ldexp = &Opcode {
		Opname:   "ldexp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'k'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_lgamma = &Opcode {
		Opname:   "lgamma",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_lgamma_r = &Opcode {
		Opname:   "lgamma_r",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'signp'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_log = &Opcode {
		Opname:   "log",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_log2 = &Opcode {
		Opname:   "log2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_log10 = &Opcode {
		Opname:   "log10",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_log1p = &Opcode {
		Opname:   "log1p",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_logb = &Opcode {
		Opname:   "logb",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_mad = &Opcode {
		Opname:   "mad",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'b'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'c'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_maxmag = &Opcode {
		Opname:   "maxmag",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_minmag = &Opcode {
		Opname:   "minmag",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_modf = &Opcode {
		Opname:   "modf",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'iptr'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_nan = &Opcode {
		Opname:   "nan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'nancode'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_nextafter = &Opcode {
		Opname:   "nextafter",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_pow = &Opcode {
		Opname:   "pow",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_pown = &Opcode {
		Opname:   "pown",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_powr = &Opcode {
		Opname:   "powr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_remainder = &Opcode {
		Opname:   "remainder",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_remquo = &Opcode {
		Opname:   "remquo",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'quo'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_rint = &Opcode {
		Opname:   "rint",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_rootn = &Opcode {
		Opname:   "rootn",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_round = &Opcode {
		Opname:   "round",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_rsqrt = &Opcode {
		Opname:   "rsqrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_sin = &Opcode {
		Opname:   "sin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_sincos = &Opcode {
		Opname:   "sincos",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'cosval'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_sinh = &Opcode {
		Opname:   "sinh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_sinpi = &Opcode {
		Opname:   "sinpi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_sqrt = &Opcode {
		Opname:   "sqrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_tan = &Opcode {
		Opname:   "tan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_tanh = &Opcode {
		Opname:   "tanh",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_tanpi = &Opcode {
		Opname:   "tanpi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_tgamma = &Opcode {
		Opname:   "tgamma",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_trunc = &Opcode {
		Opname:   "trunc",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_cos = &Opcode {
		Opname:   "half_cos",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_divide = &Opcode {
		Opname:   "half_divide",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_exp = &Opcode {
		Opname:   "half_exp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_exp2 = &Opcode {
		Opname:   "half_exp2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_exp10 = &Opcode {
		Opname:   "half_exp10",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_log = &Opcode {
		Opname:   "half_log",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_log2 = &Opcode {
		Opname:   "half_log2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_log10 = &Opcode {
		Opname:   "half_log10",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_powr = &Opcode {
		Opname:   "half_powr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_recip = &Opcode {
		Opname:   "half_recip",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_rsqrt = &Opcode {
		Opname:   "half_rsqrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_sin = &Opcode {
		Opname:   "half_sin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_sqrt = &Opcode {
		Opname:   "half_sqrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_half_tan = &Opcode {
		Opname:   "half_tan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_cos = &Opcode {
		Opname:   "native_cos",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_divide = &Opcode {
		Opname:   "native_divide",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_exp = &Opcode {
		Opname:   "native_exp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_exp2 = &Opcode {
		Opname:   "native_exp2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_exp10 = &Opcode {
		Opname:   "native_exp10",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_log = &Opcode {
		Opname:   "native_log",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_log2 = &Opcode {
		Opname:   "native_log2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_log10 = &Opcode {
		Opname:   "native_log10",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_powr = &Opcode {
		Opname:   "native_powr",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_recip = &Opcode {
		Opname:   "native_recip",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_rsqrt = &Opcode {
		Opname:   "native_rsqrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_sin = &Opcode {
		Opname:   "native_sin",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_sqrt = &Opcode {
		Opname:   "native_sqrt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_native_tan = &Opcode {
		Opname:   "native_tan",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_abs = &Opcode {
		Opname:   "s_abs",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_abs_diff = &Opcode {
		Opname:   "s_abs_diff",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_add_sat = &Opcode {
		Opname:   "s_add_sat",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_add_sat = &Opcode {
		Opname:   "u_add_sat",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_hadd = &Opcode {
		Opname:   "s_hadd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_hadd = &Opcode {
		Opname:   "u_hadd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_rhadd = &Opcode {
		Opname:   "s_rhadd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_rhadd = &Opcode {
		Opname:   "u_rhadd",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_clamp = &Opcode {
		Opname:   "s_clamp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'minval'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'maxval'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_clamp = &Opcode {
		Opname:   "u_clamp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'minval'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'maxval'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_clz = &Opcode {
		Opname:   "clz",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_ctz = &Opcode {
		Opname:   "ctz",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_mad_hi = &Opcode {
		Opname:   "s_mad_hi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'b'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'c'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_mad_sat = &Opcode {
		Opname:   "u_mad_sat",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'z'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_mad_sat = &Opcode {
		Opname:   "s_mad_sat",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'z'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_max = &Opcode {
		Opname:   "s_max",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_max = &Opcode {
		Opname:   "u_max",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_min = &Opcode {
		Opname:   "s_min",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_min = &Opcode {
		Opname:   "u_min",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_mul_hi = &Opcode {
		Opname:   "s_mul_hi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_rotate = &Opcode {
		Opname:   "rotate",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'v'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'i'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_sub_sat = &Opcode {
		Opname:   "s_sub_sat",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_sub_sat = &Opcode {
		Opname:   "u_sub_sat",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_upsample = &Opcode {
		Opname:   "u_upsample",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'hi'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'lo'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_upsample = &Opcode {
		Opname:   "s_upsample",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'hi'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'lo'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_popcount = &Opcode {
		Opname:   "popcount",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_mad24 = &Opcode {
		Opname:   "s_mad24",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'z'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_mad24 = &Opcode {
		Opname:   "u_mad24",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'z'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_s_mul24 = &Opcode {
		Opname:   "s_mul24",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_mul24 = &Opcode {
		Opname:   "u_mul24",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_abs = &Opcode {
		Opname:   "u_abs",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_abs_diff = &Opcode {
		Opname:   "u_abs_diff",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_mul_hi = &Opcode {
		Opname:   "u_mul_hi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_u_mad_hi = &Opcode {
		Opname:   "u_mad_hi",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'b'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'c'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fclamp = &Opcode {
		Opname:   "fclamp",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'minval'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'maxval'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_degrees = &Opcode {
		Opname:   "degrees",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'radians'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fmax_common = &Opcode {
		Opname:   "fmax_common",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fmin_common = &Opcode {
		Opname:   "fmin_common",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_mix = &Opcode {
		Opname:   "mix",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_radians = &Opcode {
		Opname:   "radians",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'degrees'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_step = &Opcode {
		Opname:   "step",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'edge'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_smoothstep = &Opcode {
		Opname:   "smoothstep",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'edge0'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'edge1'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_sign = &Opcode {
		Opname:   "sign",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_cross = &Opcode {
		Opname:   "cross",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p0'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p1'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_distance = &Opcode {
		Opname:   "distance",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p0'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p1'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_length = &Opcode {
		Opname:   "length",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_normalize = &Opcode {
		Opname:   "normalize",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fast_distance = &Opcode {
		Opname:   "fast_distance",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p0'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p1'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fast_length = &Opcode {
		Opname:   "fast_length",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_fast_normalize = &Opcode {
		Opname:   "fast_normalize",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_bitselect = &Opcode {
		Opname:   "bitselect",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'b'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'c'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_select = &Opcode {
		Opname:   "select",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'a'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'b'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'c'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vloadn = &Opcode {
		Opname:   "vloadn",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'n'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vstoren = &Opcode {
		Opname:   "vstoren",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vload_half = &Opcode {
		Opname:   "vload_half",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vload_halfn = &Opcode {
		Opname:   "vload_halfn",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'n'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vstore_half = &Opcode {
		Opname:   "vstore_half",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vstore_half_r = &Opcode {
		Opname:   "vstore_half_r",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindFPRoundingMode,
				Name:       "'mode'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vstore_halfn = &Opcode {
		Opname:   "vstore_halfn",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vstore_halfn_r = &Opcode {
		Opname:   "vstore_halfn_r",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindFPRoundingMode,
				Name:       "'mode'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vloada_halfn = &Opcode {
		Opname:   "vloada_halfn",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'n'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vstorea_halfn = &Opcode {
		Opname:   "vstorea_halfn",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_vstorea_halfn_r = &Opcode {
		Opname:   "vstorea_halfn_r",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'data'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'p'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindFPRoundingMode,
				Name:       "'mode'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_shuffle = &Opcode {
		Opname:   "shuffle",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'shuffle mask'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_shuffle2 = &Opcode {
		Opname:   "shuffle2",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'x'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'y'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'shuffle mask'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLStd_printf = &Opcode {
		Opname:   "printf",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'format'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'additional arguments'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLStd_prefetch = &Opcode {
		Opname:   "prefetch",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'ptr'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'num elements'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugInfoNone = &Opcode {
		Opname:   "DebugInfoNone",
		Operands: []Operand {
		},
	}
	OpenCLDebugInfo100_DebugCompilationUnit = &Opcode {
		Opname:   "DebugCompilationUnit",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Version'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'DWARF Version'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindSourceLanguage,
				Name:       "'Language'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeBasic = &Opcode {
		Opname:   "DebugTypeBasic",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugBaseTypeAttributeEncoding,
				Name:       "'Encoding'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypePointer = &Opcode {
		Opname:   "DebugTypePointer",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindStorageClass,
				Name:       "'Storage Class'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeQualifier = &Opcode {
		Opname:   "DebugTypeQualifier",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugTypeQualifier,
				Name:       "'Type Qualifier'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeArray = &Opcode {
		Opname:   "DebugTypeArray",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Component Counts'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeVector = &Opcode {
		Opname:   "DebugTypeVector",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Component Count'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypedef = &Opcode {
		Opname:   "DebugTypedef",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Base Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeFunction = &Opcode {
		Opname:   "DebugTypeFunction",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Return Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parameter Types'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeEnum = &Opcode {
		Opname:   "DebugTypeEnum",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Underlying Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindPairIdRefIdRef,
				Name:       "'Value, Name, Value, Name, ...'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeComposite = &Opcode {
		Opname:   "DebugTypeComposite",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugCompositeType,
				Name:       "'Tag'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Linkage Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Members'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeMember = &Opcode {
		Opname:   "DebugTypeMember",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "?",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeInheritance = &Opcode {
		Opname:   "DebugTypeInheritance",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Child'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Offset'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Size'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypePtrToMember = &Opcode {
		Opname:   "DebugTypePtrToMember",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Member Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeTemplate = &Opcode {
		Opname:   "DebugTypeTemplate",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Target'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parameters'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeTemplateParameter = &Opcode {
		Opname:   "DebugTypeTemplateParameter",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Actual Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeTemplateTemplateParameter = &Opcode {
		Opname:   "DebugTypeTemplateTemplateParameter",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Template Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugTypeTemplateParameterPack = &Opcode {
		Opname:   "DebugTypeTemplateParameterPack",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Template Parameters'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugGlobalVariable = &Opcode {
		Opname:   "DebugGlobalVariable",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Linkage Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Variable'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Static Member Declaration'",
				Quantifier: "?",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugFunctionDeclaration = &Opcode {
		Opname:   "DebugFunctionDeclaration",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Linkage Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugFunction = &Opcode {
		Opname:   "DebugFunction",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Linkage Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Scope Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Function'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Declaration'",
				Quantifier: "?",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugLexicalBlock = &Opcode {
		Opname:   "DebugLexicalBlock",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "?",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugLexicalBlockDiscriminator = &Opcode {
		Opname:   "DebugLexicalBlockDiscriminator",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Discriminator'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugScope = &Opcode {
		Opname:   "DebugScope",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Scope'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Inlined At'",
				Quantifier: "?",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugNoScope = &Opcode {
		Opname:   "DebugNoScope",
		Operands: []Operand {
		},
	}
	OpenCLDebugInfo100_DebugInlinedAt = &Opcode {
		Opname:   "DebugInlinedAt",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Scope'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Inlined'",
				Quantifier: "?",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugLocalVariable = &Opcode {
		Opname:   "DebugLocalVariable",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Type'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugInfoFlags,
				Name:       "'Flags'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Arg Number'",
				Quantifier: "?",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugInlinedVariable = &Opcode {
		Opname:   "DebugInlinedVariable",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Variable'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Inlined'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugDeclare = &Opcode {
		Opname:   "DebugDeclare",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Local Variable'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Variable'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Expression'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugValue = &Opcode {
		Opname:   "DebugValue",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Local Variable'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Expression'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Indexes'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugOperation = &Opcode {
		Opname:   "DebugOperation",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindDebugOperation,
				Name:       "'OpCode'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Operands ...'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugExpression = &Opcode {
		Opname:   "DebugExpression",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Operands ...'",
				Quantifier: "*",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugMacroDef = &Opcode {
		Opname:   "DebugMacroDef",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Value'",
				Quantifier: "?",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugMacroUndef = &Opcode {
		Opname:   "DebugMacroUndef",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Macro'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugImportedEntity = &Opcode {
		Opname:   "DebugImportedEntity",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Name'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindDebugImportedEntity,
				Name:       "'Tag'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Source'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Entity'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Line'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindLiteralInteger,
				Name:       "'Column'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Parent'",
				Quantifier: "",
			}, 
		},
	}
	OpenCLDebugInfo100_DebugSource = &Opcode {
		Opname:   "DebugSource",
		Operands: []Operand {
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'File'",
				Quantifier: "",
			}, 
			Operand {
				Kind:       OperandKindIdRef,
				Name:       "'Text'",
				Quantifier: "?",
			}, 
		},
	}


	OperandKindImageOperands = &OperandKind {
		Kind:       "ImageOperands",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Bias",
				Value:        0x0001,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Lod",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Grad",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, ""},{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ConstOffset",
				Value:        0x0008,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Offset",
				Value:        0x0010,
				Capabilities: []string{"ImageGatherExtended",},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ConstOffsets",
				Value:        0x0020,
				Capabilities: []string{"ImageGatherExtended",},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sample",
				Value:        0x0040,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MinLod",
				Value:        0x0080,
				Capabilities: []string{"MinLod",},
				Parameters:   []Parameter{{OperandKindIdRef, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MakeTexelAvailable",
				Value:        0x0100,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeTexelAvailableKHR",
				Value:        0x0100,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeTexelVisible",
				Value:        0x0200,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeTexelVisibleKHR",
				Value:        0x0200,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonPrivateTexel",
				Value:        0x0400,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonPrivateTexelKHR",
				Value:        0x0400,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VolatileTexel",
				Value:        0x0800,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VolatileTexelKHR",
				Value:        0x0800,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "SignExtend",
				Value:        0x1000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "ZeroExtend",
				Value:        0x2000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindFPFastMathMode = &OperandKind {
		Kind:       "FPFastMathMode",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NotNaN",
				Value:        0x0001,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NotInf",
				Value:        0x0002,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NSZ",
				Value:        0x0004,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AllowRecip",
				Value:        0x0008,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Fast",
				Value:        0x0010,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindSelectionControl = &OperandKind {
		Kind:       "SelectionControl",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Flatten",
				Value:        0x0001,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DontFlatten",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLoopControl = &OperandKind {
		Kind:       "LoopControl",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Unroll",
				Value:        0x0001,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DontUnroll",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DependencyInfinite",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "DependencyLength",
				Value:        0x0008,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "MinIterations",
				Value:        0x0010,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "MaxIterations",
				Value:        0x0020,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "IterationMultiple",
				Value:        0x0040,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "PeelCount",
				Value:        0x0080,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "PartialCount",
				Value:        0x0100,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "1.4",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindFunctionControl = &OperandKind {
		Kind:       "FunctionControl",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Inline",
				Value:        0x0001,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DontInline",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Pure",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Const",
				Value:        0x0008,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindMemorySemantics = &OperandKind {
		Kind:       "MemorySemantics",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Relaxed",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Acquire",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Release",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AcquireRelease",
				Value:        0x0008,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SequentiallyConsistent",
				Value:        0x0010,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UniformMemory",
				Value:        0x0040,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupMemory",
				Value:        0x0080,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WorkgroupMemory",
				Value:        0x0100,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CrossWorkgroupMemory",
				Value:        0x0200,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AtomicCounterMemory",
				Value:        0x0400,
				Capabilities: []string{"AtomicStorage",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageMemory",
				Value:        0x0800,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputMemory",
				Value:        0x1000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "OutputMemoryKHR",
				Value:        0x1000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeAvailable",
				Value:        0x2000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeAvailableKHR",
				Value:        0x2000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeVisible",
				Value:        0x4000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakeVisibleKHR",
				Value:        0x4000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "Volatile",
				Value:        0x8000,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindMemoryAccess = &OperandKind {
		Kind:       "MemoryAccess",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Volatile",
				Value:        0x0001,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Aligned",
				Value:        0x0002,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Nontemporal",
				Value:        0x0004,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MakePointerAvailable",
				Value:        0x0008,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakePointerAvailableKHR",
				Value:        0x0008,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakePointerVisible",
				Value:        0x0010,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "MakePointerVisibleKHR",
				Value:        0x0010,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{{OperandKindIdScope, ""},},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonPrivatePointer",
				Value:        0x0020,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonPrivatePointerKHR",
				Value:        0x0020,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindKernelProfilingInfo = &OperandKind {
		Kind:       "KernelProfilingInfo",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0x0000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CmdExecTime",
				Value:        0x0001,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindRayFlags = &OperandKind {
		Kind:       "RayFlags",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "NoneKHR",
				Value:        0x0000,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OpaqueKHR",
				Value:        0x0001,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoOpaqueKHR",
				Value:        0x0002,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TerminateOnFirstHitKHR",
				Value:        0x0004,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SkipClosestHitShaderKHR",
				Value:        0x0008,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CullBackFacingTrianglesKHR",
				Value:        0x0010,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CullFrontFacingTrianglesKHR",
				Value:        0x0020,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CullOpaqueKHR",
				Value:        0x0040,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CullNoOpaqueKHR",
				Value:        0x0080,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SkipTrianglesKHR",
				Value:        0x0100,
				Capabilities: []string{"RayTraversalPrimitiveCullingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SkipAABBsKHR",
				Value:        0x0200,
				Capabilities: []string{"RayTraversalPrimitiveCullingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindSourceLanguage = &OperandKind {
		Kind:       "SourceLanguage",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Unknown",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ESSL",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLSL",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OpenCL_C",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OpenCL_CPP",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "HLSL",
				Value:        5,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindExecutionModel = &OperandKind {
		Kind:       "ExecutionModel",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Vertex",
				Value:        0,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessellationControl",
				Value:        1,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessellationEvaluation",
				Value:        2,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Geometry",
				Value:        3,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Fragment",
				Value:        4,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLCompute",
				Value:        5,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Kernel",
				Value:        6,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TaskNV",
				Value:        5267,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MeshNV",
				Value:        5268,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayGenerationNV",
				Value:        5313,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayGenerationKHR",
				Value:        5313,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IntersectionNV",
				Value:        5314,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IntersectionKHR",
				Value:        5314,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "AnyHitNV",
				Value:        5315,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "AnyHitKHR",
				Value:        5315,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ClosestHitNV",
				Value:        5316,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ClosestHitKHR",
				Value:        5316,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MissNV",
				Value:        5317,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MissKHR",
				Value:        5317,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "CallableNV",
				Value:        5318,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "CallableKHR",
				Value:        5318,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindAddressingModel = &OperandKind {
		Kind:       "AddressingModel",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Logical",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Physical32",
				Value:        1,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Physical64",
				Value:        2,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBuffer64",
				Value:        5348,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBuffer64EXT",
				Value:        5348,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindMemoryModel = &OperandKind {
		Kind:       "MemoryModel",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Simple",
				Value:        0,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLSL450",
				Value:        1,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OpenCL",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Vulkan",
				Value:        3,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VulkanKHR",
				Value:        3,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindExecutionMode = &OperandKind {
		Kind:       "ExecutionMode",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Invocations",
				Value:        0,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Number of <<Invocation,invocations>>'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SpacingEqual",
				Value:        1,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SpacingFractionalEven",
				Value:        2,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SpacingFractionalOdd",
				Value:        3,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VertexOrderCw",
				Value:        4,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VertexOrderCcw",
				Value:        5,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PixelCenterInteger",
				Value:        6,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OriginUpperLeft",
				Value:        7,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OriginLowerLeft",
				Value:        8,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "EarlyFragmentTests",
				Value:        9,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PointMode",
				Value:        10,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Xfb",
				Value:        11,
				Capabilities: []string{"TransformFeedback",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthReplacing",
				Value:        12,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthGreater",
				Value:        14,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthLess",
				Value:        15,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthUnchanged",
				Value:        16,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LocalSize",
				Value:        17,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'x size'"},{OperandKindLiteralInteger, "'y size'"},{OperandKindLiteralInteger, "'z size'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LocalSizeHint",
				Value:        18,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'x size'"},{OperandKindLiteralInteger, "'y size'"},{OperandKindLiteralInteger, "'z size'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputPoints",
				Value:        19,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputLines",
				Value:        20,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputLinesAdjacency",
				Value:        21,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Triangles",
				Value:        22,
				Capabilities: []string{"Geometry","Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputTrianglesAdjacency",
				Value:        23,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Quads",
				Value:        24,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Isolines",
				Value:        25,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputVertices",
				Value:        26,
				Capabilities: []string{"Geometry","Tessellation","MeshShadingNV",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Vertex count'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputPoints",
				Value:        27,
				Capabilities: []string{"Geometry","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputLineStrip",
				Value:        28,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "OutputTriangleStrip",
				Value:        29,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VecTypeHint",
				Value:        30,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Vector type'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ContractionOff",
				Value:        31,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Initializer",
				Value:        33,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "Finalizer",
				Value:        34,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "SubgroupSize",
				Value:        35,
				Capabilities: []string{"SubgroupDispatch",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Subgroup Size'"},},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "SubgroupsPerWorkgroup",
				Value:        36,
				Capabilities: []string{"SubgroupDispatch",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Subgroups Per Workgroup'"},},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "SubgroupsPerWorkgroupId",
				Value:        37,
				Capabilities: []string{"SubgroupDispatch",},
				Parameters:   []Parameter{{OperandKindIdRef, "'Subgroups Per Workgroup'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "LocalSizeId",
				Value:        38,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, "'x size'"},{OperandKindIdRef, "'y size'"},{OperandKindIdRef, "'z size'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "LocalSizeHintId",
				Value:        39,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindIdRef, "'Local Size Hint'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "PostDepthCoverage",
				Value:        4446,
				Capabilities: []string{"SampleMaskPostDepthCoverage",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DenormPreserve",
				Value:        4459,
				Capabilities: []string{"DenormPreserve",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "DenormFlushToZero",
				Value:        4460,
				Capabilities: []string{"DenormFlushToZero",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "SignedZeroInfNanPreserve",
				Value:        4461,
				Capabilities: []string{"SignedZeroInfNanPreserve",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RoundingModeRTE",
				Value:        4462,
				Capabilities: []string{"RoundingModeRTE",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RoundingModeRTZ",
				Value:        4463,
				Capabilities: []string{"RoundingModeRTZ",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Target Width'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "StencilRefReplacingEXT",
				Value:        5027,
				Capabilities: []string{"StencilExportEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "OutputLinesNV",
				Value:        5269,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "OutputPrimitivesNV",
				Value:        5270,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Primitive count'"},},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DerivativeGroupQuadsNV",
				Value:        5289,
				Capabilities: []string{"ComputeDerivativeGroupQuadsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DerivativeGroupLinearNV",
				Value:        5290,
				Capabilities: []string{"ComputeDerivativeGroupLinearNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "OutputTrianglesNV",
				Value:        5298,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PixelInterlockOrderedEXT",
				Value:        5366,
				Capabilities: []string{"FragmentShaderPixelInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PixelInterlockUnorderedEXT",
				Value:        5367,
				Capabilities: []string{"FragmentShaderPixelInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SampleInterlockOrderedEXT",
				Value:        5368,
				Capabilities: []string{"FragmentShaderSampleInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SampleInterlockUnorderedEXT",
				Value:        5369,
				Capabilities: []string{"FragmentShaderSampleInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShadingRateInterlockOrderedEXT",
				Value:        5370,
				Capabilities: []string{"FragmentShaderShadingRateInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShadingRateInterlockUnorderedEXT",
				Value:        5371,
				Capabilities: []string{"FragmentShaderShadingRateInterlockEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindStorageClass = &OperandKind {
		Kind:       "StorageClass",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "UniformConstant",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Input",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Uniform",
				Value:        2,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Output",
				Value:        3,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Workgroup",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CrossWorkgroup",
				Value:        5,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Private",
				Value:        6,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Function",
				Value:        7,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Generic",
				Value:        8,
				Capabilities: []string{"GenericPointer",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PushConstant",
				Value:        9,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AtomicCounter",
				Value:        10,
				Capabilities: []string{"AtomicStorage",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Image",
				Value:        11,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageBuffer",
				Value:        12,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "CallableDataNV",
				Value:        5328,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "CallableDataKHR",
				Value:        5328,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingCallableDataNV",
				Value:        5329,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingCallableDataKHR",
				Value:        5329,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayPayloadNV",
				Value:        5338,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayPayloadKHR",
				Value:        5338,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitAttributeNV",
				Value:        5339,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitAttributeKHR",
				Value:        5339,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingRayPayloadNV",
				Value:        5342,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingRayPayloadKHR",
				Value:        5342,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderRecordBufferNV",
				Value:        5343,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderRecordBufferKHR",
				Value:        5343,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBuffer",
				Value:        5349,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBufferEXT",
				Value:        5349,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDim = &OperandKind {
		Kind:       "Dim",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "1D",
				Value:        0,
				Capabilities: []string{"Sampled1D","Image1D",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "2D",
				Value:        1,
				Capabilities: []string{"Shader","Kernel","ImageMSArray",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "3D",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Cube",
				Value:        3,
				Capabilities: []string{"Shader","ImageCubeArray",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rect",
				Value:        4,
				Capabilities: []string{"SampledRect","ImageRect",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Buffer",
				Value:        5,
				Capabilities: []string{"SampledBuffer","ImageBuffer",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubpassData",
				Value:        6,
				Capabilities: []string{"InputAttachment",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindSamplerAddressingMode = &OperandKind {
		Kind:       "SamplerAddressingMode",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "None",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ClampToEdge",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Clamp",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Repeat",
				Value:        3,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RepeatMirrored",
				Value:        4,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindSamplerFilterMode = &OperandKind {
		Kind:       "SamplerFilterMode",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Nearest",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Linear",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindImageFormat = &OperandKind {
		Kind:       "ImageFormat",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Unknown",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba32f",
				Value:        1,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16f",
				Value:        2,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R32f",
				Value:        3,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba8",
				Value:        4,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba8Snorm",
				Value:        5,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg32f",
				Value:        6,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16f",
				Value:        7,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R11fG11fB10f",
				Value:        8,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16f",
				Value:        9,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16",
				Value:        10,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgb10A2",
				Value:        11,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16",
				Value:        12,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg8",
				Value:        13,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16",
				Value:        14,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R8",
				Value:        15,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16Snorm",
				Value:        16,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16Snorm",
				Value:        17,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg8Snorm",
				Value:        18,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16Snorm",
				Value:        19,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R8Snorm",
				Value:        20,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba32i",
				Value:        21,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16i",
				Value:        22,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba8i",
				Value:        23,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R32i",
				Value:        24,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg32i",
				Value:        25,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16i",
				Value:        26,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg8i",
				Value:        27,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16i",
				Value:        28,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R8i",
				Value:        29,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba32ui",
				Value:        30,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba16ui",
				Value:        31,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgba8ui",
				Value:        32,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R32ui",
				Value:        33,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rgb10a2ui",
				Value:        34,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg32ui",
				Value:        35,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg16ui",
				Value:        36,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rg8ui",
				Value:        37,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R16ui",
				Value:        38,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "R8ui",
				Value:        39,
				Capabilities: []string{"StorageImageExtendedFormats",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindImageChannelOrder = &OperandKind {
		Kind:       "ImageChannelOrder",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "R",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "A",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RG",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RA",
				Value:        3,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RGB",
				Value:        4,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RGBA",
				Value:        5,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "BGRA",
				Value:        6,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ARGB",
				Value:        7,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Intensity",
				Value:        8,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Luminance",
				Value:        9,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Rx",
				Value:        10,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RGx",
				Value:        11,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RGBx",
				Value:        12,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Depth",
				Value:        13,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DepthStencil",
				Value:        14,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "sRGB",
				Value:        15,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "sRGBx",
				Value:        16,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "sRGBA",
				Value:        17,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "sBGRA",
				Value:        18,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ABGR",
				Value:        19,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindImageChannelDataType = &OperandKind {
		Kind:       "ImageChannelDataType",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "SnormInt8",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SnormInt16",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt8",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt16",
				Value:        3,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormShort565",
				Value:        4,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormShort555",
				Value:        5,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt101010",
				Value:        6,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SignedInt8",
				Value:        7,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SignedInt16",
				Value:        8,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SignedInt32",
				Value:        9,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnsignedInt8",
				Value:        10,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnsignedInt16",
				Value:        11,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnsignedInt32",
				Value:        12,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "HalfFloat",
				Value:        13,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float",
				Value:        14,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt24",
				Value:        15,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnormInt101010_2",
				Value:        16,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindFPRoundingMode = &OperandKind {
		Kind:       "FPRoundingMode",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "RTE",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RTZ",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RTP",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RTN",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLinkageType = &OperandKind {
		Kind:       "LinkageType",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Export",
				Value:        0,
				Capabilities: []string{"Linkage",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Import",
				Value:        1,
				Capabilities: []string{"Linkage",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindAccessQualifier = &OperandKind {
		Kind:       "AccessQualifier",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "ReadOnly",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WriteOnly",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ReadWrite",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindFunctionParameterAttribute = &OperandKind {
		Kind:       "FunctionParameterAttribute",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Zext",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sext",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ByVal",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sret",
				Value:        3,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoAlias",
				Value:        4,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoCapture",
				Value:        5,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoWrite",
				Value:        6,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoReadWrite",
				Value:        7,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDecoration = &OperandKind {
		Kind:       "Decoration",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "RelaxedPrecision",
				Value:        0,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SpecId",
				Value:        1,
				Capabilities: []string{"Shader","Kernel",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Specialization Constant ID'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Block",
				Value:        2,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "BufferBlock",
				Value:        3,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RowMajor",
				Value:        4,
				Capabilities: []string{"Matrix",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ColMajor",
				Value:        5,
				Capabilities: []string{"Matrix",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ArrayStride",
				Value:        6,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Array Stride'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MatrixStride",
				Value:        7,
				Capabilities: []string{"Matrix",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Matrix Stride'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLSLShared",
				Value:        8,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GLSLPacked",
				Value:        9,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CPacked",
				Value:        10,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "BuiltIn",
				Value:        11,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindBuiltIn, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoPerspective",
				Value:        13,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Flat",
				Value:        14,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Patch",
				Value:        15,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Centroid",
				Value:        16,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sample",
				Value:        17,
				Capabilities: []string{"SampleRateShading",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Invariant",
				Value:        18,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Restrict",
				Value:        19,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Aliased",
				Value:        20,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Volatile",
				Value:        21,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Constant",
				Value:        22,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Coherent",
				Value:        23,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NonWritable",
				Value:        24,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NonReadable",
				Value:        25,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Uniform",
				Value:        26,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UniformId",
				Value:        27,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindIdScope, "'Execution'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "SaturatedConversion",
				Value:        28,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Stream",
				Value:        29,
				Capabilities: []string{"GeometryStreams",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Stream Number'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Location",
				Value:        30,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Location'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Component",
				Value:        31,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Component'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Index",
				Value:        32,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Index'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Binding",
				Value:        33,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Binding Point'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DescriptorSet",
				Value:        34,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Descriptor Set'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Offset",
				Value:        35,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Byte Offset'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "XfbBuffer",
				Value:        36,
				Capabilities: []string{"TransformFeedback",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'XFB Buffer Number'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "XfbStride",
				Value:        37,
				Capabilities: []string{"TransformFeedback",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'XFB Stride'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FuncParamAttr",
				Value:        38,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindFunctionParameterAttribute, "'Function Parameter Attribute'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FPRoundingMode",
				Value:        39,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindFPRoundingMode, "'Floating-Point Rounding Mode'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FPFastMathMode",
				Value:        40,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindFPFastMathMode, "'Fast-Math Mode'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LinkageAttributes",
				Value:        41,
				Capabilities: []string{"Linkage",},
				Parameters:   []Parameter{{OperandKindLiteralString, "'Name'"},{OperandKindLinkageType, "'Linkage Type'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NoContraction",
				Value:        42,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputAttachmentIndex",
				Value:        43,
				Capabilities: []string{"InputAttachment",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Attachment Index'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Alignment",
				Value:        44,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Alignment'"},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MaxByteOffset",
				Value:        45,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Max Byte Offset'"},},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "AlignmentId",
				Value:        46,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{{OperandKindIdRef, "'Alignment'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "MaxByteOffsetId",
				Value:        47,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{{OperandKindIdRef, "'Max Byte Offset'"},},
				Version:      "1.2",
			},
			Enumerant{
				Enumerant:    "NoSignedWrap",
				Value:        4469,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "NoUnsignedWrap",
				Value:        4470,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "ExplicitInterpAMD",
				Value:        4999,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "OverrideCoverageNV",
				Value:        5248,
				Capabilities: []string{"SampleMaskOverrideCoverageNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PassthroughNV",
				Value:        5250,
				Capabilities: []string{"GeometryShaderPassthroughNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ViewportRelativeNV",
				Value:        5252,
				Capabilities: []string{"ShaderViewportMaskNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SecondaryViewportRelativeNV",
				Value:        5256,
				Capabilities: []string{"ShaderStereoViewNV",},
				Parameters:   []Parameter{{OperandKindLiteralInteger, "'Offset'"},},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerPrimitiveNV",
				Value:        5271,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerViewNV",
				Value:        5272,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerTaskNV",
				Value:        5273,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerVertexNV",
				Value:        5285,
				Capabilities: []string{"FragmentBarycentricNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "NonUniform",
				Value:        5300,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "NonUniformEXT",
				Value:        5300,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RestrictPointer",
				Value:        5355,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RestrictPointerEXT",
				Value:        5355,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "AliasedPointer",
				Value:        5356,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "AliasedPointerEXT",
				Value:        5356,
				Capabilities: []string{"PhysicalStorageBufferAddresses",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "CounterBuffer",
				Value:        5634,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, "'Counter Buffer'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "HlslCounterBufferGOOGLE",
				Value:        5634,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindIdRef, "'Counter Buffer'"},},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "UserSemantic",
				Value:        5635,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralString, "'Semantic'"},},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "HlslSemanticGOOGLE",
				Value:        5635,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralString, "'Semantic'"},},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "UserTypeGOOGLE",
				Value:        5636,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralString, "'User Type'"},},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindBuiltIn = &OperandKind {
		Kind:       "BuiltIn",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Position",
				Value:        0,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PointSize",
				Value:        1,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ClipDistance",
				Value:        3,
				Capabilities: []string{"ClipDistance",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CullDistance",
				Value:        4,
				Capabilities: []string{"CullDistance",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VertexId",
				Value:        5,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InstanceId",
				Value:        6,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PrimitiveId",
				Value:        7,
				Capabilities: []string{"Geometry","Tessellation","RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InvocationId",
				Value:        8,
				Capabilities: []string{"Geometry","Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Layer",
				Value:        9,
				Capabilities: []string{"Geometry","ShaderLayer","ShaderViewportIndexLayerEXT",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ViewportIndex",
				Value:        10,
				Capabilities: []string{"MultiViewport","ShaderViewportIndex","ShaderViewportIndexLayerEXT",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessLevelOuter",
				Value:        11,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessLevelInner",
				Value:        12,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessCoord",
				Value:        13,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PatchVertices",
				Value:        14,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FragCoord",
				Value:        15,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PointCoord",
				Value:        16,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FrontFacing",
				Value:        17,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampleId",
				Value:        18,
				Capabilities: []string{"SampleRateShading",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SamplePosition",
				Value:        19,
				Capabilities: []string{"SampleRateShading",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampleMask",
				Value:        20,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FragDepth",
				Value:        22,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "HelperInvocation",
				Value:        23,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NumWorkgroups",
				Value:        24,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WorkgroupSize",
				Value:        25,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WorkgroupId",
				Value:        26,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LocalInvocationId",
				Value:        27,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GlobalInvocationId",
				Value:        28,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LocalInvocationIndex",
				Value:        29,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WorkDim",
				Value:        30,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GlobalSize",
				Value:        31,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "EnqueuedWorkgroupSize",
				Value:        32,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GlobalOffset",
				Value:        33,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GlobalLinearId",
				Value:        34,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupSize",
				Value:        36,
				Capabilities: []string{"Kernel","GroupNonUniform","SubgroupBallotKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupMaxSize",
				Value:        37,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NumSubgroups",
				Value:        38,
				Capabilities: []string{"Kernel","GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "NumEnqueuedSubgroups",
				Value:        39,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupId",
				Value:        40,
				Capabilities: []string{"Kernel","GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupLocalInvocationId",
				Value:        41,
				Capabilities: []string{"Kernel","GroupNonUniform","SubgroupBallotKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VertexIndex",
				Value:        42,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InstanceIndex",
				Value:        43,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupEqMask",
				Value:        4416,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupGeMask",
				Value:        4417,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupGtMask",
				Value:        4418,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupLeMask",
				Value:        4419,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupLtMask",
				Value:        4420,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupEqMaskKHR",
				Value:        4416,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupGeMaskKHR",
				Value:        4417,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupGtMaskKHR",
				Value:        4418,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupLeMaskKHR",
				Value:        4419,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupLtMaskKHR",
				Value:        4420,
				Capabilities: []string{"SubgroupBallotKHR","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "BaseVertex",
				Value:        4424,
				Capabilities: []string{"DrawParameters",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "BaseInstance",
				Value:        4425,
				Capabilities: []string{"DrawParameters",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "DrawIndex",
				Value:        4426,
				Capabilities: []string{"DrawParameters","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "DeviceIndex",
				Value:        4438,
				Capabilities: []string{"DeviceGroup",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "ViewIndex",
				Value:        4440,
				Capabilities: []string{"MultiView",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "BaryCoordNoPerspAMD",
				Value:        4992,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordNoPerspCentroidAMD",
				Value:        4993,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordNoPerspSampleAMD",
				Value:        4994,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordSmoothAMD",
				Value:        4995,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordSmoothCentroidAMD",
				Value:        4996,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordSmoothSampleAMD",
				Value:        4997,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordPullModelAMD",
				Value:        4998,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragStencilRefEXT",
				Value:        5014,
				Capabilities: []string{"StencilExportEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ViewportMaskNV",
				Value:        5253,
				Capabilities: []string{"ShaderViewportMaskNV","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SecondaryPositionNV",
				Value:        5257,
				Capabilities: []string{"ShaderStereoViewNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SecondaryViewportMaskNV",
				Value:        5258,
				Capabilities: []string{"ShaderStereoViewNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PositionPerViewNV",
				Value:        5261,
				Capabilities: []string{"PerViewAttributesNV","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ViewportMaskPerViewNV",
				Value:        5262,
				Capabilities: []string{"PerViewAttributesNV","MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FullyCoveredEXT",
				Value:        5264,
				Capabilities: []string{"FragmentFullyCoveredEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "TaskCountNV",
				Value:        5274,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PrimitiveCountNV",
				Value:        5275,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PrimitiveIndicesNV",
				Value:        5276,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ClipDistancePerViewNV",
				Value:        5277,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "CullDistancePerViewNV",
				Value:        5278,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "LayerPerViewNV",
				Value:        5279,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MeshViewCountNV",
				Value:        5280,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MeshViewIndicesNV",
				Value:        5281,
				Capabilities: []string{"MeshShadingNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordNV",
				Value:        5286,
				Capabilities: []string{"FragmentBarycentricNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "BaryCoordNoPerspNV",
				Value:        5287,
				Capabilities: []string{"FragmentBarycentricNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragSizeEXT",
				Value:        5292,
				Capabilities: []string{"FragmentDensityEXT","ShadingRateNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentSizeNV",
				Value:        5292,
				Capabilities: []string{"ShadingRateNV","FragmentDensityEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragInvocationCountEXT",
				Value:        5293,
				Capabilities: []string{"FragmentDensityEXT","ShadingRateNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "InvocationsPerPixelNV",
				Value:        5293,
				Capabilities: []string{"ShadingRateNV","FragmentDensityEXT",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "LaunchIdNV",
				Value:        5319,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "LaunchIdKHR",
				Value:        5319,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "LaunchSizeNV",
				Value:        5320,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "LaunchSizeKHR",
				Value:        5320,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldRayOriginNV",
				Value:        5321,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldRayOriginKHR",
				Value:        5321,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldRayDirectionNV",
				Value:        5322,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldRayDirectionKHR",
				Value:        5322,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectRayOriginNV",
				Value:        5323,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectRayOriginKHR",
				Value:        5323,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectRayDirectionNV",
				Value:        5324,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectRayDirectionKHR",
				Value:        5324,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayTminNV",
				Value:        5325,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayTminKHR",
				Value:        5325,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayTmaxNV",
				Value:        5326,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayTmaxKHR",
				Value:        5326,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "InstanceCustomIndexNV",
				Value:        5327,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "InstanceCustomIndexKHR",
				Value:        5327,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectToWorldNV",
				Value:        5330,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ObjectToWorldKHR",
				Value:        5330,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldToObjectNV",
				Value:        5331,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WorldToObjectKHR",
				Value:        5331,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitTNV",
				Value:        5332,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitTKHR",
				Value:        5332,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitKindNV",
				Value:        5333,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "HitKindKHR",
				Value:        5333,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingRayFlagsNV",
				Value:        5351,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IncomingRayFlagsKHR",
				Value:        5351,
				Capabilities: []string{"RayTracingNV","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayGeometryIndexKHR",
				Value:        5352,
				Capabilities: []string{"RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WarpsPerSMNV",
				Value:        5374,
				Capabilities: []string{"ShaderSMBuiltinsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SMCountNV",
				Value:        5375,
				Capabilities: []string{"ShaderSMBuiltinsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "WarpIDNV",
				Value:        5376,
				Capabilities: []string{"ShaderSMBuiltinsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SMIDNV",
				Value:        5377,
				Capabilities: []string{"ShaderSMBuiltinsNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindScope = &OperandKind {
		Kind:       "Scope",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "CrossDevice",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Device",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Workgroup",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Subgroup",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Invocation",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "QueueFamily",
				Value:        5,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "QueueFamilyKHR",
				Value:        5,
				Capabilities: []string{"VulkanMemoryModel",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "ShaderCallKHR",
				Value:        6,
				Capabilities: []string{"RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindGroupOperation = &OperandKind {
		Kind:       "GroupOperation",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Reduce",
				Value:        0,
				Capabilities: []string{"Kernel","GroupNonUniformArithmetic","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InclusiveScan",
				Value:        1,
				Capabilities: []string{"Kernel","GroupNonUniformArithmetic","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ExclusiveScan",
				Value:        2,
				Capabilities: []string{"Kernel","GroupNonUniformArithmetic","GroupNonUniformBallot",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ClusteredReduce",
				Value:        3,
				Capabilities: []string{"GroupNonUniformClustered",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "PartitionedReduceNV",
				Value:        6,
				Capabilities: []string{"GroupNonUniformPartitionedNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PartitionedInclusiveScanNV",
				Value:        7,
				Capabilities: []string{"GroupNonUniformPartitionedNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PartitionedExclusiveScanNV",
				Value:        8,
				Capabilities: []string{"GroupNonUniformPartitionedNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindKernelEnqueueFlags = &OperandKind {
		Kind:       "KernelEnqueueFlags",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "NoWait",
				Value:        0,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WaitKernel",
				Value:        1,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "WaitWorkGroup",
				Value:        2,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindCapability = &OperandKind {
		Kind:       "Capability",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Matrix",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Shader",
				Value:        1,
				Capabilities: []string{"Matrix",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Geometry",
				Value:        2,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Tessellation",
				Value:        3,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Addresses",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Linkage",
				Value:        5,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Kernel",
				Value:        6,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Vector16",
				Value:        7,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float16Buffer",
				Value:        8,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float16",
				Value:        9,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float64",
				Value:        10,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Int64",
				Value:        11,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Int64Atomics",
				Value:        12,
				Capabilities: []string{"Int64",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageBasic",
				Value:        13,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageReadWrite",
				Value:        14,
				Capabilities: []string{"ImageBasic",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageMipmap",
				Value:        15,
				Capabilities: []string{"ImageBasic",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Pipes",
				Value:        17,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Groups",
				Value:        18,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DeviceEnqueue",
				Value:        19,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "LiteralSampler",
				Value:        20,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AtomicStorage",
				Value:        21,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Int16",
				Value:        22,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TessellationPointSize",
				Value:        23,
				Capabilities: []string{"Tessellation",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GeometryPointSize",
				Value:        24,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageGatherExtended",
				Value:        25,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageMultisample",
				Value:        27,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UniformBufferArrayDynamicIndexing",
				Value:        28,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampledImageArrayDynamicIndexing",
				Value:        29,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageBufferArrayDynamicIndexing",
				Value:        30,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageArrayDynamicIndexing",
				Value:        31,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ClipDistance",
				Value:        32,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "CullDistance",
				Value:        33,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageCubeArray",
				Value:        34,
				Capabilities: []string{"SampledCubeArray",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampleRateShading",
				Value:        35,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageRect",
				Value:        36,
				Capabilities: []string{"SampledRect",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampledRect",
				Value:        37,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GenericPointer",
				Value:        38,
				Capabilities: []string{"Addresses",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Int8",
				Value:        39,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InputAttachment",
				Value:        40,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SparseResidency",
				Value:        41,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MinLod",
				Value:        42,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Sampled1D",
				Value:        43,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Image1D",
				Value:        44,
				Capabilities: []string{"Sampled1D",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampledCubeArray",
				Value:        45,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SampledBuffer",
				Value:        46,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageBuffer",
				Value:        47,
				Capabilities: []string{"SampledBuffer",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageMSArray",
				Value:        48,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageExtendedFormats",
				Value:        49,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImageQuery",
				Value:        50,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "DerivativeControl",
				Value:        51,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "InterpolationFunction",
				Value:        52,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "TransformFeedback",
				Value:        53,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "GeometryStreams",
				Value:        54,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageReadWithoutFormat",
				Value:        55,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StorageImageWriteWithoutFormat",
				Value:        56,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "MultiViewport",
				Value:        57,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SubgroupDispatch",
				Value:        58,
				Capabilities: []string{"DeviceEnqueue",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "NamedBarrier",
				Value:        59,
				Capabilities: []string{"Kernel",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "PipeStorage",
				Value:        60,
				Capabilities: []string{"Pipes",},
				Parameters:   []Parameter{},
				Version:      "1.1",
			},
			Enumerant{
				Enumerant:    "GroupNonUniform",
				Value:        61,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformVote",
				Value:        62,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformArithmetic",
				Value:        63,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformBallot",
				Value:        64,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformShuffle",
				Value:        65,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformShuffleRelative",
				Value:        66,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformClustered",
				Value:        67,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformQuad",
				Value:        68,
				Capabilities: []string{"GroupNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "ShaderLayer",
				Value:        69,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "ShaderViewportIndex",
				Value:        70,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "SubgroupBallotKHR",
				Value:        4423,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DrawParameters",
				Value:        4427,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "SubgroupVoteKHR",
				Value:        4431,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "StorageBuffer16BitAccess",
				Value:        4433,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "StorageUniformBufferBlock16",
				Value:        4433,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "UniformAndStorageBuffer16BitAccess",
				Value:        4434,
				Capabilities: []string{"StorageBuffer16BitAccess","StorageUniformBufferBlock16",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "StorageUniform16",
				Value:        4434,
				Capabilities: []string{"StorageBuffer16BitAccess","StorageUniformBufferBlock16",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "StoragePushConstant16",
				Value:        4435,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "StorageInputOutput16",
				Value:        4436,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "DeviceGroup",
				Value:        4437,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "MultiView",
				Value:        4439,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "VariablePointersStorageBuffer",
				Value:        4441,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "VariablePointers",
				Value:        4442,
				Capabilities: []string{"VariablePointersStorageBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.3",
			},
			Enumerant{
				Enumerant:    "AtomicStorageOps",
				Value:        4445,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SampleMaskPostDepthCoverage",
				Value:        4447,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "StorageBuffer8BitAccess",
				Value:        4448,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformAndStorageBuffer8BitAccess",
				Value:        4449,
				Capabilities: []string{"StorageBuffer8BitAccess",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StoragePushConstant8",
				Value:        4450,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "DenormPreserve",
				Value:        4464,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "DenormFlushToZero",
				Value:        4465,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "SignedZeroInfNanPreserve",
				Value:        4466,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RoundingModeRTE",
				Value:        4467,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RoundingModeRTZ",
				Value:        4468,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.4",
			},
			Enumerant{
				Enumerant:    "RayQueryKHR",
				Value:        4471,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayTraversalPrimitiveCullingKHR",
				Value:        4478,
				Capabilities: []string{"RayQueryKHR","RayTracingKHR",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "Float16ImageAMD",
				Value:        5008,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ImageGatherBiasLodAMD",
				Value:        5009,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentMaskAMD",
				Value:        5010,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "StencilExportEXT",
				Value:        5013,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ImageReadWriteLodAMD",
				Value:        5015,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderClockKHR",
				Value:        5055,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SampleMaskOverrideCoverageNV",
				Value:        5249,
				Capabilities: []string{"SampleRateShading",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "GeometryShaderPassthroughNV",
				Value:        5251,
				Capabilities: []string{"Geometry",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderViewportIndexLayerEXT",
				Value:        5254,
				Capabilities: []string{"MultiViewport",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderViewportIndexLayerNV",
				Value:        5254,
				Capabilities: []string{"MultiViewport",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderViewportMaskNV",
				Value:        5255,
				Capabilities: []string{"ShaderViewportIndexLayerNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderStereoViewNV",
				Value:        5259,
				Capabilities: []string{"ShaderViewportMaskNV",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "PerViewAttributesNV",
				Value:        5260,
				Capabilities: []string{"MultiView",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentFullyCoveredEXT",
				Value:        5265,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "MeshShadingNV",
				Value:        5266,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ImageFootprintNV",
				Value:        5282,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentBarycentricNV",
				Value:        5284,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ComputeDerivativeGroupQuadsNV",
				Value:        5288,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentDensityEXT",
				Value:        5291,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShadingRateNV",
				Value:        5291,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "GroupNonUniformPartitionedNV",
				Value:        5297,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderNonUniform",
				Value:        5301,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "ShaderNonUniformEXT",
				Value:        5301,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RuntimeDescriptorArray",
				Value:        5302,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RuntimeDescriptorArrayEXT",
				Value:        5302,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "InputAttachmentArrayDynamicIndexing",
				Value:        5303,
				Capabilities: []string{"InputAttachment",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "InputAttachmentArrayDynamicIndexingEXT",
				Value:        5303,
				Capabilities: []string{"InputAttachment",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformTexelBufferArrayDynamicIndexing",
				Value:        5304,
				Capabilities: []string{"SampledBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformTexelBufferArrayDynamicIndexingEXT",
				Value:        5304,
				Capabilities: []string{"SampledBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageTexelBufferArrayDynamicIndexing",
				Value:        5305,
				Capabilities: []string{"ImageBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageTexelBufferArrayDynamicIndexingEXT",
				Value:        5305,
				Capabilities: []string{"ImageBuffer",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformBufferArrayNonUniformIndexing",
				Value:        5306,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformBufferArrayNonUniformIndexingEXT",
				Value:        5306,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "SampledImageArrayNonUniformIndexing",
				Value:        5307,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "SampledImageArrayNonUniformIndexingEXT",
				Value:        5307,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageBufferArrayNonUniformIndexing",
				Value:        5308,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageBufferArrayNonUniformIndexingEXT",
				Value:        5308,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageImageArrayNonUniformIndexing",
				Value:        5309,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageImageArrayNonUniformIndexingEXT",
				Value:        5309,
				Capabilities: []string{"ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "InputAttachmentArrayNonUniformIndexing",
				Value:        5310,
				Capabilities: []string{"InputAttachment","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "InputAttachmentArrayNonUniformIndexingEXT",
				Value:        5310,
				Capabilities: []string{"InputAttachment","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformTexelBufferArrayNonUniformIndexing",
				Value:        5311,
				Capabilities: []string{"SampledBuffer","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "UniformTexelBufferArrayNonUniformIndexingEXT",
				Value:        5311,
				Capabilities: []string{"SampledBuffer","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageTexelBufferArrayNonUniformIndexing",
				Value:        5312,
				Capabilities: []string{"ImageBuffer","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "StorageTexelBufferArrayNonUniformIndexingEXT",
				Value:        5312,
				Capabilities: []string{"ImageBuffer","ShaderNonUniform",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "RayTracingNV",
				Value:        5340,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "VulkanMemoryModel",
				Value:        5345,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VulkanMemoryModelKHR",
				Value:        5345,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VulkanMemoryModelDeviceScope",
				Value:        5346,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "VulkanMemoryModelDeviceScopeKHR",
				Value:        5346,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBufferAddresses",
				Value:        5347,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "PhysicalStorageBufferAddressesEXT",
				Value:        5347,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "1.5",
			},
			Enumerant{
				Enumerant:    "ComputeDerivativeGroupLinearNV",
				Value:        5350,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "RayTracingKHR",
				Value:        5353,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "CooperativeMatrixNV",
				Value:        5357,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentShaderSampleInterlockEXT",
				Value:        5363,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentShaderShadingRateInterlockEXT",
				Value:        5372,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "ShaderSMBuiltinsNV",
				Value:        5373,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "FragmentShaderPixelInterlockEXT",
				Value:        5378,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "DemoteToHelperInvocationEXT",
				Value:        5379,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupShuffleINTEL",
				Value:        5568,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupBufferBlockIOINTEL",
				Value:        5569,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupImageBlockIOINTEL",
				Value:        5570,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupImageMediaBlockIOINTEL",
				Value:        5579,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "IntegerFunctions2INTEL",
				Value:        5584,
				Capabilities: []string{"Shader",},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupAvcMotionEstimationINTEL",
				Value:        5696,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupAvcMotionEstimationIntraINTEL",
				Value:        5697,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
			Enumerant{
				Enumerant:    "SubgroupAvcMotionEstimationChromaINTEL",
				Value:        5698,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "None",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindRayQueryIntersection = &OperandKind {
		Kind:       "RayQueryIntersection",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "RayQueryCandidateIntersectionKHR",
				Value:        0,
				Capabilities: []string{"RayQueryKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RayQueryCommittedIntersectionKHR",
				Value:        1,
				Capabilities: []string{"RayQueryKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindRayQueryCommittedIntersectionType = &OperandKind {
		Kind:       "RayQueryCommittedIntersectionType",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "RayQueryCommittedIntersectionNoneKHR",
				Value:        0,
				Capabilities: []string{"RayQueryKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RayQueryCommittedIntersectionTriangleKHR",
				Value:        1,
				Capabilities: []string{"RayQueryKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RayQueryCommittedIntersectionGeneratedKHR",
				Value:        2,
				Capabilities: []string{"RayQueryKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindRayQueryCandidateIntersectionType = &OperandKind {
		Kind:       "RayQueryCandidateIntersectionType",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "RayQueryCandidateIntersectionTriangleKHR",
				Value:        0,
				Capabilities: []string{"RayQueryKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RayQueryCandidateIntersectionAABBKHR",
				Value:        1,
				Capabilities: []string{"RayQueryKHR",},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdResultType = &OperandKind {
		Kind:       "IdResultType",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdResult = &OperandKind {
		Kind:       "IdResult",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdMemorySemantics = &OperandKind {
		Kind:       "IdMemorySemantics",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdScope = &OperandKind {
		Kind:       "IdScope",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindIdRef = &OperandKind {
		Kind:       "IdRef",
		Category:   "Id",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralInteger = &OperandKind {
		Kind:       "LiteralInteger",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralString = &OperandKind {
		Kind:       "LiteralString",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralContextDependentNumber = &OperandKind {
		Kind:       "LiteralContextDependentNumber",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralExtInstInteger = &OperandKind {
		Kind:       "LiteralExtInstInteger",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindLiteralSpecConstantOpInteger = &OperandKind {
		Kind:       "LiteralSpecConstantOpInteger",
		Category:   "Literal",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {},
	}
	OperandKindPairLiteralIntegerIdRef = &OperandKind {
		Kind:       "PairLiteralIntegerIdRef",
		Category:   "Composite",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {OperandKindLiteralInteger,OperandKindIdRef,},
	}
	OperandKindPairIdRefLiteralInteger = &OperandKind {
		Kind:       "PairIdRefLiteralInteger",
		Category:   "Composite",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {OperandKindIdRef,OperandKindLiteralInteger,},
	}
	OperandKindPairIdRefIdRef = &OperandKind {
		Kind:       "PairIdRefIdRef",
		Category:   "Composite",
		Enumerants: []Enumerant {
		},
		Bases:      []*OperandKind {OperandKindIdRef,OperandKindIdRef,},
	}
	OperandKindDebugInfoFlags = &OperandKind {
		Kind:       "DebugInfoFlags",
		Category:   "BitEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "FlagIsProtected",
				Value:        0x01,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagIsPrivate",
				Value:        0x02,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagIsPublic",
				Value:        0x03,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagIsLocal",
				Value:        0x04,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagIsDefinition",
				Value:        0x08,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagFwdDecl",
				Value:        0x10,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagArtificial",
				Value:        0x20,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagExplicit",
				Value:        0x40,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagPrototyped",
				Value:        0x80,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagObjectPointer",
				Value:        0x100,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagStaticMember",
				Value:        0x200,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagIndirectVariable",
				Value:        0x400,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagLValueReference",
				Value:        0x800,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagRValueReference",
				Value:        0x1000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagIsOptimized",
				Value:        0x2000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagIsEnumClass",
				Value:        0x4000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagTypePassByValue",
				Value:        0x8000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "FlagTypePassByReference",
				Value:        0x10000,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDebugBaseTypeAttributeEncoding = &OperandKind {
		Kind:       "DebugBaseTypeAttributeEncoding",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Unspecified",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Address",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Boolean",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Float",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Signed",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "SignedChar",
				Value:        5,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Unsigned",
				Value:        6,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "UnsignedChar",
				Value:        7,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDebugCompositeType = &OperandKind {
		Kind:       "DebugCompositeType",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Class",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Structure",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Union",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDebugTypeQualifier = &OperandKind {
		Kind:       "DebugTypeQualifier",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "ConstType",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "VolatileType",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "RestrictType",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "AtomicType",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDebugOperation = &OperandKind {
		Kind:       "DebugOperation",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "Deref",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Plus",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Minus",
				Value:        2,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "PlusUconst",
				Value:        3,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "BitPiece",
				Value:        4,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},{OperandKindLiteralInteger, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Swap",
				Value:        5,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Xderef",
				Value:        6,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "StackValue",
				Value:        7,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Constu",
				Value:        8,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "Fragment",
				Value:        9,
				Capabilities: []string{},
				Parameters:   []Parameter{{OperandKindLiteralInteger, ""},{OperandKindLiteralInteger, ""},},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}
	OperandKindDebugImportedEntity = &OperandKind {
		Kind:       "DebugImportedEntity",
		Category:   "ValueEnum",
		Enumerants: []Enumerant {
			Enumerant{
				Enumerant:    "ImportedModule",
				Value:        0,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
			Enumerant{
				Enumerant:    "ImportedDeclaration",
				Value:        1,
				Capabilities: []string{},
				Parameters:   []Parameter{},
				Version:      "",
			},
		},
		Bases:      []*OperandKind {},
	}

)
