/****************************************************************************/
// Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.org/sumo
// Copyright (C) 2001-2020 German Aerospace Center (DLR) and others.
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0/
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License 2.0 are satisfied: GNU General Public License, version 2
// or later which is available at
// https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later
/****************************************************************************/
/// @file    GUITextures.h
/// @author  Pablo Alvarez Lopez
/// @date    Jul 2016
///
// An enumeration of gifs used by the gui applications
/****************************************************************************/
#pragma once
#include <config.h>


// ===========================================================================
// enumerations
// ===========================================================================
/**
 * @enum GUITexture
 * @brief An enumeration of gifs used by the gui applications
 */
enum GUITexture {
    GNETEXTURE_E3 = 0,
    GNETEXTURE_E3SELECTED,
    GNETEXTURE_EMPTY,
    GNETEXTURE_EMPTYSELECTED,
    GNETEXTURE_LOCK,
    GNETEXTURE_LOCKSELECTED,
    GNETEXTURE_NOTMOVING,
    GNETEXTURE_NOTMOVINGSELECTED,
    GNETEXTURE_REROUTER,
    GNETEXTURE_REROUTERSELECTED,
    GNETEXTURE_ROUTEPROBE,
    GNETEXTURE_ROUTEPROBESELECTED,
    GNETEXTURE_TLS,
    GNETEXTURE_VAPORIZER,
    GNETEXTURE_VAPORIZERSELECTED,
    GNETEXTURE_VARIABLESPEEDSIGN,
    GNETEXTURE_VARIABLESPEEDSIGNSELECTED,
    GNETEXTURE_LANEBIKE,
    GNETEXTURE_LANEBUS,
    GNETEXTURE_LANEPEDESTRIAN,
    GIF_MAX
};
