---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, logos, AMS-LaTeX
---

# Comment obtenir le logo AMS-LaTeX ?

Actuellement, le [logo d'AMS-LaTeX](/1_generalites/glossaire/ams-tex_et_ams-latex) 
tend à être le suivant :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
AMS-\LaTeX
\end{document}
```

Toutefois, une version historique est encore souvent utilisée 
et c'est cette dernière qui est évoquée par la suite.


## Avec l'extension <ctanpkg:hologo>

L'extension <ctanpkg:hologo> contient de nombreux logos associés aux logiciels liés à TeX. 
Elle met à disposition en particulier celui de l'AMS.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{hologo}

\begin{document}
\hologo{AmSLaTeX}
\end{document}
```


## Avec l'extension <ctanpkg:amsmath>

Plus simplement, l'extension <ctanpkg:amsmath> met à disposition la commande 
pour écrire AMS : `\AmS`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amsmath}

\begin{document}
\AmS-\LaTeX
\end{document}
```


## Sans extension

Cette solution revient à réutiliser *in extenso* la définition de la commande 
utilisée par l'extension <ctanpkg:amsmath> :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
$\cal A$\kern-.1667em\lower.5ex\hbox{$\cal M$}\kern-.125em$\cal S$-\LaTeX
\end{document}
```


:::{sources}
[How to display the word "AMS-LaTeX" in LaTeX?](https://tex.stackexchange.com/q/263449),
sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::