/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#ifndef UKUITASKGROUP_H
#define UKUITASKGROUP_H

#include <QObject>
#include <QMap>
#include <windowmanager/windowmanager.h>
#include "ukuitaskbutton.h"
#include "../panel/common/ukuigridlayout.h"
#include "../panel/common/common.h"
#include "kbadge.h"

class UKUi::GridLayout;
class UKUITaskButton;
class UKUITaskGroup: public QWidget
{
    Q_OBJECT

public:
    UKUITaskGroup(const QString & groupName, const QString & desktopFileName, QWidget *parent);
    virtual ~UKUITaskGroup();

    enum PanelPosition {
        Bottom = 0, //!< The bottom side of the screen.
        Top,    //!< The top side of the screen.
        Left,   //!< The left side of the screen.
        Right   //!< The right side of the screen.
    };

    QString getGroupName();
    QString getDesktopFileName();
    void setDesktopFileName(QString desktopFileName);
    QMap<WindowId, std::shared_ptr<UKUITaskButton>> getButtonsInfo();
    bool isPinned();
    void addWindow(WindowId window);
    void removeWindow(WindowId window);
    void changeButtonsCount();
    bool isHorizontalPanel();
    bool isOnlyPinned();
    void refreshButtonsVisible();
    void setButtonsStyle(std::shared_ptr<UKUITaskButton> btn);
    void changeButtonsStatus();
    void onExpandModeChanged(bool isGrouping);
    void calculGroupSize();
    void changeButtonsSize();
    void realign();

    bool isHaveCornerMark();
    void setHaveCornerMark(bool isHave);
    KBadge *getKbadge();
    void newKbage();

public Q_SLOTS:
    void pinToTaskbar(QString desktopFileName);
    void unpinFromTaskbar(QString desktopFileName);
    void closeAllWindowInGroup();
    void appsCornerMarkChangedSlot(QString arg, int value);
    void setCornerMarkSize();
    void timeToEmit();
    void onCurrentDesktopChanged();

Q_SIGNALS:
    void pinToTaskbarSignal(QString desktopFileName);
    void unpinFromTaskbarSignal(QString desktopFileName);
    void enterGroup(QList<WindowId>, QString groupName, int x, int y);
    void leaveGroup(QString groupName);

protected:
    void enterEvent(QEvent *e);
    void leaveEvent(QEvent *e) override;

    void mousePressEvent(QMouseEvent *event) override;

private:
    QString m_groupName;
    QString m_desktopFileName;
    QWidget *m_parent;
    QMap<WindowId, std::shared_ptr<UKUITaskButton>> m_buttonsMap;
    QList<WindowId> m_currentDesktopWindowIdList;
    std::unique_ptr<QGSettings> m_gsettings;
    QStringList m_gsettingKeys;
    std::unique_ptr<UKUi::GridLayout> m_layout;
    int m_panelPosition;
    int m_panelSize;
    int m_buttonsSpan = 3;
    bool m_isGrouping = true;
    bool m_isPinned = false;
    enum TaskGroupEvent {ENTEREVENT, LEAVEEVENT, OTHEREVENT};
    TaskGroupEvent  m_taskGroupEvent;
    QEvent * m_event;
    QTimer *m_timer;

    //Corner mark
    KBadge *m_badge = nullptr;
    bool m_isHaveCornerMark = false;

};

#endif // UKUITASKGROUP_H
