/*-------------------------------------------------------------------------*\

  FILE..: DECCID.CPP
  AUTHOR: David Rowe
  DATE..: 10/5/01

  Test program for testing Caller ID decoding module.  Attempts to decode
  CID signal from a wave file.

\*-------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "vpbapi.h"
#include "wobbly.h"

#include <cstdio>
#include <cstdlib>

int main(int argc, char *argv[])
{
	if (argc != 2) {
		printf("usage: deccid InputWaveFile\n");
		exit(0);
	}

	vpb_cid_debug_on("debug.txt");
	try {
		WFILE *w;
		size_t sz_bytes;
		char number_str[VPB_MAX_STR];

		vpb_wave_open_read(&w, argv[1]);
		sz_bytes = vpb_wave_get_size(w);
		if(sz_bytes == 0) {
			printf("Error: file '%s' has zero length", argv[1]);
			return -1;
		}
		printf("sz_bytes = %d\n", (int)sz_bytes);
		char *buf = new char[sz_bytes];
		vpb_wave_read(w, buf, sz_bytes);
		printf("Read in wave ...\n");
//	while(1){
		vpb_cid_decode(number_str, (short*)buf, sz_bytes/sizeof(short));
		printf("Decoded ...\n");
		printf("number = %s\n",number_str);
//	printf("Sleeping....\n");
//	vpb_sleep(5000);
//	}

	}

	catch(Wobbly w) {
		char s[VPB_MAX_STR];
		w.translate(s);
		printf("Error: %s\n",s);
		return 1;
	}

	printf("Packet received OK!\n");
	return 0;
}
