/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import java.util.HashMap;
import java.util.Map;

public enum EurekaAccept {
    full,
    compact;

    public static final String HTTP_X_EUREKA_ACCEPT = "X-Eureka-Accept";
    private static final Map<String, EurekaAccept> decoderNameToAcceptMap;

    public static EurekaAccept getClientAccept(DecoderWrapper decoderWrapper) {
        return decoderNameToAcceptMap.get(decoderWrapper.codecName());
    }

    public static EurekaAccept fromString(String name) {
        if (name == null || name.isEmpty()) {
            return full;
        }
        try {
            return EurekaAccept.valueOf(name.toLowerCase());
        }
        catch (Exception e) {
            return full;
        }
    }

    static {
        decoderNameToAcceptMap = new HashMap<String, EurekaAccept>();
        decoderNameToAcceptMap.put(CodecWrappers.getCodecName(CodecWrappers.LegacyJacksonJson.class), full);
        decoderNameToAcceptMap.put(CodecWrappers.getCodecName(CodecWrappers.JacksonJson.class), full);
        decoderNameToAcceptMap.put(CodecWrappers.getCodecName(CodecWrappers.XStreamJson.class), full);
        decoderNameToAcceptMap.put(CodecWrappers.getCodecName(CodecWrappers.XStreamXml.class), full);
        decoderNameToAcceptMap.put(CodecWrappers.getCodecName(CodecWrappers.JacksonXml.class), full);
        decoderNameToAcceptMap.put(CodecWrappers.getCodecName(CodecWrappers.JacksonJsonMini.class), compact);
        decoderNameToAcceptMap.put(CodecWrappers.getCodecName(CodecWrappers.JacksonXmlMini.class), compact);
    }
}

