!-------------------------------------------------
!  SHTlib Module
!-------------------------------------------------
module shtrlib
!  use dcl_common
!  use sht_interface

  type list !Ɨ̈Ȃǂi[邽߂̘AXg
    integer :: idx             ! ʒũCfbNX
    type(list),pointer :: next ! ̃Xgւ̃|C^
    integer :: mm,jm,im        ! i[萔
    real, dimension(:), pointer :: array ! i[Ɨ̈
  end type list

  type(list),pointer :: top,now,pre

  public
  private :: list,top,now,pre,seek
  save
  
contains
!------------------------
  function seek(idx) ! AXg̊֐
    ! idx ɑΉʒu, ^ƂȂ, now ̈ʒuւ̃|C^ƂȂ.
    ! ܂, ̈ʒu擪łȂ, pre Öʒuւ̃|C^ƂȂĂ.
    ! idx ɑΉʒuȂ, UƂȂ.
    integer,intent(in) :: idx
    logical :: seek

    now => top

    do
      if(.not. associated(now)) then
        seek = .false.
        return
      else if(now%idx == idx) then
        seek = .true.
        return
      end if
      pre => now
      now => now%next
    end do
    
  end function seek
!-------------------------------------------------
  subroutine DclInitSHT(mm,jm,im,idx) ! [`D 
    integer,intent(in)          :: mm    ! ؒfg
    integer,intent(in)          :: jm    ! k1/2
    integer,intent(in)          :: im    ! 1/2
    integer,intent(in),optional :: idx   ! Ɨ̈ԍ
    integer :: idxl, length

    call prcopn('DclInitSHT')
    idxl = 1; if(present(idx)) idxl = idx

    if(seek(idxl)) then
      call msgdmp('E','DclInitSHT','The working area has been allocated already.')
    else
      nullify(now)
      allocate(now)
      now%next => top
      top => now
      now%idx = idxl
      now%mm = mm
      now%jm = jm
      now%im = im
      length = (jm+1)*(4*jm+5*mm+14) + (mm+1)*(mm+1) +mm + 2 + 6*im + 15
      allocate(now%array(length))
      call shtint(mm,jm,im,now%array)
    end if
    call prccls('DclInitSHT')

  end subroutine
!---------------------------------------------------------
  subroutine DclDeallocSHT(idx) ! Ɨ̈
    integer,optional :: idx    ! Ɨ̈ԍ
    integer :: idxl
    
    call prcopn('DclDeallocSHT')
    idxl = 1; if(present(idx)) idxl = idx

    if(associated(top)) then
      if(top%idx == idxl) then
        deallocate(top%array)
        now => top%next
        deallocate(top)
        top => now
      else
        if(seek(idxl)) then
          deallocate(now%array)
          pre%next => now%next
          deallocate(now)
        end if
      end if
    end if

    call prccls('DclDeallocSHT')

  end subroutine
!-------------------------------------------------
  function DclGetSpectrumNumber(n,m,idx) !XyNgf[^̊i[ʒu߂D
    integer :: DclGetSpectrumNumber
    integer,intent(in) :: n            ! Sg
    integer,intent(in) :: m            ! яg
    integer,intent(in),optional :: idx ! Ɨ̈ԍ
    integer :: idxl, lr, li

    call prcopn('DclGetSpectrumNumber')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclGetSpectrumNumber','Working area has not been allocated yet.')
    end if

    call shtnml(now%mm,n,abs(m),lr,li)

    if(m >= 0) then              
      DclGetSpectrumNumber = lr   ! m >= 0 ̂Ƃ͎̈ʒu
    else
      DclGetSpectrumNumber = li   ! m <  0 ̂Ƃ͋̈ʒu
    end if
    call prccls('DclGetSpectrumNumber')

  end function
!-------------------------------------------------
  subroutine DclOperateLaplacian(a,b,ind,idx)   !XyNgf[^ɑ΂ăvVAZD
    real,intent(in),dimension(*) :: a   ! ͔z
    real,intent(out),dimension(*) :: b  ! o͔z
    integer,intent(in),optional :: ind  ! vVẢZ`w
    integer,intent(in),optional :: idx  ! Ɨ̈ԍ
    integer :: idxl, indl

    call prcopn('DclOperateLaplacian')
    idxl = 1
    if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclOperateLaplacian','Working area has not been allocated yet.')
    end if

    indl = 1
    if(present(ind)) indl = ind
    
    call shtlap(now%mm,indl,a,b)
    call prccls('DclOperateLaplacian')
  end subroutine
!-------------------------------------------------
  subroutine DclSpectrumToGrid(s,w,g,isw,idx,m1,m2) ! XyNgf[^Obhf[^ւ̕ϊ
    real,intent(in),dimension(*),optional :: s   ! XyNgf[^
    real,dimension(*) :: w                       ! EG[uf[^
    real,intent(out),dimension(*),optional :: g  ! Obhf[^
    integer,intent(in),optional :: isw           ! ϊ̎ނ̎w
    integer,intent(in),optional :: idx           ! Ɨ̈ԍ
    integer,intent(in),optional :: m1, m2        ! gԂ̍ŏől
    integer :: idxl, m1l, m2l, iswl

    call prcopn('DclSpectrumToGrid')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclSpectrumToGrid','Working area has not been allocated yet.')
    end if

    m1l = 0; if(present(m1)) m1l = m1
    m2l = now%mm; if(present(m2)) m2l = m2
    iswl = 0; if(present(isw)) iswl = isw

    if(present(s)) then
      if(present(g)) then
        call shtsga(now%mm,now%jm,now%im,iswl,m1l,m2l,s,w,g,now%array)
      else
        call shtswa(now%mm,now%jm,iswl,m1l,m2l,s,w,now%array)
      end if
    else
      if(present(g)) then
        call shtwga(now%mm,now%jm,now%im,m1l,m2l,w,g,now%array)
      else
        call msgdmp('E','DclSpectrumToGrid','Either S or G must be specified.')
      end if
    end if
    call prccls('DclSpectrumToGrid')
    
  end subroutine
!---------------------------------------------------------------------------
  subroutine DclGridToSpectrum(g,w,s,isw,idx) ! Obhf[^XyNgf[^ւ̕ϊ
    real,intent(in),dimension(*),optional :: g  ! Obhf[^
    real,intent(out),dimension(*) :: w          ! EG[uf[^
    real,intent(out),dimension(*),optional :: s ! XyNgf[^
    integer,intent(in),optional :: isw          ! ϊ̎ނ̎w    
    integer,intent(in),optional :: idx          ! Ɨ̈ԍ
    integer :: idxl, iswl

    call prcopn('DclGridToSpectrum')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclGridToSpectrum','Working area has not been allocated yet.')
    end if

    iswl = 0; if(present(isw)) iswl = isw
    
    if(present(g)) then
      if(present(s)) then
        call shtg2s(now%mm,now%jm,now%im,iswl,g,w,s,now%array)
      else
        call shtg2w(now%mm,now%jm,now%im,g,w,now%array)
      end if
    else
      if(present(s)) then
        call shtw2s(now%mm,now%jm,iswl,w,s,now%array)
      else
        call msgdmp('E','DclGridToSpectrum','Either G or S must be specified.')
      end if
    end if
    call prccls('DclGridToSpectrum')

  end subroutine
!---------------------------------------------------------------------------
  subroutine DclSpectrumToGridForWave(m,s,wr,wi,g,isw,idx) ! XyNgf[^Obhf[^ւ̕ϊ(gw)
    integer,intent(in) :: m                     ! ϊg
    real,intent(in),dimension(*),optional :: s  ! XyNgf[^
    real,dimension(*) :: wr                     ! w^m()̎
    real,dimension(*) :: wi                     ! w^m()̋
    real,intent(out),dimension(*),optional :: g ! Obhf[^
    integer,intent(in),optional :: isw          ! ϊ̎ނ̎w
    integer,intent(in),optional :: idx          ! Ɨ̈ԍ
    integer :: idxl, iswl

    call prcopn('DclSpectrumToGridForWave')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclSpectrumToGridForWave','Working area has not been allocated yet.')
    end if

    iswl = 0; if(present(isw)) iswl = isw

    if(present(s)) then
      if(present(g)) then
        call shtsgm(now%mm,now%jm,now%im,m,iswl,s,wr,wi,g,now%array)
      else
        call shtswm(now%mm,now%jm,m,iswl,s,wr,wi,now%array)
      end if
    else
      if(present(g)) then
        call shtwgm(now%mm,now%jm,now%im,m,wr,wi,g,now%array)        
      else
        call msgdmp('E', 'DclSpectrumToGridForWave', &
&         'Either S or G must be specified.')
      end if
    end if
    call prccls('DclSpectrumToGridForWave')

  end subroutine
!--------------------------------------------------------------------------
  subroutine DclSpectrumToGridForZonal(s,wz,g,isw,idx) ! XyNgf[^Obhf[^ւ̕ϊ(я󐬕)
    real,intent(in),dimension(*),optional :: s  ! XyNgf[^
    real,dimension(*) :: wz                     ! w^0()
    real,intent(out),dimension(*),optional :: g ! Obhf[^
    integer,intent(in),optional :: isw          ! ϊ̎ނ̎w
    integer,intent(in),optional :: idx          ! Ɨ̈ԍ
    integer :: idxl, iswl

    call prcopn('DclSpectrumToGridForZonal')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclSpectrumToGridForZonal','Working area has not been allocated yet.')
    end if

    iswl = 0; if(present(isw)) iswl = isw

    if(present(s)) then
      if(present(g)) then
        call shtsgz(now%mm,now%jm,now%im,iswl,s,wz,g,now%array)
      else
        call shtswz(now%mm,now%jm,iswl,s,wz,now%array)
      end if
    else
      if(present(g)) then
        call shtwgz(now%jm,now%im,wz,g)
      else
        call msgdmp('E','DclSpectrumToGridForZonal','Either S or G must be specified.')
      end if
    end if
    call prccls('DclSpectrumToGridForZonal')
    
  end subroutine
!--------------------------------------------------------------------------
  subroutine DclSpectrumToGridForLatitude(j,s,wj,gj,isw,idx,m1,m2) ! XyNgf[^Obhf[^ւ̕ϊ(ܓx~w)
    integer,intent(in) :: j                      ! ϊsܓx~̎w
    real,intent(in), dimension(*),optional :: s  ! XyNgf[^
    real,dimension(*) :: wj                      ! w^m(_j)
    real,intent(out),dimension(*),optional :: gj ! Obhf[^
    integer,intent(in),optional :: isw           ! ϊ̎ނ̎w
    integer,intent(in),optional :: idx           ! Ɨ̈ԍ
    integer,intent(in),optional :: m1, m2        ! gԂ̍ŏől
    integer :: idxl, iswl, m1l, m2l

    call prcopn('DclSpectrumToGridForLatitude')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclSpectrumToGridForLatitude','Working area has not been allocated yet.')
    end if

    iswl = 0; if(present(isw)) iswl = isw

    m1l = 0; if(present(m1)) m1l = m1
    m2l = now%mm; if(present(m2)) m2l = m2

    if(present(s)) then
      if(present(gj)) then
        call shtsgj(now%mm,now%jm,now%im,iswl,j,m1l,m2l,s,wj,gj,now%array)
      else
        call shtswj(now%mm,now%jm,iswl,j,m1l,m2l,s,wj,now%array)
      end if
    else
      if(present(gj)) then
        call shtwgj(now%mm,now%im,m1l,m2l,wj,gj,now%array)
      else
        call msgdmp('E','DclSpectrumToGridForLatitude','Either S or G must be specified.')
      end if
    end if
    call prccls('DclSpectrumToGridForLatitude')

  end subroutine
!------------------------------------------------------------------------
  subroutine DclGetLegendreFunctions(m,fun,idx) ! Wh֐̌vZ
    integer,intent(in) :: m              ! яg
    real,intent(out),dimension(*) :: fun ! Wh֐i[z
    integer,intent(in),optional :: idx   ! Ɨ̈ԍ
    integer :: idxl

    call prcopn('DclGetLegendreFunctions')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclGetLegendreFunctions','Working area has not been allocated yet.')
    end if

    call shtfun(now%mm,now%jm,m,fun,now%array)
    call prccls('DclGetLegendreFunctions')
  end subroutine
!-------------------------------------------------
  subroutine DclLegendreTransform_F(m,wm,sm,isw,idx) ! Whϊ
    integer,intent(in) :: m             ! ϊsяg).
    real,intent(in),dimension(*) :: wm  ! EG[uf[^
    real,intent(out),dimension(*) :: sm ! XyNgf[^
    integer,intent(in),optional :: isw  ! ϊ̎ނ̎w
    integer,intent(in),optional :: idx  ! Ɨ̈ԍ
    integer :: idxl, iswl

    call prcopn('DclLegendreTransform_F')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclLegendreTransform_F','Working area has not been allocated yet.')
    end if

    iswl = 0; if(present(isw)) iswl = isw

    call shtlfw(now%mm,now%jm,m,iswl,wm,sm,now%array)
    call prccls('DclLegendreTransform_F')
  end subroutine
!-------------------------------------------------
  subroutine DclLegendreTransform_B(m,sm,wm,isw,idx) ! Whtϊ
    integer,intent(in) :: m             ! ϊsяg.
    real,intent(in),dimension(*) :: sm  ! XyNgf[^
    real,intent(out),dimension(*) :: wm ! EG[uf[^
    integer,intent(in),optional :: isw  ! ϊ̎ނ̎w
    integer,intent(in),optional :: idx  ! Ɨ̈ԍ
    integer :: idxl, iswl

    call prcopn('DclLegendreTransform_B')
    idxl = 1; if(present(idx)) idxl = idx

    if(.not. seek(idxl)) then
      call msgdmp('E','DclLegendreTransform_B','Working area has not been allocated yet.')
    end if

    iswl = 0; if(present(isw)) iswl = isw

    call shtlbw(now%mm,now%jm,m,iswl,sm,wm,now%array) 
    call prccls('DclLegendreTransform_B')
  end subroutine
!-------------------------------------------------
end module
