#!/bin/sh
#
# Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
#
fc="`which ${FC:?}`"
fflags="-I${MODINSTDIR:?} ${SYSFFLAGS}"
libs="-L${LIBINSTDIR:?} -l${LIBNAME:?}"

ldflags=${SYSLDFLAGS}
ldlibs=${SYSLDLIBS:?}
out=${1:-dclf90}

if [ ${F90MODTYPE:?} = intel.d ]; then
	ldlibs=`echo $ldlibs | sed s/-lm//`
fi

cat > $out <<EOF
#!/bin/sh

fc="$fc"
fflags="$fflags"
libs="$libs"
ldflags="$ldflags"
ldlibs="$ldlibs"

EOF

if [ ${F90MODTYPE:?} = intel.d ]; then

	cat >> $out <<EOF
# support for Intel Fortran
	if [ ! -f work.pcl ]; then
		echo work.pc > work.pcl
	fi
	if ! grep $MODINSTDIR work.pcl 2>/dev/null
	then
		echo $MODINSTDIR/work.pc >> work.pcl
		echo adding $MODINSTDIR to work.pcl
	fi
EOF

fi

cat >> $out <<EOF

echo \$fc \$fflags "\$@" \$libs \$ldflags \$ldlibs
exec \$fc \$fflags "\$@" \$libs \$ldflags \$ldlibs
EOF
