;;; TEX.el - Special code for TeX mode.

;; $Id: TEX.el,v 1.4 1993/09/06 22:28:12 amanda Exp $

(require 'tex-init)

(TeX-add-style-hook "TEX"
 (function
  (lambda ()
    (use-local-map plain-TeX-mode-map)
    (easy-menu-add plain-TeX-mode-menu plain-TeX-mode-map)
    (setq mode-name "TeX")
    (setq major-mode 'plain-tex-mode)
    (set-syntax-table TeX-mode-syntax-table)
    (setq paragraph-start
	  (concat
	   "\\(^[ \t]*$"
	   "\\|" (regexp-quote TeX-esc) "par\\|" 
	   "^[ \t]*"
	   (regexp-quote TeX-esc)
	   "\\("
	   "begin\\|end\\|part\\|chapter\\|"
	   "section\\|subsection\\|subsubsection\\|"
	   "paragraph\\|include\\|includeonly\\|"
	   "tableofcontents\\|appendix\\|label\\|caption\\|"
	   "\\[\\|\\]" ; display math delimitors
	   "\\)"
	   "\\|"
	   "^[ \t]*\\$\\$" ; display math delimitor
	   "\\)" ))
    (setq paragraph-separate
	  (concat
	   "\\("
	   (regexp-quote TeX-esc)
	   "par\\|"
	   "^[ \t]*$\\|"
	   "^[ \t]*"
	   (regexp-quote TeX-esc)
	   "\\("
	   "begin\\|end\\|label\\|caption\\|part\\|chapter\\|"
	   "section\\|subsection\\|subsubsection\\|"
	   "paragraph\\|include\\|includeonly\\|"
	   "tableofcontents\\|appendix\\|" (regexp-quote TeX-esc)
	   "\\)"
	   "\\)"))
    (setq TeX-header-end (regexp-quote "%**end of header"))
    (setq TeX-trailer-start (regexp-quote (concat TeX-esc "bye")))
    (setq TeX-command-default "TeX")
    (run-hooks 'text-mode-hook 'TeX-mode-hook 'plain-TeX-mode-hook))))

;;; TEX.el ends here
