;;; out-xtra.el --- Extra support for outline minor mode.

;; Copyright (C) 1993 Per Abrahamsen.
;; Copyright abandoned.  This file is donated to the public domain.

;; Author: Per Abrahamsen <abraham@iesd.auc.dk>
;; Version: $Id: out-xtra.el,v 5.3 1993/11/18 20:09:55 amanda Exp $
;; Bogus-Bureaucratic-Cruft: How 'bout ESR and the LCD people agreed
;; 	on a common format?

;; LCD Archive Entry:
;; out-xtra|Per Abrahamsen|abraham@iesd.auc.dk|
;; Extra support for outline minor mode|
;; $Date: 1993/11/18 20:09:55 $|$Revision: 5.3 $|~/misc/out-xtra.el.Z|

;;; Commentary:

;; This file provides some nice extra features for outline minor mode. 
;;
;; - Add extra keybindings.
;; - Add function to show top level headers.
;; - Change default minor mode key prefix to `C-c C-o'.
;; - Add support for mm macro package in nroff mode.
;; - Add support for emacs lisp mode.
;;
;; If you have hooks for support for other major modes, please send
;; them to me.

;; `out-xtra.el' works with:
;; - FSF Emacs 19.19
;; - Lucid Emacs 19.8 with outln-18.el
;; - Emacs 18 with outln-18.el

;; Get `powerkey.el' if you want keyboard shortcuts to appear in the
;; menu for FSF Emacs 19 (very nice).

;; Get AUC TeX if you want support for LaTeX and TeXinfo files (also
;; nice :-).

;; Insert 
;;   (require 'out-xtra)
;; in your .emacs file to install.  If you want a different prefix
;; key, insert first 
;;   (defvar outline-minor-mode-prefix "\C-c")
;; or whatever.  The prefix can only be changed before outline (minor)
;; mode is loaded.

;;; ChangeLog:
;; * 16 Nov 1993	Per Abrahamsen
;;      `outline-hide-sublevels' now takes an argument.  Thanks to 
;;      Kevin Broadey <KevinB@bartley.demon.co.uk>.

;;; Code:

(defvar outline-minor-mode-prefix "\C-c\C-o")

(defun outline-hide-sublevels (keep-levels)
  ;; I have forgotten who I stole this from, sorry.
  "Hide everything except the first KEEP-LEVEL headers."
  (interactive "p")
  (if (< keep-levels 1)
      (error "Must keep at least one level of headers"))
  (setq keep-levels (1- keep-levels))
  (save-excursion
    (goto-char (point-min))
    (hide-subtree)
    (show-children keep-levels)
    (condition-case err
      (while (outline-get-next-sibling)
	(hide-subtree)
	(show-children keep-levels))
      (error nil))))

(if (fboundp 'eval-after-load)
    ;; FSF Emacs 19.
    (eval-after-load "outline"
      '(progn
	 (define-key outline-minor-mode-map
	   (concat outline-minor-mode-prefix "\C-t") 'hide-body)
	 (define-key outline-minor-mode-map
	   (concat outline-minor-mode-prefix "\C-a") 'show-all)
	 (define-key outline-minor-mode-map
	   (concat outline-minor-mode-prefix "\C-c") 'hide-entry)
	 (define-key outline-minor-mode-map
	   (concat outline-minor-mode-prefix "\C-e") 'show-entry)
	 (define-key outline-minor-mode-map
	   (concat outline-minor-mode-prefix "\C-l") 'hide-leaves)
	 (define-key outline-minor-mode-map
	   (concat outline-minor-mode-prefix "\C-k") 'show-branches)
	 (define-key outline-minor-mode-map
	   (concat outline-minor-mode-prefix "\C-q") 'outline-hide-sublevels)
	 (define-key outline-minor-mode-map [menu-bar hide hide-sublevels]
	   '("Hide Sublevels" . outline-hide-sublevels))
	 (if (fboundp 'update-power-keys)
	     (update-power-keys outline-minor-mode-map))))
  ;; Lucid Emacs or Emacs 18.
  (require 'outln-18)
  (define-key outline-minor-mode-map
    (concat outline-minor-mode-prefix "\C-t") 'hide-body)
  (define-key outline-minor-mode-map
    (concat outline-minor-mode-prefix "\C-a") 'show-all)
  (define-key outline-minor-mode-map
    (concat outline-minor-mode-prefix "\C-c") 'hide-entry)
  (define-key outline-minor-mode-map
    (concat outline-minor-mode-prefix "\C-e") 'show-entry)
  (define-key outline-minor-mode-map
    (concat outline-minor-mode-prefix "\C-l") 'hide-leaves)
  (define-key outline-minor-mode-map
    (concat outline-minor-mode-prefix "\C-k") 'show-branches)
  (define-key outline-minor-mode-map
    (concat outline-minor-mode-prefix "\C-q") 'outline-hide-sublevels))

;;; Major Modes

(defun outline-minor-mode-on ()
  (outline-minor-mode 1))

;; Supported by AUC TeX.
(add-hook 'TeXinfo-mode-hook 'outline-minor-mode-on)
(add-hook 'LaTeX-mode-hook 'outline-minor-mode-on)

;;; Emacs Lisp

(add-hook 'emacs-lisp-mode-hook
	  (function (lambda ()
	    (require 'outline)
	    (make-local-variable 'outline-regexp)
	    (setq outline-regexp ";;; \\|(....")
	    (outline-minor-mode 1))))

;;; Nroff

(defun nroff-outline-level ()
  ;; Only `mm' currently.
  (save-excursion
    (looking-at outline-regexp)
    (skip-chars-forward ".H ")
    (string-to-int (buffer-substring (point) (+ 1 (point))))))

(add-hook 'nroff-mode-hook
	  (function (lambda ()
	    (require 'outline)
	    (make-local-variable 'outline-regexp)
	    (setq outline-regexp "\\.H[ ]+[1-7]+ ")
	    (make-local-variable 'outline-level)
	    (setq outline-level 'nroff-outline-level)
	    (outline-minor-mode 1))))

(provide 'out-xtra)

;;; out-xtra.el ends here
