;;; tex-18.el - Special support for Emacs 18

;; Author: Per Abrahamsen <abraham@iesd.auc.dk>
;; Version: $Id: tex-18.el,v 5.7 1993/11/18 20:10:04 amanda Exp $

;;; Code:

(autoload 'outline-mode "outln-18" nil t)
(autoload 'outline-minor-mode "outln-18" nil t)
(autoload 'outline-flag-region "outln-18")

;; The Emacs 19 definition of `add-hook'.
(defun add-hook (hook function &optional append)
  "Add to the value of HOOK the function FUNCTION.
FUNCTION is not added if already present.
FUNCTION is added (if necessary) at the beginning of the hook list
unless the optional argument APPEND is non-nil, in which case
FUNCTION is added at the end.
 
HOOK should be a symbol, and FUNCTION may be any valid function.  If
HOOK is void, it is first set to nil.  If HOOK's value is a single
function, it is changed to a list of functions."
  (or (boundp hook) (set hook nil))
  ;; If the hook value is a single function, turn it into a list.
  (let ((old (symbol-value hook)))
    (if (or (not (listp old)) (eq (car old) 'lambda))
        (set hook (list old))))
  (or (if (consp function)
          ;; Clever way to tell whether a given lambda-expression
          ;; is equal to anything in the hook.
          (let ((tail (assoc (cdr function) (symbol-value hook))))
            (equal function tail))
        (memq function (symbol-value hook)))
      (set hook 
           (if append
               (nconc (symbol-value hook) (list function))
             (cons function (symbol-value hook))))))

;; An Emacs 19 function.
(defun make-directory (dir)
  "Create the directory DIR."
  (shell-command (concat "mkdir " (if (string-match "/$" dir)
				      (substring dir 0 -1)
				    dir))))
 
;; An Emacs 19 function.
(defun abbreviate-file-name (name)
  name)

;; Different interface for each variant.
(defun TeX-mark-active ()
  ;; In Emacs 18 (mark) returns nil when not active.
  (mark))

;; An Emacs 19 function.
(defun member (elt list)
  (TeX-member elt list 'equal))

(provide 'tex-18)

;;; tex-18.el ends here
