;;; tex-site.el - Site specific variables.

;; Copyright (C) 1991 Kresten Krab Thorup 
;; Copyright (C) 1993 Per Abrahamsen 

;; Author: Per Abrahamsen <abraham@iesd.auc.dk>
;; Version: $Id: tex-site.el,v 5.61 1994/01/05 19:08:57 amanda Exp $

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; This file contains variables to be customized for a given site.
;;
;; It also contains all necessary autoloads, so the user can simple
;; enable AUC TeX by putting (load "tex-site.el") in his .emacs
;; file. 
;;
;; If you are afraid of the delay of loading this file, you can
;; copy the sections Path and Autoloads to your file verbatim instead.

;;; Code:

;;; Path
;;
;; Change these for your site.

;; (defvar TeX-lisp-directory "/home/pd/share/emacs/auctex8.0/"
(defvar TeX-lisp-directory "/usr/local/lib/emacs/site-lisp/auctex/"
  "*The directory where the AUC TeX lisp files are located.

The directory name *must* end with a slash.")

(defvar TeX-macro-global
  '("/usr/local/lib/tex/inputs/" "/usr/local/lib/tex/generate/")
  "*Directories containing the sites TeX macro files and style files.

The directory names *must* end with a slash.")

;;; Autoloads
;;
;; This set up everything to be loaded as needed.
;; No need for changes in this section.

(setq load-path (cons TeX-lisp-directory load-path))
(require 'tex-load)

(defvar bibtex-mode-hook nil)
(add-hook 'bibtex-mode-hook 'BibTeX-auto-store)

;;; Internationalization
;;
;; The following hooks are automatically run from buffers that
;; includes language specific style files.

(defvar TeX-language-dk-hook nil
  "Initialization of Danish TeX files.")

(defvar TeX-language-nl-hook nil
  "Initialization of Dutch TeX files.")

(defvar TeX-language-de-hook nil
  "Initialization of German TeX files.")

;; If you have the remap package, you can use theese hooks to choose a
;; setup, like this:
;;
;; (add-hook 'TeX-language-dk-hook 
;;           '(lambda () (remap-setup-choose "DK" nil)))
;;
;; If you have ispell 3 (not ispell 4!) you can choose a dictionary
;; like this:
;;
;; (add-hook 'TeX-language-dk-hook
;;           '(lambda () (ispell-change-dictionary "danish")))
;;
;; This is not needed if you have the remap package.  The ispell
;; dictionary change will be global if you use a version of ispell.el
;; older than 2.24, otherwise it will only change the local
;; dictionary.

;;; From tex-buf.el

;; This is the major configuration variable.  Most sites will only
;; need to change the second string in each entry, which is the name
;; of a command to send to the shell.  If you use other formatters
;; like AMSLaTeX or AMSTeX, you can add those to the list.  See
;; TeX-expand-list for a description of the % escapes

(defvar TeX-print-command "dvips %s -P%p"
  "*Command used to print a file. 

First %p is expanded to the printer name, then ordinary expansion is
performed as specified in TeX-expand-list.")

(defvar TeX-queue-command "lpq -P%p"
  "*Command used to show the status of a printer queue. 

First %p is expanded to the printer name, then ordinary expansion is
performed as specified in TeX-expand-list.")

(defvar TeX-command-list
  ;; You may have to remove the single quotes around the command
  ;; arguments if you use DOS.
  (list (list "TeX" "tex '\\nonstopmode\\input %t'" 'TeX-run-TeX nil t)
	(list "TeX Interactive" "tex %t" 'TeX-run-interactive nil t)
	(list "LaTeX" "latex '\\nonstopmode\\input{%t}'" 'TeX-run-LaTeX nil t)
	(list "LaTeX Interactive" "latex %t" 'TeX-run-interactive nil t)
	(list "SliTeX" "slitex '\\nonstopmode\\input{%t}'"
	      'TeX-run-LaTeX nil t)  
	(if (or window-system (getenv "DISPLAY"))
	    (list "View" "%v " 'TeX-run-background t nil)
	  (list "View" "dvi2tty -q -w 132 %s " 'TeX-run-command t nil))
	(list "Print" "%p " 'TeX-run-command t nil)
	(list "Queue" "%q" 'TeX-run-background nil nil)
	(list "File" "dvips %d -o %f " 'TeX-run-command t nil)
	(list "BibTeX" "bibtex %s" 'TeX-run-BibTeX nil nil)
	(list "Index" "makeindex %s" 'TeX-run-command nil t)
	(list "Check" "lacheck %s" 'TeX-run-compile nil t)
	(list "Spell" "<ignored>" 'TeX-run-ispell nil nil)
	(list "Other" "" 'TeX-run-command t t)
	;; Not part of standard TeX.
	(list "Makeinfo" "makeinfo %s" 'TeX-run-compile nil t)
;;	(list "AmSTeX" "amstex '\\nonstopmode\\input %t'"
;;	      'TeX-run-TeX nil t)
;;	(list "AmSLaTeX" "amslatex '\\nonstopmode\\input{%t}'"
;;	      'TeX-run-LaTeX nil t)
;;	(list "FoilTeX" "foiltex '\\nonstopmode\\input{%t}'"
;;	      'TeX-run-LaTeX nil t)
	;; The next entries support Japanese TeX.
;;	(list "jTeX" "jtex '\\nonstopmode\\input %t'" 'TeX-run-TeX nil t)
;;	(list "jLaTeX" "jlatex '\\nonstopmode\\input{%t}'"
;;	      'TeX-run-LaTeX nil t)
;;	(list "jSliTeX" "jslitex '\\nonstopmode\\input{%t}'"
;;	      'TeX-run-LaTeX nil t)
;;	(list "jBibTeX" "jbibtex %s" 'TeX-run-BibTeX nil nil)
	;; Add your own entries here :-)
	)

  "*List of commands to execute on the current document.

Each element is a list, whose first element is the name of the command
as it will be presented to the user.  

The second element is the string handed to the shell after being
expanded. The expansion is done using the information found in
TeX-expand-list. 

The third element is the function which actually start the process.
Several such hooks has been defined:

TeX-run-command: Start up the process and show the output in a
separate buffer.  Check that there is not two commands running for the
same file.  Return the process object. 

TeX-run-format: As TeX-run-command, but assume the output is created
by a TeX macro package.  Return the process object. 

TeX-run-TeX: For TeX output.

TeX-run-LaTeX: For LaTeX output.

TeX-run-interactive: Run TeX or LaTeX interactively.

TeX-run-BibTeX: For BibTeX output.

TeX-run-compile: Use `compile' to run the process.  

TeX-run-shell: Use `shell-command' to run the process.

TeX-run-discard: Start the process in the background, discarding its
output.

TeX-run-background: Start the process in the background, show output
in other window.

TeX-run-dviout: Special hook for the Japanese dviout previewer for
PC-9801.

To create your own hook, define a function taking three arguments: The
name of the command, the command string, and the name of the file to
process.  It might be useful to use TeX-run-command in order to
create an asynchronous process.

If the fourth element is non-nil, the user will get a chance to
modify the expanded string.

If the fifth element is non-nil, the TeX-region file will be rebuild
before the command is started.")


;; Enter the names of the printers available at your site, or nil if
;; you only have one printer.

(defvar TeX-printer-list
  '(("Local" "dvips -f %s | lpr" "lpq")
    ("lw") ("ps"))
  "*List of available printers.

The first element of each entry is the printer name.

The second element is the command used to print to this
printer.  It defaults to the value of TeX-print-command.

The third element is the command used to examine the print queue for
this printer.  It defaults to the value of TeX-queue-command.

Any occurence of `%p' in the second or third element is expanded to
the printer name given in the first element, then ordinary expansion
is performed as specified in TeX-expand-list.")

;; The name of the most used printer.  

(defvar TeX-printer-default (or (getenv "PRINTER")
				(and TeX-printer-list
				     (car (car TeX-printer-list)))
				"lw")
  "*Default printer to use with TeX-command.")

;; You may want special options to the view command depending on the
;; style optios.

(defvar TeX-view-style '(("^epsf$" "ghostview %f")
			 ("^a5$" "xdvi %d -paper a5")
			 ("^landscape$" "xdvi %d -paper a4r -s 4")
			 ("." "xdvi %d"))
  "*List of style options and view options.

If the first element (a regular expresion) matches the name of one of
the style files, any occurrence of the string %v in a command in
TeX-command-list will be replaced with the second element.  The first
match is used, if no match is found the %v is replaced with the empty
string.")

;; This is the list of expansion for the commands in
;; TeX-command-list.  Not likely to be changed, but you may e.g. want
;; to handle .ps files. 

(defvar TeX-expand-list 
  (list (list "%p" 'TeX-printer-query)	;%p must be the first entry
	(list "%q" (function (lambda ()
		     (TeX-printer-query TeX-queue-command 2))))
	(list "%v" 'TeX-style-check TeX-view-style)
	(list "%s" 'file)
	(list "%t" 'file 't)
	(list "%d" 'file "dvi")
	(list "%f" 'file "ps"))
  "*List of expansion strings for TeX command names.

Each entry is a list with two or more elements.  The first element is
the string to be expanded.  The second element is the name of a
function returning the expanded string when called with the remaining
elements as arguments.  The special value `file' will be expanded to
the name of the file being processed, with an optional extension.")

(provide 'tex-site)

;;; tex-site.el ends here
