;; hilit-LaTeX.el - Enhancements for LaTeX highlighting w/ hilit19.el or hl319
;;
;; Copyright (C) 1994 Peter S. Galbraith
 
;; Author:    Peter S. Galbraith <rhogee@bathybius.meteo.mcgill.ca>
;; Created:   01 March 1994
;; Version:   1.07 (04 January 95)
;; Keywords:  LaTeX, hilit19, hl319, highlight, auctex 

;; Everyone is granted permission to copy, modify and redistribute this
;; file provided:
;;   1. All copies contain this copyright notice.
;;   2. All modified copies shall carry a prominant notice stating who
;;      made modifications and the date of such modifications.
;;   3. The name of the modified file be changed.
;;   4. No charge is made for this software or works derived from it.
;;      This clause shall not be construed as constraining other software
;;      distributed on the same medium as this software, nor is a
;;      distribution fee considered a charge.

;; ----------------------------------------------------------------------------
;;; Commentary:

;; New versions of this package (if they exist) may be found at:
;;  /anonymous@bathybius.meteo.mcgill.ca:/pub/users/rhogee/elisp/hilit-LaTeX.el

;; Description:
;;  This package enhances hilit19 (or hl319) highlighting patterns for LaTeX.

;; Installation instructions:
;;  Simply load it and go.
;;  All you need to do is add this line to your .emacs file (optionally in 
;;  your LaTeX-mode-hook for later loading):
;;
;;    (if window-system
;;        (require 'hilit-LaTeX))

;; (Following LCD Archive Entry included for your later use --- 
;;  Not yet submitted but perhaps you can get your next version there)
;; LCD Archive Entry:
;; hilit-LaTeX|Peter Galbraith|rhogee@bathybius.meteo.mcgill.ca
;; |Enhancements for LaTeX highlighting w/ hilit19.el or hl319
;; Wed Jan 04 09:09:45 1995|1.07||
;;
;; ----------------------------------------------------------------------------
;;; Change log:
;; V1.00 01Mar94 Peter S Galbraith - Created
;; V1.01 14Mar94 PSG - Added {\sc } 
;;                   - Added fix for \[ ]\ excluding \\[len]
;; V1.02 15Mar94 PSG - Real dollar sign \$ won't hilit like math mode.
;; V1.03 16Mar94     - lateX2e-mode, \documentclass, \usepackage
;;                     Jonathan Katz <jkatz@weber.ucsd.edu>
;; V1.04 16Mar94 PSG - Added \sc as a declaration.
;; V1.05 17Mar94     - ams-latex-mode, \eqref , \title[]{}, \numberwithin
;;                     Andrew Swann <swann@imada.ou.dk>
;;               PSG - \[any]cite command that user makes up.
;; V1.06 06Apr94     - \cite[anyword] commands that user makes up. 
;;                      Martin Maechler <maechler@stat.math.ethz.ch>
;; V1.07 04Jan95 PSG - Added hilit-inside-bracket-region for LaTeX2e
;;                     commands \textrm \textbf and \emph.
;; ----------------------------------------------------------------------------
;;; Code:

(defun hilit-bracket-region (open)
  "Find region within curly brackets for hilit pattern.
ARG is pattern for beginning of pattern and ends with {.
It cannot be white space.  
Patterns ends simply at the matching closing bracket.

Used for patterns like:
 \\chapter{stuff with matching {} ending with }"
  (if (re-search-forward open nil t)
      (let ((here (point))
            (the-start (match-beginning 0)))
        (backward-char 1)               ; point is on bracket
        (forward-sexp 1)
        (cons the-start (point)))))


(defun hilit-inside-bracket-region (open)
  "Find region within curly brackets for hilit pattern.
ARG is pattern for beginning of pattern and ends with {.
It cannot be white space.  
Patterns ends simply at the matching closing bracket.

Used for patterns like:
 \\textbf{only stuff within bracket is highlited}"
  (if (re-search-forward open nil t)
      (let ((the-start (point)))
        (backward-char 1)               ; point is on bracket
        (forward-sexp 1)
        (backward-char 1)
        (cons the-start (point)))))

(defun hilit-bracket-wysiwyg (open)
  "Find region within curly brackets for hilit pattern.
ARG is pattern for beginning of pattern and starts with {.
Patterns ends simply at the matching closing bracket.

Used for patterns like:
 {\em stuff with matching {} ending with }"
  (if (re-search-forward open nil t)
      (let ((the-start (match-beginning 0)))
        (goto-char the-start)
        (forward-sexp 1)
        (cons the-start (point)))))

(hilit-set-mode-patterns
 '(
   LaTeX-mode japanese-LaTeX-mode SliTeX-mode
   japanese-SliTeX-mode FoilTeX-mode latex-mode latex2e-mode ams-latex-mode
   )
 '(
   ("[^\\]%.*$" nil comment)            ;; comments
   ("\\\\\\(sc\\|textbf\\|emph\\|it\\|textrm\\|bf\\|em\\|rm\\|sf\\|sl\\|ss\\|tt\\)\\b" nil decl)
   ("``" "''" string)
   ("\\\\\\(raggedright\\|makeindex\\|makeglossary\\|maketitle\\)\\b" nil
    decl)
   ;; label-like things
   ("\\\\item\\(\\[[^]]*\\]\\)?" nil label)
   ;; formulas
   ("\\\\("  "\\\\)" formula)           ; \( \)
   ("[^\\\\]\\\\\\[" "\\\\\\]" formula) ; \[ \] but not \\[len] (PS Galbraith)
   ("[^$\\]\\($\\($[^$]*\\$\\|[^$]*\\)\\$\\)" 1 formula) ; '$...$' or '$$...$$'
   ;;   ^^ but not \$102.54 is expensive for a car wash.
   ;; various declarations/definitions
   ("\\\\\\(setlength\\|settowidth\\|addtolength\\|setcounter\\|addtocounter\\)" nil define)
   ("\\\\\\(normalsize\\|small\\|footnotesize\\|scriptsize\\|tiny\\|large\\|Large\\|LARGE\\|huge\\|Huge\\)\\b" nil decl)
   ("\\\\\\(appendix\\|tableofcontents\\|listoffigures\\|listoftables\\)\\b"
    nil decl)
   ("\\\\[a-z]+box" nil keyword)
   ;; "wysiwyg" emphasis
   (hilit-bracket-wysiwyg "{\\\\\\(em\\|it\\|sl\\)" italic)
   (hilit-bracket-wysiwyg "{\\\\bf" bold)
   (hilit-bracket-wysiwyg "{\\\\sc" label)
   (hilit-inside-bracket-region "\\\\emph{" italic)
   (hilit-inside-bracket-region "\\\\textrm{" label)
   (hilit-inside-bracket-region "\\\\textbf{" bold)
   (hilit-bracket-region 
   ;       (\\(no\\)?cite  -> changed to any cite commands that users make up.
    "\\\\\\([A-z]*cite[A-z]*\\|\\(page\\)?ref\\|eqref\\|label\\|index\\|glossary\\){"
    crossref)
   (hilit-bracket-region "\\\\\\(v\\|h\\)space\\(\*\\)?{" keyword)
   (hilit-bracket-region "\\\\footnote\\(mark\\|text\\)?{" keyword)
   ;; things that do some sort of cross-reference
   (hilit-bracket-region 
    "\\\\\\(pagestyle\\|thispagestyle\\|pagenumbering\\|numberwithin\\){" decl)
   ;; things that bring in external files
   (hilit-bracket-region  "\\\\\\(include\\|input\\|bibliography\\){" include)
   ;; (re-)define new commands/environments/counters
   (hilit-bracket-region "\\\\\\(re\\)?new\\(environment\\|command\\){" defun)
   (hilit-bracket-region "\\\\new\\(length\\|theorem\\|counter\\){" defun)
   ;; the following two match \foo[xx]{xx} or \foo*{xx} or \foo{xx}
   (hilit-bracket-region 
    "\\\\\\(sub\\)*\\(paragraph\\|section\\)\\(\*\\|\\[.*\\]\\)?{" keyword)
   (hilit-bracket-region 
    "\\\\\\(chapter\\|part\\)\\(\*\\|\\[.*\\]\\)?{" keyword)
   (hilit-bracket-region 
    "\\(\\\\document\\(style\\|class\\)\\|\\\\usepackage\\)\\(\\[.*\\]\\)?{" 
    decl)
   (hilit-bracket-region "\\\\title\\(\\[.*\\]\\)?{" define)
   (hilit-bracket-region "\\\\\\(author\\|date\\|thanks\\){" define)
   (hilit-bracket-region "\\\\caption\\(\\[[^]]*\\]\\)?{" label)
   (hilit-bracket-region "\\\\\\(begin\\|end\\|nofiles\\|includeonly\\){" 
                         decl)))
(provide 'hilit-LaTeX)
;;; hilit-LaTeX.el ends here
