;; sample file of .emacs

;;
;; to process marks in summary mode before exiting Emacs.
;;

(setq mew-init-hook
      (function
       (lambda ()
	 (setq kill-emacs-hook (function mew-mark-process-all-folders)))))

;
;or
;
;(setq mew-init-hook
;      (function
;       (lambda ()
;	(your job1)
;	(your job2)
;	...
;	(mew-mark-process-all-folders))))


;;
;; to handle colors.
;;

(cond
 ((and window-system (string-match "^19" emacs-version))
      (setq hilit-mode-enable-list  nil
	    hilit-background-mode   'light
	    hilit-inhibit-hooks     nil
	    hilit-inhibit-rebinding nil)
      (require 'hilit19)
      ;;
      (add-hook 'mew-message-hook
		'hilit-rehighlight-buffer-quietly)
      (hilit-set-mode-patterns 
       '(mew-message-mode)
       '(("^Subject:.*$" nil msg-subject)
	 ("^From:.*$" nil msg-from)
	 ("^X-.*:.*$" nil msg-quote)
	 ("^>.*$" nil msg-quote)
	 ("^[A-Za-z][A-Za-z0-9-]+:" nil msg-header)))
      ;;
      (add-hook 'mew-draft-mode-hook
		'hilit-rehighlight-buffer-quietly)
      (hilit-set-mode-patterns 
       '(mew-draft-mode)
       '(("^Subject:.*$" nil msg-subject)
	 ("^From:.*$" nil msg-from)
	 ("^>.*$" nil msg-quote)
	 ("^[A-Za-z][A-Za-z0-9-]+:" nil msg-header)))
      )
 )

;;
;; citation tip
;;
;;
;; From: Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;; Subject: Hello World
;; Date: Thu, 08 Dec 1994 11:44:08 +0900
;;
;; kazu> The quick brown fox jumped over the very lazy dog.
;;

(setq mew-cite-format  
      '(progn
	 (setq mew-cite-prefix 
	       (format "%s> " (mew-header-delete-at
			       (mew-header-extract-addr from))))
	 (format "From: %s\nSubject: %s\nDate: %s\n\n" from subject date))
      )

;;
;; ispell-message for Mew
;;
;;	You should apply ispell.el.patch to ispell.el.
;;

(add-hook 'mew-send-hook 'ispell-message)

;;
;; End
;;
