;;; $B!V$f$G$?$^$4!W(B(boiled-egg.el): $B%m!<%^;z4A;zJQ49MQ!V$?$^$4!W%U%m%s%H%(%s%I(B
;;; Copyright (C) 1992 Miura Kin'ya

;;; This program is free software; You can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 1, or (at your option)
;;; any later version.

;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.

;;; You should have received a copy of the GNU General Public License
;;; along with this program; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;;	Miura Kin'ya [ Miura is my family name. ]
;;;	e-mail:  miura@cs.gunma-u.ac.jp
;;;	address: Gunma Univ., 1-5-1 Tenjin-cho, Kiryu, 376 Japan
;;;	phone:   +81 277 22 3181, (ext. 818)
;;;	fax:     +81 277 47 3051

;;; Log:
;;; 	3.10 [Jul 02, 1993] debug
;;; 	3.9 [Oct 28, 1992] rK-kakutei-before-point, README.be
;;; 	3.8 [Oct 27, 1992] hk -> K, be-display-mode, be-verbose
;;; 	3.7 [Oct 27, 1992] 'x-mode, egg-insert-after-hook, auto-fill etc.
;;; 	3.5 [Aug 27, 1992] rK-kakutei-before-point debug
;;; 	3.4 [Aug 12, 1992] rK-kakutei-before-point etc.
;;; 	3.3 [Jul 29, 1992] X-transes, rK-trans modified. (by Mr. Hoshi)
;;;	                   replace-on-keymap changed.
;;; 	3.2 [Jul 27, 1992] changed for MULE (thanks to Mr. Furuhata/Mr. Furuta)
;;; 	3.1 [Jan 17, 1992] be-mark-as-trans-begin introduced.
;;; 	3.0 [Dec 06, 1991] hard-boiled.el has not been distributed, yet.
;;; 	2.5 [Dec 07, 1990] rK-cancel-trans has modified.
;;; 	2.2 [Aug 28, 1990] 'hard-boiled' has made.
;;; 	2.1 [Aug 17, 1990] (provide ..) added.
;;; 	2.0 [Jul 06, 1990] key-binding, initialization modified.
;;; 	1.2 [Jun 22, 1990] KR-trans added.
;;; 	1.0 [Apr 23, 1990] Kh-trans, rRkh-trans(by Mr. Takahasi) added.
;;; 	0.0 [Feb 15, 1990] private version of `boiled-egg'.

;;; Special thanks to:
;;;	takahasi@etl.go.jp ($B9b669'0l(B) $B$5$s(B
;;;	furuhata@tamago.fujita3.iis.u-tokyo.ac.jp (Tomotake FURUHATA) $B$5$s(B
;;;	furuta@srarc2.sra.co.jp ($B8EEDFX(B) $B$5$s(B
;;;	hoshi@sra.co.jp (Hoshi Takanori) $B$5$s(B

(defmacro if-mule (&rest args)
  (` (if (boundp 'MULE) (,@ args))))

(require (if-mule 'egg 'wnn-egg))

;;;
;;;	$BJQ?tEy(B
;;;

;; $B%^%/%m(B
(defmacro defvar-local (var &rest args)
  "define VAR, and make it buffer local."
  (` (progn (defvar (, var) (,@ args))
	    (make-variable-buffer-local '(, var)))))

;; $B%-!<%P%$%s%G%#%s%0(B
(defvar-local rK-trans-key "\C-j" "for `boil' only")
(defvar-local rhkR-trans-key "\ej" "for `boil' only")
(defvar-local rRkh-trans-key "\e\C-j" "for `boil' only")
(defvar Kh-trans-key nil)
(defvar KR-trans-key nil)

;; $B$=$NB>(B
(defconst X-transes '(rhkR-trans rRkh-trans henkan-kakutei Kh-trans KR-trans))
(defconst be-trans-mode-name
  '((r . "Aa") (hk . "$B:.(B")
    (h . "$B$"(B") (k  . "$B%"(B") (R . "$B#A(B")
    (K . "$B4A(B")
    (x . "??")))

(defvar-local be-trans-begin-regexp "[^!-~]\\|[(){}]"
  "*regexp for beginning of words(- 1 char).")
(defvar-local be-trans-begin-regexp-hk "[^$B!<$!(B-$B$s%!(B-$B%v(B]"
  "*regexp for beginning of words(- 1 char) for 'hk be-trans-src-type.")
(defvar-local be-trans-mode nil "Current mode of transformation.")
(defvar-local be-trans-begin nil "Begin marker of transfer region.")
(defvar-local be-trans-end nil "End marker of transfer region.")
(defvar-local be-trans-src "" "Source string of transfer region.")
(defvar-local be-trans-src-type nil "Character type of be-trans-src.")

(defvar-local be-verbose t
  "*If non-nil some messages are displaied.")
(defvar-local be-mark-as-trans-begin t
  "*If non-nil 'mark' will be regarded as trans-begin.")
(defvar-local be-mark-trans-end nil
  "*If non-nil trans-end be marked on 'kakutei'.")

;;;
;;;	$B=i4|2=%k!<%A%s(B
;;;

(defun boil ()
  "`boil' cooks `egg', then makes `boiled-egg'"
  (interactive)
  (local-set-key rK-trans-key 'rK-trans)
  (local-set-key rhkR-trans-key 'rhkR-trans)
  (local-set-key rRkh-trans-key 'rRkh-trans)
  (if be-trans-mode nil
    (define-key minibuffer-local-map rK-trans-key 'rK-trans)
    (define-key minibuffer-local-map rhkR-trans-key 'rhkR-trans)
    (define-key minibuffer-local-map rRkh-trans-key 'rRkh-trans)
    (define-key minibuffer-local-ns-map rK-trans-key 'rK-trans)
    (define-key minibuffer-local-ns-map rhkR-trans-key 'rhkR-trans)
    (define-key minibuffer-local-ns-map rRkh-trans-key 'rRkh-trans))
  (boiling)
  (message "boiled"))

(defun boiling ()
  "boiling (initialize of boiled-egg)"
  (or (memq 'be-reset-mode egg-insert-after-hook)
      (setq egg-insert-after-hook (cons 'be-reset-mode egg-insert-after-hook)))
  (if (and (if-mule mc-flag kanji-flag)
	   (not egg:*mode-on*))
      (progn
	(setq egg:*mode-on* t)
	(setq egg:*input-mode* nil)
	(egg:mode-line-display)))
  (if be-trans-mode nil
    (replace-on-keymap henkan-mode-map 'henkan-quit 'rK-cancel-trans)
    (replace-on-keymap henkan-mode-map
		       'henkan-kakutei-before-point 'rK-kakutei-before-point)
    (define-similar-keys (current-local-map) 'rK-trans
                         henkan-mode-map 'henkan-next-kouho)
    (if Kh-trans-key (define-key henkan-mode-map Kh-trans-key 'Kh-trans)
      (define-similar-keys (current-local-map) 'rhkR-trans
                           henkan-mode-map 'Kh-trans))
    (if KR-trans-key (define-key henkan-mode-map KR-trans-key 'KR-trans)
      (define-similar-keys (current-local-map) 'rRkh-trans
                           henkan-mode-map 'KR-trans))
    (setq-default be-trans-mode 'x)))

(defun replace-on-keymap (map old new)
  "on a keymap (MAP), replace command OLD with another command NEW"
  (define-similar-keys map old map new))

(defun define-similar-keys (map1 com1 map2 com2)
  "args: KEYMAP1, COMMAND1, KEYMAP2, COMMAND2.
define key sequences, which are defined in KEYMAP1 as COMMAND1,
in KEYMAP2 as COMMAND2"
  (mapcar (function (lambda (seq) (define-key map2 seq com2)))
	  (where-is-internal com1 map1)))

;;;
;;;	$BJd=u4X?t(B
;;;

(defun mark-src ()
  "mark source string for transformation, and save it to `be-trans-src'"
  (save-excursion
    (setq be-trans-end (point-marker))
    (set-marker-type be-trans-end t)
    (if (re-search-backward be-trans-begin-regexp (point-min) 0)
      (forward-char 1))
    (if (< (point) (marker-position be-trans-end))
	(setq be-trans-src-type 'r)
      (if (re-search-backward be-trans-begin-regexp-hk (point-min) 0)
	  (forward-char 1))
      (if (< (point) (marker-position be-trans-end))
	  (setq be-trans-src-type 'hk)))
    (and (mark)
	 be-mark-as-trans-begin
	 (< (point) (mark))
	 (< (mark) (marker-position be-trans-end))
	 (goto-char (mark)))
    (setq be-trans-begin (point-marker))
    (setq be-trans-src (buffer-substring (point)
					 (marker-position be-trans-end)))))

(defun cancel-trans ()
  "Cancel transformation."
  (goto-char (marker-position be-trans-begin))
  (insert be-trans-src)
  (delete-region (point) (marker-position be-trans-end)))

(defun be-display-mode ()
  (if (and be-verbose (zerop (minibuffer-depth)) (not (eq be-trans-mode 'x)))
      (message "[%s]:%s"
	       (cdr (assq be-trans-mode be-trans-mode-name))
	       be-trans-src)))

(defun be-reset-mode ()
  (if (eq be-trans-mode 'x) nil
    (if be-mark-trans-end
	(set-mark (if (eq be-trans-mode 'K) (point) (1- (point)))))
    (egg:do-auto-fill)
    (setq be-trans-mode 'x)))

;;;
;;;	$B4A;zJQ49(B
;;;

(defun rK-trans ()
  "(roman(hankaku) or hiragana/ktakana) -> KANJI transformation."
  (interactive)
  (boiling)
  (setq disable-undo t)
  (if (memq last-command X-transes) (cancel-trans) (mark-src))
  (if (string-match "^ *$" be-trans-src)
      (setq be-trans-mode 'x)
    (setq be-trans-mode 'K) ; henkan-mode is `K-mode.'
    (cond
     ((eq be-trans-src-type 'r)
	(roma-kana-region (marker-position be-trans-begin)
			  (marker-position be-trans-end)))
     ((eq be-trans-src-type 'hk)
	(hiragana-region (marker-position be-trans-begin)
			 (marker-position be-trans-end))))
    (henkan-region (marker-position be-trans-begin)
		   (marker-position be-trans-end)))
  (be-display-mode))

(defun rK-cancel-trans()
  "cancel KANJI transformation (KANJI -> roman(hankaku) or hiragana/ktakana)."
  (interactive)
  (henkan-quit)
  (if (not (eq be-trans-mode 'K)) nil
    (fence-cancel-input)
    (insert be-trans-src)
    (setq be-trans-mode 'x)
    (setq disable-undo nil)))

(defun rK-kakutei-before-point ()
  "boiled-egg version of henkan-kakutei-before-point."
  (interactive)
  (henkan-kakutei-before-point)
  (if (not (eq be-trans-mode 'K)) nil
    (fence-exit-mode)
    (let* ((begin (point))
	   (rest (buffer-substring begin (marker-position be-trans-end))))
      (insert be-trans-src)
      (delete-region (point) (marker-position be-trans-end))
      (cond
       ((eq be-trans-src-type 'r)
		(roma-kana-region begin (marker-position be-trans-end)))
       ((eq be-trans-src-type 'hk)
		(hiragana-region begin (marker-position be-trans-end))))
      (while (not (string=
		   (buffer-substring begin (marker-position be-trans-end))
		   rest))
	(cond
	 ((eq be-trans-src-type 'r)
		(setq be-trans-src (substring be-trans-src 1))
		(goto-char begin)
		(insert be-trans-src)
		(delete-region (point) (marker-position be-trans-end))
		(roma-kana-region begin (marker-position be-trans-end)))
	 ((eq be-trans-src-type 'hk)
		(setq be-trans-src (substring be-trans-src (if-mule 3 2)))
		(goto-char begin)
		(insert be-trans-src)
		(delete-region (point) (marker-position be-trans-end))
		(hiragana-region begin (marker-position be-trans-end)))))
      (move-marker be-trans-begin begin)
      (cancel-trans)
      (setq be-trans-mode 'x)
      (setq disable-undo nil))))

(defun Kh-trans ()
  "cancel KANJI transformation and transform to hiragana
(KANJI -> hiragana)."
  (interactive)
  (rK-cancel-trans)
  (rhkR-trans))

(defun KR-trans ()
  "cancel KANJI transformation and transform to ROMAN(zenkaku)
(KANJI -> ROMAN(ZENKAKU)),
or transform to katakana (KANJI -> katakana)."
  (interactive)
  (rK-cancel-trans)
  (rRkh-trans))

;;;
;;;	$BH>3Q(B -> $B$R$i$,$J(B -> $B%+%?%+%J(B -> $BA43Q(B (-> $BH>3Q(B) $BJQ49(B
;;;

(defun rhkR-trans ()
  "roman(hankaku) -> hiragana -> katakana -> ROMAN(zenkaku) transformation
or hiragana/katakana -> hiragana -> katakana transformation."
  (interactive)
  (boiling)
  (if (memq last-command X-transes)
    (cond ((= be-trans-begin be-trans-end) nil)
	  ((eq be-trans-mode 'r)
	   	(roma-kana-region (marker-position be-trans-begin)
				  (marker-position be-trans-end))
		(setq be-trans-mode 'h))
	  ((eq be-trans-mode 'hk)
	   	(hiragana-region (marker-position be-trans-begin)
				 (marker-position be-trans-end))
		(setq be-trans-mode 'h))
	  ((eq be-trans-mode 'h)
		(katakana-region (marker-position be-trans-begin)
				 (marker-position be-trans-end))
		(setq be-trans-mode 'k))
	  ((and (eq be-trans-mode 'k) (eq be-trans-src-type 'r))
		(cancel-trans)
		(zenkaku-region (marker-position be-trans-begin)
				(marker-position be-trans-end))
		(setq be-trans-mode 'R))
	  (t	(cancel-trans)
		(setq be-trans-mode be-trans-src-type)))
    (mark-src)
    (cond
     ((eq be-trans-src-type 'r)
      	(roma-kana-region (marker-position be-trans-begin)
			  (marker-position be-trans-end)))
     ((eq be-trans-src-type 'hk)
      	(hiragana-region (marker-position be-trans-begin)
			 (marker-position be-trans-end))))
    (setq be-trans-mode 'h))
  (be-display-mode))

;;;
;;;	$BH>3Q(B -> $BA43Q(B -> $B%+%?%+%J(B -> $B$R$i$,$J(B (-> $BH>3Q(B) $BJQ49(B
;;;

(defun rRkh-trans ()
  "roman(hankaku) -> ROMAN(zenkaku) -> katakana -> hiragana transformation
or hiragana/katakana -> katakana -> hiragana transformation."
  (interactive)
  (boiling)
  (if (memq last-command X-transes)
    (cond ((= be-trans-begin be-trans-end) nil)
	  ((eq be-trans-mode 'k)
		(cancel-trans)
		(cond
		 ((eq be-trans-src-type 'r)
		  	(roma-kana-region (marker-position be-trans-begin)
					  (marker-position be-trans-end)))
		 ((eq be-trans-src-type 'hk)
		  	(hiragana-region (marker-position be-trans-begin)
					 (marker-position be-trans-end))))
		(setq be-trans-mode 'h))
	  ((eq be-trans-mode 'R)
		(cancel-trans)
		(roma-kana-region (marker-position be-trans-begin)
				  (marker-position be-trans-end))
		(katakana-region (marker-position be-trans-begin)
				 (marker-position be-trans-end))
		(setq be-trans-mode 'k))
	  ((eq be-trans-mode 'hk)
		(cancel-trans)
		(katakana-region (marker-position be-trans-begin)
				 (marker-position be-trans-end))
		(setq be-trans-mode 'k))
	  ((eq be-trans-mode 'r)
		(zenkaku-region (marker-position be-trans-begin)
				(marker-position be-trans-end))
		(setq be-trans-mode 'R))
	  (t	(cancel-trans)
		(setq be-trans-mode be-trans-src-type)))
    (mark-src)
    (cond
     ((eq be-trans-src-type 'r)
      	(zenkaku-region (marker-position be-trans-begin)
			(marker-position be-trans-end))
	(setq be-trans-mode 'R))
     ((eq be-trans-src-type 'hk)
	(katakana-region (marker-position be-trans-begin)
			 (marker-position be-trans-end))
	(setq be-trans-mode 'k))))
  (be-display-mode))

;;;
(provide 'boiled-egg)
;(autoload 'hard-boil "hard-boiled"
;  "`hard-boil' cooks `boiled-egg', then makes `hard-boiled'" t)
;(autoload 'skk2hb "hb-skk"
;  "read SKK-JISYO file, and change its format to `hard-boiled' dictionary" "F")
;(autoload 'hb-dic-normalize "hb-skk"
;  "normalize `hard-boiled' dictionary in specified BUFFER" t)
;(autoload 'hb-dic-merge "hb-skk"
;  "marge DICFILE to `hard-boiled' dictionary buffer" "f")
