;;
;;      dmacro.el - $B%-!<A`:n$N7+JV$78!=P(B & $B<B9T(B
;;
;;      1993 4/14 original idea by $BA}0f=SG7!w%7%c!<%W(B
;;                  implemented by $BB@OBED@?!wD92,5;2JBg(B
;;                   refinement by $BA}0f=SG7!w%7%c!<%W(B
;;
;;      $Date: 93/08/05 11:15:24 $
;;      $Revision: 1.9 $
;;
;; .emacs$B$K0J2<$N9T$rF~$l$k(B
;;
;; (defconst *dmacro-key* "\C-t" "$B7+JV$7;XDj%-!<(B")
;; (global-set-key *dmacro-key* 'dmacro-exec)
;; (autoload 'dmacro-exec "dmacro" nil t)
;;

(defvar *dmacro-str* nil "$B7+JV$7J8;zNs(B")
(setq dmacro-keys (concat *dmacro-key* *dmacro-key*))

(defun dmacro-exec ()
  "$B%-!<A`:n$N7+JV$7$r8!=P$7<B9T$9$k(B"
  (interactive)
  (let ((s (dmacro-get)))
    (if (null s)
	(message "$BA`:n$N7+JV$7$,8+$D$+$j$^$;$s(B")
      (execute-kbd-macro s)
      )
    ))

(defun dmacro-get ()
  (let ((rkeys (recent-keys)) str)
    (if (string= dmacro-keys (substring rkeys (- (length dmacro-keys))))
        *dmacro-str*
      (setq str (dmacro-search (substring rkeys 0 (- (length *dmacro-key*)))))
      (if (null str)
          (setq *dmacro-str* nil)
        (let ((s1 (car str)) (s2 (cdr str)))
          (setq *dmacro-str* (concat s2 s1))
          (setq last-kbd-macro *dmacro-str*)
          (if (string= s1 "") *dmacro-str* s1)
          )))))

(defun dmacro-search (string)
  (let* ((str (string-reverse string))
         (sptr  1)
         (dptr0 (string-search (substring str 0 sptr) str sptr))
         (dptr dptr0)
         maxptr)
    (while (and dptr0
                (not (string-search *dmacro-key* (substring str sptr dptr0))))
      (if (= dptr0 sptr)
          (setq maxptr sptr))
      (setq sptr (1+ sptr))
      (setq dptr dptr0)
      (setq dptr0 (string-search (substring str 0 sptr) str sptr))
      )
    (if (null maxptr)
        (let ((predict-str (string-reverse (substring str (1- sptr) dptr))))
          (if (string-search *dmacro-key* predict-str)
              nil
            (cons predict-str (string-reverse (substring str 0 (1- sptr)))))
          )
      (cons "" (string-reverse (substring str 0 maxptr)))
      )
    ))

(defun string-reverse (str)
  (concat "" (reverse (mapcar (function (lambda (x) x)) str))))

(defun string-search (pat str &optional start)
  (let* ((len (length pat))
	 (max (- (length str) len))
	 p found
	 )
    (setq p (if start start 0))
    (while (and (not found) (<= p max))
      (setq found (string= pat (substring str p (+ p len))))
      (if (not found) (setq p (1+ p)))
      )
    (if found p nil)
    ))

