;;; perham, 92
;;;
;;;  Startup coding systems.
;;;
(defvar *coding-from-filename-list* nil
  "*The user's list favourit file codings given a filename.  To add to
or change this list use insert-new-coding-from-filename and
remove-coding-from-filename.")

;;;
;;;  This is now obsolete...
;;;
(defun coding-in-obarray-p (file-coding)
  "Find out if FILE-CODING is one of the codings that we know of, ie that
it is in the array *coding-system-obarray*."
  (if (symbolp file-coding)
    (let ((result nil))
      (dotimes (item (length *coding-system-obarray*))
	(if (and (symbolp (aref *coding-system-obarray* item))
		 (string= file-coding
			  (aref *coding-system-obarray* item)))
	  (setq result t)))
      result)
    (error "Coding-in-obarray-p called with argument that is not a symbol.")))

;;;
;;;
;;;
(defun insert-coding-from-filename-rec (filename-regexp file-coding coding-from-filename-list)
  "This dunction should not be used by users, use insert-coding-from-filename
or remove-coding-from-filename."
  ;;Is there more in the list?
  (if coding-from-filename-list
    ;;found the right regexp?
    (if (string= filename-regexp
		 (car (car coding-from-filename-list)))
      ;;remove or change
      (if file-coding
	;;change
	(cons (cons filename-regexp file-coding)
	      (cdr coding-from-filename-list))
	;;remove
	(cdr coding-from-filename-list))
      ;;go further down
      (cons (car coding-from-filename-list)
	    (insert-coding-from-filename-rec filename-regexp
					     file-coding
					     (cdr coding-from-filename-list))))
    ;;at the end
    (if file-coding
      ;;create new entry
      (list (cons filename-regexp file-coding))
      ;;report error
      (error "Cannot remove nonexistent coding-to-filename entry!"))))

;;;
;;;
;;;
(defun insert-new-coding-from-filename (filename-regexp file-coding)
  "This function inserts or changes an entry in the coding-from-filename-list.
If FILENAME-REGEXP matches an entry in the list, then the coding of that
entry is changed to FILE-CODING.  If the FILENAME-REGEXP is not found in
the list, a new entry is added at the end of the list."
  (if (stringp filename-regexp)
    (if (check-coding-system file-coding)
      (setq *coding-from-filename-list*
	    (insert-coding-from-filename-rec filename-regexp
					     file-coding
					     *coding-from-filename-list*)))
    (error "Insert-new-coding-from-filename called with something that is not a string!")))
;;;
;;;
;;;
(defun remove-coding-from-filename (filename-regexp)
  "This function removes a filename-to-coding entry where the filename-regexp
of the entry matches FILENAME-REGEXP."
  (if (stringp filename-regexp)
    (setq *coding-from-filename-list*
	  (insert-coding-from-filename-rec filename-regexp nil *coding-from-filename-list*))
    (error "Remove-coding-from-filename called with something that is not string!")))

;;;
;;;
;;;
(defun coding-from-filename (name visit)
  "This functions attempts to find a suitable coding systems to use when
reading a file based on the filename.  It uses the entries in the list
*coding-from-filename-list* when testing what coding to use.

It will use the last entry in the list that matches NAME, ie the
last entry the user inserted into the list.

It lets the user override an automatic selection of a coding system,
if the user initiated the file read with C-u C-x C-f, C-u C-x C-i,
or C-u C-x C-r. 

If no suitable coding is found, then it returns the default."

  ;;check if the user wants to specify coding himself.
  (if (eq file-coding-system-for-read 'query)
    ;;return what the user types
    (read-coding-system "Coding-system: ")
    ;;try to look at the filename and decide...
    (let ((result-coding nil)
	  filename-regexp
	  coding)
      ;;loop through all of teh list to really capture the last entry matching NAME.
      (dolist (code-entry *coding-from-filename-list*)
	;;Make sure that we are looking at a cons cell, the user may have inserted
	;; something on his own...
	(if (consp code-entry)
	  (progn
	    (setq filename-regexp (car code-entry))
	    (setq coding (cdr code-entry))
	    (if (and (stringp filename-regexp)
		     (check-coding-system coding))
	      (if (string-match filename-regexp name)
		(setq result-coding coding))
	      ;;somthing that is not a string coding cons cell has been found...
	      (error "Coding-from-extension: Something alien in the *coding-from-filename-list* list!")))
	  ;;Not a cons cell...
	  (error "Coding-from-extension: Something that is not a cons cell in *coding-from-filename-list*!")))
      ;; Now check the result, if nil return default...
      (if result-coding
	;;Get the real coding
	result-coding
	;;Just settle for the default.
	file-coding-system-for-read))))

;;;Sample matches
(insert-new-coding-from-filename ".*.gb$"   *euc-china*)
(insert-new-coding-from-filename ".*.jis$"  *junet*)
(insert-new-coding-from-filename ".*.big$"  *big5-hku*)
(insert-new-coding-from-filename ".*.big5$" *big5-hku*)
