;; Search commands of mh-e.el for Emacs
;; Copyright (C) 1990 Sony Co, Inc.  SAITO Yutaka (yutaka@sys1.cpg.sony.co.jp)
;; Special Thanks to enami@sys.ptg.sony.co.jp
;;
;;	$Header: mh-search.el,v 1.4 90/09/06 13:20:54 yutaka Exp $
;;	$Revision: 1.4 $   
;;	$Author: yutaka $     
;;	$Locker: yutaka $     
;;	$Date: 90/09/06 13:20:54 $  
;;	$State: Exp $    


;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

(require 'mh-e)
(provide 'mh-search)

;;;
;;; Caution Rebind mh-search-folder. ESC-s ==> S
(define-key mh-folder-mode-map "S" 'mh-search-folder)

;;;
;;; New Bind (link gnus-Subject-search-article-{forward,backward}
;;; ESC-s search-forward
;;; ESC-S search-backward
(define-key mh-folder-mode-map "\es" 'mh-search-message-forward)
(define-key mh-folder-mode-map "\eS" 'mh-search-message-backward)

(defvar mh-last-search-regexp nil
  "Default regexp for message search command.")

(defvar mh-last-msg nil)

(defvar mh-current-msg nil)

(defmacro mh-eval-in-buffer-window (buffer &rest forms)
  "Pop to BUFFER, evaluate FORMS, and then returns to original window."
  (` (let ((MHStartBufferWindow (selected-window)))
       (unwind-protect
	   (progn
	     (pop-to-buffer (, buffer))
	     (,@ forms))
	 (select-window MHStartBufferWindow)))))

(defun mh-search-message-forward (regexp)
  "Search for an message containing REGEXP forward.
   mh-{folder-mode,letter-mode,inc-folder,compose-letter}-hook 
   is not called during the search."
  (interactive
   (list (read-string
	  (concat "Search forward (regexp): "
		  (if mh-last-search-regexp
		      (concat "(default " mh-last-search-regexp ") "))))))
  (if (string-equal regexp "")
      (setq regexp (or mh-last-search-regexp ""))
    (setq mh-last-search-regexp regexp))
  (if (mh-search-message regexp nil)
      (display-buffer mh-show-buffer)
    (error "Search failed: \"%s\"" regexp) )
)

(defun mh-search-message-backward (regexp)
  "Search for an message ontaining REGEXP backward.
   mh-{folder-mode,letter-mode,inc-folder,compose-letter}-hook 
   is not called during the search."
  (interactive
   (list (read-string
	  (concat "Search backward (regexp): "
		  (if mh-last-search-regexp
		      (concat "(default " mh-last-search-regexp ") "))))))
  (if (string-equal regexp "")
      (setq regexp (or mh-last-search-regexp ""))
    (setq mh-last-search-regexp regexp))
    (if (mh-search-message regexp t)
	(display-buffer mh-show-buffer)
      (error "Search failed: \"%s\"" regexp) )
  )

;; (put 'mh-eval-in-buffer-window 'lisp-indent-hook 1)
;; (get 'mh-eval-in-buffer-window 'lisp-indent-hook)

(defun mh-search-message (regexp &optional backward)
  "Search for an message containing REGEXP.
Optional argument BACKWARD means do search for backward.
   mh-{folder-mode,letter-mode,inc-folder,compose-letter}-hook 
   is not called during the search."
  (let ((mh-folder-mode-hook nil)	;Disable hook.
        (mh-letter-mode-hook nil)
	(mh-inc-folder-hook  nil)
	(mh-compose-letter-hook nil)
	(mh-current-msg (mh-get-msg-num nil))
	(re-search (if backward
		       (function re-search-backward)
		     (function re-search-forward) ))
	(found nil)
	(last nil)
	(buffer nil)
	(msg nil) )
    ;; First of all, search current show-buffer's current point.
    (mh-goto-msg mh-current-msg t t)
    (mh-show mh-current-msg)
    (message "Searching message: %d..." mh-current-msg)
    (setq last mh-current-msg)
    (setq buffer mh-show-buffer)
    (mh-eval-in-buffer-window
	buffer
      (save-restriction
	(widen)
	;; Begin search from current point.
	(setq found (funcall re-search regexp nil t)) ))
    ;; Then search next message.
    (while (not found)
      (if backward
	  (mh-previous-undeleted-msg 1)
	(mh-next-undeleted-msg 1) )
      (setq msg mh-current-msg)
      (setq mh-current-msg (mh-get-msg-num nil))
      (if (= msg mh-current-msg)
	  (setq found 'break)
	(mh-goto-msg mh-current-msg t t)
	(message "Searching message: %d..." mh-current-msg)
	(mh-eval-in-buffer-window
	    buffer
	  (save-restriction
	    (widen)
	    (goto-char (if backward (point-max) (point-min)))
	    (setq found (funcall re-search regexp nil t)) ))
	(setq last mh-current-msg) ))
    (message "")
    ;; Adjust message pointer.
    (setq mh-last-msg last)
    ;; Return T if found such message.
    (eq found t)
    ))
