;; Miscellaneous small functions
;; Copyright (C) 1992 Free Software Foundation, Inc.
;; This file is part of Mule (MULtilingual Enhancement of GNU Emacs).

;; Mule is free software distributed in the form of patches to GNU Emacs.
;; You can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; Mule is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; 90.3.3   created by K.Handa
;;; 92.3.16  modified for Mule Ver.0.9.1 by K.Handa <handa@etl.go.jp>

;;; MAIL

(if (boundp 'mail-setup-hook)
    (if (consp mail-setup-hook)
	(if (not (memq 'mail-setup-for-mailing-list mail-setup-hook))
	    (setq mail-setup-hook
		  (cons 'mail-setup-for-mailing-list mail-setup-hook)))
      (setq mail-setup-hook
	    (cons 'mail-setup-for-mailing-list mail-setup-hook)))
  (setq mail-setup-hook  'mail-setup-for-mailing-list))

(defvar mail-mailing-list-list
  nil
  "*List of names of mailing lists to be recognized by\n\
'mail-setup-for-mailing-list'.")

(defun mail-setup-for-mailing-list ()
  "Set up fields when reply to mailing list."
  (if mail-mailing-list-list
      (progn
	(let ((list mail-mailing-list-list)
	      (to-and-cc (concat (mail-fetch-field "to")
				 (mail-fetch-field "cc"))))
	  (while list
	    (if (string-match (car list) to-and-cc)
		(progn
		  (if (mail-position-on-field "to" t)
		      (progn
			(forward-char 1)
			(zap-to-char -2 ?\n)))
		  (if (mail-position-on-field "cc" t)
		      (progn
			(forward-char 1)
			(zap-to-char -2 ?\n)))
		  (if (mail-position-on-field "reply-to" t)
		      (progn
			(forward-char 1)
			(zap-to-char -2 ?\n)))
		  (insert "To: " (car list) ?\n "Reply-to: " (car list) ?\n)
		  (goto-char (point-max))
		  (setq list nil)))
	    (setq list (cdr list))))
	))
  )

(global-set-key "\er" 'rmail)

;;; EGG

(defun set-attribute-for-egg ()
  "Set attributes to use EGG with proper style."
  (interactive)
  (set-egg-fence-mode-format "" "" 'underline)
  (set-egg-henkan-mode-format "" "" " " "" 'underline 'underline 'inverse))

;;; Caution!  The following feature will be changed in the near future.
;;; 92.3.16 by K.Handa
;;; obsolete now.
;(defun set-short-egg-mode-line ()
;  (interactive)
;  (setq-default mode-line-egg-mode "--")
;  (setq mode-line-egg-mode "--")
;  (setq mode-line-egg-mode-in-minibuffer "--")
;  (if (fboundp 'its:set-mode-indicator)
;      (progn
;	(its:set-mode-indicator "roma-kana" "$B$"(B")
;	(its:set-mode-indicator "roma-kata" "$B%+(B"))
;    (egg:set-mode-indicator "roma-kana" "$B$"(B")
;    (egg:set-mode-indicator "roma-kata" "$B%+(B"))
;  (setq-default its:*current-mode* (its:get-mode-indicator "roma-kana"))
;  (setq its:*current-mode* (its:get-mode-indicator "roma-kana"))
;  (setq alphabet-mode-indicator "aA")
;  (setq transparent-mode-indicator "--")
;  (setq henkan-mode-indicator "$B4A(B")
;  )

;;; GREP
(defun egrep (str target)
  (interactive "sRegexp = \nFFiles = ")
  (setq str (code-convert-string str *internal* *euc-japan* ))
  (setq target (expand-file-name target))
  (let ((buf (get-buffer-create "*egrep-output*"))
	files)
    (save-excursion
      (set-buffer buf)
      (erase-buffer)
      (insert "(")
      (call-process "sh" nil t nil "-c" (concat "echo " target))
      (insert " /dev/null")
      (goto-char 2)
      (replace-regexp "\\(\\S *\\)" "\"\\&\"")
      (insert ")")
      (goto-char 0)
      (setq files (read (current-buffer)))
      (erase-buffer)
      (apply 'call-process "egrep" nil t t "-ne" str files)
      (set-window-start (display-buffer buf) 1)
      )))
