#define DEFAULT_FONTSET 0

#define FONT_NOT_OPENED	0
#define FONT_OPENED	1
#define FONT_NOT_FOUND	2

typedef void *FONT_PTR;

typedef struct _FONT_INFO {
  int fontID;			/* Font index */
  FONT_PTR font;		/* points window-system depended font info. */
  char *requested;		/* name of requested font */
  char *name;			/* name of opened font */
  int lc;			/* leading-char for this font */
  int status;			/* one of FONT_NOT_OPENED, FONT_OPENED,
				   and FONT_NOT_FOUND */
  /* The meanings of following info are window-system depended. */ 
  int size;			/* pixel size */
  int encoding;			/* 0: 0x21-0x7F 1: 0xA1-0xFE */
  int yoffset;			/* vertical upward offset from baseline */
  int relative_compose;		/* Non zero means characters should be
				   composed at vertically relative position. */
} FONT_INFO;

typedef struct _FONTSET_INFO {
  char *name;			/* name of this fontset */
  int size;			/* pixel size (not used now) */
  int table[128];		/* each element holds index to `font_table'
				   or -1 (font not specified) */
} FONTSET_INFO;

#define FS_FONT_ID(fsID,lc) fontset_table[fsID].table[(lc) & 0x7F]
#define FS_FONT_INFO(fsID,lc) font_table[FS_FONT_ID(fsID,lc)]
#define FS_FONT(fsID,lc) FS_FONT_INFO(fsID,lc).font

extern FONT_INFO *font_table;
extern FONTSET_INFO *fontset_table;
extern int n_fonts, n_fontsets;

extern void (*load_font_func)( /* FONT_INFO fontinfo, int lc */);
extern char **(*font_list_func)( /* char *name, int *count, int size */);
